/*
 * Decompiled with CFR 0.152.
 */
package genj.search;

import genj.gedcom.Entity;
import genj.gedcom.Property;
import genj.search.Matcher;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

class Hit {
    private static final SimpleAttributeSet PLAIN = new SimpleAttributeSet();
    private static final SimpleAttributeSet RED = new SimpleAttributeSet();
    private static final SimpleAttributeSet BOLD = new SimpleAttributeSet();
    private static final Color[] fgColors = new Color[2];
    private Property property;
    private ImageIcon img;
    private StyledDocument doc;
    private int entity;

    public Hit(Property setProp, String value, Matcher.Match[] matches, int setEntity, boolean isID) {
        this.property = setProp;
        this.img = this.property.getImage(false);
        this.entity = setEntity;
        this.doc = new DefaultStyledDocument();
        Color c = fgColors[setEntity & 1];
        StyleConstants.setForeground(PLAIN, c);
        StyleConstants.setForeground(BOLD, c);
        try {
            int offset = 0;
            String tag = setProp.getPropertyName();
            this.doc.insertString(offset++, " ", PLAIN);
            if (setProp instanceof Entity) {
                tag = "";
            }
            if (!isID) {
                this.doc.insertString(offset, tag, BOLD);
                offset += tag.length();
                this.doc.insertString(offset++, " ", PLAIN);
            }
            this.doc.insertString(offset, value, PLAIN);
            if (matches != null) {
                for (int i = 0; i < matches.length; ++i) {
                    Matcher.Match m = matches[i];
                    this.doc.setCharacterAttributes(offset + m.pos, m.len, RED, false);
                }
            }
            offset += value.length();
            if (isID) {
                this.doc.insertString(offset++, " ", PLAIN);
                this.doc.insertString(offset, tag, BOLD);
            }
            SimpleAttributeSet img = new SimpleAttributeSet();
            StyleConstants.setIcon(img, (Icon)setProp.getImage(false));
            this.doc.insertString(0, " ", img);
            this.doc.insertString(0, "[" + setProp.getEntity().getId() + "] ", PLAIN);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    StyledDocument getDocument() {
        return this.doc;
    }

    Property getProperty() {
        return this.property;
    }

    ImageIcon getImage() {
        return this.img;
    }

    int getEntity() {
        return this.entity;
    }

    static {
        StyleConstants.setForeground(RED, Color.RED);
        StyleConstants.setBold(BOLD, true);
        Hit.fgColors[0] = Color.BLACK;
        Hit.fgColors[1] = new Color(0, 51, 241);
    }
}

