/*
 * Decompiled with CFR 0.152.
 */
package genj.search;

import ancestris.api.search.SearchCommunicator;
import ancestris.awt.FilteredMouseAdapter;
import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.swing.ToolBar;
import ancestris.util.Utilities;
import ancestris.util.swing.DialogManager;
import ancestris.view.SelectionDispatcher;
import genj.edit.beans.DateBean;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyXRef;
import genj.io.Filter;
import genj.search.Hit;
import genj.search.SettingsPanel;
import genj.search.Worker;
import genj.search.WorkerListener;
import genj.search.WorkerMulti;
import genj.search.WorkerTag;
import genj.util.GridBagHelper;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.WordBuffer;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.ImageIcon;
import genj.util.swing.PopupWidget;
import genj.view.Images;
import genj.view.View;
import genj.view.ViewContext;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import spin.Spin;

public class SearchView
extends View
implements Filter {
    private int max_hits;
    private boolean case_sensitive;
    private static final String[] DEFAULT_VALUES = new String[]{"L(a|e)pe(i|y)re", "Paris.+France", "^(M|F)"};
    private static final String[] DEFAULT_TAGS = new String[]{"NAME", "BIRT", "BIRT, PLAC", "OCCU", "NOTE", "BIRT, NOTE", "RESI", "PLAC"};
    private static final String[] DEFAULT_STR = new String[0];
    private static final ImageIcon IMG_START = new ImageIcon(SearchView.class, "images/Start");
    private static final ImageIcon IMG_STOP = new ImageIcon(SearchView.class, "images/Stop");
    private static final ImageIcon IMG_CLEAN = new ImageIcon(SearchView.class, "images/Clean");
    private static final ImageIcon IMG_CLEAR = new ImageIcon(SearchView.class, "images/ClearHistory");
    private static final ImageIcon IMG_SETTINGS = Images.imgSettings;
    private static final int MAX_OLD = 16;
    static final Resources RESOURCES = Resources.get(SearchView.class);
    private static final Registry REGISTRY = Registry.get(SearchView.class);
    private Context context = null;
    private Results results1 = new Results();
    private Results results2 = new Results();
    private ResultWidget listResults1 = new ResultWidget(this.results1);
    private ResultWidget listResults2 = new ResultWidget(this.results2);
    private ChoiceWidget choiceLastname;
    private ChoiceWidget choiceFirstname;
    private ChoiceWidget choicePlace;
    private ChoiceWidget choiceOccu;
    private ChoiceWidget choiceTag;
    private ChoiceWidget choiceValue;
    private JCheckBox checkRegExp;
    private JLabel labelCount2;
    private LinkedList<String> oldLastnames;
    private LinkedList<String> oldFirstnames;
    private LinkedList<String> oldPlaces;
    private LinkedList<String> oldOccupations;
    private LinkedList<String> oldTags;
    private LinkedList<String> oldValues;
    private AbstractAncestrisAction actionStart = new ActionStart();
    private AbstractAncestrisAction actionStop = new ActionStop();
    private AbstractAncestrisAction actionClean = new ActionClean();
    private AbstractAncestrisAction actionClearHistory = new ActionClearHistory();
    private AbstractAncestrisAction actionSettings = new ActionSettings();
    private WorkerMulti worker1;
    private WorkerTag worker2;
    private SearchCommunicator searchCommunicator = null;
    Set<Entity> connectedEntities = null;
    private JCheckBox allButCb;
    private DateBean birthDateBean;
    private JLabel birthLabel;
    private DateBean deathDateBean;
    private JLabel deathLabel;
    private JCheckBox femaleCb;
    private JLabel firstnameLabel;
    private JComboBox firstnameText;
    private JTabbedPane jTabbedPane1;
    private JLabel labelCount1;
    private JLabel lastnameLabel;
    private JComboBox lastnameText;
    private JCheckBox maleCb;
    private JCheckBox marrCb;
    private JLabel occuLabel;
    private JComboBox occuText;
    private JLabel placeLabel;
    private JComboBox placetext;
    private JPanel result1Panel;
    private JCheckBox singleCb;
    private JPanel tabMulti;
    private JPanel tabTag;
    private JCheckBox unknownCb;

    public SearchView() {
        ActionListener aclick = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchView.this.actionStop.isEnabled()) {
                    SearchView.this.stop();
                }
                if (SearchView.this.actionStart.isEnabled()) {
                    SearchView.this.start();
                }
            }
        };
        SettingsPanel settingsPanel = new SettingsPanel(REGISTRY);
        this.max_hits = settingsPanel.getMaxHits();
        this.case_sensitive = settingsPanel.getCaseSensitive();
        this.oldLastnames = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.lastnames", DEFAULT_STR)));
        this.choiceLastname = new ChoiceWidget(this.oldLastnames);
        this.choiceLastname.addActionListener(aclick);
        this.oldFirstnames = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.firstnames", DEFAULT_STR)));
        this.choiceFirstname = new ChoiceWidget(this.oldFirstnames);
        this.choiceFirstname.addActionListener(aclick);
        this.oldPlaces = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.places", DEFAULT_STR)));
        this.choicePlace = new ChoiceWidget(this.oldPlaces);
        this.choicePlace.addActionListener(aclick);
        this.oldOccupations = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.occupations", DEFAULT_STR)));
        this.choiceOccu = new ChoiceWidget(this.oldOccupations);
        this.choiceOccu.addActionListener(aclick);
        this.initComponents();
        this.birthDateBean.addActionListener(aclick);
        this.deathDateBean.addActionListener(aclick);
        this.worker1 = new WorkerMulti((WorkerListener)Spin.over((Object)new WorkerListener(){

            @Override
            public void more(List<Hit> hits) {
                SearchView.this.results1.add(hits);
                SearchView.this.labelCount1.setText("" + SearchView.this.results1.getSize());
                SearchView.this.notifyResults();
            }

            @Override
            public void started() {
                SearchView.this.results1.clear();
                SearchView.this.labelCount1.setText("");
                SearchView.this.actionStart.setEnabled(false);
                SearchView.this.actionStop.setEnabled(true);
            }

            @Override
            public void stopped() {
                SearchView.this.actionStop.setEnabled(false);
                SearchView.this.actionStart.setEnabled(SearchView.this.context.getGedcom() != null);
            }
        }));
        this.worker2 = new WorkerTag((WorkerListener)Spin.over((Object)new WorkerListener(){

            @Override
            public void more(List<Hit> hits) {
                SearchView.this.results2.add(hits);
                SearchView.this.labelCount2.setText("" + SearchView.this.results2.getSize());
                SearchView.this.notifyResults();
            }

            @Override
            public void started() {
                SearchView.this.results2.clear();
                SearchView.this.labelCount2.setText("");
                SearchView.this.actionStart.setEnabled(false);
                SearchView.this.actionStop.setEnabled(true);
            }

            @Override
            public void stopped() {
                SearchView.this.actionStop.setEnabled(false);
                SearchView.this.actionStart.setEnabled(SearchView.this.context.getGedcom() != null);
            }
        }));
        this.oldTags = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.tags", DEFAULT_TAGS)));
        this.oldValues = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.values", DEFAULT_VALUES)));
        boolean useRegEx = REGISTRY.get("regexp", false);
        JLabel labelValue = new JLabel(RESOURCES.getString("label.value"));
        this.checkRegExp = new JCheckBox(RESOURCES.getString("label.regexp"), useRegEx);
        this.choiceValue = new ChoiceWidget(this.oldValues);
        this.choiceValue.addActionListener(aclick);
        PopupWidget popupPatterns = new PopupWidget("...", null);
        popupPatterns.addItems(this.createPatternActions());
        popupPatterns.setMargin(new Insets(0, 0, 0, 0));
        JLabel labelTag = new JLabel(RESOURCES.getString("label.tag"));
        this.choiceTag = new ChoiceWidget(this.oldTags);
        this.choiceTag.addActionListener(aclick);
        PopupWidget popupTags = new PopupWidget("...", null);
        popupTags.addItems(this.createTagActions());
        popupTags.setMargin(new Insets(0, 0, 0, 0));
        this.labelCount2 = new JLabel();
        JPanel paneCriteria = new JPanel();
        try {
            paneCriteria.setFocusCycleRoot(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        GridBagHelper gh = new GridBagHelper((Container)paneCriteria);
        gh.add((Component)labelValue, 0, 0, 2, 1, 0, new Insets(0, 0, 0, 8));
        gh.add((Component)this.checkRegExp, 2, 0, 1, 1, 17);
        gh.add((Component)this.labelCount2, 3, 0, 1, 1);
        gh.add((Component)popupPatterns, 0, 1, 1, 1);
        gh.add((Component)this.choiceValue, 1, 1, 3, 1, 17, new Insets(3, 3, 3, 3));
        gh.add((Component)labelTag, 0, 2, 4, 1, 17);
        gh.add((Component)popupTags, 0, 3, 1, 1);
        gh.add((Component)this.choiceTag, 1, 3, 3, 1, 17, new Insets(0, 3, 3, 3));
        this.birthDateBean.setPropertyImpl(null);
        this.deathDateBean.setPropertyImpl(null);
        this.birthDateBean.setFormat(PropertyDate.BETWEEN_AND);
        this.deathDateBean.setFormat(PropertyDate.BETWEEN_AND);
        this.result1Panel.setLayout(new BorderLayout());
        this.result1Panel.add("Center", new JScrollPane(this.listResults1));
        this.labelCount1.setText("");
        this.tabTag.setLayout(new BorderLayout());
        this.tabTag.add("North", paneCriteria);
        this.tabTag.add("Center", new JScrollPane(this.listResults2));
        this.connectedEntities = new HashSet<Entity>();
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                SearchView.this.notifyResults();
                SearchView.this.choiceLastname.requestFocusInWindow();
            }
        });
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.tabMulti = new JPanel();
        this.labelCount1 = new JLabel();
        this.lastnameLabel = new JLabel();
        this.firstnameLabel = new JLabel();
        this.birthLabel = new JLabel();
        this.deathLabel = new JLabel();
        this.placeLabel = new JLabel();
        this.occuLabel = new JLabel();
        this.lastnameText = this.choiceLastname;
        this.firstnameText = this.choiceFirstname;
        this.birthDateBean = new DateBean();
        this.deathDateBean = new DateBean();
        this.placetext = this.choicePlace;
        this.occuText = this.choiceOccu;
        this.maleCb = new JCheckBox();
        this.femaleCb = new JCheckBox();
        this.unknownCb = new JCheckBox();
        this.marrCb = new JCheckBox();
        this.singleCb = new JCheckBox();
        this.allButCb = new JCheckBox();
        this.result1Panel = new JPanel();
        this.tabTag = new JPanel();
        this.tabMulti.setPreferredSize(new Dimension(150, 354));
        this.labelCount1.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.labelCount1, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.labelCount1.text"));
        Mnemonics.setLocalizedText((JLabel)this.lastnameLabel, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.lastnameLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.firstnameLabel, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.firstnameLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.birthLabel, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.birthLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.deathLabel, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.deathLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.placeLabel, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.placeLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.occuLabel, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.occuLabel.text"));
        this.maleCb.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.maleCb, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.maleCb.text"));
        this.femaleCb.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.femaleCb, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.femaleCb.text"));
        this.unknownCb.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.unknownCb, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.unknownCb.text"));
        this.marrCb.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.marrCb, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.marrCb.text"));
        this.singleCb.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.singleCb, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.singleCb.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.allButCb, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.allButCb.text"));
        GroupLayout result1PanelLayout = new GroupLayout(this.result1Panel);
        this.result1Panel.setLayout(result1PanelLayout);
        result1PanelLayout.setHorizontalGroup(result1PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        result1PanelLayout.setVerticalGroup(result1PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 267, Short.MAX_VALUE));
        GroupLayout tabMultiLayout = new GroupLayout(this.tabMulti);
        this.tabMulti.setLayout(tabMultiLayout);
        tabMultiLayout.setHorizontalGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.result1Panel, -1, -1, Short.MAX_VALUE).addGroup(tabMultiLayout.createSequentialGroup().addContainerGap().addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelCount1, -1, -1, Short.MAX_VALUE).addGroup(tabMultiLayout.createSequentialGroup().addComponent(this.marrCb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.singleCb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.allButCb)).addGroup(tabMultiLayout.createSequentialGroup().addComponent(this.maleCb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.femaleCb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unknownCb).addGap(0, 0, Short.MAX_VALUE)).addGroup(tabMultiLayout.createSequentialGroup().addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lastnameLabel).addComponent(this.firstnameLabel).addComponent(this.birthLabel).addComponent(this.deathLabel).addComponent(this.placeLabel).addComponent(this.occuLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.occuText, 0, -1, Short.MAX_VALUE).addComponent(this.lastnameText, 0, -1, Short.MAX_VALUE).addComponent(this.firstnameText, 0, -1, Short.MAX_VALUE).addComponent(this.placetext, 0, -1, Short.MAX_VALUE).addComponent((Component)this.deathDateBean, -1, 278, Short.MAX_VALUE).addComponent((Component)this.birthDateBean, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        tabMultiLayout.setVerticalGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tabMultiLayout.createSequentialGroup().addComponent(this.labelCount1, -2, 15, -2).addGap(3, 3, 3).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lastnameLabel).addComponent(this.lastnameText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.firstnameLabel).addComponent(this.firstnameText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.birthLabel).addComponent((Component)this.birthDateBean, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.deathLabel).addComponent((Component)this.deathDateBean, -2, -1, -2)).addGap(8, 8, 8).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.placeLabel).addComponent(this.placetext, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.occuLabel).addComponent(this.occuText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maleCb).addComponent(this.femaleCb).addComponent(this.unknownCb)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.singleCb).addComponent(this.marrCb).addComponent(this.allButCb)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.result1Panel, -1, -1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(NbBundle.getMessage(SearchView.class, (String)"SearchView.tabMulti.TabConstraints.tabTitle"), new javax.swing.ImageIcon(((Object)((Object)this)).getClass().getResource("/genj/search/images/multiSearch.png")), this.tabMulti, NbBundle.getMessage(SearchView.class, (String)"SearchView.tabMulti.TabConstraints.tabToolTip"));
        GroupLayout tabTagLayout = new GroupLayout(this.tabTag);
        this.tabTag.setLayout(tabTagLayout);
        tabTagLayout.setHorizontalGroup(tabTagLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 367, Short.MAX_VALUE));
        tabTagLayout.setVerticalGroup(tabTagLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 535, Short.MAX_VALUE));
        this.jTabbedPane1.addTab(NbBundle.getMessage(SearchView.class, (String)"SearchView.tabTag.TabConstraints.tabTitle"), new javax.swing.ImageIcon(((Object)((Object)this)).getClass().getResource("/genj/search/images/tagSearch.png")), this.tabTag, NbBundle.getMessage(SearchView.class, (String)"SearchView.tabTag.TabConstraints.tabToolTip"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTabbedPane1).addGap(0, 0, 0)));
    }

    public void closing() {
        super.closing();
        if (this.results1 != null && this.results2 != null) {
            this.context.getGedcom().removeGedcomListener((GedcomListener)Spin.over((Object)this.results1));
            this.context.getGedcom().removeGedcomListener((GedcomListener)Spin.over((Object)this.results2));
        }
        SearchCommunicator.unregister((SearchCommunicator)this.searchCommunicator);
    }

    public void start() {
        if (this.context == null) {
            return;
        }
        this.getSelectedWorker().stop();
        Worker worker = this.getSelectedWorker();
        if (worker instanceof WorkerMulti) {
            this.remember(this.choiceLastname, this.oldLastnames, this.choiceLastname.getText());
            this.remember(this.choiceFirstname, this.oldFirstnames, this.choiceFirstname.getText());
            this.remember(this.choicePlace, this.oldPlaces, this.choicePlace.getText());
            this.remember(this.choiceOccu, this.oldOccupations, this.choiceOccu.getText());
            worker.start(this.context.getGedcom(), this.max_hits, this.case_sensitive, this.choiceLastname.getText(), this.choiceFirstname.getText(), this.birthDateBean, this.deathDateBean, this.choicePlace.getText(), this.choiceOccu.getText(), this.maleCb.isSelected(), this.femaleCb.isSelected(), this.unknownCb.isSelected(), this.marrCb.isSelected(), this.singleCb.isSelected(), this.allButCb.isSelected());
        } else if (worker instanceof WorkerTag) {
            String value = this.choiceValue.getText();
            String tags = this.choiceTag.getText();
            this.remember(this.choiceValue, this.oldValues, value);
            this.remember(this.choiceTag, this.oldTags, tags);
            worker.start(this.context.getGedcom(), this.max_hits, this.case_sensitive, tags, value, this.checkRegExp.isSelected());
        }
        this.connectedEntities.clear();
    }

    public void stop() {
        this.getSelectedWorker().stop();
    }

    public void clean() {
        if (this.jTabbedPane1.getSelectedComponent() == this.tabMulti) {
            this.choiceLastname.setText("");
            this.choiceFirstname.setText("");
            this.choicePlace.setText("");
            this.choiceOccu.setText("");
            this.birthDateBean.setPropertyImpl(null);
            this.birthDateBean.setFormat(PropertyDate.BETWEEN_AND);
            this.deathDateBean.setPropertyImpl(null);
            this.deathDateBean.setFormat(PropertyDate.BETWEEN_AND);
            this.maleCb.setSelected(true);
            this.femaleCb.setSelected(true);
            this.unknownCb.setSelected(true);
            this.marrCb.setSelected(true);
            this.singleCb.setSelected(true);
            this.choiceLastname.requestFocusInWindow();
        } else {
            this.choiceTag.setText("");
            this.choiceValue.setText("");
            this.choiceValue.requestFocusInWindow();
        }
        this.getSelectedResults().clear();
        this.labelCount1.setText("");
        this.notifyResults();
    }

    private void notifyResults() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                if (SearchView.this.searchCommunicator != null) {
                    SearchView.this.searchCommunicator.fireNewResults();
                }
            }
        });
    }

    public void clearHistory() {
        if (DialogManager.YES_OPTION != DialogManager.create((String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TITL_ConfirmClear"), (String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_ConfirmClear")).setMessageType(0).setOptionType(0).show()) {
            return;
        }
        if (this.jTabbedPane1.getSelectedComponent() == this.tabMulti) {
            REGISTRY.remove("old.lastnames");
            REGISTRY.remove("old.firstnames");
            REGISTRY.remove("old.places");
            this.oldLastnames = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.lastnames", DEFAULT_STR)));
            this.oldFirstnames = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.firstnames", DEFAULT_STR)));
            this.oldPlaces = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.places", DEFAULT_STR)));
            this.oldOccupations = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.occupations", DEFAULT_STR)));
            this.choiceLastname.setValues(this.oldLastnames);
            this.choiceFirstname.setValues(this.oldFirstnames);
            this.choicePlace.setValues(this.oldPlaces);
            this.choiceOccu.setValues(this.oldOccupations);
        } else {
            REGISTRY.remove("regexp");
            REGISTRY.remove("old.values");
            REGISTRY.remove("old.tags");
            this.oldTags = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.tags", DEFAULT_TAGS)));
            this.oldValues = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.values", DEFAULT_VALUES)));
            this.choiceTag.setValues(this.oldValues);
            this.choiceValue.setValues(this.oldTags);
        }
        this.notifyResults();
    }

    public void addNotify() {
        super.addNotify();
        AncestrisPlugin.register((Object)((Object)this));
    }

    public void removeNotify() {
        REGISTRY.put("old.lastnames", this.oldLastnames);
        REGISTRY.put("old.firstnames", this.oldFirstnames);
        REGISTRY.put("old.places", this.oldPlaces);
        REGISTRY.put("old.occupationss", this.oldOccupations);
        REGISTRY.put("regexp", Boolean.valueOf(this.checkRegExp.isSelected()));
        REGISTRY.put("old.values", this.oldValues);
        REGISTRY.put("old.tags", this.oldTags);
        AncestrisPlugin.unregister((Object)((Object)this));
        super.removeNotify();
    }

    public void setContext(Context newContext) {
        if (newContext == null || this.context != null) {
            return;
        }
        Gedcom newGedcom = newContext.getGedcom();
        this.stop();
        this.results1.clear();
        this.results2.clear();
        this.labelCount1.setText("");
        this.labelCount2.setText("");
        this.actionStart.setEnabled(false);
        newGedcom.addGedcomListener((GedcomListener)Spin.over((Object)this.results1));
        newGedcom.addGedcomListener((GedcomListener)Spin.over((Object)this.results2));
        this.context = newContext;
        this.actionStart.setEnabled(true);
        if (this.searchCommunicator == null) {
            this.searchCommunicator = new SearchCommunicator(){

                public List<Property> getResults() {
                    ArrayList<Property> props = new ArrayList<Property>();
                    for (Hit hit : SearchView.this.getSelectedResults().hits) {
                        props.add(hit.getProperty());
                    }
                    return props;
                }
            };
        }
        this.searchCommunicator.setGedcom(newGedcom);
    }

    public void populate(ToolBar toolbar) {
        toolbar.add((Action)this.actionStart);
        toolbar.add((Action)this.actionStop);
        toolbar.add((Action)this.actionClean);
        toolbar.add((Action)this.actionClearHistory);
        toolbar.addGlue();
        toolbar.addSeparator();
        toolbar.add((Action)this.actionSettings);
    }

    private void remember(ChoiceWidget choice, LinkedList<String> old, String value) {
        if (value.trim().length() == 0) {
            return;
        }
        old.remove(value);
        old.addFirst(value);
        if (old.size() > 16) {
            old.removeLast();
        }
        choice.setValues(old);
        choice.setText(value);
    }

    private List<AbstractAncestrisAction> createTagActions() {
        ArrayList<AbstractAncestrisAction> result = new ArrayList<AbstractAncestrisAction>();
        for (String tag : DEFAULT_TAGS) {
            result.add(new ActionTag(tag));
        }
        return result;
    }

    private List<AbstractAncestrisAction> createPatternActions() {
        ArrayList<AbstractAncestrisAction> result = new ArrayList<AbstractAncestrisAction>();
        int i = 0;
        while (true) {
            String key = "regexp." + i;
            String txt = RESOURCES.getString(key + ".txt", false);
            String pat = RESOURCES.getString(key + ".pat", false);
            if (txt == null) break;
            if (pat != null) {
                result.add(new ActionPattern(txt, pat));
            }
            ++i;
        }
        return result;
    }

    private Worker getSelectedWorker() {
        Worker worker = null;
        worker = this.jTabbedPane1.getSelectedComponent() == this.tabMulti ? this.worker1 : this.worker2;
        return worker;
    }

    private Results getSelectedResults() {
        Results results = null;
        results = this.jTabbedPane1.getSelectedComponent() == this.tabMulti ? this.results1 : this.results2;
        return results;
    }

    private void displaySettings() {
        SettingsPanel settingsPanel = new SettingsPanel(REGISTRY);
        DialogManager.create((String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TITL_ChangeSettings"), (JComponent)settingsPanel).setMessageType(-1).setOptionType(10).show();
        settingsPanel.setSettings();
        this.max_hits = settingsPanel.getMaxHits();
        this.case_sensitive = settingsPanel.getCaseSensitive();
    }

    public String getFilterName() {
        return NbBundle.getMessage(SearchView.class, (String)"TTL_Filter", (Object)this.getSelectedResults().getSize(), (Object)RESOURCES.getString("title"));
    }

    public boolean veto(Entity entity) {
        if (this.connectedEntities.isEmpty()) {
            for (Hit hit : this.getSelectedResults().hits) {
                this.connectedEntities.addAll(Utilities.getDependingEntitiesRecursively((Entity)hit.getProperty().getEntity()));
            }
        }
        return !this.connectedEntities.contains(entity);
    }

    public boolean veto(Property property) {
        PropertyXRef xref;
        return property instanceof PropertyXRef && (xref = (PropertyXRef)property).isValid() && !this.connectedEntities.contains(xref.getTargetEntity());
    }

    public boolean canApplyTo(Gedcom gedcom) {
        return gedcom != null && gedcom.equals(this.context.getGedcom());
    }

    private class ResultWidget
    extends JList
    implements ListSelectionListener,
    ListCellRenderer {
        private final Results results;
        private final JTextPane text;

        private ResultWidget(final Results results) {
            super(results);
            this.text = new JTextPane();
            this.results = results;
            this.setCellRenderer(this);
            this.addListSelectionListener(this);
            this.text.setOpaque(true);
            this.addMouseListener((MouseListener)new FilteredMouseAdapter(){

                public void mouseClickedFiltered(MouseEvent e) {
                    Property cell;
                    int row = ResultWidget.this.getSelectedIndex();
                    if (row >= 0 && (cell = results.getHit(row).getProperty()) != null && cell instanceof Property) {
                        SelectionDispatcher.fireSelection((AWTEvent)e, (Context)new Context(cell));
                    }
                }
            });
        }

        public ViewContext getContext() {
            Object[] selection;
            if (SearchView.this.context == null) {
                return null;
            }
            ArrayList<Property> properties = new ArrayList<Property>();
            for (Object selection1 : selection = this.getSelectedValues()) {
                Hit hit = (Hit)selection1;
                properties.add(hit.getProperty());
            }
            return new ViewContext(SearchView.this.context.getGedcom(), null, properties);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Hit hit = (Hit)value;
            this.text.setBorder(isSelected ? BorderFactory.createLineBorder(this.getSelectionBackground(), 1, false) : BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.text.setDocument(hit.getDocument());
            return this.text;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int row = this.getSelectedIndex();
            if (row >= 0) {
                SelectionDispatcher.fireSelection((Context)new Context(this.results.getHit(row).getProperty()));
            }
        }
    }

    private static class Results
    extends AbstractListModel
    implements GedcomListener {
        private List<Hit> hits = new ArrayList<Hit>();

        private Results() {
        }

        private void clear() {
            if (this.hits.isEmpty()) {
                return;
            }
            int size = this.hits.size();
            this.hits.clear();
            this.fireIntervalRemoved(this, 0, size - 1);
        }

        private void add(List<Hit> list) {
            if (list.isEmpty()) {
                return;
            }
            int size = this.hits.size();
            this.hits.addAll(list);
            this.fireIntervalAdded(this, size, this.hits.size() - 1);
        }

        @Override
        public Object getElementAt(int index) {
            return this.hits.get(index);
        }

        @Override
        public int getSize() {
            return this.hits.size();
        }

        private Hit getHit(int i) {
            return this.hits.get(i);
        }

        public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        }

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            for (int i = 0; i < this.hits.size(); ++i) {
                Hit hit = this.hits.get(i);
                if (hit.getProperty() != property) continue;
                this.fireContentsChanged(this, i, i);
            }
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property removed) {
            int i = 0;
            while (i < this.hits.size()) {
                Hit hit = this.hits.get(i);
                if (hit.getProperty() == removed) {
                    this.hits.remove(i);
                    this.fireIntervalRemoved(this, i, i);
                    continue;
                }
                ++i;
            }
        }
    }

    private class ActionSettings
    extends AbstractAncestrisAction {
        private ActionSettings() {
            this.setImage((Icon)IMG_SETTINGS);
            this.setTip(RESOURCES.getString("settings.tip"));
        }

        public void actionPerformed(ActionEvent event) {
            SearchView.this.displaySettings();
        }
    }

    private class ActionClearHistory
    extends AbstractAncestrisAction {
        private ActionClearHistory() {
            this.setImage((Icon)IMG_CLEAR);
            this.setTip(RESOURCES.getString("clearHistory.tip"));
        }

        public void actionPerformed(ActionEvent event) {
            SearchView.this.clearHistory();
            SearchView.this.clean();
        }
    }

    private class ActionClean
    extends AbstractAncestrisAction {
        private ActionClean() {
            this.setImage((Icon)IMG_CLEAN);
            this.setTip(RESOURCES.getString("clean.tip"));
        }

        public void actionPerformed(ActionEvent event) {
            SearchView.this.clean();
        }
    }

    private class ActionStop
    extends AbstractAncestrisAction {
        private ActionStop() {
            this.setImage((Icon)IMG_STOP);
            this.setTip(RESOURCES.getString("stop.tip"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent event) {
            SearchView.this.stop();
        }
    }

    private class ActionStart
    extends AbstractAncestrisAction {
        private ActionStart() {
            this.setImage((Icon)IMG_START);
            this.setTip(RESOURCES.getString("start.tip"));
        }

        public void actionPerformed(ActionEvent e) {
            SearchView.this.stop();
            SearchView.this.start();
        }
    }

    private class ActionPattern
    extends AbstractAncestrisAction {
        private final String pattern;

        private ActionPattern(String txt, String pat) {
            int i = txt.indexOf(32);
            if (i > 0) {
                txt = "<html><b>" + txt.substring(0, i) + "</b>&nbsp;&nbsp;&nbsp;" + txt.substring(i) + "</html>";
            }
            this.setText(txt);
            this.pattern = pat;
        }

        public void actionPerformed(ActionEvent event) {
            final JTextField field = SearchView.this.choiceValue.getTextEditor();
            int selStart = field.getSelectionStart();
            int selEnd = field.getSelectionEnd();
            if (selEnd <= selStart) {
                selEnd = selStart = field.getCaretPosition();
            }
            String all = field.getText();
            String before = all.substring(0, selStart);
            String selection = selEnd > selStart ? '(' + all.substring(selStart, selEnd) + ')' : "";
            String after = all.substring(selEnd);
            final String result = MessageFormat.format(this.pattern, all, before, selection, after);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int pos = result.indexOf(35);
                    field.setText(result.substring(0, pos) + result.substring(pos + 1));
                    field.select(0, 0);
                    field.setCaretPosition(pos);
                    SearchView.this.checkRegExp.setSelected(true);
                }
            });
        }
    }

    private class ActionTag
    extends AbstractAncestrisAction {
        private final String tags;

        private ActionTag(String tags) {
            this.tags = tags;
            WordBuffer txt = new WordBuffer(", ");
            for (String t : tags.split(",")) {
                txt.append(Gedcom.getName((String)t.trim()));
            }
            this.setText(txt.toString());
        }

        public void actionPerformed(ActionEvent event) {
            SearchView.this.choiceTag.setText(this.tags);
        }
    }
}

