/*
 * Decompiled with CFR 0.152.
 */
package genj.search;

import genj.edit.beans.DateBean;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.search.Hit;
import genj.search.Matcher;
import genj.search.Worker;
import genj.search.WorkerListener;
import java.text.Normalizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WorkerMulti
extends Worker {
    private static int MT_EQ = 0;
    private static int MT_GT = 1;
    private static int MT_LT = 2;
    private String lastnameText;
    private String firstnameText;
    private DateBean birthDateBean;
    private DateBean deathDateBean;
    private String placeText;
    private String occuText;
    private boolean isMale;
    private boolean isFemale;
    private boolean isUnknown;
    private boolean isMarried;
    private boolean isSingle;
    private boolean isAllBut;

    public WorkerMulti(WorkerListener listener) {
        super(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Gedcom gedcom, int max_hits, boolean case_sensitive, Object ... args) {
        this.lastnameText = (String)args[0];
        this.firstnameText = (String)args[1];
        this.birthDateBean = (DateBean)args[2];
        this.deathDateBean = (DateBean)args[3];
        this.placeText = (String)args[4];
        this.occuText = (String)args[5];
        this.isMale = (Boolean)args[6];
        this.isFemale = (Boolean)args[7];
        this.isUnknown = (Boolean)args[8];
        this.isMarried = (Boolean)args[9];
        this.isSingle = (Boolean)args[10];
        this.isAllBut = (Boolean)args[11];
        AtomicBoolean atomicBoolean = this.lock;
        synchronized (atomicBoolean) {
            if (this.thread != null) {
                throw new IllegalStateException("can't start while running");
            }
            this.gedcom = gedcom;
            this.max_hits = max_hits;
            this.case_sensitive = case_sensitive;
            this.matcher = this.getMatcher(!this.lastnameText.isEmpty() ? this.lastnameText : this.firstnameText, false);
            this.hits.clear();
            this.entities.clear();
            this.hitCount = 0;
            this.lock.set(true);
            this.thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        WorkerMulti.this.listener.started();
                        WorkerMulti.this.search(WorkerMulti.this.gedcom);
                        WorkerMulti.this.flush();
                    }
                    catch (Throwable t) {
                        Logger.getLogger("ancestris.search").log(Level.FINE, "worker bailed", t);
                        t.printStackTrace();
                    }
                    finally {
                        AtomicBoolean atomicBoolean = WorkerMulti.this.lock;
                        synchronized (atomicBoolean) {
                            WorkerMulti.this.thread = null;
                            WorkerMulti.this.lock.set(false);
                            WorkerMulti.this.lock.notifyAll();
                        }
                        try {
                            WorkerMulti.this.listener.stopped();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            });
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    @Override
    public void search(Entity entity, Property prop) {
        if (this.isEmptyCriteria()) {
            return;
        }
        if (!(entity instanceof Indi) && !(entity instanceof Fam)) {
            return;
        }
        if (entity instanceof Indi) {
            Indi indi = (Indi)entity;
            if (this.isMatch(indi)) {
                if (!this.isAllBut) {
                    this.addHit((Entity)indi);
                }
            } else if (this.isAllBut) {
                this.addHit((Entity)indi);
            }
        }
    }

    private boolean isMatch(Indi indi) {
        return this.isCommonString(indi.getLastNames(), this.lastnameText) && this.isCommonString(indi.getFirstNames(), this.firstnameText) && this.isCommonDate(indi.getBirthDate(), this.birthDateBean) && this.isCommonDate(indi.getDeathDate(), this.deathDateBean) && this.isCommonPlace(indi, this.placeText) && this.isCommonOccupation(indi, this.occuText) && this.isSameSex(indi.getSex(), this.isMale, this.isFemale, this.isUnknown) && this.isSameStatus(indi.getFamiliesWhereSpouse(), this.isMarried, this.isSingle);
    }

    private boolean isCommonString(String[] names, String nameText) {
        if (nameText == null || nameText.isEmpty()) {
            return true;
        }
        for (String name : names) {
            String str2;
            String str1;
            if (!(this.case_sensitive ? name.contains(nameText) : (str1 = Normalizer.normalize(name, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "").toLowerCase()).contains(str2 = Normalizer.normalize(nameText, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "").toLowerCase()))) continue;
            return true;
        }
        return false;
    }

    private boolean isCommonDate(PropertyDate dateFound, DateBean dateBean) {
        PointInTime nullPit = new PointInTime();
        if (dateBean == null) {
            return true;
        }
        PointInTime pitFrom = dateBean.getFromPIT();
        PointInTime pitTo = dateBean.getToPIT();
        if (this.isToBeSwapped(dateBean.getFormat())) {
            pitTo = pitFrom;
            pitFrom = nullPit;
        }
        if (this.isEqual(pitFrom, nullPit) && this.isEqual(pitTo, nullPit)) {
            return true;
        }
        if (dateFound == null) {
            return false;
        }
        PointInTime pit1 = dateFound.getStart();
        PointInTime pit2 = dateFound.getEnd();
        if (this.isToBeSwapped(dateFound.getFormat())) {
            pit2 = pit1;
            pit1 = nullPit;
        }
        if (this.isEqual(pit1, nullPit) && this.isEqual(pit2, nullPit)) {
            return false;
        }
        if (this.isRange(dateBean.getFormat())) {
            if (this.isRange(dateFound.getFormat())) {
                if (this.isEqual(pitFrom, nullPit)) {
                    return this.match(pit1, MT_LT, pitTo) && this.match(pit2, MT_GT, pitTo) || this.match(pit1, MT_LT, pitTo) && this.match(pit2, MT_LT, pitTo);
                }
                return this.match(pit1, MT_GT, pitFrom) && this.match(pit1, MT_LT, pitTo) || this.match(pit1, MT_LT, pitFrom) && this.match(pit2, MT_GT, pitFrom);
            }
            return this.match(pit1, MT_GT, pitFrom) && this.match(pit1, MT_LT, pitTo);
        }
        if (this.isRange(dateFound.getFormat())) {
            return false;
        }
        return this.match(pit1, MT_EQ, pitFrom);
    }

    private boolean match(PointInTime pit, int matchType, PointInTime pitRef) {
        int N = Integer.MAX_VALUE;
        int yR = pitRef.getYear();
        int mR = pitRef.getMonth();
        int dR = pitRef.getDay();
        Calendar calR = pitRef.getCalendar();
        int y = pit.getYear();
        int m = pit.getMonth();
        int d = pit.getDay();
        Calendar cal = pit.getCalendar();
        if (calR != PointInTime.GREGORIAN || cal != PointInTime.GREGORIAN) {
            try {
                if (calR != PointInTime.GREGORIAN) {
                    pitRef = pitRef.convertIncomplete((Calendar)PointInTime.GREGORIAN);
                    yR = pitRef.getYear();
                    mR = pitRef.getMonth();
                    dR = pitRef.getDay();
                    calR = PointInTime.GREGORIAN;
                }
                if (cal != PointInTime.GREGORIAN) {
                    pit = pit.convertIncomplete((Calendar)PointInTime.GREGORIAN);
                    y = pit.getYear();
                    m = pit.getMonth();
                    d = pit.getDay();
                    cal = PointInTime.GREGORIAN;
                }
                String string = "";
            }
            catch (GedcomException ex) {
                return false;
            }
        }
        if (yR == N && mR == N && dR == N) {
            return true;
        }
        if (y == N && m == N && d == N) {
            return false;
        }
        if (yR != N && y == N) {
            return false;
        }
        if (mR != N && m == N) {
            return false;
        }
        if (dR != N && d == N) {
            return false;
        }
        if (yR == N && mR == N && dR != N && d != N) {
            return this.compare(d, matchType, dR);
        }
        if (yR == N && mR != N && dR == N && m != N) {
            return this.compare(m, matchType, mR);
        }
        if (yR != N && mR == N && dR == N && y != N) {
            return this.compare(y, matchType, yR);
        }
        if (yR != N && mR == N && dR != N && y != N && d != N) {
            return this.compare(y, matchType, yR) && this.compare(d, matchType, dR);
        }
        if (mR != N && dR != N) {
            if (yR == N && y != N) {
                yR = y;
                calR = cal;
            } else if (yR == N && y == N) {
                yR = 2016;
                calR = PointInTime.GREGORIAN;
                y = 2016;
                cal = PointInTime.GREGORIAN;
            }
            return this.compare(new PointInTime(d, m, y, cal), matchType, new PointInTime(dR, mR, yR, calR));
        }
        if (yR != N && mR != N && dR == N) {
            if (d != N) {
                dR = d;
            } else if (d == N) {
                dR = 15;
                d = 15;
            }
            return this.compare(new PointInTime(d, m, y, cal), matchType, new PointInTime(dR, mR, yR, calR));
        }
        if (yR != N && mR != N && dR != N && y != N && m != N && d != N) {
            return this.compare(pit, matchType, pitRef);
        }
        return false;
    }

    private boolean isEqual(PointInTime pit1, PointInTime pit2) {
        return pit1.getDay() == pit2.getDay() && pit1.getMonth() == pit2.getMonth() && pit1.getYear() == pit2.getYear() && pit1.getCalendar().getName().equals(pit2.getCalendar().getName());
    }

    private boolean compare(int i, int matchType, int ref) {
        if (matchType == MT_EQ) {
            return i == ref;
        }
        if (matchType == MT_GT) {
            return i >= ref;
        }
        if (matchType == MT_LT) {
            return i <= ref;
        }
        return false;
    }

    private boolean compare(PointInTime pit, int matchType, PointInTime pitRef) {
        if (matchType == MT_EQ) {
            return pit.compareTo(pitRef) == 0;
        }
        if (matchType == MT_GT) {
            return pit.compareTo(pitRef) >= 0;
        }
        if (matchType == MT_LT) {
            return pit.compareTo(pitRef) <= 0;
        }
        return false;
    }

    private boolean isCommonPlace(Indi indi, String placeText) {
        Fam[] fams;
        if (placeText.isEmpty()) {
            return true;
        }
        for (PropertyPlace prop : indi.getProperties(PropertyPlace.class)) {
            String place = prop.getDisplayValue();
            if (!(this.case_sensitive ? place.contains(placeText) : place.toLowerCase().contains(placeText.toLowerCase()))) continue;
            return true;
        }
        for (Fam fam : fams = indi.getFamiliesWhereSpouse()) {
            for (PropertyPlace prop : fam.getProperties(PropertyPlace.class)) {
                String place = prop.getDisplayValue();
                if (!(this.case_sensitive ? place.contains(placeText) : place.toLowerCase().contains(placeText.toLowerCase()))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCommonOccupation(Indi indi, String occuText) {
        if (occuText.isEmpty()) {
            return true;
        }
        for (Property prop : indi.getAllProperties("OCCU")) {
            String occupation = prop.getDisplayValue();
            if (!(this.case_sensitive ? occupation.contains(occuText) : occupation.toLowerCase().contains(occuText.toLowerCase()))) continue;
            return true;
        }
        return false;
    }

    private boolean isSameSex(int sex, boolean male, boolean female, boolean unknown) {
        if (!(male || female || unknown)) {
            return false;
        }
        return sex == 1 && male || sex == 2 && female || sex == 0 && unknown;
    }

    private boolean isSameStatus(Fam[] familiesWhereSpouse, boolean married, boolean single) {
        if (!married && !single) {
            return false;
        }
        return married && familiesWhereSpouse != null && familiesWhereSpouse.length != 0 || single && (familiesWhereSpouse == null || familiesWhereSpouse.length == 0);
    }

    private void addHit(Entity entity) {
        Matcher.Match[] matches = this.matcher.match(entity.toString(true));
        if (this.hitCount >= this.max_hits) {
            return;
        }
        this.entities.add(entity);
        Hit hit = new Hit((Property)entity, entity.toString(true), matches, this.entities.size(), true);
        this.hits.add(hit);
        ++this.hitCount;
        long now = System.currentTimeMillis();
        if (now - this.lastFlush > 500L) {
            this.flush();
        }
        this.lastFlush = now;
    }

    private boolean isEmptyCriteria() {
        return this.lastnameText.isEmpty() && this.firstnameText.isEmpty() && this.placeText.isEmpty() && !this.isMale && !this.isFemale && !this.isUnknown && !this.isMarried && !this.isSingle;
    }

    private boolean isRange(PropertyDate.Format format) {
        return format.equals(PropertyDate.FROM_TO) || format.equals(PropertyDate.FROM) || format.equals(PropertyDate.TO) || format.equals(PropertyDate.BETWEEN_AND) || format.equals(PropertyDate.BEFORE) || format.equals(PropertyDate.AFTER);
    }

    private boolean isToBeSwapped(PropertyDate.Format format) {
        return format.equals(PropertyDate.TO) || format.equals(PropertyDate.BEFORE);
    }
}

