/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree.build;

import ancestris.report.svgtree.FamBox;
import ancestris.report.svgtree.IndiBox;
import ancestris.report.svgtree.build.NoSpouseFilter;
import ancestris.report.svgtree.build.RemoveFamboxes;
import ancestris.report.svgtree.build.RemoveFamboxesWhereNoSpouse;
import ancestris.report.svgtree.build.TreeBuilder;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class BasicTreeBuilder
implements TreeBuilder {
    public int gen_ancestors = 0;
    public String[] gen_ancestorss = new String[]{"nolimit", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    public int gen_ancestor_descendants = 0;
    public String[] gen_ancestor_descendantss = new String[]{"nolimit", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    public int gen_descendants = 0;
    public String[] gen_descendantss = new String[]{"nolimit", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    public boolean show_spouses = true;
    public boolean other_marriages = true;
    public boolean display_fambox = true;

    @Override
    public IndiBox build(Indi indi) {
        IndiBox indibox = new IndiBox(indi);
        this.buildTree(indibox, IndiBox.Direction.NONE, 0, 0);
        if (!this.show_spouses) {
            new NoSpouseFilter().filter(indibox);
        }
        if (!this.display_fambox) {
            new RemoveFamboxes().filter(indibox);
        } else {
            new RemoveFamboxesWhereNoSpouse().filter(indibox);
        }
        return indibox;
    }

    private void buildTree(IndiBox indibox, IndiBox.Direction dir, int genUp, int genDown) {
        ArrayList<Fam> families = new ArrayList<Fam>(Arrays.asList(indibox.individual.getFamiliesWhereSpouse()));
        Fam indiboxFamily = null;
        if (!families.isEmpty()) {
            IndiBox last;
            indiboxFamily = (Fam)families.get(0);
            Indi spouse = null;
            if (dir == IndiBox.Direction.PARENT) {
                indiboxFamily = indibox.prev.individual.getFamiliesWhereChild()[0];
                spouse = indiboxFamily.getOtherSpouse(indibox.individual);
                if (spouse != null) {
                    families.addAll(Arrays.asList(spouse.getFamiliesWhereSpouse()));
                }
                while (families.remove(indiboxFamily)) {
                }
                families.add(0, indiboxFamily);
            } else {
                spouse = indiboxFamily.getOtherSpouse(indibox.individual);
            }
            indibox.family = new FamBox(indiboxFamily);
            if (spouse != null) {
                indibox.spouse = new IndiBox(spouse, indibox);
            }
            if (this.other_marriages || genDown != 0) {
                last = indibox.spouse;
                if (last == null) {
                    last = indibox;
                }
                Iterator i = families.iterator();
                i.next();
                while (i.hasNext()) {
                    Fam f = (Fam)i.next();
                    Indi indi = indibox.individual;
                    if (indibox.individual != f.getHusband() && indibox.individual != f.getWife()) {
                        indi = spouse;
                    }
                    IndiBox box = new IndiBox(indi, last);
                    box.family = new FamBox(f);
                    if (f.getOtherSpouse(indi) != null) {
                        box.spouse = new IndiBox(f.getOtherSpouse(indi), box);
                    }
                    last.nextMarriage = box;
                    last = box.spouse;
                    if (last != null) continue;
                    last = box;
                }
            }
            last = indibox;
            while (last != null) {
                if (genUp == 0 && (this.gen_descendants == 0 || genDown < this.gen_descendants - 1) || genUp < 0 && (this.gen_ancestor_descendants == 0 || genDown < this.gen_ancestor_descendants - 1)) {
                    ArrayList<Indi> children = new ArrayList<Indi>(Arrays.asList(last.getFamily().getChildren()));
                    if (last == indibox && dir == IndiBox.Direction.PARENT) {
                        children.remove(indibox.prev.individual);
                    }
                    last.children = new IndiBox[children.size()];
                    for (int j = 0; j < children.size(); ++j) {
                        last.children[j] = new IndiBox((Indi)children.get(j), last);
                        this.buildTree(last.children[j], IndiBox.Direction.CHILD, genUp, genDown + 1);
                    }
                }
                if (!this.other_marriages && genDown == 0) {
                    last = null;
                    continue;
                }
                if (last.spouse != null) {
                    last = last.spouse.nextMarriage;
                    continue;
                }
                last = last.nextMarriage;
            }
        }
        if (!(dir != IndiBox.Direction.PARENT && dir != IndiBox.Direction.NONE || this.gen_ancestors != 0 && -genUp >= this.gen_ancestors - 1)) {
            Indi parent = this.getParent(indibox.individual);
            if (parent != null) {
                indibox.parent = new IndiBox(parent, indibox);
                this.buildTree(indibox.parent, IndiBox.Direction.PARENT, genUp - 1, genDown);
            }
            if (indibox.spouse != null && (parent = this.getParent(indibox.spouse.individual)) != null) {
                indibox.spouse.parent = new IndiBox(parent, indibox.spouse);
                this.buildTree(indibox.spouse.parent, IndiBox.Direction.PARENT, genUp - 1, genDown);
            }
        }
    }

    private Indi getParent(Indi i) {
        Fam[] fs = i.getFamiliesWhereChild();
        if (fs.length == 0) {
            return null;
        }
        Fam f = fs[0];
        if (f.getHusband() != null) {
            return f.getHusband();
        }
        return f.getWife();
    }
}

