/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree.graphics;

import ancestris.report.svgtree.graphics.GraphicsFileOutput;
import ancestris.report.svgtree.graphics.GraphicsRenderer;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.fop.svg.PDFDocumentGraphics2D;

public class PdfWriter
extends GraphicsFileOutput {
    @Override
    public void write(OutputStream out, GraphicsRenderer renderer) throws IOException {
        int width = renderer.getImageWidth();
        int height = renderer.getImageHeight();
        double scale = 1.0;
        if (width > 14400) {
            scale = 14400.0 / (double)width;
            width = 14400;
            height = (int)((double)height * scale);
        }
        if (height > 14400) {
            scale = 14400.0 / (double)height;
            height = 14400;
            width = (int)((double)width * scale);
        }
        PDFDocumentGraphics2D pdfGraphics = new PDFDocumentGraphics2D(true, out, width, height);
        pdfGraphics.setGraphicContext(new GraphicContext());
        pdfGraphics.fill((Shape)new Rectangle(0, 0, 1, 1));
        if (scale != 1.0) {
            AffineTransform transform = pdfGraphics.getTransform();
            transform.scale(scale, scale);
            pdfGraphics.setTransform(transform);
        }
        renderer.render((Graphics2D)pdfGraphics);
        pdfGraphics.finish();
    }

    @Override
    public String getFileExtension() {
        return "pdf";
    }
}

