/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree.output;

import ancestris.core.TextOptions;
import ancestris.report.svgtree.FamBox;
import ancestris.report.svgtree.IndiBox;
import ancestris.report.svgtree.output.TreeElements;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.TagPath;
import genj.renderer.MediaRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;

public class GraphicsTreeElements
implements TreeElements {
    private static final int DEFAULT_INDIBOX_WIDTH = 110;
    private static final int SHRINKED_INDIBOX_WIDTH = 50;
    private static final int DEFAULT_INDIBOX_HEIGHT = 64;
    private static final int DEFAULT_FAMBOX_WIDTH = 100;
    private static final int DEFAULT_FAMBOX_HEIGHT = 27;
    private static final int MAX_IMAGE_WIDTH = 50;
    private static final int DEFAULT_INDIBOX_LINES = 2;
    private static final int DEFAULT_FAMBOX_LINES = 1;
    private static final int TEXT_MARGIN = 5;
    private static final int NAME_LINE_HEIGHT = 12;
    private static final int LINE_HEIGHT = 10;
    private static final TagPath PATH_INDIBIRTPLAC = new TagPath("INDI:BIRT:PLAC");
    private static final TagPath PATH_INDIDEATPLAC = new TagPath("INDI:DEAT:PLAC");
    private static final TagPath PATH_INDIOCCU = new TagPath("INDI:OCCU");
    private static final TagPath PATH_INDITITL = new TagPath("INDI:TITL");
    private static final TagPath PATH_FAMMARRPLAC = new TagPath("FAM:MARR:PLAC");
    private static final TagPath PATH_FAMDIVPLAC = new TagPath("FAM:DIV:PLAC");
    private double IMAGE_SCALE_FACTOR = 4.0;
    private static final FontRenderContext FONT_RENDER_CONTEXT = new FontRenderContext(null, false, false);
    private static final Color[] BOX_COLORS = new Color[]{new Color(255, 255, 255), new Color(206, 182, 189), new Color(222, 85, 255), new Color(132, 130, 255), new Color(173, 174, 239), new Color(173, 207, 255), new Color(231, 219, 231), new Color(214, 93, 90), new Color(255, 130, 181), new Color(239, 174, 198), new Color(255, 221, 221), new Color(206, 170, 49), new Color(255, 221, 0), new Color(255, 255, 51), new Color(255, 255, 221), new Color(222, 255, 222), new Color(130, 255, 130), new Color(26, 225, 26), new Color(169, 208, 169), new Color(169, 208, 191), new Color(187, 187, 187), new Color(170, 149, 149), new Color(158, 163, 178), new Color(205, 211, 233), new Color(223, 226, 226), new Color(250, 250, 250), new Color(255, 255, 255)};
    private static final int COLOR_GENERATIONS = (BOX_COLORS.length - 1) / 2;
    private static final float STROKE_WIDTH = 2.0f;
    private static final String MALE_SYMBOL = "\u2642";
    private static final String FEMALE_SYMBOL = "\u2640";
    private static final String UNKNOWN_SYMBOL = "?";
    private static final Stroke DASHED_STROKE = new BasicStroke(2.0f, 2, 0, 10.0f, new float[]{3.0f, 6.0f}, 0.0f);
    private static final Font DETAILS_FONT = new Font("verdana", 0, 10);
    private static final Font NAME_FONT = new Font("verdana", 1, 12);
    private static final Font ID_FONT = new Font("verdana", 2, 10);
    private static Font sexSymbolFont = null;
    public int max_names = 0;
    public String[] max_namess = new String[]{"nolimit", "1", "2", "3"};
    public int max_names_per_line = 2;
    public String[] max_names_per_lines = new String[]{"nolimit", "1", "2", "3"};
    public boolean draw_title = false;
    public boolean draw_name_suffix = false;
    public int font_name_suffix = 3;
    public String[] font_name_suffixs = new String[]{"plain", "bold", "italic", "bolditalic"};
    public boolean draw_places = true;
    public String place_display_format = "";
    public boolean draw_dates = true;
    public boolean draw_occupation = true;
    public boolean draw_images = true;
    public boolean high_quality_images = false;
    public boolean draw_sex_symbols = true;
    public boolean draw_indi_ids = false;
    public boolean draw_fam_ids = false;
    public boolean draw_divorce = true;
    public boolean shrink_boxes = false;
    public boolean use_colors = true;
    public boolean swap_names = false;
    private Graphics2D graphics = null;

    @Override
    public void setGraphics(Graphics2D graphics) {
        this.graphics = graphics;
    }

    @Override
    public void drawIndiBox(IndiBox indibox, int x, int y, int gen) {
        if (!this.graphics.hitClip(x, y, indibox.width, indibox.height)) {
            return;
        }
        Indi i = indibox.individual;
        int imageWidth = 0;
        int imageHeight = indibox.height;
        if (this.draw_images) {
            Dimension d = MediaRenderer.getSize((Property)i, (Graphics)this.graphics);
            if (d.width > 0 && d.height > 0) {
                imageWidth = d.width * indibox.height / d.height;
            }
            if (imageWidth > 50) {
                imageWidth = 50;
                imageHeight = d.height * imageWidth / d.width;
            }
        }
        int dataWidth = indibox.width - imageWidth;
        Color color = this.getBoxColor(gen);
        RoundRectangle2D.Double box = new RoundRectangle2D.Double(x, y, indibox.width, indibox.height, 15.0, 15.0);
        this.graphics.setColor(color);
        this.graphics.fill(box);
        this.graphics.setColor(Color.BLACK);
        Shape oldClip = this.graphics.getClip();
        this.graphics.clip(box);
        String nameSuffix = null;
        if (this.draw_name_suffix && (nameSuffix = i.getNameSuffix()) != null && nameSuffix.equals("")) {
            nameSuffix = null;
        }
        int currentY = y + 14;
        String[] firstNames = this.getFirstNames(i);
        String lastName = null;
        lastName = this.draw_title && i.getProperty(PATH_INDITITL) != null ? i.getLastName() + " " + i.getProperty(PATH_INDITITL) : i.getLastName();
        if (this.swap_names) {
            this.graphics.setFont(NAME_FONT);
            GraphicsTreeElements.centerString(this.graphics, lastName, x + dataWidth / 2, currentY);
            currentY += 12;
            if (nameSuffix != null) {
                this.graphics.setFont(new Font("verdana", this.font_name_suffix, 12));
                GraphicsTreeElements.centerString(this.graphics, nameSuffix, x + dataWidth / 2, currentY);
                currentY += 12;
            }
        }
        this.graphics.setFont(NAME_FONT);
        for (int j = 0; j < firstNames.length; ++j) {
            GraphicsTreeElements.centerString(this.graphics, firstNames[j], x + dataWidth / 2, currentY);
            currentY += 12;
        }
        if (!this.swap_names) {
            this.graphics.setFont(NAME_FONT);
            GraphicsTreeElements.centerString(this.graphics, lastName, x + dataWidth / 2, currentY);
            currentY += 12;
            if (nameSuffix != null) {
                this.graphics.setFont(new Font("verdana", this.font_name_suffix, 12));
                GraphicsTreeElements.centerString(this.graphics, nameSuffix, x + dataWidth / 2, currentY);
                currentY += 12;
            }
        }
        this.graphics.setFont(DETAILS_FONT);
        PropertyDate birthDate = null;
        PropertyDate deathDate = null;
        PropertyPlace birthPlace = null;
        PropertyPlace deathPlace = null;
        Property occupation = null;
        if (this.draw_dates) {
            birthDate = i.getBirthDate();
            if (birthDate != null && !birthDate.isValid()) {
                birthDate = null;
            }
            if ((deathDate = i.getDeathDate()) != null && !deathDate.isValid()) {
                deathDate = null;
            }
        }
        if (this.draw_places) {
            birthPlace = (PropertyPlace)i.getProperty(PATH_INDIBIRTPLAC);
            if (birthPlace != null && birthPlace.getDisplayValue().equals("")) {
                birthPlace = null;
            }
            if ((deathPlace = (PropertyPlace)i.getProperty(PATH_INDIDEATPLAC)) != null && deathPlace.getDisplayValue().equals("")) {
                deathPlace = null;
            }
        }
        if (this.draw_occupation) {
            occupation = i.getProperty(PATH_INDIOCCU);
        }
        if (birthDate != null || birthPlace != null) {
            GraphicsTreeElements.centerString(this.graphics, TextOptions.getInstance().getBirthSymbol(), x + 7, currentY);
            if (birthDate != null) {
                this.graphics.drawString(birthDate.getDisplayValue(), x + 13, currentY);
                currentY += 10;
            }
            if (birthPlace != null) {
                this.graphics.drawString(birthPlace.format(this.place_display_format).replaceAll("^(,|(, ))*", "").trim(), x + 13, currentY);
                currentY += 10;
            }
        }
        if (i.getDeathDate() != null || i.getProperty(PATH_INDIDEATPLAC) != null) {
            GraphicsTreeElements.centerString(this.graphics, TextOptions.getInstance().getDeathSymbol(), x + 7, currentY);
            if (deathDate != null) {
                this.graphics.drawString(deathDate.getDisplayValue(), x + 13, currentY);
                currentY += 10;
            }
            if (deathPlace != null) {
                this.graphics.drawString(deathPlace.format(this.place_display_format).replaceAll("^(,|(, ))*", "").trim(), x + 13, currentY);
                currentY += 10;
            }
            if (deathDate == null && deathPlace == null) {
                currentY += 10;
            }
        }
        if (occupation != null) {
            this.graphics.drawString(occupation.getDisplayValue(), x + 6, currentY);
        }
        if (this.draw_sex_symbols) {
            int symbolX = x + dataWidth - 14;
            int symbolY = y + indibox.height - 5;
            this.graphics.setFont(sexSymbolFont);
            this.graphics.drawString(GraphicsTreeElements.getSexSymbol(i.getSex()), symbolX, symbolY);
        }
        if (this.draw_indi_ids) {
            this.graphics.setFont(ID_FONT);
            this.graphics.drawString(i.getId(), x + 8, y + indibox.height - 4);
        }
        if (imageWidth > 0) {
            AffineTransform transform = null;
            double scale = 1.0;
            if (this.high_quality_images) {
                transform = this.graphics.getTransform();
                this.graphics.scale(1.0 / this.IMAGE_SCALE_FACTOR, 1.0 / this.IMAGE_SCALE_FACTOR);
                scale = this.IMAGE_SCALE_FACTOR;
            }
            MediaRenderer.render((Graphics)this.graphics, (Rectangle)new Rectangle((int)((double)x + (double)dataWidth * scale), y, (int)((double)imageWidth * scale), (int)((double)imageHeight * scale)), (Property)i);
            if (this.high_quality_images) {
                this.graphics.setTransform(transform);
            }
        }
        this.graphics.setClip(oldClip);
        this.graphics.draw(box);
    }

    @Override
    public void drawFamBox(FamBox fambox, int x, int y, int gen) {
        if (!this.graphics.hitClip(x, y, fambox.width, fambox.height)) {
            return;
        }
        Fam f = fambox.family;
        Color color = this.getBoxColor(gen);
        RoundRectangle2D.Double box = new RoundRectangle2D.Double(x, y, fambox.width, fambox.height, 5.0, 5.0);
        this.graphics.setColor(color);
        this.graphics.fill(box);
        this.graphics.setColor(Color.BLACK);
        Shape oldClip = this.graphics.getClip();
        this.graphics.clip(box);
        int currentY = y + 12;
        this.graphics.setFont(DETAILS_FONT);
        PropertyDate marriageDate = null;
        PropertyDate divorceDate = null;
        PropertyPlace marriagePlace = null;
        PropertyPlace divorcePlace = null;
        if (this.draw_dates) {
            marriageDate = f.getMarriageDate();
            if (marriageDate != null && !marriageDate.isValid()) {
                marriageDate = null;
            }
            if ((divorceDate = f.getDivorceDate()) != null && !divorceDate.isValid()) {
                divorceDate = null;
            }
        }
        if (this.draw_places) {
            marriagePlace = (PropertyPlace)f.getProperty(PATH_FAMMARRPLAC);
            if (marriagePlace != null && marriagePlace.getDisplayValue().equals("")) {
                marriagePlace = null;
            }
            if ((divorcePlace = (PropertyPlace)f.getProperty(PATH_FAMDIVPLAC)) != null && divorcePlace.getDisplayValue().equals("")) {
                divorcePlace = null;
            }
        }
        if (f.getMarriageDate() != null) {
            GraphicsTreeElements.centerString(this.graphics, TextOptions.getInstance().getMarriageSymbol(), x + 13, currentY);
            if (marriageDate != null) {
                this.graphics.drawString(marriageDate.getDisplayValue(), x + 25, currentY);
                currentY += 10;
            }
            if (marriagePlace != null) {
                this.graphics.drawString(marriagePlace.format(this.place_display_format).replaceAll("^(,|(, ))*", "").trim(), x + 13, currentY);
                currentY += 10;
            }
            if (marriageDate == null && marriagePlace == null) {
                currentY += 10;
            }
        }
        if (this.draw_divorce && f.getDivorceDate() != null) {
            GraphicsTreeElements.centerString(this.graphics, TextOptions.getInstance().getDivorceSymbol(), x + 13, currentY);
            if (divorceDate != null) {
                this.graphics.drawString(divorceDate.getDisplayValue(), x + 25, currentY);
                currentY += 10;
            }
            if (divorcePlace != null) {
                this.graphics.drawString(divorcePlace.format(this.place_display_format).replaceAll("^(,|(, ))*", "").trim(), x + 13, currentY);
                currentY += 10;
            }
            if (divorceDate == null && divorcePlace == null) {
                currentY += 10;
            }
        }
        if (this.draw_fam_ids) {
            this.graphics.setFont(ID_FONT);
            this.graphics.drawString(f.getId(), x + 8, y + fambox.height - 4);
        }
        this.graphics.setClip(oldClip);
        this.graphics.draw(box);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.graphics.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawDashedLine(int x1, int y1, int x2, int y2) {
        Stroke oldStroke = this.graphics.getStroke();
        this.graphics.setStroke(DASHED_STROKE);
        this.graphics.drawLine(x1, y1, x2, y2);
        this.graphics.setStroke(oldStroke);
    }

    @Override
    public void header(int width, int height) {
        this.graphics.setStroke(new BasicStroke(2.0f));
        this.graphics.setBackground(Color.WHITE);
        this.graphics.clearRect(0, 0, width, height);
    }

    @Override
    public void footer() {
    }

    public static void centerString(Graphics2D graphics, String text, int x, int y) {
        int width = GraphicsTreeElements.getTextWidth(text, graphics.getFont(), graphics);
        graphics.drawString(text, x - width / 2, y);
    }

    public static void alignRightString(Graphics2D graphics, String text, int x, int y) {
        int width = GraphicsTreeElements.getTextWidth(text, graphics.getFont(), graphics);
        graphics.drawString(text, x - width, y);
    }

    private static int getTextWidth(String text, Font font, Graphics2D graphics) {
        FontRenderContext fontRenderContext = FONT_RENDER_CONTEXT;
        if (graphics != null) {
            fontRenderContext = graphics.getFontRenderContext();
        }
        return (int)font.getStringBounds(text, fontRenderContext).getWidth();
    }

    private static int getTextWidth(String text, Font font) {
        return GraphicsTreeElements.getTextWidth(text, font, null);
    }

    private static String getSexSymbol(int sex) {
        if (sex == 1) {
            return MALE_SYMBOL;
        }
        if (sex == 2) {
            return FEMALE_SYMBOL;
        }
        return UNKNOWN_SYMBOL;
    }

    private Color getBoxColor(int gen) {
        if (!this.use_colors) {
            return Color.WHITE;
        }
        if (gen == 0) {
            return BOX_COLORS[COLOR_GENERATIONS];
        }
        if (gen < 0) {
            return BOX_COLORS[-((-gen - 1) % COLOR_GENERATIONS) + COLOR_GENERATIONS - 1];
        }
        return BOX_COLORS[(gen - 1) % COLOR_GENERATIONS + COLOR_GENERATIONS + 1];
    }

    private String[] getFirstNames(Indi indi) {
        String firstName = indi.getFirstName();
        if (this.max_names <= 0 && this.max_names_per_line <= 0) {
            return new String[]{firstName};
        }
        if (firstName.trim().equals("")) {
            return new String[]{""};
        }
        String[] names = firstName.split("  *");
        int namesCount = names.length;
        if (this.max_names > 0 && this.max_names < namesCount) {
            namesCount = this.max_names;
        }
        int linesCount = 1;
        if (this.max_names_per_line > 0) {
            linesCount = (namesCount - 1) / this.max_names_per_line + 1;
        }
        String[] lines = new String[linesCount];
        boolean currentName = false;
        for (int j = 0; j < linesCount; ++j) {
            int n;
            StringBuffer sb = new StringBuffer();
            for (int k = 0; k < this.max_names_per_line && (n = j * this.max_names_per_line + k) < namesCount; ++k) {
                sb.append(names[n]).append(" ");
            }
            lines[j] = sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
        }
        return lines;
    }

    @Override
    public void getIndiBoxSize(IndiBox indibox) {
        PropertyPlace deathPlace;
        Indi i = indibox.individual;
        indibox.height = 64;
        indibox.width = this.shrink_boxes ? 50 : 110;
        int lines = 0;
        if (this.draw_dates && i.getBirthDate() != null && i.getBirthDate().isValid()) {
            ++lines;
        }
        PropertyPlace birthPlace = (PropertyPlace)i.getProperty(PATH_INDIBIRTPLAC);
        if (this.draw_places && birthPlace != null && !birthPlace.getDisplayValue().equals("")) {
            ++lines;
        }
        if ((deathPlace = (PropertyPlace)i.getProperty(PATH_INDIDEATPLAC)) != null && deathPlace.getDisplayValue().equals("")) {
            deathPlace = null;
        }
        if (i.getDeathDate() != null || deathPlace != null) {
            ++lines;
            if (this.draw_dates && this.draw_places && i.getDeathDate() != null && i.getDeathDate().isValid() && deathPlace != null) {
                ++lines;
            }
        }
        if (this.draw_occupation && i.getProperty(PATH_INDIOCCU) != null) {
            ++lines;
        }
        if (lines - 2 > 0) {
            indibox.height += (lines - 2) * 10;
        }
        int width = 0;
        String[] firstNames = this.getFirstNames(i);
        for (int j = 0; j < firstNames.length; ++j) {
            int w2 = GraphicsTreeElements.getTextWidth(firstNames[j], NAME_FONT);
            width = width > w2 ? width : w2;
        }
        indibox.height += (firstNames.length - 1) * 12;
        if (this.draw_name_suffix && i.getNameSuffix() != null && i.getNameSuffix().length() > 0) {
            indibox.height += 12;
        }
        if (width + 10 > indibox.width) {
            indibox.width = width + 10;
        }
        if ((width = this.draw_title && i.getProperty(PATH_INDITITL) != null ? GraphicsTreeElements.getTextWidth(i.getLastName() + " " + i.getProperty(PATH_INDITITL), NAME_FONT) : GraphicsTreeElements.getTextWidth(i.getLastName(), NAME_FONT)) + 10 > indibox.width) {
            indibox.width = width + 10;
        }
        if ((width = GraphicsTreeElements.getTextWidth(i.getNameSuffix(), NAME_FONT)) + 10 > indibox.width) {
            indibox.width = width + 10;
        }
        if (i.getBirthDate() != null && (width = GraphicsTreeElements.getTextWidth(i.getBirthDate().getDisplayValue(), DETAILS_FONT)) + 13 + 5 > indibox.width) {
            indibox.width = width + 13 + 5;
        }
        if (i.getDeathDate() != null && (width = GraphicsTreeElements.getTextWidth(i.getDeathDate().getDisplayValue(), DETAILS_FONT)) + 13 + 5 > indibox.width) {
            indibox.width = width + 13 + 5;
        }
        if (this.draw_places) {
            if (birthPlace != null && (width = GraphicsTreeElements.getTextWidth(birthPlace.format(this.place_display_format).replaceAll("^(,|(, ))*", "").trim(), DETAILS_FONT)) + 13 + 5 > indibox.width) {
                indibox.width = width + 13 + 5;
            }
            if (deathPlace != null && (width = GraphicsTreeElements.getTextWidth(deathPlace.format(this.place_display_format).replaceAll("^(,|(, ))*", "").trim(), DETAILS_FONT)) + 13 + 5 > indibox.width) {
                indibox.width = width + 13 + 5;
            }
        }
        if (this.draw_occupation && i.getProperty(PATH_INDIOCCU) != null && (width = GraphicsTreeElements.getTextWidth(i.getProperty(PATH_INDIOCCU).getDisplayValue(), DETAILS_FONT)) + 7 + 5 > indibox.width) {
            indibox.width = width + 7 + 5;
        }
        if (this.draw_indi_ids) {
            width = GraphicsTreeElements.getTextWidth(i.getId(), ID_FONT);
            if (this.draw_sex_symbols) {
                width += 14;
            }
            if (width + 8 + 5 > indibox.width) {
                indibox.width = width + 8 + 5;
            }
        }
        if (this.draw_images) {
            Dimension d = MediaRenderer.getSize((Property)i, (Graphics)this.graphics);
            if (d.width > 0 && d.height > 0) {
                int newWidth = d.width * 64 / d.height;
                indibox.width = newWidth < 50 ? (indibox.width += newWidth) : (indibox.width += 50);
            }
        }
    }

    @Override
    public void getFamBoxSize(FamBox fambox) {
        int width;
        Fam f = fambox.family;
        fambox.width = 100;
        fambox.height = 27;
        int lines = 0;
        PropertyPlace marriagePlace = (PropertyPlace)f.getProperty(PATH_FAMMARRPLAC);
        if (f.getMarriageDate() != null) {
            ++lines;
            if (this.draw_dates && this.draw_places && f.getMarriageDate().isValid() && marriagePlace != null && !marriagePlace.getDisplayValue().equals("")) {
                ++lines;
            }
        }
        PropertyPlace divorcePlace = (PropertyPlace)f.getProperty(PATH_FAMDIVPLAC);
        if (this.draw_divorce && f.getDivorceDate() != null) {
            ++lines;
            if (this.draw_dates && this.draw_places && f.getDivorceDate().isValid() && divorcePlace != null && !divorcePlace.getDisplayValue().equals("")) {
                ++lines;
            }
        }
        if (lines - 1 > 0) {
            fambox.height += (lines - 1) * 10;
        }
        if (f.getMarriageDate() != null && (width = GraphicsTreeElements.getTextWidth(f.getMarriageDate().getDisplayValue(), DETAILS_FONT)) + 25 + 5 > fambox.width) {
            fambox.width = width + 25 + 5;
        }
        if (this.draw_divorce && f.getDivorceDate() != null && (width = GraphicsTreeElements.getTextWidth(f.getDivorceDate().getDisplayValue(), DETAILS_FONT)) + 25 + 5 > fambox.width) {
            fambox.width = width + 25 + 5;
        }
        if (this.draw_places) {
            if (marriagePlace != null && (width = GraphicsTreeElements.getTextWidth(marriagePlace.format(this.place_display_format).replaceAll("^(,|(, ))*", "").trim(), DETAILS_FONT)) + 25 + 5 > fambox.width) {
                fambox.width = width + 25 + 5;
            }
            if (this.draw_divorce && divorcePlace != null && (width = GraphicsTreeElements.getTextWidth(divorcePlace.format(this.place_display_format).replaceAll("^(,|(, ))*", "").trim(), DETAILS_FONT)) + 25 + 5 > fambox.width) {
                fambox.width = width + 25 + 5;
            }
        }
    }

    static {
        String[] candidateFontNames = new String[]{"sansserif", "apple symbol", "symbol"};
        for (int i = 0; i < candidateFontNames.length; ++i) {
            Font candidateFont = new Font(candidateFontNames[i], 0, 10);
            if (!candidateFont.canDisplay(MALE_SYMBOL.charAt(0))) continue;
            sexSymbolFont = candidateFont;
            break;
        }
        if (sexSymbolFont == null) {
            sexSymbolFont = new Font("SansSerif", 0, 10);
        }
    }
}

