/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.edit.beans.CCPMenu;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.util.swing.NestedBlockLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EventBean
extends PropertyBean {
    private static final NestedBlockLayout LAYOUT = new NestedBlockLayout("<col><row><at/><age wx=\"1\"/></row><row><known/></row></col>");
    private JCheckBox cKnown;
    private JLabel lAgeAt;
    private JTextField tAge;

    public EventBean() {
        this.setLayout((LayoutManager)LAYOUT.copy());
        this.lAgeAt = new JLabel();
        this.tAge = new JTextField("", 16);
        this.tAge.setComponentPopupMenu(new CCPMenu(this.tAge));
        this.tAge.setEditable(false);
        this.tAge.setFocusable(false);
        this.cKnown = new JCheckBox(RESOURCES.getString("even.known"));
        this.cKnown.addActionListener((ActionListener)this.changeSupport);
        this.add(this.lAgeAt);
        this.add(this.tAge);
        this.add(this.cKnown);
    }

    protected void commitImpl(Property property) {
        if (this.cKnown.isVisible()) {
            ((PropertyEvent)property).setKnownToHaveHappened(this.cKnown.isSelected());
        }
    }

    public boolean isEditable() {
        return this.cKnown.isVisible();
    }

    public void setPropertyImpl(Property prop) {
        PropertyEvent event = (PropertyEvent)prop;
        if (event != null && event.getEntity() instanceof Indi) {
            Indi indi = (Indi)event.getEntity();
            PropertyDate date = event.getDate(true);
            String ageat = "even.age";
            String age = "";
            if ("BIRT".equals(event.getTag())) {
                Delta delta;
                ageat = "even.age.today";
                if (date != null && (delta = Delta.get((PointInTime)date.getStart(), (PointInTime)PointInTime.getNow())) != null) {
                    age = delta.toString();
                }
            } else {
                age = date != null ? indi.getAgeString(date.getStart()) : RESOURCES.getString("even.age.?");
            }
            this.lAgeAt.setText(RESOURCES.getString(ageat));
            this.tAge.setText(age);
            this.lAgeAt.setVisible(true);
            this.tAge.setVisible(true);
        } else {
            this.lAgeAt.setVisible(false);
            this.tAge.setVisible(false);
        }
        Boolean known = null;
        if (event != null && !"EVEN".equals(event.getTag())) {
            known = event.isKnownToHaveHappened();
        }
        if (known != null) {
            this.cKnown.setSelected(known);
            this.cKnown.setVisible(true);
            this.defaultFocus = this.cKnown;
        } else {
            this.cKnown.setVisible(false);
            this.defaultFocus = null;
        }
    }
}

