/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import ancestris.core.CoreOptions;
import ancestris.util.swing.DialogManager;
import genj.edit.beans.BeanHelper;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyName;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.TextFieldWidget;
import genj.util.swing.Updateable;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.openide.util.NbBundle;

public class FullNameBean
extends PropertyBean {
    private Property[] sameLastNames = new Property[0];
    private ChoiceWidget cLast;
    private ChoiceWidget cFirst;
    private JCheckBox cAll;
    private TextFieldWidget tSuff;
    private TextFieldWidget tNick;
    private JPanel extPanel;
    private TextFieldWidget tNPfx;
    private TextFieldWidget tSPfx;

    private String getReplaceAllMsg() {
        if (this.sameLastNames.length < 2) {
            return null;
        }
        return RESOURCES.getString("choice.global.confirm", new Object[]{"" + this.sameLastNames.length, ((PropertyName)this.getProperty()).getLastName(), this.cLast.getText()});
    }

    public FullNameBean() {
        MigLayout layout = new MigLayout(new LC().fillX().hideMode(2), new AC().align("right").gap("rel").grow().fill());
        this.setLayout((LayoutManager)layout);
        this.cLast = new ChoiceWidget();
        this.cLast.setUpdater(new Updateable(){

            public Object[] getValues() {
                if (FullNameBean.this.getRoot() != null) {
                    return PropertyName.getLastNames((Gedcom)FullNameBean.this.getRoot().getGedcom(), (boolean)true).toArray();
                }
                return null;
            }
        });
        this.cLast.addChangeListener((ChangeListener)this.changeSupport);
        this.cLast.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                String msg = FullNameBean.this.getReplaceAllMsg();
                if (msg != null) {
                    FullNameBean.this.cAll.setVisible(true);
                    FullNameBean.this.cAll.setToolTipText(msg);
                }
            }
        });
        this.cLast.setIgnoreCase(true);
        this.cFirst = new ChoiceWidget();
        this.cFirst.setUpdater(new Updateable(){

            public Object[] getValues() {
                if (FullNameBean.this.getRoot() != null) {
                    return PropertyName.getFirstNames((Gedcom)FullNameBean.this.getRoot().getGedcom(), (boolean)true).toArray();
                }
                return null;
            }
        });
        this.cFirst.addChangeListener((ChangeListener)this.changeSupport);
        this.cFirst.setIgnoreCase(true);
        this.tSuff = new TextFieldWidget("", 10);
        this.tSuff.addChangeListener((ChangeListener)this.changeSupport);
        this.tNick = new TextFieldWidget("", 10);
        this.tNick.addChangeListener((ChangeListener)this.changeSupport);
        this.tNPfx = new TextFieldWidget("", 10);
        this.tNPfx.addChangeListener((ChangeListener)this.changeSupport);
        this.tSPfx = new TextFieldWidget("", 10);
        this.tSPfx.addChangeListener((ChangeListener)this.changeSupport);
        this.cAll = new JCheckBox();
        this.cAll.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.cAll.setVisible(false);
        this.cAll.setRequestFocusEnabled(false);
        this.cAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String msg = FullNameBean.this.getReplaceAllMsg();
                if (msg != null && FullNameBean.this.cAll.isSelected()) {
                    boolean yes = DialogManager.YES_OPTION == DialogManager.createYesNo((String)PropertyBean.RESOURCES.getString("choice.global.enable"), (String)msg).show();
                    FullNameBean.this.cAll.setSelected(yes);
                }
            }
        });
        this.add(BeanHelper.createTagLabel(this, "SURN", "", 0));
        this.add((Component)this.cLast, new CC().split().growX().gapRight("0"));
        this.add((Component)this.cAll, new CC().wrap());
        this.add(BeanHelper.createTagLabel(this, "GIVN", "", 0));
        this.add((Component)this.cFirst, new CC().wrap());
        this.extPanel = new JPanel((LayoutManager)new MigLayout(new LC().fillX(), new AC().align("right").gap("rel").grow().fill()));
        this.extPanel.add(BeanHelper.createTagLabel(this, "NICK", "", 10));
        this.extPanel.add((Component)this.tNick, new CC().wrap());
        this.extPanel.add(BeanHelper.createTagLabel(this, "NPFX", "", 10));
        this.extPanel.add((Component)this.tNPfx, new CC().wrap());
        this.extPanel.add(BeanHelper.createTagLabel(this, "SPFX", "", 10));
        this.extPanel.add((Component)this.tSPfx, new CC().wrap());
        this.extPanel.add(BeanHelper.createTagLabel(this, "NSFX", "", 10));
        this.extPanel.add((Component)this.tSuff, new CC().wrap());
        JCheckBox showCb = BeanHelper.createShowHide(NbBundle.getMessage(FullNameBean.class, (String)"FullNameBean.showCb.text"), NbBundle.getMessage(FullNameBean.class, (String)"FullNameBean.showCb.hint"), this.extPanel);
        this.extPanel.setVisible(showCb.isSelected());
        this.add((Component)showCb, new CC().spanX().alignX("left").wrap());
        this.add((Component)this.extPanel, new CC().grow().spanX().gapBefore("20").wrap());
        this.defaultFocus = this.cFirst;
    }

    protected void commitImpl(Property property) {
        PropertyName p = (PropertyName)property;
        String first = this.cFirst.getText().trim();
        String last = this.cLast.getText().trim();
        String suff = this.tSuff.getText().trim();
        String nick = this.tNick.getText().trim();
        Gedcom ged = p.getGedcom();
        if (ged != null) {
            switch (CoreOptions.getInstance().getCorrectName()) {
                case 2: {
                    last = last.toUpperCase(ged.getLocale());
                    this.cLast.setText(last);
                }
                case 1: {
                    if (first.length() <= 0) break;
                    first = Character.toString(first.charAt(0)).toUpperCase(ged.getLocale()) + first.substring(1);
                    this.cFirst.setText(first);
                }
            }
        }
        p.setName(this.tNPfx.getText().trim(), first, this.tSPfx.getText().trim(), last, suff, this.cAll.isSelected());
        p.setNick(nick);
        this.setPropertyImpl((Property)p);
    }

    public void setPropertyImpl(Property prop) {
        PropertyName name = (PropertyName)prop;
        if (name == null) {
            this.sameLastNames = new Property[0];
            this.cLast.setText("");
            this.cFirst.setText("");
            this.tSuff.setText("");
            this.tNick.setText("");
            this.tNPfx.setText("");
            this.tSPfx.setText("");
        } else {
            this.sameLastNames = name.getSameLastNames();
            this.cLast.setText(name.getLastName());
            this.cFirst.setText(name.getFirstName());
            this.tSuff.setText(name.getSuffix());
            this.tNick.setText(name.getNick());
            this.tNPfx.setText(name.getNamePrefix());
            this.tSPfx.setText(name.getSurnamePrefix());
        }
        this.cAll.setVisible(false);
        this.cAll.setSelected(false);
    }
}

