/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.actions.AncestrisActionProvider;
import ancestris.core.actions.RunExternal;
import ancestris.core.resources.Images;
import ancestris.util.swing.DialogManager;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyComparator;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.io.InputSource;
import genj.util.DefaultValueMap;
import genj.util.Origin;
import genj.util.Resources;
import genj.util.swing.FileChooserWidget;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.TextFieldWidget;
import genj.util.swing.ThumbnailWidget;
import genj.util.swing.ToolbarWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaBean
extends PropertyBean
implements AncestrisActionProvider {
    private static final Resources RES = Resources.get(MediaBean.class);
    private Set<Property> OBJEsToRemove = new HashSet<Property>();
    private Map<InputSource.FileInput, Set<Property>> propsNeedingOBJEs = new DefaultValueMap(new HashMap(), new HashSet());
    private Map<InputSource, Set<Property>> currentOBJEs = new DefaultValueMap(new HashMap(), new HashSet());
    private ThumbnailWidget thumbs = new ThumbnailWidget(){

        public String getToolTipText(InputSource source) {
            StringBuilder result = new StringBuilder();
            result.append("<html><body>");
            result.append("<b>");
            result.append(source.getName());
            result.append("</b><br/>");
            int i = 0;
            for (Property obje : (Set)MediaBean.this.currentOBJEs.get(source)) {
                if (i++ > 0) {
                    result.append("<br/>");
                }
                result.append(obje.getParent().toString());
            }
            for (Property prop : (Set)MediaBean.this.propsNeedingOBJEs.get(source)) {
                if (i++ > 0) {
                    result.append("<br/>");
                }
                result.append(prop.toString());
            }
            result.append("</body></html>");
            return result.toString();
        }

        protected void handleDrop(List<File> files) {
            if (files.size() == 1) {
                new Add(files.get(0)).actionPerformed(null);
            }
        }
    };
    private ToolbarWidget actions = new ToolbarWidget();
    private AbstractAncestrisAction add = new Add();
    private AbstractAncestrisAction del = new Del();

    public MediaBean() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add("North", (Component)this.actions);
        this.add("Center", (Component)this.thumbs);
        this.setPreferredSize(new Dimension(128, 128));
        this.actions.setFloatable(false);
        this.actions.add((Action)this.add);
        this.actions.add((Action)this.del);
        this.actions.addSeparator();
        this.actions.add((Action)this.thumbs.getFitAction());
        this.actions.add((Action)this.thumbs.getOneAction());
        this.actions.add((Action)this.thumbs.getAllAction());
    }

    public List<Action> getActions(boolean hasFocus, Node[] nodes) {
        InputSource source;
        if (!hasFocus) {
            return new ArrayList<Action>();
        }
        ArrayList<Action> result = new ArrayList<Action>(1);
        Property p = this.getProperty();
        if (nodes != null && p != null && (source = this.thumbs.getSelection()) instanceof InputSource.FileInput) {
            result.add((Action)new RunExternal(((InputSource.FileInput)source).getFile()));
        }
        return result;
    }

    @Override
    protected void commitImpl(Property property) {
        for (Property obje : this.OBJEsToRemove) {
            obje.getParent().delProperty(obje);
        }
        this.OBJEsToRemove.clear();
        Gedcom gedcom = property.getGedcom();
        boolean inline = GedcomOptions.getInstance().isUseInline() || !property.getGedcom().getGrammar().getMeta(new TagPath("OBJE")).allows("FILE");
        for (InputSource.FileInput source : this.propsNeedingOBJEs.keySet()) {
            Media media = null;
            for (Property prop : this.propsNeedingOBJEs.get(source)) {
                if (inline) {
                    prop.addFile(source.getFile(), source.getName());
                    continue;
                }
                prop.addMedia(media == null ? this.createMedia(gedcom, source) : media);
            }
        }
        this.propsNeedingOBJEs.clear();
    }

    private Media createMedia(Gedcom gedcom, InputSource.FileInput source) {
        Media media;
        for (Entity e : gedcom.getEntities("OBJE")) {
            Media media2 = (Media)e;
            if (source.getName().length() > 0 && !source.getName().equals(media2.getTitle()) || !source.getFile().equals(media2.getFile())) continue;
            return media2;
        }
        try {
            media = (Media)gedcom.createEntity("OBJE");
        }
        catch (GedcomException e) {
            throw new Error("unexpected problem creating OBJE record", e);
        }
        media.addFile(source.getFile());
        media.setTitle(source.getName());
        return media;
    }

    @Override
    protected void setPropertyImpl(Property prop) {
        this.OBJEsToRemove.clear();
        this.propsNeedingOBJEs.clear();
        this.currentOBJEs.clear();
        if (prop == null) {
            this.thumbs.clear();
            this.add.setEnabled(false);
            this.del.setEnabled(false);
        } else {
            this.scan(prop);
            this.thumbs.setSources(new ArrayList<InputSource>(this.currentOBJEs.keySet()));
            this.add.setEnabled(true);
            this.del.setEnabled(true);
        }
    }

    private void scan(Property root) {
        for (int i = 0; i < root.getNoOfProperties(); ++i) {
            Property child = root.getProperty(i);
            if (!"OBJE".equals(child.getTag())) {
                this.scan(child);
                continue;
            }
            this.scan(root, child);
        }
    }

    private void scan(Property parent, Property OBJE) {
        File file;
        if (OBJE instanceof PropertyXRef && ((PropertyXRef)OBJE).getTargetEntity() instanceof Media) {
            Media media = (Media)((PropertyXRef)OBJE).getTargetEntity();
            File file2 = media.getFile();
            if (file2 != null) {
                this.currentOBJEs.get(InputSource.get((String)media.getTitle(), (File)file2)).add(OBJE);
                return;
            }
            PropertyBlob blob = media.getBlob();
            if (blob != null) {
                this.currentOBJEs.get(InputSource.get((String)media.getTitle(), (byte[])blob.getBlobData())).add(OBJE);
            }
            return;
        }
        Property FILE = OBJE.getProperty("FILE");
        if (FILE instanceof PropertyFile && (file = ((PropertyFile)FILE).getFile()) != null) {
            this.currentOBJEs.get(InputSource.get((String)OBJE.getPropertyValue("TITL"), (File)file)).add(OBJE);
        }
    }

    private Property[] list(Collection<Property> props) {
        Property[] result = props.toArray(new Property[0]);
        Arrays.sort(result, new PropertyComparator(".:DATE"));
        return result;
    }

    private class Del
    extends AbstractAncestrisAction
    implements PropertyChangeListener,
    ListSelectionListener {
        private JList<Property> from;

        public Del() {
            this.setImage((Icon)ThumbnailWidget.IMG_THUMBNAIL.getGrayedOut().getOverLayed(Images.imgDel));
            MediaBean.this.thumbs.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.setEnabled(MediaBean.this.getProperty() != null);
        }

        public void setEnabled(boolean set) {
            if (MediaBean.this.thumbs.getSelection() == null) {
                set = false;
            }
            super.setEnabled(set);
            if (set) {
                this.setTip(RES.getString("file.del", new Object[]{MediaBean.this.getProperty().getPropertyName()}));
            } else {
                this.setTip("");
            }
        }

        public void actionPerformed(ActionEvent e) {
            InputSource source = MediaBean.this.thumbs.getSelection();
            if (source == null) {
                return;
            }
            ArrayList properties = new ArrayList();
            properties.addAll((Collection)MediaBean.this.currentOBJEs.get(source));
            properties.addAll((Collection)MediaBean.this.propsNeedingOBJEs.get(source));
            Collections.sort(properties, new PropertyComparator(".:DATE"){

                public int compare(Property a, Property b) {
                    if ("OBJE".equals(a.getTag())) {
                        a = a.getParent();
                    }
                    if ("OBJE".equals(b.getTag())) {
                        b = b.getParent();
                    }
                    return super.compare(a, b);
                }
            });
            ArrayList<Property> choices = new ArrayList<Property>();
            for (Property prop : properties) {
                if ("OBJE".equals(prop.getTag())) {
                    choices.add(prop.getParent());
                    continue;
                }
                choices.add(prop);
            }
            this.from = new JList<Property>(choices.toArray(new Property[0]));
            this.from.setVisibleRowCount(5);
            if (!choices.isEmpty()) {
                this.from.setSelectionInterval(0, choices.size() - 1);
            }
            JPanel options = new JPanel((LayoutManager)new NestedBlockLayout("<col><l1 gx=\"1\"/><targets gx=\"1\" gy=\"1\"/></col>"));
            options.add(new JLabel(RES.getString("file.del", new Object[]{"..."})));
            options.add(new JScrollPane(this.from));
            this.from.addListSelectionListener(this);
            if (DialogManager.OK_OPTION != DialogManager.create((String)this.getTip(), (JComponent)options).setOptionType(2).setDialogId("mediabean.del").show()) {
                return;
            }
            Set objes = (Set)MediaBean.this.currentOBJEs.get(source);
            Set needing = (Set)MediaBean.this.propsNeedingOBJEs.get(source);
            int[] is = this.from.getSelectedIndices();
            for (int i = 0; i < is.length; ++i) {
                Property prop = (Property)properties.get(is[i]);
                if (objes.remove(prop)) {
                    MediaBean.this.OBJEsToRemove.add(prop);
                }
                needing.remove(prop);
            }
            if (objes.isEmpty() && needing.isEmpty()) {
                MediaBean.this.thumbs.removeSource(source);
            }
            MediaBean.this.changeSupport.fireChangeEvent();
        }

        public void valueChanged(ListSelectionEvent e) {
        }
    }

    private class Add
    extends AbstractAncestrisAction
    implements ListSelectionListener,
    ChangeListener {
        private JList<Property> to;
        private final FileChooserWidget chooser = new FileChooserWidget();

        Add(File file) {
            this.chooser.setFile(file);
        }

        Add() {
            this.setImage((Icon)ThumbnailWidget.IMG_THUMBNAIL.getOverLayed(Images.imgNew));
            if (MediaBean.this.getProperty() != null) {
                Origin origin = MediaBean.this.getProperty().getGedcom().getOrigin();
                this.chooser.setDirectory(origin.getFile() != null ? origin.getFile().getParent() : null);
            }
        }

        public void setEnabled(boolean set) {
            if (set && this.candidates().length == 0) {
                set = false;
            }
            super.setEnabled(set);
            if (set) {
                this.setTip(RES.getString("file.add", new Object[]{MediaBean.this.getProperty().getPropertyName()}));
            } else {
                this.setTip("");
            }
        }

        private Property[] candidates() {
            ArrayList<Property> result = new ArrayList<Property>();
            Property p = MediaBean.this.getProperty();
            if (p != null) {
                if (p.getMetaProperty().allows("OBJE")) {
                    result.add(p);
                }
                for (Property c : p.getProperties()) {
                    if (!c.getMetaProperty().allows("OBJE")) continue;
                    result.add(c);
                }
            }
            return MediaBean.this.list(result);
        }

        public void actionPerformed(ActionEvent e) {
            ThumbnailWidget preview = new ThumbnailWidget();
            preview.setPreferredSize(new Dimension(128, 128));
            this.chooser.setAccessory((JComponent)preview);
            this.to = new JList<Property>(this.candidates());
            this.to.setVisibleRowCount(5);
            TextFieldWidget title = new TextFieldWidget();
            JPanel options = new JPanel((LayoutManager)new NestedBlockLayout("<col><l1/><file gx=\"1\"/><l2/><title gx=\"1\"/><l3/><targets gx=\"1\" gy=\"1\"/></col>"));
            options.add(new JLabel(RES.getString("file.choose")));
            options.add((Component)this.chooser);
            options.add(new JLabel(RES.getString("file.title")));
            options.add((Component)title);
            options.add(new JLabel(RES.getString("file.add", new Object[]{"..."})));
            options.add(new JScrollPane(this.to));
            this.to.addListSelectionListener(this);
            this.chooser.addChangeListener((ChangeListener)this);
            if (this.to.getModel().getSize() > 0) {
                this.to.setSelectedIndex(0);
            }
            this.validate();
            if (DialogManager.OK_OPTION != DialogManager.create((String)this.getTip(), (JComponent)options).setOptionType(2).setDialogId("mediabean.add").show()) {
                return;
            }
            InputSource.FileInput source = new InputSource.FileInput(title.getText(), this.getFile());
            if (!MediaBean.this.currentOBJEs.containsKey(source) && !MediaBean.this.propsNeedingOBJEs.containsKey(source)) {
                MediaBean.this.thumbs.addSource((InputSource)source);
            }
            Set props = (Set)MediaBean.this.propsNeedingOBJEs.get(source);
            for (Property prop : this.to.getSelectedValuesList()) {
                props.add(prop);
            }
            MediaBean.this.changeSupport.fireChangeEvent();
        }

        private File getFile() {
            Origin origin = MediaBean.this.getProperty().getGedcom().getOrigin();
            return origin.getFile(this.chooser.getFile().toString());
        }

        private void validate() {
            File file = this.getFile();
        }

        public void valueChanged(ListSelectionEvent e) {
            this.validate();
        }

        public void stateChanged(ChangeEvent e) {
            this.validate();
        }
    }
}

