/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import ancestris.util.TimingUtility;
import genj.edit.beans.AgeBean;
import genj.edit.beans.ChoiceBean;
import genj.edit.beans.DateBean;
import genj.edit.beans.EntityBean;
import genj.edit.beans.EventBean;
import genj.edit.beans.FileBean;
import genj.edit.beans.MLEBean;
import genj.edit.beans.NameBean;
import genj.edit.beans.PlaceBean;
import genj.edit.beans.QualityBean;
import genj.edit.beans.SexBean;
import genj.edit.beans.SimpleValueBean;
import genj.edit.beans.XRefBean;
import genj.gedcom.Entity;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyAge;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyChoiceValue;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMultilineValue;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyQuality;
import genj.gedcom.PropertySex;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.renderer.BlueprintManager;
import genj.renderer.BlueprintRenderer;
import genj.util.ChangeSupport;
import genj.util.Registry;
import genj.util.Resources;
import genj.view.ViewContext;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyBean
extends JPanel {
    protected static final Resources RESOURCES = Resources.get(PropertyBean.class);
    protected static final Logger LOG = Logger.getLogger("ancestris.edit.beans");
    protected static final Registry REGISTRY = Registry.get(PropertyBean.class);
    private static final Class<?>[] PROPERTY2BEANTYPE = new Class[]{Entity.class, EntityBean.class, PropertyQuality.class, QualityBean.class, PropertyPlace.class, PlaceBean.class, PropertyAge.class, AgeBean.class, PropertyChoiceValue.class, ChoiceBean.class, PropertyDate.class, DateBean.class, PropertyEvent.class, EventBean.class, PropertyFile.class, FileBean.class, PropertyBlob.class, FileBean.class, PropertyMultilineValue.class, MLEBean.class, PropertyName.class, NameBean.class, PropertySex.class, SexBean.class, PropertyXRef.class, XRefBean.class, Property.class, SimpleValueBean.class};
    protected Property root;
    protected TagPath path;
    protected Property property;
    protected List<? extends PropertyBean> session;
    protected JComponent defaultFocus = null;
    protected ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private String tag = null;

    public static PropertyBean getBean(Class<? extends Property> property) {
        for (int i = 0; i < PROPERTY2BEANTYPE.length; i += 2) {
            if (PROPERTY2BEANTYPE[i] == null || !PROPERTY2BEANTYPE[i].isAssignableFrom(property)) continue;
            return PropertyBean.getBeanImpl(PROPERTY2BEANTYPE[i + 1]);
        }
        LOG.log(Level.WARNING, "Can''t find declared bean for property type {0})", property.getName());
        return PropertyBean.getBeanImpl(SimpleValueBean.class);
    }

    public static PropertyBean getBean(String bean) {
        try {
            return PropertyBean.getBeanImpl(Class.forName(bean));
        }
        catch (ClassNotFoundException e) {
            LOG.log(Level.FINE, "Can't find desired bean " + bean, e);
            return PropertyBean.getBeanImpl(SimpleValueBean.class);
        }
    }

    private static PropertyBean getBeanImpl(Class<? extends PropertyBean> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Throwable t) {
            LOG.log(Level.FINE, "Problem with bean lookup " + clazz.getName(), t);
            return new SimpleValueBean();
        }
    }

    public static void recycle(PropertyBean bean) {
        if (bean.getParent() != null) {
            throw new IllegalArgumentException("bean still has parent");
        }
        bean.root = null;
        bean.path = null;
        bean.property = null;
        bean.session = null;
    }

    protected PropertyBean() {
        this.setOpaque(false);
    }

    public void setPreferHorizontal(boolean set) {
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public final PropertyBean setContext(Property property) {
        return this.setContext(property, new TagPath("."), property, new ArrayList<PropertyBean>());
    }

    public final PropertyBean setContext(Property root, TagPath path) {
        if (path == null && this.getTag() != null) {
            path = TagPath.valueOf((String)(".:" + this.getTag()));
        }
        if (root == null || path == null) {
            throw new IllegalArgumentException("root and path cannot be null");
        }
        return this.setContext(root, path, root.getProperty(path));
    }

    public final PropertyBean setContext(Property root, TagPath parentPath, Property parent, String relativePath) {
        if (relativePath == null) {
            relativePath = this.getTag();
        }
        if (parent == null) {
            if (relativePath == null || parentPath == null) {
                throw new IllegalArgumentException("path cannot be null");
            }
            return this.setContext(root, TagPath.valueOf((String)(parentPath.toString() + ":" + relativePath)), null);
        }
        return this.setContext(parent, TagPath.valueOf((String)(".:" + relativePath)));
    }

    public final PropertyBean setContext(Property root, TagPath path, Property property) {
        return this.setContext(root, path, property, new ArrayList<PropertyBean>());
    }

    public final PropertyBean setContext(Property root, TagPath path, Property property, List<PropertyBean> session) {
        if (path == null && this.getTag() != null) {
            path = TagPath.valueOf((String)(".:" + this.getTag()));
        }
        if (root == null || path == null) {
            throw new IllegalArgumentException("root and path cannot be null");
        }
        this.root = root;
        this.path = path;
        this.property = property;
        this.session = session;
        LOG.log(Level.FINER, "{0}: setPropertyImpl {1}", new Object[]{TimingUtility.getInstance().getTime(), this.getClass().getCanonicalName()});
        this.setPropertyImpl(property);
        this.changeSupport.setChanged(false);
        return this;
    }

    protected abstract void setPropertyImpl(Property var1);

    public ViewContext getContext() {
        return this.property == null || this.property.getEntity() == null ? null : new ViewContext(this.property);
    }

    public final Property getRoot() {
        return this.root;
    }

    public final TagPath getPath() {
        return this.path;
    }

    public final Property getProperty() {
        return this.property;
    }

    public boolean isCommittable() {
        return true;
    }

    public boolean hasChanged() {
        return this.changeSupport.hasChanged();
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public final void commit() throws GedcomException {
        if (!this.hasChanged()) {
            return;
        }
        if (this.property == null) {
            this.property = this.root.setValue(this.path, "");
        }
        this.commitImpl(this.property);
        this.changeSupport.setChanged(false);
    }

    protected abstract void commitImpl(Property var1) throws GedcomException;

    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.defaultFocus != null) {
            return this.defaultFocus.requestFocusInWindow();
        }
        return false;
    }

    @Override
    public void requestFocus() {
        if (this.defaultFocus != null) {
            this.defaultFocus.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public List<? extends Action> getActions() {
        return new ArrayList();
    }

    public static class Preview
    extends JComponent {
        private Entity entity;
        private BlueprintRenderer renderer;

        protected Preview() {
            this.setBorder(new EmptyBorder(4, 4, 4, 4));
        }

        protected void paintComponent(Graphics g) {
            Insets insets = this.getInsets();
            Rectangle box = new Rectangle(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
            g.setColor(Color.WHITE);
            g.fillRect(box.x, box.y, box.width, box.height);
            if (this.renderer != null && this.entity != null) {
                this.renderer.render(g, (Property)this.entity, box);
            }
        }

        protected void setEntity(Entity ent) {
            this.entity = ent;
            if (this.entity != null) {
                this.renderer = new BlueprintRenderer(BlueprintManager.getInstance().getBlueprint(this.entity.getTag(), REGISTRY.get("blueprint.entity" + this.entity.getTag(), "")));
            }
            this.repaint();
        }
    }
}

