/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor;

import ancestris.api.editor.Editor;
import ancestris.core.beans.ConfirmChangeWidget;
import ancestris.modules.editors.genealogyeditor.editors.FamilyEditor;
import ancestris.modules.editors.genealogyeditor.editors.IndividualEditor;
import ancestris.modules.editors.genealogyeditor.editors.MultiMediaObjectEditor;
import ancestris.modules.editors.genealogyeditor.editors.NoteEditor;
import ancestris.modules.editors.genealogyeditor.editors.RepositoryEditor;
import ancestris.modules.editors.genealogyeditor.editors.SourceEditor;
import ancestris.modules.editors.genealogyeditor.editors.SubmitterEditor;
import ancestris.view.AncestrisTopComponent;
import genj.gedcom.Context;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomListenerAdapter;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.Repository;
import genj.gedcom.Source;
import genj.gedcom.Submitter;
import genj.gedcom.UnitOfWork;
import genj.view.ViewContext;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.openide.awt.UndoRedo;
import org.openide.windows.RetainLocation;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@RetainLocation(value="ancestris-editor")
public class AriesTopComponent
extends AncestrisTopComponent
implements TopComponent.Cloneable,
ConfirmChangeWidget.ConfirmChangeCallBack {
    private static final String PREFERRED_ID = "AriesTopComponent";
    private static AriesTopComponent factory;
    static final Logger LOG;
    private final Callback callback = new Callback();
    private boolean isChangeSource = false;
    private Editor editor;
    private ConfirmChangeWidget confirmPanel;
    private Gedcom gedcom;
    private Context context = null;
    private JScrollPane editorContainer;
    private JLabel titleLabel;
    private int undoNb;
    UndoRedoListener undoRedoListener;
    private static final Map<Class<? extends Property>, Editor> panels;

    public boolean createPanel() {
        JPanel editorPanel = new JPanel((LayoutManager)new MigLayout(new LC().fill().hideMode(3), new AC().grow().fill()));
        this.editorContainer = new JScrollPane();
        editorPanel.add((Component)this.editorContainer, new CC().grow());
        this.titleLabel = new JLabel("");
        this.confirmPanel = new ConfirmChangeWidget((ConfirmChangeWidget.ConfirmChangeCallBack)this);
        this.confirmPanel.setChanged(false);
        this.titleLabel.setFont(new Font("DejaVu Sans", 1, 13));
        editorPanel.add((Component)this.titleLabel, new CC().dockNorth());
        editorPanel.add((Component)this.confirmPanel, new CC().dockSouth());
        this.setPanel(editorPanel);
        Context ctx = this.getContext();
        this.setContext(new Context(ctx.getGedcom()));
        this.setContext(ctx);
        return true;
    }

    public static synchronized AriesTopComponent getFactory() {
        if (factory == null) {
            factory = new AriesTopComponent();
        }
        return factory;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private void setEditor(Editor set) {
        if (this.editorContainer == null) {
            return;
        }
        ViewContext old = null;
        if (set != null) {
            old = set.getContext();
        }
        if (this.editor != null) {
            this.editor.removeChangeListener((ChangeListener)this.confirmPanel);
            this.editor.setContext(new Context());
            this.editor.getExplorerHelper().setPopupAllowed(false);
            this.editor = null;
        }
        this.editor = set;
        if (this.editor != null) {
            int cut;
            int len;
            if (old != null) {
                this.editor.setContext((Context)old);
            }
            this.editorContainer.setViewportView((Component)this.editor);
            String title = this.editor.getTitle();
            if (!title.isEmpty() && (len = title.length()) > 80 && (cut = title.indexOf(" ", 80)) != -1) {
                title = title.substring(0, cut) + "...";
            }
            this.titleLabel.setText("<html>  " + title + " </html>");
            this.editor.getExplorerHelper().setPopupAllowed(true);
            this.editor.addChangeListener((ChangeListener)this.confirmPanel);
        }
        this.revalidate();
        this.repaint();
    }

    public void componentOpened() {
        this.undoRedoListener = new UndoRedoListener();
        UndoRedo undoRedo = this.getUndoRedo();
        undoRedo.addChangeListener((ChangeListener)this.undoRedoListener);
    }

    public void commit() {
        this.commit(true);
    }

    private void commit(boolean ask) {
        if (this.confirmPanel == null || !this.confirmPanel.hasChanged()) {
            return;
        }
        if (!this.isOpen) {
            return;
        }
        if (ask && !this.confirmPanel.isCommitChanges()) {
            this.cancel();
            this.confirmPanel.setChanged(false);
            return;
        }
        try {
            this.isChangeSource = true;
            if (this.gedcom.isWriteLocked()) {
                this.editor.commit();
            } else {
                this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        AriesTopComponent.this.editor.commit();
                    }
                });
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "error committing editor", t);
        }
        finally {
            this.isChangeSource = false;
            this.confirmPanel.setChanged(false);
            this.undoNb = this.gedcom.getUndoNb();
        }
    }

    private void cancel() {
        if (!this.isOpen) {
            return;
        }
        if (!this.gedcom.isWriteLocked()) {
            while (this.gedcom.getUndoNb() > this.undoNb && this.gedcom.canUndo()) {
                this.gedcom.undoUnitOfWork(false);
            }
        }
    }

    public void setContextImpl(Context newContext) {
        if (newContext == null) {
            return;
        }
        if (newContext.equals((Object)this.context)) {
            return;
        }
        this.context = newContext;
        if (newContext.getGedcom() != this.gedcom && this.gedcom != null) {
            this.gedcom.removeGedcomListener((GedcomListener)this.callback);
            this.gedcom = null;
        }
        if (newContext.getGedcom() == null) {
            this.setEditor(null);
            this.confirmPanel.setChanged(false);
            return;
        }
        if (newContext.getGedcom() != this.gedcom) {
            this.gedcom = newContext.getGedcom();
            this.gedcom.addGedcomListener((GedcomListener)this.callback);
        }
        this.commit(true);
        if (newContext.getEntity() == null) {
            return;
        }
        Editor panel = panels.get(newContext.getEntity().getClass());
        if (panel != null) {
            panel.setContext(newContext);
            this.setEditor(panel);
        }
        this.undoNb = this.gedcom.getUndoNb();
        this.repaint();
    }

    public void okCallBack(ActionEvent event) {
        this.commit(false);
    }

    public void cancelCallBack(ActionEvent event) {
        this.cancel();
        ViewContext ctx = this.editor.getContext();
        this.editor.setContext((Context)ctx);
    }

    public Image getImageIcon() {
        Image icon = null;
        if (this.editor != null) {
            icon = this.editor.getImageIcon();
        }
        if (icon == null) {
            icon = this.getImageIcon("ancestris/modules/editors/genealogyeditor/resources/Editor.png");
        }
        if (icon == null) {
            icon = super.getImageIcon();
        }
        return icon;
    }

    public void setName() {
        if (this.editor != null && this.editor.getName() != null) {
            this.setName(this.editor.getName());
        } else {
            super.setName();
        }
    }

    public void setToolTipText() {
        if (this.editor != null && this.editor.getToolTipText() != null) {
            this.setToolTipText(this.editor.getToolTipText());
        } else {
            super.setToolTipText();
        }
    }

    public TopComponent cloneComponent() {
        if (this.getContext() == null) {
            return null;
        }
        AriesTopComponent topComponent = new AriesTopComponent();
        topComponent.init(this.getContext());
        return topComponent;
    }

    public static AriesTopComponent findEditorWindow(Gedcom gedcom) {
        AriesTopComponent editorWindow = null;
        for (TopComponent tc : WindowManager.getDefault().getRegistry().getOpened()) {
            AriesTopComponent gltc;
            if (!(tc instanceof AriesTopComponent) || (gltc = (AriesTopComponent)tc).getGedcom() != gedcom) continue;
            editorWindow = gltc;
            break;
        }
        return editorWindow;
    }

    static {
        LOG = Logger.getLogger("ancestris.genealogyedit");
        panels = new HashMap<Class<? extends Property>, Editor>();
        panels.put(Fam.class, new FamilyEditor());
        panels.put(Indi.class, new IndividualEditor());
        panels.put(Note.class, new NoteEditor());
        panels.put(Repository.class, new RepositoryEditor());
        panels.put(Source.class, new SourceEditor());
        panels.put(Submitter.class, new SubmitterEditor());
        panels.put(Media.class, new MultiMediaObjectEditor());
    }

    private class UndoRedoListener
    implements ChangeListener {
        private UndoRedoListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ViewContext ctx = AriesTopComponent.this.editor.getContext();
            AriesTopComponent.this.editor.setContext((Context)ctx);
        }
    }

    private class Callback
    extends GedcomListenerAdapter {
        private Callback() {
        }

        public void gedcomWriteLockAcquired(Gedcom gedcom) {
            if (!AriesTopComponent.this.isChangeSource) {
                AriesTopComponent.this.commit(false);
            }
        }
    }
}

