/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.editors;

import ancestris.modules.editors.genealogyeditor.editors.EntityEditor;
import ancestris.modules.editors.genealogyeditor.panels.ReferencesTablePanel;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.PropertyChange;
import genj.gedcom.PropertyXRef;
import genj.view.ViewContext;
import java.awt.Component;
import java.awt.Container;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.util.NbBundle;

public class NoteEditor
extends EntityEditor {
    private Context context;
    private Note mNote;
    private boolean mNoteModified = false;
    private JLabel changeDateLabel;
    private JLabel changeDateLabeldate;
    private JLabel noteIDLabel;
    private JPanel noteIDPanel;
    private JTextField noteIDTextField;
    private JTabbedPane noteInformationTabbedPane;
    private JPanel noteReferencesPanel;
    private JPanel noteTextPanel;
    private JScrollPane noteTextScrollPane;
    private JTextArea noteTextTextArea;
    private JToolBar noteTextToolBar;
    private ReferencesTablePanel referencesTablePanel;

    public NoteEditor() {
        this(false);
    }

    public NoteEditor(boolean isNew) {
        super(isNew);
        this.initComponents();
        this.noteTextTextArea.getDocument().addDocumentListener((DocumentListener)this.changes);
    }

    private void initComponents() {
        this.noteIDPanel = new JPanel();
        this.noteIDLabel = new JLabel();
        this.noteIDTextField = new JTextField();
        this.noteInformationTabbedPane = new JTabbedPane();
        this.noteTextPanel = new JPanel();
        this.noteTextToolBar = new JToolBar();
        this.noteTextScrollPane = new JScrollPane();
        this.noteTextTextArea = new JTextArea();
        this.noteReferencesPanel = new JPanel();
        this.referencesTablePanel = new ReferencesTablePanel();
        this.changeDateLabel = new JLabel();
        this.changeDateLabeldate = new JLabel();
        this.noteIDLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("NoteEditor.noteIDLabel.text"), new Object[0]));
        this.noteIDTextField.setEditable(false);
        this.noteIDTextField.setColumns(8);
        this.noteIDTextField.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("NoteEditor.noteIDTextField.text"), new Object[0]));
        GroupLayout noteIDPanelLayout = new GroupLayout(this.noteIDPanel);
        this.noteIDPanel.setLayout(noteIDPanelLayout);
        noteIDPanelLayout.setHorizontalGroup(noteIDPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(noteIDPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.noteIDLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noteIDTextField, -2, -1, -2)));
        noteIDPanelLayout.setVerticalGroup(noteIDPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(noteIDPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.noteIDTextField, -2, -1, -2).addComponent(this.noteIDLabel)));
        this.noteTextToolBar.setFloatable(false);
        this.noteTextToolBar.setRollover(true);
        this.noteTextTextArea.setColumns(20);
        this.noteTextTextArea.setLineWrap(true);
        this.noteTextTextArea.setRows(5);
        this.noteTextTextArea.setWrapStyleWord(true);
        this.noteTextScrollPane.setViewportView(this.noteTextTextArea);
        GroupLayout noteTextPanelLayout = new GroupLayout(this.noteTextPanel);
        this.noteTextPanel.setLayout(noteTextPanelLayout);
        noteTextPanelLayout.setHorizontalGroup(noteTextPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteTextToolBar, -1, -1, Short.MAX_VALUE).addComponent(this.noteTextScrollPane));
        noteTextPanelLayout.setVerticalGroup(noteTextPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(noteTextPanelLayout.createSequentialGroup().addComponent(this.noteTextToolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noteTextScrollPane)));
        this.noteInformationTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("NoteEditor.noteTextPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/note.png")), this.noteTextPanel);
        GroupLayout noteReferencesPanelLayout = new GroupLayout(this.noteReferencesPanel);
        this.noteReferencesPanel.setLayout(noteReferencesPanelLayout);
        noteReferencesPanelLayout.setHorizontalGroup(noteReferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.referencesTablePanel, -1, 547, Short.MAX_VALUE));
        noteReferencesPanelLayout.setVerticalGroup(noteReferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.referencesTablePanel, -1, 109, Short.MAX_VALUE));
        this.noteInformationTabbedPane.addTab(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("NoteEditor.noteReferencesPanel.TabConstraints.tabTitle"), new Object[0]), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/association.png")), this.noteReferencesPanel);
        this.changeDateLabel.setHorizontalAlignment(2);
        this.changeDateLabel.setText(NbBundle.getMessage(NoteEditor.class, (String)"NoteEditor.changeDateLabel.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteInformationTabbedPane).addGroup(layout.createSequentialGroup().addComponent(this.changeDateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.changeDateLabeldate, -1, -1, Short.MAX_VALUE)).addComponent(this.noteIDPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.noteIDPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noteInformationTabbedPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.changeDateLabel, -1, -1, Short.MAX_VALUE).addComponent(this.changeDateLabeldate, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }

    public ViewContext getContext() {
        return new ViewContext(this.context);
    }

    public Component getEditorComponent() {
        return this;
    }

    protected String getTitleImpl() {
        if (this.context == null || this.context.getEntity() == null) {
            return "";
        }
        return new ViewContext(this.context.getEntity()).getText();
    }

    protected void setContextImpl(Context context) {
        this.context = context;
        Entity entity = context.getEntity();
        if (entity != null && entity instanceof Note) {
            this.mNote = (Note)entity;
            this.setTitle(NbBundle.getMessage(NoteEditor.class, (String)(this.isNew() ? "NoteEditor.create.title" : "NoteEditor.edit.title"), (Object)this.mNote));
            this.noteIDTextField.setText(this.mNote.getId());
            ArrayList<Entity> entitiesList = new ArrayList<Entity>();
            for (PropertyXRef entityRef : this.mNote.getProperties(PropertyXRef.class)) {
                entitiesList.add(entityRef.getTargetEntity());
            }
            this.referencesTablePanel.set((Entity)this.mNote, entitiesList);
            this.noteTextTextArea.setText(this.mNote.getValue() != null ? this.mNote.getValue() : "");
            Property changeDate = this.mNote.getProperty("CHAN");
            if (changeDate != null) {
                this.changeDateLabeldate.setText(((PropertyChange)changeDate).getDisplayValue());
            }
            this.noteTextTextArea.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    NoteEditor.this.mNoteModified = true;
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    NoteEditor.this.mNoteModified = true;
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    NoteEditor.this.mNoteModified = true;
                }
            });
        }
    }

    public void commit() {
        if (this.mNoteModified) {
            this.mNote.setValue(this.noteTextTextArea.getText());
        }
    }

    public Entity getEditedEntity() {
        return this.mNote;
    }
}

