/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.beans.ADateBean;
import ancestris.modules.editors.genealogyeditor.panels.AssociationsTablePanel;
import ancestris.modules.editors.genealogyeditor.utilities.PropertyTag2Name;
import ancestris.modules.editors.geoplace.PlaceEditorPanel;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.UnitOfWork;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class RecordedEventEditorPanel
extends JPanel {
    private Property mEvent = null;
    private PropertyPlace mPlace = null;
    private PropertyDate mDate = null;
    private ArrayList<String> mEvents = new ArrayList<String>(){
        {
            this.add(PropertyTag2Name.getTagName("BIRT"));
            this.add(PropertyTag2Name.getTagName("CHR"));
            this.add(PropertyTag2Name.getTagName("DEAT"));
            this.add(PropertyTag2Name.getTagName("BURI"));
            this.add(PropertyTag2Name.getTagName("CREM"));
            this.add(PropertyTag2Name.getTagName("ADOP"));
            this.add(PropertyTag2Name.getTagName("BAPM"));
            this.add(PropertyTag2Name.getTagName("BARM"));
            this.add(PropertyTag2Name.getTagName("BASM"));
            this.add(PropertyTag2Name.getTagName("BLES"));
            this.add(PropertyTag2Name.getTagName("CHRA"));
            this.add(PropertyTag2Name.getTagName("CONF"));
            this.add(PropertyTag2Name.getTagName("FCOM"));
            this.add(PropertyTag2Name.getTagName("ORDN"));
            this.add(PropertyTag2Name.getTagName("NATU"));
            this.add(PropertyTag2Name.getTagName("EMIG"));
            this.add(PropertyTag2Name.getTagName("IMMI"));
            this.add(PropertyTag2Name.getTagName("CENS"));
            this.add(PropertyTag2Name.getTagName("PROB"));
            this.add(PropertyTag2Name.getTagName("WILL"));
            this.add(PropertyTag2Name.getTagName("GRAD"));
            this.add(PropertyTag2Name.getTagName("RETI"));
            this.add(PropertyTag2Name.getTagName("ANUL"));
            this.add(PropertyTag2Name.getTagName("CENS"));
            this.add(PropertyTag2Name.getTagName("DIV"));
            this.add(PropertyTag2Name.getTagName("DIVF"));
            this.add(PropertyTag2Name.getTagName("MARR"));
            this.add(PropertyTag2Name.getTagName("ENGA"));
            this.add(PropertyTag2Name.getTagName("MARB"));
            this.add(PropertyTag2Name.getTagName("MARC"));
            this.add(PropertyTag2Name.getTagName("MARL"));
            this.add(PropertyTag2Name.getTagName("MARS"));
        }
    };
    private DefaultListModel<CheckableItem> mEventsModel = new DefaultListModel();
    private final ChangeSupport changeSupport = new ChangeSupport(AssociationsTablePanel.class);
    private ADateBean aDateBean;
    private JLabel dateLabel;
    private JButton editPlaceButton;
    private JLabel placeLabel;
    private JTextField placeTextField;
    private JLabel recordedEventsLabel;
    private JList recordedEventsList;
    private JScrollPane recordedEventsScrollPane;

    public RecordedEventEditorPanel() {
        this.initComponents();
        this.aDateBean.setPreferHorizontal(true);
        Collections.sort(this.mEvents);
        for (String event : this.mEvents) {
            this.mEventsModel.addElement(new CheckableItem(event));
        }
        this.recordedEventsList.setVisibleRowCount(-1);
        this.recordedEventsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CheckableItem item;
                int index = RecordedEventEditorPanel.this.recordedEventsList.getSelectedIndex();
                item.setSelected(!(item = (CheckableItem)RecordedEventEditorPanel.this.recordedEventsList.getModel().getElementAt(index)).isSelected());
            }
        });
    }

    private void initComponents() {
        this.recordedEventsLabel = new JLabel();
        this.dateLabel = new JLabel();
        this.aDateBean = new ADateBean();
        this.placeLabel = new JLabel();
        this.placeTextField = new JTextField();
        this.editPlaceButton = new JButton();
        this.recordedEventsScrollPane = new JScrollPane();
        this.recordedEventsList = new JList();
        this.recordedEventsLabel.setHorizontalAlignment(0);
        this.recordedEventsLabel.setText(NbBundle.getMessage(RecordedEventEditorPanel.class, (String)"RecordedEventEditorPanel.recordedEventsLabel.text"));
        this.dateLabel.setHorizontalAlignment(4);
        this.dateLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("RecordedEventEditorPanel.dateLabel.text"), new Object[0]));
        this.placeLabel.setHorizontalAlignment(4);
        this.placeLabel.setText(NbBundle.getMessage(RecordedEventEditorPanel.class, (String)"RecordedEventEditorPanel.placeLabel.text"));
        this.placeTextField.setText(NbBundle.getMessage(RecordedEventEditorPanel.class, (String)"RecordedEventEditorPanel.placeTextField.text"));
        this.editPlaceButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/Place.png")));
        this.editPlaceButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("RecordedEventEditorPanel.editPlaceButton.toolTipText"), new Object[0]));
        this.editPlaceButton.setFocusable(false);
        this.editPlaceButton.setHorizontalTextPosition(0);
        this.editPlaceButton.setMaximumSize(new Dimension(26, 26));
        this.editPlaceButton.setMinimumSize(new Dimension(26, 26));
        this.editPlaceButton.setPreferredSize(new Dimension(26, 26));
        this.editPlaceButton.setVerticalTextPosition(3);
        this.editPlaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RecordedEventEditorPanel.this.editPlaceButtonActionPerformed(evt);
            }
        });
        this.recordedEventsScrollPane.setMinimumSize(new Dimension(526, 104));
        this.recordedEventsScrollPane.setPreferredSize(new Dimension(526, 104));
        this.recordedEventsList.setModel(this.mEventsModel);
        this.recordedEventsList.setCellRenderer(new CheckListRenderer());
        this.recordedEventsList.setSelectionMode(0);
        this.recordedEventsList.setLayoutOrientation(2);
        this.recordedEventsScrollPane.setViewportView(this.recordedEventsList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.recordedEventsScrollPane, -1, 656, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.placeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.dateLabel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.aDateBean, -1, 613, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.placeTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editPlaceButton, -2, -1, -2)))).addComponent(this.recordedEventsLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.recordedEventsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.recordedEventsScrollPane, -1, 226, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.aDateBean, -2, -1, -2).addComponent(this.dateLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.editPlaceButton, -2, -1, -2).addComponent(this.placeTextField, -2, -1, -2).addComponent(this.placeLabel, -2, 15, -2)).addContainerGap()));
    }

    private void editPlaceButtonActionPerformed(ActionEvent evt) {
        Gedcom gedcom = this.mEvent.getGedcom();
        int undoNb = gedcom.getUndoNb();
        final PlaceEditorPanel placeEditorPanel = new PlaceEditorPanel();
        JButton OKButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"Button_Ok"));
        JButton cancelButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"Button_Cancel"));
        Object[] options = new Object[]{OKButton, cancelButton};
        placeEditorPanel.setOKButton(OKButton);
        placeEditorPanel.set(gedcom, this.mPlace, false);
        DialogManager.ADialog eventEditorDialog = new DialogManager.ADialog(NbBundle.getMessage(this.getClass(), (String)"PlaceEditorPanel.edit.title"), (JComponent)placeEditorPanel);
        eventEditorDialog.setDialogId(PlaceEditorPanel.class.getName());
        eventEditorDialog.setOptions(options);
        Object o = eventEditorDialog.show();
        placeEditorPanel.close();
        if (o == OKButton) {
            try {
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        placeEditorPanel.commit(RecordedEventEditorPanel.this.mEvent, RecordedEventEditorPanel.this.mPlace);
                    }
                });
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.mPlace = (PropertyPlace)this.mEvent.getProperty("PLAC", false);
            this.placeTextField.setText(this.mPlace != null ? this.mPlace.getDisplayValue() : "");
        } else {
            while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                gedcom.undoUnitOfWork(false);
            }
        }
    }

    public void set(Property event) {
        this.mEvent = event;
        for (String eventTag : this.mEvent.getValue().replaceAll(" ", "").split(",")) {
            for (int index = 0; index < this.mEventsModel.size(); ++index) {
                if (!this.mEventsModel.get(index).toString().equals(PropertyTag2Name.getTagName(eventTag))) continue;
                this.mEventsModel.get(index).setSelected(true);
            }
        }
        Property p = this.mEvent.getProperty("DATE", false);
        this.mDate = (PropertyDate)(p instanceof PropertyDate ? p : null);
        if (this.mDate == null) {
            this.aDateBean.setContext(this.mEvent, null);
        } else {
            this.aDateBean.setContext((Property)this.mDate);
        }
        this.mPlace = (PropertyPlace)this.mEvent.getProperty("PLAC", false);
        if (this.mPlace == null) {
            try {
                this.mEvent.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        RecordedEventEditorPanel.this.mPlace = (PropertyPlace)RecordedEventEditorPanel.this.mEvent.addProperty("PLAC", "");
                    }
                });
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.placeTextField.setText(this.mPlace.getDisplayValue());
    }

    public void commit() {
        String tmp = "";
        for (int index = 0; index < this.mEventsModel.size(); ++index) {
            if (!this.mEventsModel.get(index).isSelected) continue;
            tmp = tmp + (tmp.isEmpty() ? "" : ", ") + PropertyTag2Name.getPropertyTag(this.mEventsModel.get(index).toString());
        }
        this.mEvent.setValue(tmp);
        try {
            this.aDateBean.commit();
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        Property place = this.mEvent.getProperty("PLAC", false);
        if (place != null) {
            place.setValue(this.placeTextField.getText());
        } else {
            this.mEvent.addProperty("PLAC", this.placeTextField.getText());
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    private class CheckListRenderer
    extends JCheckBox
    implements ListCellRenderer<CheckableItem> {
        @Override
        public Component getListCellRendererComponent(JList<? extends CheckableItem> list, CheckableItem checkableItem, int index, boolean isSelected, boolean hasFocus) {
            this.setEnabled(list.isEnabled());
            this.setSelected(checkableItem.isSelected());
            this.setText(checkableItem.toString());
            return this;
        }
    }

    private class CheckableItem {
        private final String str;
        private boolean isSelected;

        public CheckableItem(String str) {
            this.str = str;
            this.isSelected = false;
        }

        public void setSelected(boolean b) {
            this.isSelected = b;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public String toString() {
            return this.str;
        }
    }
}

