/*
 * Decompiled with CFR 0.152.
 */
package ancestris.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.UIResource;
import net.miginfocom.swing.MigLayout;
import org.openide.util.actions.Presenter;

public class ToolBar
extends JToolBar {
    AtomicBoolean notEmpty = new AtomicBoolean(false);

    public ToolBar() {
        this(0);
    }

    public ToolBar(int orientation) {
        this(null, orientation);
    }

    public ToolBar(String name) {
        this(name, 0);
    }

    public ToolBar(String name, int orientation) {
        super(name, orientation);
        ToolBarLayout layout = new ToolBarLayout(orientation);
        this.setLayout(layout);
        this.addPropertyChangeListener(layout);
    }

    @Override
    public void updateUI() {
        this.setUI((ToolBarUI)UIManager.getUI(this));
        if (this.getLayout() == null) {
            this.setLayout(new ToolBarLayout(this.getOrientation()));
        }
        this.invalidate();
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        this.setVisible(true);
        this.notEmpty.set(true);
    }

    public void add(JComponent component) {
        super.add(component);
        this.setVisible(true);
        component.setFocusable(false);
        this.notEmpty.set(true);
    }

    public void add(Presenter.Toolbar component) {
        if (component != null) {
            this.add(component.getToolbarPresenter());
        }
    }

    public JToolBar getToolBar() {
        return this.notEmpty.get() ? this : null;
    }

    public void beginUpdate() {
        this.notEmpty.set(false);
        this.removeAll();
        this.setVisible(false);
    }

    public void endUpdate() {
    }

    public void addGlue() {
        this.add(Box.createGlue(), "growx, pushx");
    }

    @Override
    public void addSeparator() {
        this.addSeparator(new Dimension(3, 32));
    }

    private class ToolBarLayout
    implements LayoutManager2,
    Serializable,
    PropertyChangeListener,
    UIResource {
        MigLayout lm;

        ToolBarLayout(int orientation) {
            this.setLm(orientation);
        }

        private void setLm(int orientation) {
            this.lm = orientation == 1 ? new MigLayout("insets 10 0 10 0, gap 0, flowy") : new MigLayout("insets 0 10 0 10, gap 0, flowx");
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.lm.addLayoutComponent(name, comp);
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            this.lm.addLayoutComponent(comp, constraints);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.lm.removeLayoutComponent(comp);
        }

        @Override
        public Dimension preferredLayoutSize(Container target) {
            return this.lm.preferredLayoutSize(target);
        }

        @Override
        public Dimension minimumLayoutSize(Container target) {
            return this.lm.minimumLayoutSize(target);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return this.lm.maximumLayoutSize(target);
        }

        @Override
        public void layoutContainer(Container target) {
            this.lm.layoutContainer(target);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return this.lm.getLayoutAlignmentX(target);
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return this.lm.getLayoutAlignmentY(target);
        }

        @Override
        public void invalidateLayout(Container target) {
            this.lm.invalidateLayout(target);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("orientation")) {
                int o = (Integer)e.getNewValue();
                this.setLm(o);
            }
        }
    }
}

