/*
 * Decompiled with CFR 0.152.
 */
package ancestris.swing.atable;

import ancestris.swing.atable.Bundle;
import genj.util.swing.GraphicsHelper;
import genj.util.swing.PopupWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import org.openide.util.actions.Presenter;

public final class ATableFilterWidget
implements Presenter.Toolbar {
    private FilterCombo filter;
    private List<String> headers = new ArrayList<String>();

    public Component getToolbarPresenter() {
        return this.getFilter();
    }

    private FilterCombo getFilter() {
        if (this.filter == null) {
            this.filter = new FilterCombo();
        }
        return this.filter;
    }

    public void setColumn(int colFilter) {
        this.getFilter().setIndex(colFilter);
    }

    public int getColFilter() {
        return this.getFilter().getIndex();
    }

    public void setSorter(DefaultRowSorter sorter) {
        this.getFilter().sorter = sorter;
        if (sorter != null) {
            this.setHeaders((TableModel)sorter.getModel());
        }
    }

    private void setHeaders(TableModel model) {
        if (this.headers == null) {
            this.headers = new ArrayList<String>();
        } else {
            this.headers.clear();
        }
        for (int c = 0; c < model.getColumnCount(); ++c) {
            this.headers.add(model.getColumnName(c));
        }
        this.getFilter().setIndex(this.getFilter().getIndex());
    }

    public void refresh() {
        this.getFilter().invokeFilter();
    }

    private class FilterCombo
    extends JPanel {
        private final Icon POPUP = GraphicsHelper.getIcon(Color.BLACK, 0.0, 0.0, 8.0, 0.0, 4.0, 4.0);
        private int index;
        private final Popup pick = new Popup();
        private final JTextField filterText;
        private final JCheckBox exactMatch;
        private DefaultRowSorter sorter;
        private final JLabel number;
        private Timer docTimer;
        private final int timerDelay = 300;

        FilterCombo() {
            this.setLayout(new BoxLayout(this, 2));
            this.filterText = new JTextField(){

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }

                @Override
                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    size.width = 220;
                    return size;
                }
            };
            this.filterText.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    FilterCombo.this.textChangedAction(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    FilterCombo.this.textChangedAction(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    FilterCombo.this.textChangedAction(e);
                }
            });
            this.exactMatch = new JCheckBox(Bundle.exactmatch());
            this.exactMatch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FilterCombo.this.invokeFilter();
                }
            });
            this.number = new JLabel(){

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }

                @Override
                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    size.width = 140;
                    return size;
                }
            };
            this.number.setHorizontalAlignment(4);
            this.add(this.number);
            this.add(this.filterText);
            this.setIndex(0);
            this.add(this.pick);
            this.add(this.exactMatch);
            this.invokeFilter();
        }

        private void setIndex(int index) {
            if (index < 0 || index > ATableFilterWidget.this.headers.size()) {
                index = 0;
            }
            this.index = index;
            if (!ATableFilterWidget.this.headers.isEmpty() && index < ATableFilterWidget.this.headers.size()) {
                this.pick.setToolTipText((String)ATableFilterWidget.this.headers.get(index));
            }
        }

        private int getIndex() {
            return this.index;
        }

        private void textChangedAction(DocumentEvent e) {
            if (this.docTimer != null && this.docTimer.isRunning()) {
                this.docTimer.stop();
            }
            this.docTimer = new Timer(300, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FilterCombo.this.invokeFilter();
                }
            });
            this.docTimer.setRepeats(false);
            this.docTimer.start();
        }

        private void invokeFilter() {
            if (this.sorter != null) {
                RowFilter rf;
                int col = this.getIndex();
                String flags = "";
                if (!this.exactMatch.isSelected()) {
                    flags = "(?i)(?u)";
                }
                try {
                    rf = RowFilter.regexFilter(flags + this.filterText.getText(), col);
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                this.sorter.setRowFilter(rf);
                String numberText = "";
                if (!this.filterText.getText().isEmpty()) {
                    numberText = Bundle.occurrences_label(this.sorter.getViewRowCount());
                }
                this.number.setText(numberText + " ");
            }
        }

        private class Popup
        extends PopupWidget {
            Popup() {
                super(FilterCombo.this.POPUP);
            }

            @Override
            public void showPopup() {
                this.removeItems();
                for (int i = 0; i < ATableFilterWidget.this.headers.size(); ++i) {
                    final int j = i;
                    JMenuItem item = new JMenuItem(new AbstractAction((String)ATableFilterWidget.this.headers.get(i)){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            FilterCombo.this.setIndex(j);
                            FilterCombo.this.invokeFilter();
                        }
                    });
                    if (FilterCombo.this.getIndex() == i) {
                        item.setFont(item.getFont().deriveFont(1));
                    }
                    this.addItem(item);
                }
                super.showPopup();
            }
        }
    }
}

