/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.io.GedcomIOException;
import genj.io.Options;
import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BackupFile {
    private static final SimpleDateFormat ISO_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss");

    public static boolean createBackup(File file) throws GedcomIOException {
        boolean result = false;
        if (Options.getNbBackups() != 0 && file.exists()) {
            File bak;
            final Pattern p = Pattern.compile(BackupFile.getBasename(file.getName()) + "_([0-9]{8}-[0-9]{6})" + BackupFile.getExtension(file.getName()));
            final File theFile = file;
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return dir.equals(theFile.getParentFile()) && p.matcher(name).matches();
                }
            };
            File parent = file.getParentFile();
            Object[] backups = parent.listFiles(filter);
            Arrays.sort(backups);
            if (backups.length >= Options.getNbBackups()) {
                for (int i = 0; i <= backups.length - Options.getNbBackups(); ++i) {
                    if (((File)backups[i]).delete()) continue;
                    throw new GedcomIOException("Couldn't delete backup file " + ((File)backups[0]).getName(), -1);
                }
            }
            if (backups.length > 0) {
                Matcher m = p.matcher(((File)backups[backups.length - 1]).getName());
                if (!m.matches()) {
                    throw new GedcomIOException("Couldn't create backup for file " + file.getName(), -1);
                }
                bak = BackupFile.getBackupFile(file);
            } else {
                bak = BackupFile.getBackupFile(file);
            }
            if (bak.exists()) {
                throw new GedcomIOException("Couldn't create backup file " + bak.getName(), -1);
            }
            if (!file.renameTo(bak)) {
                throw new GedcomIOException("Couldn't create backup for " + file.getName(), -1);
            }
        }
        result = true;
        return result;
    }

    private static File getBackupFile(File file) {
        String fileName = file.getAbsolutePath();
        return new File(BackupFile.getBasename(fileName) + "_" + ISO_FORMAT.format(new Date()) + BackupFile.getExtension(fileName));
    }

    private static String getExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return fileName.substring(index);
    }

    private static String getBasename(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }
}

