/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.gedcom.TagPath;
import genj.io.GedcomEncodingSniffer;
import genj.io.GedcomFormatException;
import genj.io.PropertyReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.openide.util.Exceptions;

public class GedcomFileReader
extends PropertyReader {
    private String theLine = "";
    private TagPath path = null;
    private Charset charset = null;

    public TagPath getPath() {
        return this.path;
    }

    public static GedcomFileReader create(File fileIn) {
        Charset charset;
        GedcomEncodingSniffer sniffer;
        try {
            sniffer = new GedcomEncodingSniffer(new BufferedInputStream(new FileInputStream(fileIn)));
            charset = sniffer.getCharset();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        GedcomFileReader reader = new GedcomFileReader(new InputStreamReader((InputStream)sniffer, charset));
        reader.setCharset(charset);
        return reader;
    }

    private GedcomFileReader(Reader in) {
        super(in, null, false);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public String getValue() {
        return this.value;
    }

    public String getXref() {
        return this.xref;
    }

    public int getLevel() {
        return this.level;
    }

    public String getNextLine(boolean consume) throws IOException {
        boolean ret = this.readLine(false, true);
        this.theLine = this.line;
        if (!ret && this.tag == null) {
            throw new GedcomFormatException(RESOURCES.getString("read.error.norecord"), 0);
        }
        this.path = this.level <= 0 ? new TagPath(this.tag) : new TagPath(new TagPath(this.path, this.level), this.tag);
        if (consume) {
            this.line = null;
        }
        return this.theLine;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public String getTag() {
        return this.tag;
    }

    public String getLine() {
        return this.theLine;
    }
}

