/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import ancestris.util.TimingUtility;
import genj.crypto.Enigma;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Submitter;
import genj.io.GedcomEncodingSniffer;
import genj.io.GedcomEncryptionException;
import genj.io.GedcomFormatException;
import genj.io.GedcomIOException;
import genj.io.GedcomReader;
import genj.io.GedcomReaderContext;
import genj.io.PropertyReader;
import genj.util.EnvironmentChecker;
import genj.util.MeteredInputStream;
import genj.util.Origin;
import genj.util.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GedcomReaderFactory {
    private static final Resources RESOURCES = Resources.get(GedcomReaderFactory.class);
    private static Logger LOG = Logger.getLogger("ancestris.io");
    private static final int ENTITY_AVG_SIZE = 150;

    public static GedcomReader createReader(Origin origin, GedcomReaderContext context) throws IOException {
        LOG.info("Initializing reader for " + origin);
        return new Impl(new Gedcom(origin), origin.open(), context != null ? context : new DefaultContext());
    }

    public static GedcomReader createReader(InputStream in, GedcomReaderContext context) throws IOException {
        return new Impl(new Gedcom(), in, context != null ? context : new DefaultContext());
    }

    private static class DefaultContext
    implements GedcomReaderContext {
        private DefaultContext() {
        }

        @Override
        public String getPassword() {
            return null;
        }

        @Override
        public void handleWarning(int line, String warning, Context context) {
        }
    }

    private static class Impl
    implements GedcomReader {
        private static final int READHEADER = 0;
        private static final int READENTITIES = 1;
        private static final int LINKING = 2;
        private Gedcom gedcom;
        private int progress;
        private int entity = 0;
        private int state;
        private int length;
        private String gedcomLine;
        private ArrayList<LazyLink> lazyLinks = new ArrayList();
        private String tempSubmitter;
        private boolean cancel = false;
        private Object lock = new Object();
        private EntityReader reader;
        private MeteredInputStream meter;
        private Enigma enigma;
        private GedcomReaderContext context;

        private Impl(Gedcom ged, InputStream in, GedcomReaderContext context) throws IOException {
            String charsetName;
            GedcomEncodingSniffer sniffer = new GedcomEncodingSniffer(in);
            Charset charset = sniffer.getCharset();
            String encoding = sniffer.getEncoding();
            if (!sniffer.isDeterministic()) {
                context.handleWarning(0, RESOURCES.getString("read.warn.nochar"), new Context(ged));
            }
            if ((charsetName = EnvironmentChecker.getProperty("ancestris.gedcom.charset", null, "checking for forced charset for read of " + ged.getName())) != null) {
                try {
                    charset = Charset.forName(charsetName);
                    encoding = "UTF-8";
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "Can't force charset " + charset, t);
                }
            }
            this.length = sniffer.available();
            this.gedcom = ged;
            this.gedcom.setEncoding(encoding);
            this.context = context;
            this.meter = new MeteredInputStream(sniffer);
            this.reader = new EntityReader(new InputStreamReader((InputStream)this.meter, charset));
        }

        @Override
        public void cancelTrackable() {
            this.cancel = true;
        }

        @Override
        public int getProgress() {
            if (this.state == 1 && this.length > 0) {
                this.progress = (int)Math.min(80L, this.meter.getCount() * 80L / (long)this.length);
            }
            return this.progress;
        }

        @Override
        public String getState() {
            switch (this.state) {
                case 0: {
                    return this.getTaskName() + " : " + RESOURCES.getString("progress.read.header");
                }
                default: {
                    String lStr = NumberFormat.getIntegerInstance().format(this.reader.getLines());
                    String eStr = NumberFormat.getIntegerInstance().format(this.entity);
                    return this.getTaskName() + " : " + RESOURCES.getString("progress.read.entities", "" + lStr, eStr);
                }
                case 2: 
            }
            String task = this.getTaskName();
            return task.isEmpty() ? "" : task + " : " + RESOURCES.getString("progress.read.linking");
        }

        public int getLines() {
            return this.reader.getLines();
        }

        @Override
        public Gedcom read() throws GedcomEncryptionException, GedcomIOException, GedcomFormatException {
            if (this.gedcom == null) {
                throw new IllegalStateException("can't call read() twice");
            }
            try {
                this.readGedcom();
                Gedcom gedcom = this.gedcom;
                return gedcom;
            }
            catch (GedcomIOException gex) {
                throw gex;
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "unexpected throwable", t);
                throw new GedcomIOException(t.toString(), this.reader.getLines());
            }
            finally {
                try {
                    this.reader.in.close();
                }
                catch (Throwable throwable) {}
                this.lazyLinks.clear();
                this.gedcom = null;
            }
        }

        private void readGedcom() throws IOException {
            long start = System.currentTimeMillis();
            this.readHeader();
            ++this.state;
            long header = System.currentTimeMillis();
            while (this.reader.readEntity() != null) {
                if (!this.cancel) continue;
                throw new GedcomIOException(RESOURCES.getString("read.warn.cancelled"), this.getLines());
            }
            long records = System.currentTimeMillis();
            ++this.state;
            if (this.tempSubmitter.length() > 0) {
                try {
                    Submitter sub = (Submitter)this.gedcom.getEntity("SUBM", this.tempSubmitter.replace('@', ' ').trim());
                    this.gedcom.setSubmitter(sub);
                }
                catch (IllegalArgumentException t) {
                    this.context.handleWarning(0, RESOURCES.getString("read.warn.setsubmitter", this.tempSubmitter), new Context(this.gedcom));
                }
            }
            this.linkReferences();
            long linking = System.currentTimeMillis();
            long total = System.currentTimeMillis();
            LOG.log(Level.INFO, "{0}: {1} loaded in {2}s (header {3}s, records {4}s, linking {5}s ({6}))", new Object[]{TimingUtility.getInstance().getTime(), this.gedcom.getName(), (total - start) / 1000L, (header - start) / 1000L, (records - header) / 1000L, (linking - records) / 1000L, this.lazyLinks.size()});
        }

        private void linkReferences() throws GedcomIOException {
            int n = this.lazyLinks.size();
            int i = 0;
            for (LazyLink lazyLink : this.lazyLinks) {
                try {
                    if (lazyLink.xref.getParent() != null && lazyLink.xref.getTarget() == null) {
                        lazyLink.xref.link();
                    }
                    this.progress = 80 + Math.min(20, i * 40 / n);
                }
                catch (GedcomException ex) {
                    this.context.handleWarning(lazyLink.line, ex.getMessage(), new Context(lazyLink.xref));
                }
                catch (Throwable t) {
                    throw new GedcomIOException(RESOURCES.getString("read.error.xref", lazyLink.xref.getTag(), lazyLink.xref.getValue()), lazyLink.line);
                }
                ++i;
            }
        }

        private boolean readHeader() throws IOException {
            String dest;
            Entity header = this.reader.readEntity();
            if (header == null || !header.getTag().equals("HEAD")) {
                throw new GedcomFormatException(RESOURCES.getString("read.error.noheader"), 0);
            }
            this.tempSubmitter = header.getPropertyValue("SUBM");
            String source = header.getPropertyValue("SOUR");
            Property vers = header.getPropertyByPath("HEAD:GEDC:VERS");
            if (vers == null || header.getPropertyByPath("HEAD:GEDC:FORM") == null) {
                this.context.handleWarning(0, RESOURCES.getString("read.warn.badgedc"), new Context(this.gedcom));
            } else {
                String v = vers.getValue();
                if ("5.5".equals(v)) {
                    this.gedcom.setGrammar(Grammar.V55);
                    LOG.info("Found VERS " + v + " - Gedcom version is 5.5");
                } else if ("5.5.1".equals(v)) {
                    this.gedcom.setGrammar(Grammar.V551);
                    LOG.info("Found VERS " + v + " - Gedcom version is 5.5.1");
                } else {
                    String s = RESOURCES.getString("read.warn.badversion", v, this.gedcom.getGrammar().getVersion());
                    this.context.handleWarning(0, RESOURCES.getString("read.warn.badversion", v, this.gedcom.getGrammar().getVersion()), new Context(this.gedcom));
                    LOG.warning(s);
                }
            }
            String lang = header.getPropertyValue("LANG");
            if (lang.length() > 0) {
                this.gedcom.setLanguage(lang);
                LOG.info("Found LANG " + lang + " - Locale is " + this.gedcom.getLocale());
            }
            if ((dest = header.getPropertyValue("DEST")) == null || dest.isEmpty()) {
                this.context.handleWarning(0, RESOURCES.getString("read.warn.baddest"), new Context(this.gedcom));
            } else if ("ANY".equals(dest)) {
                this.gedcom.setDestination("ANY");
                LOG.info("Found DEST " + dest + " - Any");
            } else if ("ANSTFILE".equals(dest)) {
                this.gedcom.setDestination("ANSTFILE");
                LOG.info("Found DEST " + dest + " - Ancestral File");
            } else if ("TempleReady".equals(dest)) {
                this.gedcom.setDestination("TempleReady");
                LOG.info("Found DEST " + dest + " - Temple ordinance clearance");
            } else {
                String s = RESOURCES.getString("read.warn.baddestination", dest, this.gedcom.getDestination());
                this.context.handleWarning(0, RESOURCES.getString("read.warn.baddestination", dest, this.gedcom.getDestination()), new Context(this.gedcom));
                LOG.warning(s);
            }
            String encoding = header.getPropertyValue("CHAR");
            if (encoding.length() > 0) {
                this.gedcom.setEncoding(encoding);
                if (encoding.equals("ASCII")) {
                    this.context.handleWarning(0, RESOURCES.getString("read.warn.ascii"), new Context(this.gedcom));
                }
            }
            Property plac = header.getProperty("PLAC");
            String form = "";
            if (plac != null) {
                form = plac.getPropertyValue("FORM");
                this.gedcom.setPlaceFormat(form);
                LOG.info("Found Place.Format " + form);
            }
            if (plac == null || form == null || form.isEmpty()) {
                this.context.handleWarning(0, RESOURCES.getString("read.warn.badplac"), new Context(this.gedcom));
            }
            for (Property p : header.getProperties()) {
                Impl.recurseMarkRO(p);
            }
            return true;
        }

        private static void recurseMarkRO(Property prop) {
            prop.setReadOnly(true);
            for (Property p : prop.getProperties()) {
                Impl.recurseMarkRO(p);
            }
        }

        @Override
        public String getTaskName() {
            if (this.gedcom != null && RESOURCES != null) {
                return RESOURCES.getString("reader.title", this.gedcom.getName());
            }
            return "";
        }

        private static class LazyLink {
            private PropertyXRef xref;
            private int line;

            LazyLink(PropertyXRef xref, int line) {
                this.xref = xref;
                this.line = line;
            }
        }

        private class EntityReader
        extends PropertyReader {
            EntityReader(Reader in) {
                super(in, null, false);
            }

            Entity readEntity() throws IOException {
                Entity result;
                if (!this.readLine(true, true)) {
                    throw new GedcomFormatException(RESOURCES.getString("read.error.norecord"), this.lines);
                }
                if (this.level != 0) {
                    throw new GedcomFormatException(RESOURCES.getString("read.error.nonumber"), this.lines);
                }
                if (this.tag.equals("TRLR")) {
                    if (this.readLine(true, true)) {
                        throw new GedcomFormatException(RESOURCES.getString("read.error.aftertrlr"), this.lines);
                    }
                    return null;
                }
                try {
                    result = Impl.this.gedcom.createEntity(this.tag, this.xref);
                    if (result.getClass() != Entity.class && this.xref.length() == 0) {
                        Impl.this.context.handleWarning(this.getLines(), RESOURCES.getString("read.warn.recordnoid", Gedcom.getName(this.tag)), new Context(result));
                    }
                    result.setValue(this.value);
                    this.readProperties(result, 0, 0);
                }
                catch (GedcomException ex) {
                    throw new GedcomIOException(ex.getMessage(), this.lines);
                }
                if (!this.tag.equals("TRLR")) {
                    Impl.this.entity++;
                }
                return result;
            }

            @Override
            protected void readProperties(Property prop, int currentLevel, int pos) throws IOException {
                super.readProperties(prop, currentLevel, pos);
                this.decryptLazy(prop);
            }

            private void decryptLazy(Property prop) throws GedcomIOException {
                if (prop instanceof PropertyXRef) {
                    return;
                }
                if (prop instanceof PropertyDate && prop.isValid()) {
                    return;
                }
                String value = prop.getValue();
                if (!Enigma.isEncrypted(value)) {
                    return;
                }
                prop.setPrivate(true, false);
                if (Impl.this.gedcom.getPassword() == "unknown") {
                    return;
                }
                while (Impl.this.enigma == null) {
                    String pwd = Impl.this.context.getPassword();
                    if (pwd == null) {
                        Impl.this.context.handleWarning(this.getLines(), RESOURCES.getString("crypt.password.unknown"), new Context(prop));
                        Impl.this.gedcom.setPassword("unknown");
                        return;
                    }
                    try {
                        Impl.this.enigma = Enigma.getInstance(pwd);
                        Impl.this.enigma.decrypt(value);
                        Impl.this.gedcom.setPassword(pwd);
                    }
                    catch (IOException e) {
                        Impl.this.enigma = null;
                    }
                }
                try {
                    prop.setValue(Impl.this.enigma.decrypt(value));
                }
                catch (IOException e) {
                    throw new GedcomIOException(RESOURCES.getString("crypt.password.invalid"), this.lines);
                }
            }

            @Override
            protected void link(PropertyXRef xref, int line) {
                Impl.this.lazyLinks.add(new LazyLink(xref, line));
            }

            @Override
            protected void trackEmptyLine() {
                if (!"TRLR".equals(this.tag)) {
                    Impl.this.context.handleWarning(this.getLines(), RESOURCES.getString("read.error.emptyline"), new Context(Impl.this.gedcom));
                }
            }

            @Override
            protected void trackBadLevel(int level, Property parent) {
                Impl.this.context.handleWarning(this.getLines(), RESOURCES.getString("read.warn.badlevel", "" + level), new Context(parent));
            }

            @Override
            protected void trackBadProperty(Property property, String message) {
                Impl.this.context.handleWarning(this.getLines(), message, new Context(property));
            }
        }
    }
}

