/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.util.swing.DialogManager;
import genj.gedcom.GedcomException;
import genj.gedcom.MetaProperty;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.util.ChangeSupport;
import genj.util.Resources;
import genj.util.WordBuffer;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.PopupWidget;
import genj.util.swing.TextFieldWidget;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DateWidget
extends JPanel {
    private static final NestedBlockLayout LAYOUT = new NestedBlockLayout("<row><x pad=\"0\"/><x/><x/><x pad=\"0\"/><x pad=\"0,10,0,0\"/></row>");
    private Resources resources = Resources.get(Resources.class);
    private PopupWidget widgetCalendar;
    private TextFieldWidget widgetDay;
    private TextFieldWidget widgetYear;
    private ChoiceWidget widgetMonth;
    private JLabel altDisplay;
    private Calendar calendar;
    private List<SwitchCalendar> switches;
    private Calendar preferedCalendar;
    private Calendar alternateCalendar;
    private ChangeSupport changeSupport = new ChangeSupport(this){

        @Override
        public void fireChangeEvent(ChangeEvent event) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DateWidget.this.updateStatus();
                    }
                });
            } else {
                DateWidget.this.updateStatus();
            }
            super.fireChangeEvent(event);
        }
    };

    public DateWidget() {
        this(new PointInTime());
    }

    public DateWidget(PointInTime pit) {
        String format;
        this.setOpaque(false);
        this.calendar = pit.getCalendar();
        this.switches = new ArrayList<SwitchCalendar>(PointInTime.CALENDARS.length + 1);
        for (int s = 0; s < PointInTime.CALENDARS.length; ++s) {
            this.switches.add(new SwitchCalendar(PointInTime.CALENDARS[s], this.changeSupport));
        }
        this.widgetYear = new TextFieldWidget("", 4);
        this.widgetYear.setSelectAllOnFocus(true);
        this.widgetYear.addChangeListener(this.changeSupport);
        this.widgetMonth = new ChoiceWidget(new Object[0], null);
        this.widgetMonth.setIgnoreCase(true);
        this.widgetMonth.setSelectAllOnFocus(true);
        this.widgetMonth.addChangeListener(this.changeSupport);
        this.widgetDay = new TextFieldWidget("", 2);
        this.widgetDay.setSelectAllOnFocus(true);
        this.widgetDay.addChangeListener(this.changeSupport);
        this.widgetCalendar = new PopupWidget();
        this.widgetCalendar.addItems(this.switches);
        this.widgetCalendar.setPreferredSize(new Dimension(26, 20));
        this.altDisplay = new JLabel("");
        this.setLayout(LAYOUT.copy());
        this.add(this.widgetCalendar);
        switch (new SimpleDateFormat().toPattern().charAt(0)) {
            case 'M': 
            case 'm': {
                format = this.resources.getString("dateformat.tip.month");
                this.add(this.widgetMonth);
                this.add(this.widgetDay);
                this.add(this.widgetYear);
                this.widgetMonth.getTextEditor().setDocument(new TabbingDoc(this.widgetDay));
                this.widgetDay.setDocument(new TabbingDoc(this.widgetYear));
                break;
            }
            case 'D': 
            case 'd': {
                format = this.resources.getString("dateformat.tip.day");
                this.add(this.widgetDay);
                this.add(this.widgetMonth);
                this.add(this.widgetYear);
                this.widgetDay.setDocument(new TabbingDoc(this.widgetMonth));
                this.widgetMonth.getTextEditor().setDocument(new TabbingDoc(this.widgetYear));
                break;
            }
            default: {
                format = this.resources.getString("dateformat.tip.year");
                this.add(this.widgetYear);
                this.add(this.widgetMonth);
                this.add(this.widgetDay);
                this.widgetYear.setDocument(new TabbingDoc(this.widgetMonth));
                this.widgetMonth.getTextEditor().setDocument(new TabbingDoc(this.widgetDay));
            }
        }
        this.add(this.altDisplay);
        this.widgetDay.setToolTipText(format);
        this.widgetMonth.setToolTipText(format);
        this.widgetYear.setToolTipText(format);
        this.setValue(pit);
        this.updateStatus();
    }

    public void setPreferedCalendar(Calendar prefered, Calendar alternate) {
        this.alternateCalendar = alternate;
        this.preferedCalendar = prefered;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void addActionListener(ActionListener a) {
        this.widgetYear.addActionListener(a);
        this.widgetMonth.addActionListener(a);
        this.widgetDay.addActionListener(a);
    }

    public void removeActionListener(ActionListener a) {
        this.widgetYear.removeActionListener(a);
        this.widgetMonth.removeActionListener(a);
        this.widgetDay.removeActionListener(a);
    }

    public final void setValue(PointInTime pit) {
        this.calendar = pit.getCalendar();
        this.widgetCalendar.setToolTipText(this.calendar.getName());
        this.widgetYear.setText(this.calendar.getDisplayYear(pit.getYear()));
        this.widgetDay.setText(this.calendar.getDay(pit.getDay()));
        String[] months = this.calendar.getMonths(true);
        this.widgetMonth.setValues(Arrays.asList(months));
        try {
            this.widgetMonth.setSelectedItem(null);
            this.widgetMonth.setSelectedItem(months[pit.getMonth()]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.updateStatus();
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public PointInTime getValue() {
        return this.getValue(true);
    }

    public PointInTime getValue(boolean forceValid) {
        Integer u;
        Integer d = u = Integer.valueOf(Integer.MAX_VALUE);
        Integer m = u;
        Integer y = u;
        d = this.getDay();
        if (d == null) {
            return null;
        }
        y = this.getYear();
        if (y == null) {
            return null;
        }
        m = this.getMonth();
        if (m == null) {
            return null;
        }
        PointInTime result = new PointInTime(d, m, y, this.calendar);
        if (d.equals(u) && m.equals(u) && y.equals(u) || result.isValid() || !forceValid) {
            return result;
        }
        return null;
    }

    public Integer getDay() {
        Integer d = Integer.MAX_VALUE;
        String day = this.widgetDay.getText().trim();
        if (day.length() > 0) {
            try {
                d = Integer.parseInt(day) - 1;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return d;
    }

    public Integer getMonth() {
        Integer m;
        block4: {
            m = Integer.MAX_VALUE;
            String month = this.widgetMonth.getText();
            if (month.length() > 0) {
                try {
                    m = Integer.parseInt(month) - 1;
                }
                catch (NumberFormatException e) {
                    String[] months = this.calendar.getMonths(true);
                    m = 0;
                    while (m < months.length && !month.equalsIgnoreCase(months[m])) {
                        Integer n = m;
                        Integer n2 = m = Integer.valueOf(m + 1);
                    }
                    if (m != months.length) break block4;
                    return null;
                }
            }
        }
        return m;
    }

    public Integer getYear() {
        Integer y = Integer.MAX_VALUE;
        String year = this.widgetYear.getText().trim();
        if (year.length() > 0) {
            try {
                y = this.calendar.getYear(year);
            }
            catch (GedcomException e) {
                return null;
            }
        }
        return y;
    }

    private void updateStatus() {
        PointInTime value = this.getValue();
        Calendar helpCalendar = null;
        if (value == null) {
            this.widgetCalendar.setEnabled(false);
            this.widgetCalendar.setDisabledIcon(MetaProperty.IMG_ERROR);
        } else {
            this.widgetCalendar.setVisible(true);
            this.widgetCalendar.setEnabled(true);
            this.widgetCalendar.setIcon(this.calendar.getImage());
            helpCalendar = value.getCalendar() == this.preferedCalendar ? this.alternateCalendar : this.preferedCalendar;
        }
        if (helpCalendar == null) {
            this.altDisplay.setVisible(false);
            this.altDisplay.setText("");
        } else {
            this.altDisplay.setVisible(true);
            try {
                String dispValue = value.getPointInTime(helpCalendar).toString();
                if ("?".equals(dispValue)) {
                    dispValue = "";
                }
                this.altDisplay.setText(dispValue);
            }
            catch (GedcomException gedcomException) {
                // empty catch block
            }
        }
        for (SwitchCalendar switcher : this.switches) {
            switcher.preview();
        }
    }

    private boolean areValidDaysMonths() {
        PointInTime result;
        if (!this.widgetDay.getText().isEmpty()) {
            Integer d = this.getDay();
            if (d == null) {
                return false;
            }
            result = new PointInTime(d, 0, 2016, this.calendar);
            if (!result.isValid()) {
                return false;
            }
        }
        if (!this.widgetMonth.getText().isEmpty()) {
            Integer m = this.getMonth();
            if (m == null) {
                return false;
            }
            result = new PointInTime(0, m, 2016, this.calendar);
            if (!result.isValid()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }

    @Override
    public void requestFocus() {
        this.getComponent(0).requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.getComponent(0).requestFocusInWindow();
    }

    private class SwitchCalendar
    extends AbstractAncestrisAction {
        private Calendar newCalendar;
        private ChangeSupport widgetChangeSupport;

        private SwitchCalendar(Calendar cal, ChangeSupport cs) {
            this.widgetChangeSupport = cs;
            this.newCalendar = cal;
            this.setImage(this.newCalendar.getImage());
            this.setText(cal.getName());
        }

        public void preview() {
            WordBuffer result = new WordBuffer();
            result.append(this.newCalendar.getName());
            result.setFiller(" - ");
            try {
                PointInTime p = DateWidget.this.getValue();
                if (p.isComplete()) {
                    PointInTime pit = p.getPointInTime(this.newCalendar);
                    result.append(pit.getDayOfWeek(true));
                    result.append(pit);
                } else {
                    PointInTime to;
                    PointInTime from;
                    if (p.getMonth() == Integer.MAX_VALUE) {
                        from = new PointInTime(Integer.MAX_VALUE, 0, p.getYear(), p.getCalendar());
                        to = new PointInTime();
                        to.set(from);
                        to.add(0, -1, 1);
                        from.set(Integer.MAX_VALUE, from.getMonth(), from.getYear());
                        to.set(Integer.MAX_VALUE, to.getMonth(), to.getYear());
                    } else {
                        from = new PointInTime(0, p.getMonth(), p.getYear(), p.getCalendar());
                        to = new PointInTime();
                        to.set(from);
                        to.add(-1, 1, 0);
                    }
                    result.append(from.getPointInTime(this.newCalendar));
                    result.append(to.getPointInTime(this.newCalendar));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.setText(result.toString());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            PointInTime pit = DateWidget.this.getValue();
            if (pit != null) {
                try {
                    pit.set(this.newCalendar);
                }
                catch (GedcomException e) {
                    String reset = Calendar.TXT_CALENDAR_RESET;
                    if (DialogManager.create(Calendar.TXT_CALENDAR_SWITCH, e.getMessage()).setMessageType(0).setOptions(new Object[]{DialogManager.OK_OPTION, reset}).show() == DialogManager.OK_OPTION) {
                        return;
                    }
                    pit = new PointInTime(this.newCalendar);
                }
                DateWidget.this.setValue(pit);
            }
            this.widgetChangeSupport.fireChangeEvent(event);
        }
    }

    private static class TabbingDoc
    extends PlainDocument {
        private JComponent next;

        public TabbingDoc(JComponent next) {
            this.next = next;
        }

        private boolean tab(String str) {
            if (str.length() != 1) {
                return false;
            }
            char c = str.charAt(0);
            if (c != '.' && c != '/' && c != '-') {
                return false;
            }
            if (this.next != null) {
                this.next.requestFocusInWindow();
            }
            return true;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (this.tab(str)) {
                return;
            }
            super.insertString(offs, str, a);
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (this.tab(text)) {
                return;
            }
            super.replace(offset, length, text, attrs);
        }
    }
}

