/*
 * Decompiled with CFR 0.152.
 */
package ancestris.api.imports;

import ancestris.api.imports.ImportFactory;
import ancestris.api.imports.ImportPanel;
import ancestris.api.imports.ImportRunner;
import ancestris.core.TextOptions;
import ancestris.gedcom.GedcomDirectory;
import ancestris.gedcom.GedcomMgr;
import ancestris.modules.console.Console;
import ancestris.util.ProgressListener;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyRelationship;
import genj.gedcom.TagPath;
import genj.io.GedcomFileReader;
import genj.io.GedcomFileWriter;
import genj.io.GedcomFormatException;
import genj.util.Origin;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import spin.Spin;

public abstract class Import
implements ImportRunner {
    protected static String EOL = System.getProperty("line.separator");
    protected static final String INDI_TAG_YES = "BIRT|CHR|DEAT|BURI|CREM|ADOP|BAPM|BARM|BASM|BLES|CHRA|CONF|FCOM|ORDN|NATU|EMIG|IMMI|CENS|PROB|WILL|GRAD|RETI|";
    protected static final String FAM_TAG_YES = "ANUL|CENS|DIV|DIVF|ENGA|MARR|MARB|MARC|MARL|MARS";
    protected static Pattern tag_y = Pattern.compile("(BIRT|CHR|DEAT|BURI|CREM|ADOP|BAPM|BARM|BASM|BLES|CHRA|CONF|FCOM|ORDN|NATU|EMIG|IMMI|CENS|PROB|WILL|GRAD|RETI|ANUL|CENS|DIV|DIVF|ENGA|MARR|MARB|MARC|MARL|MARS)");
    protected static String GEDCOM_VERSION = "5.5";
    protected static final String GEDCOM55_TAG = "ABBR|ADDR|ADR1|ADR2|ADOP|AFN|AGE|AGNC|ALIA|ANCE|ANCI|ANUL|ASSO|AUTH|BAPL|BAPM|BARM|BASM|BIRT|BLES|BLOB|BURI|CALN|CAST|CAUS|CENS|CHAN|CHAR|CHIL|CHR|CHRA|CITY|CONC|CONF|CONL|CONT|COPR|CORP|CREM|CTRY|DATA|DATE|DEAT|DESC|DESI|DEST|DIV|DIVF|DSCR|EDUC|EMIG|ENDL|ENGA|EVEN|FAM|FAMC|FAMF|FAMS|FCOM|FILE|FORM|GEDC|GIVN|GRAD|HEAD|HUSB|IDNO|IMMI|INDI|LANG|LEGA|MARB|MARC|MARL|MARR|MARS|MEDI|NAME|NATI|NATU|NCHI|NICK|NMR|NOTE|NPFX|NSFX|OBJE|OCCU|ORDI|ORDN|PAGE|PEDI|PHON|PLAC|POST|PROB|PROP|PUBL|QUAY|REFN|RELA|RELI|REPO|RESI|RESN|RETI|RFN|RIN|ROLE|SEX|SLGC|SLGS|SOUR|SPFX|SSN|STAE|STAT|SUBM|SUBN|SURN|TEMP|TEXT|TIME|TITL|TRLR|TYPE|VERS|WIFE|WILL";
    protected static final String GEDCOM551_TAG = "|EMAIL|FAX|FACT|FONE|ROMN|WWW|MAP|LATI|LONG|";
    protected static Pattern tag55_valid = Pattern.compile("(ABBR|ADDR|ADR1|ADR2|ADOP|AFN|AGE|AGNC|ALIA|ANCE|ANCI|ANUL|ASSO|AUTH|BAPL|BAPM|BARM|BASM|BIRT|BLES|BLOB|BURI|CALN|CAST|CAUS|CENS|CHAN|CHAR|CHIL|CHR|CHRA|CITY|CONC|CONF|CONL|CONT|COPR|CORP|CREM|CTRY|DATA|DATE|DEAT|DESC|DESI|DEST|DIV|DIVF|DSCR|EDUC|EMIG|ENDL|ENGA|EVEN|FAM|FAMC|FAMF|FAMS|FCOM|FILE|FORM|GEDC|GIVN|GRAD|HEAD|HUSB|IDNO|IMMI|INDI|LANG|LEGA|MARB|MARC|MARL|MARR|MARS|MEDI|NAME|NATI|NATU|NCHI|NICK|NMR|NOTE|NPFX|NSFX|OBJE|OCCU|ORDI|ORDN|PAGE|PEDI|PHON|PLAC|POST|PROB|PROP|PUBL|QUAY|REFN|RELA|RELI|REPO|RESI|RESN|RETI|RFN|RIN|ROLE|SEX|SLGC|SLGS|SOUR|SPFX|SSN|STAE|STAT|SUBM|SUBN|SURN|TEMP|TEXT|TIME|TITL|TRLR|TYPE|VERS|WIFE|WILL)");
    protected static Pattern tag551_valid = Pattern.compile("(ABBR|ADDR|ADR1|ADR2|ADOP|AFN|AGE|AGNC|ALIA|ANCE|ANCI|ANUL|ASSO|AUTH|BAPL|BAPM|BARM|BASM|BIRT|BLES|BLOB|BURI|CALN|CAST|CAUS|CENS|CHAN|CHAR|CHIL|CHR|CHRA|CITY|CONC|CONF|CONL|CONT|COPR|CORP|CREM|CTRY|DATA|DATE|DEAT|DESC|DESI|DEST|DIV|DIVF|DSCR|EDUC|EMIG|ENDL|ENGA|EVEN|FAM|FAMC|FAMF|FAMS|FCOM|FILE|FORM|GEDC|GIVN|GRAD|HEAD|HUSB|IDNO|IMMI|INDI|LANG|LEGA|MARB|MARC|MARL|MARR|MARS|MEDI|NAME|NATI|NATU|NCHI|NICK|NMR|NOTE|NPFX|NSFX|OBJE|OCCU|ORDI|ORDN|PAGE|PEDI|PHON|PLAC|POST|PROB|PROP|PUBL|QUAY|REFN|RELA|RELI|REPO|RESI|RESN|RETI|RFN|RIN|ROLE|SEX|SLGC|SLGS|SOUR|SPFX|SSN|STAE|STAT|SUBM|SUBN|SURN|TEMP|TEXT|TIME|TITL|TRLR|TYPE|VERS|WIFE|WILL|EMAIL|FAX|FACT|FONE|ROMN|WWW|MAP|LATI|LONG|)");
    protected static final String typerepo = "REPO";
    protected static Pattern gedcom_line = Pattern.compile("^(\\d) (_*\\w+)(.*)");
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    private boolean headerzone = false;
    private static final int TAG_MISSING = 0;
    private static final int TAG_INVALID = 1;
    private static final int TAG_VALID = 2;
    private int destination_found = 0;
    private static final int PLACE_MAX_LENGTH = 20;
    private int place_found = 0;
    private final Integer[] place_format_sizes = new Integer[20];
    private static HashMap<String, ImportEnt> hashIndis;
    private static HashMap<String, ImportEnt> hashFams;
    private static HashMap<String, ImportEnt> hashNotes;
    private static HashMap<String, ImportEnt> hashObjes;
    private static HashMap<String, ImportEnt> hashSours;
    private static HashMap<String, ImportEnt> hashRepos;
    private static HashMap<String, ImportEnt> hashSubms;
    private String tabName = "";
    public GedcomFileReader input;
    public GedcomFileWriter output;
    protected Console console;
    public int nbChanges = 0;
    private boolean cancelProcess = false;
    private static final int READLINES = 0;
    private static final int CONVERTLINES = 1;
    private static final int CONVERTGEDCOM = 2;
    private int nbOfFileLines = 0;
    private int state = 0;
    private int progress;
    private boolean cancel = false;

    public abstract String toString();

    public abstract boolean isGeneric();

    protected abstract String getImportComment();

    public void setTabName(String tabName) {
        this.console = new Console(tabName);
    }

    public void launch(File inputFile, File outputFile) {
        this.cancel = false;
        this.cancelProcess = false;
        ImportPanel importPanel = new ImportPanel(new Callable(){

            public Object call() throws Exception {
                Import.this.cancelProcess();
                return null;
            }
        });
        String title = NbBundle.getMessage(Import.class, (String)"Import.progress.importing", (Object)inputFile.getName());
        DialogManager dialog = DialogManager.create(title, importPanel, false).setMessageType(-1).setOptions(new Object[0]).setResizable(false);
        dialog.show();
        this.setTabName(NbBundle.getMessage(Import.class, (String)"OpenIDE-Module-Name") + " - " + this.toString());
        ImportRunner importTask = (ImportRunner)Spin.off((Object)ImportFactory.createImport(this));
        ProgressListener.Dispatcher.processStarted(importTask);
        boolean taskOk = importTask.run(inputFile, outputFile);
        ProgressListener.Dispatcher.processStopped(importTask);
        if (this.cancelProcess || !taskOk) {
            dialog.cancel();
            return;
        }
        importPanel.increment();
        GedcomMgr.getDefault().setQuiet(true);
        Context context = GedcomDirectory.getDefault().openAncestrisGedcom(FileUtil.toFileObject((File)outputFile));
        GedcomMgr.getDefault().setQuiet(false);
        if (this.cancelProcess || context == null) {
            dialog.cancel();
            return;
        }
        importPanel.increment();
        Gedcom importedGedcom = context.getGedcom();
        importedGedcom.setName(inputFile.getName());
        ProgressListener.Dispatcher.processStarted(importTask);
        importTask.fixGedcom(importedGedcom);
        importTask.complete();
        ProgressListener.Dispatcher.processStopped(importTask);
        importPanel.increment();
        if (this.cancelProcess) {
            dialog.cancel();
            return;
        }
        Origin o = GedcomMgr.getDefault().saveGedcomAs(context, null, FileUtil.toFileObject((File)outputFile));
        GedcomDirectory.getDefault().closeGedcom(context);
        if (this.cancelProcess || o == null) {
            dialog.cancel();
            return;
        }
        importPanel.increment();
        GedcomDirectory.getDefault().openAncestrisGedcom(FileUtil.toFileObject((File)o.getFile()));
        if (this.cancelProcess) {
            dialog.cancel();
            return;
        }
        importPanel.requestFocusInWindow();
        importPanel.increment();
        dialog.cancel();
        Object rc = DialogManager.create(NbBundle.getMessage(Import.class, (String)"Import.completed"), NbBundle.getMessage(Import.class, (String)"cc.importResults?", (Object)inputFile.getName(), (Object)this.toString(), (Object)this.getIndisNb(), (Object)this.getFamsNb(), (Object[])new Object[]{this.getNotesNb(), this.getObjesNb(), this.getSoursNb(), this.getReposNb(), this.getSubmsNb(), this.getChangesNb()})).setMessageType(1).setOptionType(0).show();
        if (rc == DialogManager.YES_OPTION) {
            this.showDetails();
        }
    }

    public void cancelProcess() {
        ProgressListener.Dispatcher.processStopAll();
        this.cancelProcess = true;
    }

    @Override
    public void cancelTrackable() {
        this.cancel = true;
    }

    @Override
    public int getProgress() {
        switch (this.state) {
            case 0: 
            case 1: {
                if (this.nbOfFileLines == 0 || this.input == null) {
                    return 1;
                }
                this.progress = (this.state * 50 * this.nbOfFileLines + this.input.getLines()) / this.nbOfFileLines;
                return this.progress;
            }
            case 2: {
                return this.progress;
            }
        }
        return 1;
    }

    @Override
    public String getState() {
        switch (this.state) {
            case 0: {
                return NbBundle.getMessage(Import.class, (String)"Import.progress.readlines", (Object)this.tabName);
            }
            case 1: {
                return NbBundle.getMessage(Import.class, (String)"Import.progress.convertlines", (Object)this.tabName);
            }
        }
        return NbBundle.getMessage(Import.class, (String)"Import.progress.convertgedcom", (Object)this.tabName);
    }

    @Override
    public String getTaskName() {
        return NbBundle.getMessage(Import.class, (String)"Import.progress.importing", (Object)this.tabName);
    }

    public void incrementProgress() {
        this.progress += 10;
        if (this.progress > 100) {
            this.progress = 90;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run(File fileIn, File fileOut) {
        String l;
        this.tabName = fileIn.getName();
        this.init();
        this.state = 0;
        try {
            FileReader in = new FileReader(fileIn);
            LineNumberReader count = new LineNumberReader(in);
            while (count.skip(Long.MAX_VALUE) > 0L) {
            }
            this.nbOfFileLines = (count.getLineNumber() + 1) / 50;
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Error during File Reading.", ex);
        }
        try {
            this.input = GedcomFileReader.create(fileIn);
            try {
                while (!this.cancel && this.input.getNextLine(true) != null) {
                    this.firstPass();
                }
            }
            finally {
                this.input.close();
            }
        }
        catch (FileNotFoundException e1) {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(Import.class, (String)"file.not.found", (Object)fileIn.getName()));
            return false;
        }
        catch (GedcomFormatException e) {
            l = "" + e.getLine();
            JOptionPane.showMessageDialog(null, e.getMessage() + "\n" + NbBundle.getMessage(Import.class, (String)"error.line", (Object)l));
            return false;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(Import.class, (String)"error.other", (Object)e.getMessage()));
            LOG.log(Level.INFO, "Error during new file creation.", e);
            return false;
        }
        ++this.state;
        try {
            this.output = new GedcomFileWriter(fileOut, this.input.getCharset(), this.getEOL(fileIn));
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(Import.class, (String)"file.create.error", (Object)fileOut.getName()));
            LOG.log(Level.INFO, "Error during new file creation.", e1);
            return false;
        }
        try {
            this.console.println("=============================");
            this.console.println(NbBundle.getMessage(Import.class, (String)"Import.starting"));
            this.console.println(NbBundle.getMessage(Import.class, (String)"Import.version", (Object)GEDCOM_VERSION));
            this.console.println("=============================");
            this.input = GedcomFileReader.create(fileIn);
            try {
                while (!this.cancel && this.input.getNextLine(true) != null) {
                    if (this.input.getLevel() == 0 && this.input.getTag().equals("HEAD")) {
                        this.output.writeLine(this.input);
                        this.output.writeLine(1, "NOTE", this.getImportComment());
                        this.console.println(NbBundle.getMessage(Import.class, (String)"Import.header"));
                        ++this.nbChanges;
                        continue;
                    }
                    if (this.process()) continue;
                    if (this.input.getTag().equals("TRLR")) {
                        this.finalise();
                        this.output.writeLine(0, "TRLR", null);
                        continue;
                    }
                    this.output.writeLine(this.input);
                }
            }
            finally {
                this.input.close();
                this.output.close();
            }
        }
        catch (FileNotFoundException e1) {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(Import.class, (String)"file.not.found", (Object)fileIn.getName()));
            return false;
        }
        catch (GedcomFormatException e) {
            l = "" + e.getLine();
            JOptionPane.showMessageDialog(null, e.getMessage() + "\n" + NbBundle.getMessage(Import.class, (String)"error.line", (Object)l));
            return false;
        }
        catch (IOException | MissingResourceException e) {
            JOptionPane.showMessageDialog(null, e.getMessage());
            LOG.log(Level.INFO, "Error during new file reading.", e);
            return false;
        }
        this.console.println("=============================");
        return true;
    }

    protected void init() {
        this.nbChanges = 0;
        this.headerzone = false;
        this.destination_found = 0;
        this.place_found = 0;
        for (int i = 0; i < 20; ++i) {
            this.place_format_sizes[i] = 0;
        }
        hashIndis = new HashMap();
        hashFams = new HashMap();
        hashNotes = new HashMap();
        hashObjes = new HashMap();
        hashSours = new HashMap();
        hashRepos = new HashMap();
        hashSubms = new HashMap();
    }

    protected void firstPass() {
        int length;
        if (this.headerzone && this.input.getLevel() == 0 && !this.input.getTag().equals("HEAD")) {
            this.headerzone = false;
        }
        if (this.input.getLevel() == 0 && this.input.getTag().equals("HEAD")) {
            this.headerzone = true;
        }
        if (this.input.getLevel() == 2 && this.input.getTag().equals("VERS")) {
            GEDCOM_VERSION = this.input.getValue();
        }
        if (this.input.getLevel() == 1 && this.input.getTag().equals("DEST")) {
            String value = this.input.getValue();
            this.destination_found = value != null && (value.equals("ANSTFILE") || value.equals("TempleReady") || value.equals("ANY")) ? 2 : 1;
        }
        if (this.headerzone && this.input.getLevel() == 1 && this.input.getTag().equals("PLAC")) {
            try {
                this.input.getNextLine(false);
            }
            catch (IOException value) {
                // empty catch block
            }
            if (this.input.getTag().equals("FORM") && this.input.getValue() != null) {
                String form = this.input.getValue().replaceAll(" ", "").replaceAll(",", "");
                this.place_found = (form = form.toUpperCase(TextOptions.getInstance().getOutputLocale(Locale.getDefault()))).matches("\\p{L}*") ? 2 : 1;
            }
        }
        if (this.input.getTag().equals("PLAC") && !this.input.getValue().isEmpty() && (length = this.input.getValue().split(",").length) < 20) {
            Integer[] integerArray = this.place_format_sizes;
            int n = length;
            Integer n2 = integerArray[n];
            Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] + 1);
        }
        this.memorizeEntities();
    }

    protected boolean process() throws IOException {
        if (this.processHeader()) {
            return true;
        }
        if (this.processYesTag()) {
            return true;
        }
        if (this.processInvalidTag()) {
            return true;
        }
        return this.processInvalidDates();
    }

    protected void finalise() throws IOException {
        this.addMissingEntities();
        this.state = 2;
        this.progress = 1;
    }

    @Override
    public boolean fixGedcom(Gedcom gedcom) {
        boolean ret = this.fixNames(gedcom);
        return ret |= this.fixPlaces(gedcom);
    }

    @Override
    public void complete() {
        this.progress = 100;
        this.console.println(NbBundle.getMessage(Import.class, (String)"Import.completed"));
        this.console.println("=============================");
    }

    private void memorizeEntities() {
        this.memorizeEntity("INDI", hashIndis);
        this.memorizeProperty("HUSB", hashIndis);
        this.memorizeProperty("WIFE", hashIndis);
        this.memorizeProperty("CHIL", hashIndis);
        this.memorizeProperty("ALIA", hashIndis);
        this.memorizeProperty("ASSO", hashIndis);
        this.memorizeEntity("FAM", hashFams);
        this.memorizeProperty("FAMS", hashFams);
        this.memorizeProperty("FAMC", hashFams);
        this.memorizeEntity("NOTE", hashNotes);
        this.memorizeProperty("NOTE", hashNotes);
        this.memorizeEntity("OBJE", hashObjes);
        this.memorizeProperty("OBJE", hashObjes);
        this.memorizeEntity("SOUR", hashSours);
        this.memorizeProperty("SOUR", hashSours);
        this.memorizeEntity(typerepo, hashRepos);
        this.memorizeProperty(typerepo, hashRepos);
        this.memorizeEntity("SUBM", hashSubms);
        this.memorizeProperty("SUBM", hashSubms);
        this.memorizeProperty("SUBN", hashSubms);
        this.memorizeProperty("ANCI", hashSubms);
        this.memorizeProperty("DESI", hashSubms);
    }

    private void addMissingEntities() throws IOException {
        for (String k : hashIndis.keySet()) {
            if (Import.hashIndis.get((Object)k).seen) continue;
            this.output.writeLine(0, k, "INDI", null);
            this.console.println(NbBundle.getMessage(Import.class, (String)"Import.addMissingEntity", (Object)k));
            ++this.nbChanges;
        }
        for (String k : hashFams.keySet()) {
            if (Import.hashFams.get((Object)k).seen) continue;
            this.output.writeLine(0, k, "FAM", null);
            this.console.println(NbBundle.getMessage(Import.class, (String)"Import.addMissingEntity", (Object)k));
            ++this.nbChanges;
        }
        for (String k : hashNotes.keySet()) {
            if (Import.hashNotes.get((Object)k).seen) continue;
            this.output.writeLine(0, k, "NOTE", null);
            this.console.println(NbBundle.getMessage(Import.class, (String)"Import.addMissingEntity", (Object)k));
            ++this.nbChanges;
        }
        for (String k : hashObjes.keySet()) {
            if (Import.hashObjes.get((Object)k).seen) continue;
            this.output.writeLine(0, k, "OBJE", null);
            this.console.println(NbBundle.getMessage(Import.class, (String)"Import.addMissingEntity", (Object)k));
            ++this.nbChanges;
        }
        for (String k : hashSours.keySet()) {
            if (Import.hashSours.get((Object)k).seen) continue;
            this.output.writeLine(0, k, "SOUR", null);
            this.console.println(NbBundle.getMessage(Import.class, (String)"Import.addMissingEntity", (Object)k));
            ++this.nbChanges;
        }
        for (String k : hashRepos.keySet()) {
            if (Import.hashRepos.get((Object)k).seen) continue;
            this.output.writeLine(0, k, typerepo, null);
            this.console.println(NbBundle.getMessage(Import.class, (String)"Import.addMissingEntity", (Object)k));
            ++this.nbChanges;
        }
        for (String k : hashSubms.keySet()) {
            if (Import.hashSubms.get((Object)k).seen) continue;
            this.output.writeLine(0, k, "SUBM", null);
            this.console.println(NbBundle.getMessage(Import.class, (String)"Import.addMissingEntity", (Object)k));
            ++this.nbChanges;
        }
    }

    public boolean processHeader() throws IOException {
        if (this.destination_found == 0 && this.input.getLevel() == 1 && this.input.getTag().equals("GEDC")) {
            this.output.writeLine(1, "DEST", "ANY");
            this.output.writeLine(1, "GEDC", "");
            this.destination_found = 2;
            this.console.println(NbBundle.getMessage(Import.class, (String)"Import.fixDestination"));
            ++this.nbChanges;
            return true;
        }
        if (this.destination_found == 1 && this.input.getLevel() == 1 && this.input.getTag().equals("DEST")) {
            this.output.writeLine(1, "DEST", "ANY");
            this.destination_found = 2;
            this.console.println(NbBundle.getMessage(Import.class, (String)"Import.fixDestination"));
            ++this.nbChanges;
            return true;
        }
        if (this.place_found == 0) {
            if (this.input.getLevel() == 1 && this.input.getTag().equals("PLAC")) {
                this.output.writeLine(this.input.getLevel(), this.input.getTag(), this.input.getValue());
                this.output.writeLine(2, "FORM", this.getPlaceFormat(false));
                this.place_found = 2;
                this.console.println(NbBundle.getMessage(Import.class, (String)"Import.fixPlaceTag"));
                ++this.nbChanges;
                return true;
            }
            if (this.input.getLevel() == 0 && !this.input.getTag().equals("HEAD")) {
                this.output.writeLine(1, "PLAC", "");
                this.output.writeLine(2, "FORM", this.getPlaceFormat(false));
                this.output.writeLine(this.input.getLevel(), this.input.getXref(), this.input.getTag(), this.input.getValue());
                this.place_found = 2;
                this.console.println(NbBundle.getMessage(Import.class, (String)"Import.fixPlaceTag"));
                ++this.nbChanges;
                return true;
            }
        }
        if (this.place_found == 1 && this.input.getLevel() == 1 && this.input.getTag().equals("PLAC")) {
            this.output.writeLine(this.input.getLevel(), this.input.getTag(), this.input.getValue());
            this.input.getNextLine(true);
            this.output.writeLine(this.input.getLevel(), this.input.getTag(), this.input.getValue());
            this.place_found = 2;
            this.console.println(NbBundle.getMessage(Import.class, (String)"Import.fixPlaceTag"));
            ++this.nbChanges;
            return true;
        }
        return false;
    }

    public boolean processYesTag() throws IOException {
        Matcher matcher = tag_y.matcher(this.input.getTag());
        if (matcher.matches()) {
            String result = null;
            String tag = this.input.getTag();
            int level = this.input.getLevel();
            String line = this.input.getLine();
            if (this.input.getValue().length() != 0) {
                if (this.input.getValue().equalsIgnoreCase("y")) {
                    this.output.writeLine(this.input);
                } else {
                    result = this.output.writeLine(level, tag, null);
                    result = result + "\n" + this.output.writeLine(level + 1, "NOTE", this.input.getValue());
                }
            } else {
                String temp = this.input.getNextLine(false);
                if (temp != null && this.input.getLevel() == level + 1) {
                    this.output.writeLine(level, tag, null);
                } else {
                    result = this.output.writeLine(level, tag, "Y");
                }
            }
            if (result != null) {
                ++this.nbChanges;
                this.console.println(NbBundle.getMessage(Import.class, (String)"Import.fixYesTag", (Object)(line + " ==> " + result)));
            }
            return true;
        }
        return false;
    }

    public boolean processInvalidTag() throws IOException {
        Pattern tag_valid;
        String lineTag = this.input.getTag();
        if (lineTag.startsWith("_")) {
            return false;
        }
        Pattern pattern = tag_valid = GEDCOM_VERSION.startsWith("5.5.1") ? tag551_valid : tag55_valid;
        if (!tag_valid.matcher(lineTag).matches()) {
            String result = this.output.writeLine(this.input.getLevel(), "_" + lineTag, this.input.getValue());
            ++this.nbChanges;
            this.console.println(NbBundle.getMessage(Import.class, (String)"Import.fixInvalidTag", (Object)(this.input.getLine() + " ==> " + result)));
            return true;
        }
        return false;
    }

    public boolean processInvalidDates() throws IOException {
        String date;
        if ("DATE".equals(this.input.getTag()) && (date = this.input.getValue()).contains("/")) {
            date = this.convertDate(date);
            String result = this.output.writeLine(this.input.getLevel(), "DATE", date);
            this.console.println(NbBundle.getMessage(Import.class, (String)"Import.fixInvalidTag", (Object)(this.input.getLine() + " ==> " + result)));
            ++this.nbChanges;
            return true;
        }
        return false;
    }

    public String convertDate(String date) {
        date = date.contains("@#DHEBREW@") ? date.replaceAll("/01/", " TSH ").replaceAll("/02/", " CSH ").replaceAll("/03/", " KSL ").replaceAll("/04/", " TVT ").replaceAll("/05/", " SHV ").replaceAll("/06/", " ADR ").replaceAll("/07/", " ADS ").replaceAll("/08/", " NSN ").replaceAll("/09/", " IYR ").replaceAll("/10/", " SVN ").replaceAll("/11/", " TMZ ").replaceAll("/12/", " AAV ").replaceAll("/13/", " ELL ").replaceAll("/1/", " TSH ").replaceAll("/2/", " CSH ").replaceAll("/3/", " KSL ").replaceAll("/4/", " TVT ").replaceAll("/5/", " SHV ").replaceAll("/6/", " ADR ").replaceAll("/7/", " ADS ").replaceAll("/8/", " NSN ").replaceAll("/9/", " IYR ") : (date.contains("@#DFRENCH R@") ? date.replaceAll("/01/", " VEND ").replaceAll("/02/", " BRUM ").replaceAll("/03/", " FRIM ").replaceAll("/04/", " NIVO ").replaceAll("/05/", " PLUV ").replaceAll("/06/", " VENT ").replaceAll("/07/", " GERM ").replaceAll("/08/", " FLOR ").replaceAll("/09/", " PRAI ").replaceAll("/10/", " MESS ").replaceAll("/11/", " THER ").replaceAll("/12/", " FRUC ").replaceAll("/12/", " COMP ").replaceAll("/1/", " VEND ").replaceAll("/2/", " BRUM ").replaceAll("/3/", " FRIM ").replaceAll("/4/", " NIVO ").replaceAll("/5/", " PLUV ").replaceAll("/6/", " VENT ").replaceAll("/7/", " GERM ").replaceAll("/8/", " FLOR ").replaceAll("/9/", " PRAI ") : date.replaceAll("/01/", " JAN ").replaceAll("/02/", " FEB ").replaceAll("/03/", " MAR ").replaceAll("/04/", " APR ").replaceAll("/05/", " MAY ").replaceAll("/06/", " JUN ").replaceAll("/07/", " JUL ").replaceAll("/08/", " AUG ").replaceAll("/09/", " SEP ").replaceAll("/10/", " OCT ").replaceAll("/11/", " NOV ").replaceAll("/12/", " DEC ").replaceAll("/1/", " JAN ").replaceAll("/2/", " FEB ").replaceAll("/3/", " MAR ").replaceAll("/4/", " APR ").replaceAll("/5/", " MAY ").replaceAll("/6/", " JUN ").replaceAll("/7/", " JUL ").replaceAll("/8/", " AUG ").replaceAll("/9/", " SEP "));
        return date;
    }

    public boolean fixNames(Gedcom gedcom) {
        boolean hasErrors = false;
        this.console.println(NbBundle.getMessage(Import.class, (String)"Import.fixNames"));
        Collection<Indi> indis = gedcom.getIndis();
        int increment = indis.size() / 10 + 1;
        int counter = 0;
        for (Indi indi : indis) {
            PropertyName propName;
            Property rawName;
            if (++counter % increment == 0 && this.progress < 100) {
                ++this.progress;
            }
            if (!((rawName = indi.getProperty("NAME", false)) instanceof PropertyName) || (propName = (PropertyName)rawName).isValid() && !propName.hasWarning()) continue;
            propName.fixNameValue();
            hasErrors = true;
            this.console.println(NbBundle.getMessage(Import.class, (String)"Import.fixInvalidValue", (Object)propName.getDisplayValue()));
            ++this.nbChanges;
        }
        this.console.println("=============================");
        return hasErrors;
    }

    public boolean fixPlaces(Gedcom gedcom) {
        boolean hasErrors = false;
        String[] locs = null;
        this.console.println(NbBundle.getMessage(Import.class, (String)"Import.fixPlaces"));
        int nbLocs = PropertyPlace.getFormat(gedcom.getPlaceFormat()).length;
        List<? extends Property> places = gedcom.getPropertiesByClass(PropertyPlace.class);
        int increment = places.size() / 10 + 1;
        int counter = 0;
        for (PropertyPlace propertyPlace : places) {
            if (++counter % increment == 0 && this.progress < 100) {
                ++this.progress;
            }
            if ((locs = propertyPlace.getJurisdictions()).length == nbLocs || propertyPlace.setJurisdictions(gedcom, locs)) continue;
            hasErrors = true;
            this.console.println(NbBundle.getMessage(Import.class, (String)"Import.fixInvalidValue", (Object)propertyPlace.getDisplayValue()));
            ++this.nbChanges;
        }
        this.console.println("=============================");
        return hasErrors;
    }

    public boolean convertAssociations(Gedcom gedcom) {
        this.console.println(NbBundle.getMessage(Import.class, (String)"Import.convertingAssos"));
        ArrayList list = new ArrayList();
        gedcom.getIndis().forEach(entity -> this.getPropertiesRecursively(list, "ASSO", (Property)entity));
        gedcom.getFamilies().forEach(entity -> this.getPropertiesRecursively(list, "ASSO", (Property)entity));
        boolean isV55 = Grammar.V55.equals(gedcom.getGrammar());
        int increment = list.size() / 10 + 1;
        int counter = 0;
        for (Property prop : list) {
            if (++counter % increment == 0 && this.progress < 100) {
                ++this.progress;
            }
            if (prop instanceof PropertyAssociation) continue;
            String id = prop.getValue().replace("@", "").trim();
            Indi indiRela = (Indi)gedcom.getEntity(id);
            if (indiRela == null) {
                this.console.println(NbBundle.getMessage(Import.class, (String)"Import.indiNotFound", (Object)id));
                continue;
            }
            String type = prop.getEntity().getTag();
            Property relaProp = prop.getProperty("RELA");
            String rela = "";
            if (relaProp != null) {
                rela = relaProp.getDisplayValue();
            }
            TagPath tagpath = prop.getParent().getPath(true);
            id = prop.getEntity().getId();
            PropertyAssociation propAsso = (PropertyAssociation)indiRela.addProperty("ASSO", "@" + id + "@");
            if (isV55) {
                propAsso.addProperty("TYPE", type);
            }
            PropertyRelationship pship = (PropertyRelationship)propAsso.getProperty("RELA", false);
            rela = rela + "@" + tagpath.toString();
            if (pship == null) {
                propAsso.addProperty("RELA", rela);
            } else {
                pship.setValue(rela);
            }
            for (Property child : prop.getProperties()) {
                if (child.getTag().equals("RELA") || child.getTag().equals("TYPE") && isV55) continue;
                this.movePropertiesRecursively(child, propAsso);
            }
            try {
                propAsso.link();
            }
            catch (GedcomException ex) {
                return false;
            }
            this.console.println(NbBundle.getMessage(Import.class, (String)"Import.adjustAssos", (Object)id));
            prop.getParent().delProperty(prop);
            ++this.nbChanges;
        }
        this.console.println("=============================");
        return true;
    }

    public <T> void getPropertiesRecursively(List<T> props, String tag, Property parent) {
        for (Property child : parent.getProperties()) {
            if (tag.equals(child.getTag())) {
                props.add(child);
            }
            this.getPropertiesRecursively(props, tag, child);
        }
    }

    private void memorizeEntity(String tag, HashMap<String, ImportEnt> hashEntities) {
        String xref;
        if (this.input.getTag().equals(tag) && !(xref = this.input.getXref()).isEmpty()) {
            if (!hashEntities.containsKey(xref)) {
                hashEntities.put(xref, new ImportEnt());
            }
            hashEntities.get((Object)xref).seen = true;
        }
    }

    private void memorizeProperty(String tag, HashMap<String, ImportEnt> hashEntities) {
        if (this.input.getTag().equals(tag) && this.input.getValue().startsWith("@") && this.input.getValue().endsWith("@") && !this.input.getValue().startsWith("@@")) {
            String value = this.input.getValue();
            if (!hashEntities.containsKey(value = value.substring(1, value.length() - 1))) {
                hashEntities.put(value, new ImportEnt());
            }
        }
    }

    public void reduceEvents(Entity entity, String tag) {
        Property[] props;
        int n = 0;
        for (Property event : props = entity.getProperties(tag)) {
            if (n == 0) {
                ++n;
                continue;
            }
            Property host = entity.addProperty("EVEN", "");
            for (Property p : event.getProperties()) {
                this.movePropertiesRecursively(p, host);
            }
            this.console.println(NbBundle.getMessage(Import.class, (String)"Import.reduceEvents", (Object)(event.getTag() + " : " + entity.getId())));
            ++this.nbChanges;
            entity.delProperty(event);
        }
    }

    private void movePropertiesRecursively(Property propertySrc, Property parentPropertyDest) {
        if (parentPropertyDest == null) {
            return;
        }
        int n = parentPropertyDest.getNoOfProperties();
        Property propertyDest = null;
        try {
            String tag = propertySrc.getTag();
            if (!parentPropertyDest.getMetaProperty().allows(tag)) {
                tag = "_" + tag;
            }
            propertyDest = parentPropertyDest.addProperty(tag, propertySrc.getValue(), n);
        }
        catch (GedcomException gedcomException) {
            // empty catch block
        }
        for (Property children : propertySrc.getProperties()) {
            this.movePropertiesRecursively(children, propertyDest);
        }
        propertySrc.getParent().delProperty(propertySrc);
    }

    private String getPlaceFormat(boolean freq) {
        int place_format_length = 0;
        int max = 0;
        for (int i = 0; i < 20; ++i) {
            if (freq && this.place_format_sizes[i] > max) {
                place_format_length = i;
                max = this.place_format_sizes[i];
            }
            if (freq || this.place_format_sizes[i] <= 0) continue;
            place_format_length = i;
        }
        if (place_format_length == 0) {
            return GedcomOptions.getInstance().getPlaceFormat();
        }
        String place_format = "";
        for (int i = 1; i <= place_format_length; ++i) {
            place_format = place_format + "jur" + i;
            if (i == place_format_length) continue;
            place_format = place_format + ",";
        }
        return place_format;
    }

    public int getIndisNb() {
        return hashIndis.size();
    }

    public int getFamsNb() {
        return hashFams.size();
    }

    public int getNotesNb() {
        return hashNotes.size();
    }

    public int getSoursNb() {
        return hashSours.size();
    }

    public int getObjesNb() {
        return hashObjes.size();
    }

    public int getReposNb() {
        return hashRepos.size();
    }

    public int getSubmsNb() {
        return hashSubms.size();
    }

    public int getChangesNb() {
        return this.nbChanges;
    }

    public void showDetails() {
        this.console.show();
    }

    public String getEOL(File input) {
        String eolMark = System.getProperty("line.separator");
        try {
            FileReader fr = new FileReader(input);
            char[] buffer = new char[200];
            fr.read(buffer);
            String line = new String(buffer);
            if (line.contains("\r\n")) {
                eolMark = "\r\n";
            } else if (line.contains("\n")) {
                eolMark = "\n";
            } else if (line.contains("\r")) {
                eolMark = "\r";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return eolMark;
    }

    private class ImportEnt {
        protected boolean seen = false;

        private ImportEnt() {
        }
    }
}

