/*
 * Decompiled with CFR 0.152.
 */
package ancestris.core;

import genj.util.AncestrisPreferences;
import genj.util.Registry;
import java.net.MalformedURLException;
import java.net.URL;

public class CoreOptions {
    private static AncestrisPreferences appOptions;
    public static final int NAME_NONE = 0;
    public static final int NAME_FIRSTCAP = 1;
    public static final int NAME_ALLCAPS = 2;

    private CoreOptions() {
        appOptions = Registry.get(CoreOptions.class);
    }

    public static CoreOptions getInstance() {
        return OptionsHolder.INSTANCE;
    }

    public int getCorrectName() {
        return appOptions.get("correctName", 0);
    }

    public void setCorrectName(int correctName) {
        appOptions.put("correctName", correctName);
    }

    public boolean isSplitJurisdictions() {
        return appOptions.get("isSplitJurisdictions", true);
    }

    public void setSplitJurisdictions(boolean isSplitJurisdictions) {
        appOptions.put("isSplitJurisdictions", isSplitJurisdictions);
    }

    public URL getDefaultGedcom() {
        try {
            String defaultFile = appOptions.get("gedcomFile", (String)null);
            if (defaultFile == null) {
                return null;
            }
            return new URL(defaultFile);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public void setDefaultGedcom(URL def) {
        appOptions.put("gedcomFile", def == null ? (String)null : def.toString());
    }

    public boolean getAlwaysOpenDefault() {
        return appOptions.get("alwaysOpenDefault", false);
    }

    public void setAlwaysOpenDefault(boolean alwaysOpen) {
        appOptions.put("alwaysOpenDefault", alwaysOpen);
    }

    public boolean getOpenNothingAtStartup() {
        return appOptions.get("openNothingAtStartup", false);
    }

    public void setOpenNothingAtStartup(boolean openNothingAtStartup) {
        appOptions.put("openNothingAtStartup", openNothingAtStartup);
    }

    public void setShowHidden(boolean def) {
        appOptions.put("showHidden", def);
    }

    public boolean getShowHidden() {
        return appOptions.get("showHidden", false);
    }

    public int getMinAutosave() {
        return appOptions.get("minautosave", 0);
    }

    public void setMinAutosave(int min) {
        appOptions.put("minautosave", min);
    }

    private static class OptionsHolder {
        private static final CoreOptions INSTANCE = new CoreOptions();

        private OptionsHolder() {
        }
    }
}

