/*
 * Decompiled with CFR 0.152.
 */
package ancestris.core.actions;

import ancestris.core.actions.TitleActionPanel;
import genj.gedcom.Property;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.openide.awt.DynamicMenuContent;
import org.openide.util.actions.Presenter;

public class CommonActions {
    public static final Action NOOP = new NoOpAction();

    public static Action createTitleAction(Property property) {
        return new TitleAction(property);
    }

    private static class TitleMenuItem
    extends JMenuItem
    implements DynamicMenuContent {
        private JPanel panel;

        public TitleMenuItem(Property property) {
            this.panel = new TitleActionPanel(property);
        }

        public JComponent[] getMenuPresenters() {
            return new JComponent[]{this.panel};
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.getMenuPresenters();
        }
    }

    private static class TitleAction
    extends AbstractAction
    implements Presenter.Popup {
        private Property property;

        public TitleAction(Property property) {
            this.property = property;
            this.setEnabled(true);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public JMenuItem getPopupPresenter() {
            return new TitleMenuItem(this.property);
        }
    }

    private static class NoOpAction
    extends AbstractAction {
        public NoOpAction() {
            this.setEnabled(false);
            this.putValue("Name", "noop");
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

