/*
 * Decompiled with CFR 0.152.
 */
package ancestris.core.actions;

import ancestris.core.actions.AbstractAncestrisAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.ActionPresenterProvider;
import org.openide.util.actions.Presenter;

public class SubMenuAction
extends AbstractAncestrisAction
implements ContextAwareAction,
Presenter.Popup {
    private List<Action> actions = new ArrayList<Action>(5);
    private Lookup context;

    public SubMenuAction() {
        this.putValue("hideWhenDisabled", true);
    }

    public SubMenuAction(String displayName) {
        this();
        this.setText(displayName);
    }

    public SubMenuAction(String displayName, Icon icon) {
        this(displayName);
        this.setImage(icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JPopupMenu menu = Utilities.actionsToPopup((Action[])this.actions.toArray(new Action[0]), (Lookup)Lookup.EMPTY);
        Component source = (Component)e.getSource();
        menu.show(source, 0, source.getHeight());
    }

    public void clearActions() {
        this.actions.clear();
    }

    public void addActions(Collection<? extends Action> actions) {
        this.actions.addAll(actions);
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public Action createContextAwareInstance(Lookup context) {
        this.context = context;
        return this;
    }

    @Override
    public JMenuItem getPopupPresenter() {
        JMenu item = this.actionsToMenu(this.context);
        item.putClientProperty("hideWhenDisabled", this.getValue("hideWhenDisabled"));
        return item;
    }

    private JMenu actionsToMenu(Lookup context) {
        HashSet<Action> counted = new HashSet<Action>();
        ArrayList<Component> components = new ArrayList<Component>();
        for (Action action : this.getActions()) {
            if (action != null && counted.add(action)) {
                JMenuItem item = SubMenuAction.actionToMenuItem(action, context);
                for (Component c : ActionPresenterProvider.getDefault().convertComponents((Component)item)) {
                    if (c instanceof JSeparator) {
                        components.add(null);
                        continue;
                    }
                    components.add(c);
                }
                continue;
            }
            components.add(null);
        }
        JMenu menu = new JMenu(this);
        boolean nonempty = false;
        boolean pendingSep = false;
        for (Component c : components) {
            try {
                if (c == null) {
                    pendingSep = nonempty;
                    continue;
                }
                nonempty = true;
                if (pendingSep) {
                    pendingSep = false;
                    menu.addSeparator();
                }
                menu.add(c);
            }
            catch (RuntimeException ex) {
                Exceptions.attachMessage((Throwable)ex, (String)("Current component: " + c));
                Exceptions.attachMessage((Throwable)ex, (String)("List of components: " + components));
                Exceptions.attachMessage((Throwable)ex, (String)("List of actions: " + this.getActions()));
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (!nonempty) {
            menu.setEnabled(false);
        }
        return menu;
    }

    private static JMenuItem actionToMenuItem(Action action, Lookup context) {
        JMenuItem item;
        if (action == null) {
            return null;
        }
        if (action instanceof ContextAwareAction) {
            Action contextAwareAction = ((ContextAwareAction)action).createContextAwareInstance(context);
            if (contextAwareAction == null) {
                Logger.getLogger(Utilities.class.getName()).log(Level.WARNING, "ContextAwareAction.createContextAwareInstance(context) returns null. That is illegal! action={0}, context={1}", new Object[]{action, context});
            } else {
                action = contextAwareAction;
            }
        }
        if (action instanceof Presenter.Popup) {
            item = ((Presenter.Popup)action).getPopupPresenter();
            if (item == null) {
                Logger.getLogger(Utilities.class.getName()).log(Level.WARNING, "findContextMenuImpl, getPopupPresenter returning null for {0}", action);
            }
        } else {
            item = ActionPresenterProvider.getDefault().createPopupPresenter(action);
        }
        return item;
    }
}

