/*
 * Decompiled with CFR 0.152.
 */
package ancestris.core.actions;

import genj.gedcom.Entity;
import genj.gedcom.Property;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TitleActionPanel
extends JPanel {
    private String actionsMenutext;
    private JLabel actionsMenuLabel;
    private JSeparator jSeparator;
    private JLabel propertyIconLabel;
    private JLabel propertyShortDescription;
    private JLabel propertyTitle;

    public TitleActionPanel(Property property) {
        String desc;
        this.actionsMenutext = property != null ? NbBundle.getMessage(TitleActionPanel.class, (String)"TitleActionPanel.actionsMenuLabel.text", (Object)property.getPropertyName().toUpperCase(property.getGedcom().getLocale())) : NbBundle.getMessage(TitleActionPanel.class, (String)"TitleActionPanel.actionsMenuLabel.multiple");
        this.initComponents();
        this.setBackground(UIManager.getColor("MenuItem.selectionBackground"));
        this.setForeground(UIManager.getColor("MenuItem.selectionForeground"));
        if (property != null) {
            this.propertyIconLabel.setIcon(property.getImage());
            this.propertyTitle.setText(property != null ? property.getDisplayTitle() : "multiple selection");
        } else {
            this.actionsMenuLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
            this.propertyIconLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
            this.propertyTitle.setVisible(false);
            this.jSeparator.setVisible(false);
        }
        String label = NbBundle.getMessage(TitleActionPanel.class, (String)"TitleActionPanel.propertyDescription.label");
        String string = desc = property != null ? property.getDisplayDescription(80) : null;
        if (desc == null || desc.isEmpty()) {
            this.propertyShortDescription.setVisible(false);
            this.propertyShortDescription.setText(" ");
        } else {
            this.propertyShortDescription.setVisible(true);
            this.propertyShortDescription.setText("<html><body width=\"400\"><center>" + label + ": " + desc + "</center></html>");
        }
        if (property != null) {
            desc = property.getDisplayValue();
            if (property instanceof Entity) {
                desc = ((Entity)property).toString(true);
            }
            if (desc == null || desc.isEmpty()) {
                this.setToolTipText(null);
            } else {
                String width = "";
                if (desc.length() > 80) {
                    width = "<body width=550>";
                }
                this.setToolTipText("<html>" + width + desc.replaceAll("\\n", "<br/>") + "</body></html>");
            }
        }
    }

    private void initComponents() {
        this.actionsMenuLabel = new JLabel();
        this.propertyIconLabel = new JLabel();
        this.jSeparator = new JSeparator();
        this.propertyTitle = new JLabel();
        this.propertyShortDescription = new JLabel();
        this.actionsMenuLabel.setFont(new Font("DejaVu Sans", 1, 12));
        this.actionsMenuLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/core/resources/images/Menu.png")));
        Mnemonics.setLocalizedText((JLabel)this.actionsMenuLabel, (String)this.actionsMenutext);
        this.actionsMenuLabel.setIconTextGap(8);
        this.propertyIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/core/resources/images/Gedcom.png")));
        Mnemonics.setLocalizedText((JLabel)this.propertyIconLabel, (String)NbBundle.getMessage(TitleActionPanel.class, (String)"TitleActionPanel.propertyIconLabel.text"));
        this.propertyTitle.setFont(new Font("DejaVu Sans", 1, 12));
        this.propertyTitle.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.propertyTitle, (String)NbBundle.getMessage(TitleActionPanel.class, (String)"TitleActionPanel.propertyTitle.text"));
        this.propertyTitle.setVerticalAlignment(1);
        this.propertyShortDescription.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.propertyShortDescription, (String)NbBundle.getMessage(TitleActionPanel.class, (String)"TitleActionPanel.propertyShortDescription.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator).addGroup(layout.createSequentialGroup().addComponent(this.actionsMenuLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.propertyIconLabel)).addComponent(this.propertyTitle, -1, -1, Short.MAX_VALUE).addComponent(this.propertyShortDescription, -1, -1, Short.MAX_VALUE)).addGap(12, 12, 12)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.propertyIconLabel).addComponent(this.actionsMenuLabel)).addGap(2, 2, 2).addComponent(this.jSeparator, -2, 7, -2).addGap(0, 0, 0).addComponent(this.propertyTitle).addGap(2, 2, 2).addComponent(this.propertyShortDescription).addContainerGap()));
    }
}

