/*
 * Decompiled with CFR 0.152.
 */
package ancestris.gedcom;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.core.pluginservice.PluginInterface;
import ancestris.core.resources.Images;
import ancestris.gedcom.GedcomDataObject;
import ancestris.gedcom.GedcomFileListener;
import ancestris.gedcom.RecentFiles;
import ancestris.gedcom.SaveOptionsWidget;
import ancestris.util.ProgressListener;
import ancestris.util.TimingUtility;
import ancestris.util.swing.DialogManager;
import ancestris.view.AncestrisViewInterface;
import genj.common.ContextListWidget;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.UnitOfWork;
import genj.io.BackupFile;
import genj.io.Filter;
import genj.io.GedcomEncodingException;
import genj.io.GedcomIOException;
import genj.io.GedcomReader;
import genj.io.GedcomReaderContext;
import genj.io.GedcomReaderFactory;
import genj.io.GedcomWriter;
import genj.io.IGedcomWriter;
import genj.util.Origin;
import genj.util.Registry;
import genj.util.Resources;
import genj.view.ViewContext;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.apache.commons.io.FileUtils;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import spin.Spin;

public abstract class GedcomMgr {
    static final Logger LOG = Logger.getLogger("ancestris.app");
    static final Resources RES = Resources.get(GedcomMgr.class);
    static final Registry REGISTRY = Registry.get(GedcomMgr.class);
    private static boolean quiet = false;
    private boolean copyMediaInError = false;
    private static GedcomMgr defaultInstance;

    public abstract boolean saveGedcomImpl(Gedcom var1, Collection<Filter> var2, FileObject var3);

    public abstract Context openGedcom(FileObject var1);

    public abstract Context setGedcom(Gedcom var1);

    public abstract void setQuiet(boolean var1);

    public abstract boolean isQuiet();

    protected void commitRequested(Context context) {
        for (GedcomFileListener listener : AncestrisPlugin.lookupAll(GedcomFileListener.class)) {
            listener.commitRequested(context);
        }
    }

    protected void gedcomOpened(Gedcom gedcom) {
        for (GedcomFileListener listener : AncestrisPlugin.lookupAll(GedcomFileListener.class)) {
            listener.gedcomOpened(gedcom);
        }
    }

    protected void gedcomClosed(Gedcom gedcom) {
        for (GedcomFileListener listener : AncestrisPlugin.lookupAll(GedcomFileListener.class)) {
            listener.gedcomClosed(gedcom);
        }
    }

    public boolean saveGedcom(Context context, FileObject output) {
        this.commitRequested(context);
        Gedcom gedcom = context.getGedcom();
        if (!this.saveGedcomImpl(gedcom, null, null)) {
            return false;
        }
        if (gedcom.hasChanged()) {
            gedcom.doMuteUnitOfWork(new UnitOfWork(){

                @Override
                public void perform(Gedcom gedcom) throws GedcomException {
                    gedcom.setUnchanged();
                }
            });
        }
        return true;
    }

    public Origin saveGedcomAs(Context context, SaveOptionsWidget options, FileObject output) {
        Origin newOrigin;
        Gedcom gedcom = context.getGedcom();
        if (options == null) {
            options = new SaveOptionsWidget(gedcom);
        }
        String prevPassword = gedcom.getPassword();
        String prevEncoding = gedcom.getEncoding();
        Origin prevOrigin = gedcom.getOrigin();
        if (options.isIsGedcom()) {
            gedcom.setPassword(options.getPassword());
            gedcom.setEncoding(options.getEncoding());
        }
        try {
            newOrigin = Origin.create(output.toURL());
            gedcom.setOrigin(newOrigin);
        }
        catch (Throwable t) {
            LOG.log(Level.FINER, "Failed to create origin for file " + output, t);
            gedcom.setEncoding(prevEncoding);
            gedcom.setPassword(prevPassword);
            gedcom.setOrigin(prevOrigin);
            return null;
        }
        if (options.isIsGedcom() && options.areMediaToBeCopied()) {
            int undoNb = gedcom.getUndoNb();
            final Origin prevOriginUoW = prevOrigin;
            final Origin newOriginUoW = newOrigin;
            this.copyMediaInError = false;
            final Filter.Union filter = new Filter.Union(gedcom, options.getFilters());
            try {
                gedcom.doUnitOfWork(new UnitOfWork(){

                    @Override
                    public void perform(Gedcom gedcom) throws GedcomException {
                        GedcomMgr.this.copyMedia(gedcom, prevOriginUoW, newOriginUoW, filter);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.copyMediaInError) {
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
                gedcom.setEncoding(prevEncoding);
                gedcom.setPassword(prevPassword);
                gedcom.setOrigin(prevOrigin);
                return null;
            }
        }
        if (!this.saveGedcomImpl(gedcom, options.getFilters(), null)) {
            gedcom.setEncoding(prevEncoding);
            gedcom.setPassword(prevPassword);
            gedcom.setOrigin(prevOrigin);
            return null;
        }
        if (gedcom.hasChanged()) {
            gedcom.doMuteUnitOfWork(new UnitOfWork(){

                @Override
                public void perform(Gedcom gedcom) throws GedcomException {
                    gedcom.setUnchanged();
                }
            });
        }
        return gedcom.getOrigin();
    }

    public boolean gedcomClose(Context context) {
        this.gedcomClosed(context.getGedcom());
        context.getGedcom().getRegistry().put("context", context.toString());
        for (AncestrisViewInterface gjvTc : AncestrisPlugin.lookupAll(AncestrisViewInterface.class)) {
            if (!context.getGedcom().equals(gjvTc.getGedcom())) continue;
            gjvTc.close();
        }
        context.getGedcom().eraseAll();
        return true;
    }

    public static GedcomMgr getDefault() {
        GedcomMgr gdInstance = (GedcomMgr)Lookup.getDefault().lookup(GedcomMgr.class);
        return gdInstance != null ? gdInstance : GedcomMgr.getDefaultInstance();
    }

    private static synchronized GedcomMgr getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new DefaultGedcomMgrImpl();
        }
        return defaultInstance;
    }

    private boolean copyMedia(Gedcom gedcom, Origin prevOrigin, Origin newOrigin, Filter filter) {
        List<? extends Property> files = gedcom.getPropertiesByClass(PropertyFile.class);
        String prevDir = null;
        String newDir = null;
        try {
            prevDir = prevOrigin.getFile().getParentFile().getCanonicalPath();
            newDir = newOrigin.getFile().getParentFile().getCanonicalPath();
            for (PropertyFile propertyFile : files) {
                File prevMediafile;
                if (filter.veto(propertyFile.getEntity()) || filter.veto(propertyFile)) continue;
                String relPath = propertyFile.getValue();
                Path p = Paths.get(relPath, new String[0]).normalize();
                if (p.isAbsolute()) {
                    relPath = p.subpath(0, p.getNameCount() - 1).toString() + File.separator + p.getFileName();
                    prevMediafile = propertyFile.getFile();
                    propertyFile.setValue(relPath);
                } else {
                    prevMediafile = new File(prevDir + File.separator + relPath);
                }
                File newMediafile = new File(newDir + File.separator + relPath);
                if (prevMediafile.exists()) {
                    FileUtils.copyFile((File)prevMediafile, (File)newMediafile, (boolean)true);
                    continue;
                }
                String fileErr = prevMediafile.getCanonicalPath();
                String msg = RES.getString("save.options.files.medianotfound", fileErr, propertyFile.getEntity());
                LOG.log(Level.FINER, "Failed to copy media : " + fileErr);
                if (DialogManager.YES_OPTION == DialogManager.createYesNo(RES.getString("save.options.files"), msg).setMessageType(2).show()) continue;
                this.copyMediaInError = true;
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private static class DefaultGedcomMgrImpl
    extends GedcomMgr {
        private DefaultGedcomMgrImpl() {
        }

        @Override
        public void setQuiet(boolean set) {
            quiet = set;
        }

        @Override
        public boolean isQuiet() {
            return quiet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Context openGedcom(final FileObject input) {
            Context context;
            GedcomReader reader;
            if (input == null) {
                return null;
            }
            Origin origin = Origin.create(input);
            final ArrayList warnings = new ArrayList();
            final ArrayList bag = new ArrayList();
            try {
                reader = (GedcomReader)Spin.off((Object)GedcomReaderFactory.createReader(origin, (GedcomReaderContext)Spin.over((Object)new GedcomReaderContext(){

                    @Override
                    public String getPassword() {
                        return DialogManager.create(FileUtil.getFileDisplayName((FileObject)input), RES.getString("cc.provide_password"), "").show();
                    }

                    @Override
                    public void handleWarning(int line, String warning, Context context) {
                        if (line == 0 && bag.isEmpty()) {
                            bag.add("header");
                        }
                        warnings.add(new ViewContext(RES.getString("cc.open.warning", line, warning), context));
                    }
                })));
            }
            catch (IOException ex) {
                String txt = RES.getString("cc.open.no_connect_to", input) + "\n[" + ex.getMessage() + "]";
                DialogManager.createError(FileUtil.getFileDisplayName((FileObject)input), txt).show();
                return null;
            }
            try {
                ProgressListener.Dispatcher.processStarted(reader);
                Gedcom gedcom = reader.read();
                if (gedcom == null) {
                    Context context2 = null;
                    return context2;
                }
                context = this.setGedcom(gedcom);
                if (!warnings.isEmpty() && !quiet) {
                    Object[] objectArray;
                    JButton updatePropertiesButton = new JButton(RES.getString("cc.open.fixWarnings"));
                    updatePropertiesButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            List list = (List)Lookup.getDefault().lookupAll(PluginInterface.class);
                            for (PluginInterface pi : list) {
                                if (!pi.getPluginName().equals("modules.editors.gedcomproperties")) continue;
                                pi.launchModule((Object)context);
                            }
                        }
                    });
                    boolean hasHeaderWarnings = !bag.isEmpty();
                    JScrollPane panel = new JScrollPane(new ContextListWidget(warnings));
                    JLabel label = new JLabel(RES.getString("cc.open.warnings.tooltip"));
                    label.setIcon(Images.imgWng);
                    DialogManager dialogManager = DialogManager.create(RES.getString("cc.open.warnings", context.getGedcom().getName()), new JComponent[]{panel, label}, false).setDialogId("cc.open.warnings");
                    if (hasHeaderWarnings) {
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = updatePropertiesButton;
                        objectArray = objectArray2;
                        objectArray2[1] = NotifyDescriptor.CLOSED_OPTION;
                    } else {
                        Object[] objectArray3 = new Object[1];
                        objectArray = objectArray3;
                        objectArray3[0] = NotifyDescriptor.CLOSED_OPTION;
                    }
                    dialogManager.setOptions(objectArray).show();
                }
            }
            catch (GedcomIOException ex) {
                DialogManager.createError(FileUtil.getFileDisplayName((FileObject)input), ex.getMessage() + "\n(" + RES.getString("cc.open.read_error", "" + ex.getLine()) + ")\n").show();
                try {
                    DataObject dao = DataObject.find((FileObject)input);
                    GedcomDataObject gdao = (GedcomDataObject)dao.getLookup().lookup(GedcomDataObject.class);
                    if (gdao != null) {
                        gdao.setCancelled(true);
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
                Context context3 = null;
                return context3;
            }
            finally {
                ProgressListener.Dispatcher.processStopped(reader);
            }
            RecentFiles.getDefault().add(input);
            return context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Context setGedcom(Gedcom gedcom) {
            Context context;
            block5: {
                LOG.log(Level.FINE, "{0}: setGedcom", TimingUtility.getInstance().getTime());
                context = new Context();
                try {
                    Registry gedcomRegistry = gedcom.getRegistry();
                    context = Context.fromString(gedcom, gedcomRegistry.get("context", gedcom.getName()));
                    Entity adam = gedcom.getFirstEntity("INDI");
                    if (!context.getEntities().isEmpty()) break block5;
                    context = new Context(gedcom, adam != null ? Collections.singletonList(adam) : null, null);
                }
                catch (GedcomException adam) {
                    Entity adam2 = gedcom.getFirstEntity("INDI");
                    if (context.getEntities().isEmpty()) {
                        context = new Context(gedcom, adam2 != null ? Collections.singletonList(adam2) : null, null);
                    }
                }
                catch (Throwable throwable) {
                    Entity adam = gedcom.getFirstEntity("INDI");
                    if (context.getEntities().isEmpty()) {
                        context = new Context(gedcom, adam != null ? Collections.singletonList(adam) : null, null);
                    }
                    throw throwable;
                }
            }
            LOG.log(Level.FINE, "{0}: gedcomOpened", TimingUtility.getInstance().getTime());
            this.gedcomOpened(gedcom);
            LOG.log(Level.FINE, "{0}: fireSelection", TimingUtility.getInstance().getTime());
            return context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean saveGedcomImpl(Gedcom gedcom, Collection<Filter> filters, FileObject outFile) {
            try {
                IGedcomWriter writer;
                File file = null;
                File temp = null;
                try {
                    file = gedcom.getOrigin().getFile().getCanonicalFile();
                    temp = File.createTempFile("ancestris", ".ged", file.getParentFile());
                    writer = (IGedcomWriter)Spin.off((Object)new GedcomWriter(gedcom, new FileOutputStream(temp)));
                }
                catch (GedcomEncodingException gee) {
                    DialogManager.createError(gedcom.getName(), RES.getString("cc.save.write_encoding_error", gee.getMessage())).show();
                    LOG.log(Level.SEVERE, "Cannot encode gedcom " + gedcom.getName() + ". Error is : " + gee.getLocalizedMessage());
                    return false;
                }
                catch (IOException ex) {
                    if (file == null) {
                        DialogManager.createError(gedcom.getName(), RES.getString("cc.save.write_error", gedcom.getOrigin().getFile().getAbsolutePath(), ex.getLocalizedMessage())).show();
                        LOG.log(Level.SEVERE, "Cannot get cannonical file for gedcom " + gedcom.getName() + ". Error is : " + ex.getLocalizedMessage());
                    }
                    if (temp == null) {
                        DialogManager.createError(gedcom.getName(), RES.getString("cc.save.write_error", file.getParentFile().getAbsolutePath(), ex.getLocalizedMessage())).show();
                        LOG.log(Level.SEVERE, "Cannot create gedcom file " + gedcom.getName() + " in directory " + file.getParentFile().getAbsolutePath() + ". Error is : " + ex.getLocalizedMessage());
                    }
                    return false;
                }
                if (filters != null) {
                    writer.setFilters(filters);
                }
                try {
                    ProgressListener.Dispatcher.processStarted(writer);
                    writer.write();
                }
                finally {
                    ProgressListener.Dispatcher.processStopped(writer);
                }
                if (BackupFile.createBackup(file)) {
                    file.delete();
                    if (!temp.renameTo(file)) {
                        throw new GedcomIOException("Couldn't move temporary " + temp.getName() + " to " + file.getName(), -1);
                    }
                }
            }
            catch (GedcomEncodingException gee) {
                DialogManager.createError(gedcom.getName(), RES.getString("cc.save.write_error", gee.getMessage())).show();
                LOG.log(Level.SEVERE, "Cannot encode gedcom " + gedcom.getName() + ". Error is : " + gee.getLocalizedMessage());
                return false;
            }
            catch (GedcomIOException gioex) {
                DialogManager.createError(gedcom.getName(), RES.getString("cc.save.write_error", "" + gioex.getLine()) + ":\n" + gioex.getMessage()).show();
                return false;
            }
            return true;
        }
    }
}

