/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import ancestris.util.swing.DialogManager;
import genj.gedcom.GedcomException;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyXRef;
import genj.io.GedcomFormatException;
import genj.util.Resources;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;

public class PropertyReader {
    protected static final Resources RESOURCES = Resources.get(PropertyReader.class);
    protected boolean useIndents = false;
    protected int lines = 0;
    protected String line = null;
    protected String nextLine = null;
    protected boolean cont = true;
    protected Collection<PropertyXRef> collectXRefs;
    protected boolean isMerge = false;
    protected int level;
    protected String tag;
    protected String xref;
    protected String value;
    protected String bit = "";
    protected BufferedReader in;

    public PropertyReader(Reader in, Collection collectXRefs, boolean useIndents) {
        this(new BufferedReader(in), (Collection<PropertyXRef>)collectXRefs, useIndents);
    }

    public PropertyReader(BufferedReader in, Collection<PropertyXRef> collectXRefs, boolean useIndents) {
        this.in = in;
        this.useIndents = useIndents;
        this.collectXRefs = collectXRefs;
    }

    public int getLines() {
        return this.lines;
    }

    public void read(Property prop) throws IOException {
        this.read(prop, -1);
    }

    public void read(Property prop, int index) throws IOException {
        this.readProperties(prop, 0, index);
        if (this.line != null) {
            this.line = null;
            this.in.reset();
        }
    }

    public void setMerge(boolean set) {
        this.isMerge = set;
    }

    protected void readProperties(Property prop, int currentLevel, int pos) throws IOException {
        if (prop instanceof MultiLineProperty) {
            MultiLineProperty.Collector collector = ((MultiLineProperty)((Object)prop)).getLineCollector();
            while (this.readLine(false, true) && this.level >= currentLevel + 1 && collector.append(this.level - currentLevel, this.tag, this.value)) {
                this.line = null;
            }
            prop.setValue(collector.getValue().replaceAll("@@", "@"));
        }
        while (this.readLine(false, true)) {
            if (this.level < currentLevel + 1) {
                return;
            }
            this.line = null;
            if (this.level > currentLevel + 1) {
                this.trackBadLevel(this.level, prop);
                for (int i = currentLevel; i < this.level - 1; ++i) {
                    prop = prop.addProperty("_TAG", "");
                }
            }
            int lineNoForChild = this.lines;
            String prevValue = this.value;
            String prevTag = this.tag;
            Property child = prevTag.equalsIgnoreCase("NAME") ? this.addProperty(prop, this.tag, "", pos) : this.addProperty(prop, this.tag, this.value, pos);
            this.readProperties(child, this.level, 0);
            if (prevTag.equalsIgnoreCase("NAME")) {
                child.setValue(prevValue);
            }
            if (child instanceof PropertyXRef) {
                this.link((PropertyXRef)child, lineNoForChild);
            }
            if (pos < 0) continue;
            ++pos;
        }
        return;
    }

    protected Property addProperty(Property prop, String tag, String value, int pos) {
        Property child;
        if (this.isMerge && (child = prop.getProperty(tag, false)) != null && prop.getMetaProperty().getNested(tag, false).isSingleton() && !(child instanceof PropertyXRef)) {
            child.setValue(value);
            return child;
        }
        try {
            if (prop instanceof PropertyName) {
                Property p = prop.addProperty(tag, value, pos);
                p.setValue(value);
                return p;
            }
            return prop.addProperty(tag, value, pos);
        }
        catch (GedcomException e) {
            Property fallback = prop.addSimpleProperty(tag, value, pos);
            this.trackBadProperty(fallback, e.getMessage());
            return fallback;
        }
    }

    protected boolean readLine(boolean consume, boolean stopIfException) throws IOException {
        if (this.line == null) {
            this.in.mark(256);
            while (this.line == null) {
                this.line = this.in.readLine();
                if (this.line == null) {
                    return false;
                }
                ++this.lines;
                if (this.line.trim().length() != 0) continue;
                this.trackEmptyLine();
                this.line = null;
            }
            if (!this.useIndents) {
                this.in.mark(4096);
                this.cont = true;
                while (this.cont) {
                    this.nextLine = this.in.readLine();
                    if (this.nextLine != null) {
                        this.nextLine = this.nextLine.trim();
                        if (this.nextLine.trim().isEmpty()) continue;
                        int i = this.nextLine.indexOf(32);
                        this.bit = i != -1 ? this.nextLine.substring(0, i) : "";
                        if (this.bit.length() == 1 && this.bit.matches("[0-9]")) {
                            try {
                                this.in.reset();
                            }
                            catch (Exception e) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DialogManager.create("Error reading file", "Line is not Gedcom compatible and is way too long (exceeds 4000 characters). Rewrite manually.\nLine starts with '" + PropertyReader.this.nextLine.substring(0, 60) + "'.").setOptionType(10).setMessageType(0).show();
                                    }
                                });
                                System.err.println("******");
                                System.err.println("Line is not Gedcom compatible and is way too long (exceeds 4000 characters). Rewrite manually.\n");
                                System.err.println("Error exceeding marker while reading line = " + this.nextLine + "\n");
                                System.err.println("******");
                                return false;
                            }
                            this.cont = false;
                            continue;
                        }
                        this.in.mark(4096);
                        this.line = this.line.trim() + " " + this.nextLine;
                        continue;
                    }
                    this.cont = false;
                }
            }
            StringTokenizer tokens = new StringTokenizer(this.line, " \t");
            try {
                try {
                    if (this.useIndents) {
                        this.level = 0;
                        while (this.line.charAt(this.level) == ' ') {
                            ++this.level;
                        }
                        ++this.level;
                    } else {
                        this.level = Integer.parseInt(tokens.nextToken(), 10);
                    }
                }
                catch (StringIndexOutOfBoundsException sioobe) {
                    if (stopIfException) {
                        throw new GedcomFormatException(RESOURCES.getString("read.error.emptyline"), this.lines);
                    }
                    return false;
                }
                catch (NumberFormatException nfe) {
                    if (stopIfException) {
                        throw new GedcomFormatException(RESOURCES.getString("read.error.nonumber") + "\n" + this.line, this.lines);
                    }
                    return false;
                }
                this.tag = tokens.hasMoreTokens() ? tokens.nextToken() : "_TAG";
                if (this.level == 0 && this.tag.startsWith("@")) {
                    if (!this.tag.endsWith("@") || this.tag.length() <= 2) {
                        throw new GedcomFormatException(RESOURCES.getString("read.error.invalidid"), this.lines);
                    }
                    this.xref = this.tag.substring(1, this.tag.length() - 1);
                    this.tag = tokens.nextToken();
                } else {
                    this.xref = "";
                }
                if (tokens.hasMoreElements()) {
                    this.value = tokens.nextToken("\n");
                    if (this.value.startsWith(" ")) {
                        this.value = this.value.substring(1);
                    }
                } else {
                    this.value = "";
                }
            }
            catch (NoSuchElementException ex) {
                throw new GedcomFormatException(RESOURCES.getString("read.error.cantparse"), this.lines);
            }
            this.tag = this.tag.intern();
        }
        if (consume) {
            this.line = null;
        }
        return true;
    }

    protected void link(PropertyXRef xref, int line) {
        if (this.collectXRefs != null) {
            this.collectXRefs.add(xref);
        } else {
            try {
                xref.link();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void trackEmptyLine() {
    }

    protected void trackBadLevel(int level, Property parent) {
    }

    protected void trackBadProperty(Property property, String message) {
    }
}

