/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

public class DirectAccessTokenizer {
    private String string;
    private String separator;
    private String[] valeur;
    private boolean skipEmpty;

    public DirectAccessTokenizer(String string, String separator) {
        this(string, separator, false);
    }

    public DirectAccessTokenizer(String string, String separator, boolean skipEmpty) {
        this.skipEmpty = skipEmpty;
        this.string = string;
        this.separator = separator;
        this.valeur = this.string.split(separator, -1);
    }

    public String[] getTokens() {
        return this.getTokens(false);
    }

    public String[] getTokens(boolean trim) {
        String[] valTrim = (String[])this.valeur.clone();
        if (trim) {
            for (int i = 0; i < valTrim.length; ++i) {
                valTrim[i] = valTrim[i].trim();
            }
        }
        return valTrim;
    }

    public int count() {
        return this.valeur.length;
    }

    public int contains(String search) {
        if (search == null || !this.string.contains(search)) {
            return -1;
        }
        for (int i = 0; i < this.valeur.length; ++i) {
            if (!search.equals(this.valeur[i].trim())) continue;
            return i;
        }
        return -1;
    }

    public String getSubstringFrom(int pos) {
        return this.getSubstring(pos, this.valeur.length);
    }

    public String getSubstring(int from, int until) {
        StringBuilder sb = new StringBuilder(this.string.length());
        for (int i = from; i < until; ++i) {
            sb.append(this.valeur[i]);
            if (i >= until - 1) continue;
            sb.append(this.separator);
        }
        return sb.toString();
    }

    public String get(int pos) {
        return this.get(pos, false);
    }

    public String get(int pos, boolean trim) {
        if (pos < 0 || pos >= this.valeur.length) {
            return null;
        }
        String result = this.valeur[pos];
        int indice = pos;
        if (this.skipEmpty) {
            ++indice;
            while ("".equals(result.trim()) && indice < this.valeur.length) {
                result = this.valeur[indice];
            }
        }
        return trim ? result.trim() : result;
    }

    public String toString() {
        return this.string.replaceAll(this.separator, ", ");
    }
}

