/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import genj.util.Resources;
import genj.util.swing.ImageIcon;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

public class LiturgicalYear {
    private static final Resources RES = Resources.get(LiturgicalYear.class);
    public static final ImageIcon IMAGE = new ImageIcon(LiturgicalYear.class, "LiturgicalYear.png");
    public static final String TXT_LITURGICAL_YEAR = RES.getString("liturgicalyear");
    public static final String TXT_SUNDAY = RES.getString("liturgicalyear.sunday");

    public static void main(String[] args) {
        int year = 2009;
        for (Sunday sunday : Sunday.values()) {
            int i = sunday.getWeeks() > 0 ? 1 : 0;
            do {
                Calendar date = sunday.getDate(year, i);
                if (i > 0) {
                    System.out.format("Julian Day for %d %s: %tD\n", i, sunday.getName(), date);
                    continue;
                }
                System.out.format("Julian Day for %s: %tD\n", sunday.getName(), date);
            } while (++i <= sunday.getWeeks());
        }
        for (int i = 1982; i <= 2022; ++i) {
            Calendar easterDate = Sunday.getEaster(i);
            System.out.format("Easter Sunday in %d: %tD\n", i, easterDate);
        }
    }

    public static enum Sunday {
        PostEpiphanias(Integer.MAX_VALUE, 5, new String[]{"post Ephiphanias"}){

            @Override
            protected Calendar getDateImpl(int year, int postEventWeeks) {
                int K = (year - 1) / 100;
                int S = 2 - (3 * K + 3) / 4;
                int SZ = 7 - (year - 1 + (year - 1) / 4 + S) % 7;
                int dayOfYear = 7 + (7 - (313 - SZ) % 7) % 7 + (postEventWeeks - 1) * 7;
                Calendar result = Calendar.getInstance();
                result.set(1, year);
                result.set(6, dayOfYear);
                return result;
            }
        }
        ,
        Septuagesimae(-9, "Septuagesimae", "Circumdederunt"),
        Sexagesimae(-8, "Sexagesimae", "Exsurge"),
        Quinquagesimae(-7, "Qinquagesimae", "Estomihi"),
        Quadragesimae(-6, "Quadragesimae", "Invocavit"),
        Reminiscere(-5, "Reminiscere"),
        Oculi(-4, "Oculi"),
        Letare(-3, "Letare", "Laetare"),
        Judica(-2, "Judica"),
        Palmarum(-1, "Palmarum"),
        Paschale(0, "Paschale"),
        Quasimodogeniti(1, "Quasimodogeniti"),
        MisericordiasDomini(2, "Misericordias Domini"),
        Jubilate(3, "Jubilate"),
        Cantate(4, "Cantate"),
        Rogate(5, "Rogate"),
        Exaudi(6, "Exaudi"),
        Pentecost(7, "Pentecost"),
        Trinitatis(8, "Trinitatis"),
        PostTrinitatis(8, 27, "post Trinitatis"),
        Adventis(Integer.MAX_VALUE, 4, new String[]{"Adventis"}){

            @Override
            protected Calendar getDateImpl(int year, int week) {
                int K = year / 100;
                int S = 2 - (3 * K + 3) / 4;
                int SZ = 7 - (year + year / 4 + S) % 7;
                int dayOfNovember = 27 + (7 - (272 - SZ) % 7) % 7 + (week - 1) * 7;
                Calendar result = Calendar.getInstance();
                result.set(1, year);
                if (dayOfNovember > 30) {
                    result.set(2, 11);
                    result.set(5, dayOfNovember - 30);
                } else {
                    result.set(2, 10);
                    result.set(5, dayOfNovember);
                }
                return result;
            }
        };

        private int easterOffset;
        private int weeks;
        private List<String> names;

        private Sunday(int easterOffset, String ... names) {
            this.easterOffset = easterOffset;
            this.weeks = 0;
            this.names = Collections.unmodifiableList(Arrays.asList(names));
        }

        private Sunday(int easterOffset, int weeks, String ... names) {
            this.easterOffset = easterOffset;
            this.weeks = weeks;
            this.names = Collections.unmodifiableList(Arrays.asList(names));
        }

        public int getWeeks() {
            return this.weeks;
        }

        public String getName() {
            return this.names.get(0);
        }

        public List<String> getNames() {
            return this.names;
        }

        public Calendar getDate(int year, int relativeWeek) {
            if (this.weeks > 0 && relativeWeek <= 0) {
                throw new IllegalArgumentException("bad relative week " + relativeWeek);
            }
            if (relativeWeek > this.weeks) {
                throw new IllegalArgumentException("bad relative week " + relativeWeek);
            }
            return this.getDateImpl(year, relativeWeek);
        }

        protected Calendar getDateImpl(int year, int relativeWeek) {
            Calendar result = Sunday.getEaster(year);
            result.add(6, (this.easterOffset + relativeWeek) * 7);
            return result;
        }

        public static Calendar getEaster(int year) {
            int K = year / 100;
            int M = 15 + (3 * K + 3) / 4 - (8 * K + 13) / 25;
            int S = 2 - (3 * K + 3) / 4;
            int A = year % 19;
            int D = (19 * A + M) % 30;
            int R = D / 29 + (D / 28 - D / 29) * (A / 11);
            int OG = 21 + D - R;
            int SZ = 7 - (year + year / 4 + S) % 7;
            int OE = 7 - (OG - SZ) % 7;
            int OS = OG + OE;
            Calendar result = Calendar.getInstance();
            result.set(1, year);
            if (OS > 31) {
                result.set(2, 3);
                result.set(5, OS - 31);
            } else {
                result.set(2, 2);
                result.set(5, OS);
            }
            return result;
        }
    }
}

