/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReferenceSet<KEY, REF> {
    private Map<KEY, Set<REF>> key2references = new HashMap<KEY, Set<REF>>();
    private int size = 0;

    public Set<REF> getReferences(KEY key) {
        if (key == null) {
            return new HashSet();
        }
        Set<REF> references = this.key2references.get(key);
        if (references == null) {
            return new HashSet();
        }
        return references;
    }

    public int getSize() {
        return this.size;
    }

    public int getSize(KEY key) {
        if (key == null) {
            return 0;
        }
        Set<REF> references = this.key2references.get(key);
        if (references == null) {
            return 0;
        }
        return references.size();
    }

    public boolean add(KEY key) {
        return this.add(key, null);
    }

    public boolean add(KEY key, REF reference) {
        if (key == null) {
            return false;
        }
        Set<REF> references = this.key2references.get(key);
        if (references == null) {
            references = new HashSet<REF>();
            this.key2references.put(key, references);
        }
        if (reference == null) {
            return false;
        }
        if (!references.add(reference)) {
            return false;
        }
        ++this.size;
        return true;
    }

    public boolean remove(KEY key, REF reference) {
        if (key == null) {
            return false;
        }
        Set<REF> references = this.key2references.get(key);
        if (references == null) {
            return false;
        }
        if (!references.remove(reference)) {
            return false;
        }
        --this.size;
        if (references.isEmpty()) {
            this.key2references.remove(key);
        }
        return true;
    }

    public List<KEY> getKeys() {
        return this.getKeys(null);
    }

    public List<KEY> getKeys(Comparator<Object> comparator) {
        ArrayList<KEY> result = new ArrayList<KEY>(this.key2references.keySet());
        if (comparator != null) {
            Collections.sort(result, comparator);
        } else {
            Collections.sort(result, new Comparator<KEY>(){

                @Override
                public int compare(KEY o1, KEY o2) {
                    return ReferenceSet.this.getSize(o1) - ReferenceSet.this.getSize(o2);
                }
            });
        }
        return result;
    }

    public void eraseAll() {
        Iterator<Map.Entry<KEY, Set<REF>>> it = this.key2references.entrySet().iterator();
        while (it.hasNext()) {
            Set<REF> set = it.next().getValue();
            Iterator<REF> it2 = set.iterator();
            while (it2.hasNext()) {
                it2.next();
                it2.remove();
            }
            it.remove();
        }
    }
}

