/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.NbBundle;

public class Resources {
    private static final Logger LOG = Logger.getLogger("ancestris.util");
    private ResourceBundle bundle = null;
    private String description = "";

    public static Resources get(Object packgeMember) {
        return Resources.get(packgeMember, (Locale)null);
    }

    public static Resources get(Object packgeMember, Locale locale) {
        if (packgeMember instanceof ResourcesProvider) {
            return ((ResourcesProvider)packgeMember).getResources(locale);
        }
        Class<?> clazz = packgeMember instanceof Class ? (Class<?>)packgeMember : packgeMember.getClass();
        return Resources.get(clazz, locale);
    }

    public static Resources get(Class<?> clazz) {
        return Resources.get(clazz, null);
    }

    public static Resources get(Class<?> clazz, Locale locale) {
        try {
            ResourceBundle bundle = locale == null ? NbBundle.getBundle(clazz) : NbBundle.getBundle((String)Resources.findName(clazz), (Locale)locale);
            Resources result = new Resources(bundle);
            result.description = "" + clazz;
            return result;
        }
        catch (MissingResourceException e) {
            LOG.log(Level.WARNING, "resources file is no longer supported for class {0}: use Bundles.properties", clazz);
            return new Resources();
        }
    }

    private static String findName(Class clazz) {
        String pref = clazz.getName();
        int last = pref.lastIndexOf(46);
        if (last >= 0) {
            pref = pref.substring(0, last + 1);
            return pref + "Bundle";
        }
        return "Bundle";
    }

    public Resources() {
        this.bundle = null;
        this.description = "";
    }

    private Resources(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public String getString(String key, boolean notNull) {
        String result = null;
        if (this.bundle == null) {
            LOG.log(Level.FINER, "Resource with null bundle({0})", key);
        } else {
            try {
                result = this.bundle.getString(key);
            }
            catch (Exception e) {
                LOG.log(Level.FINER, "key {0} not found in {1} bundle", new Object[]{key, this.description});
            }
        }
        if (result == null && notNull) {
            result = key;
        }
        return result;
    }

    public String getString(String key) {
        return this.getString(key, true);
    }

    public String getString(String key, Object ... substitutes) {
        String formatStr = this.getString(key).replace("''", "'").replace("'", "''");
        return MessageFormat.format(formatStr, substitutes);
    }

    public static interface ResourcesProvider {
        public Resources getResources();

        public Resources getResources(Locale var1);
    }
}

