/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class ScrollPaneWidget
extends JScrollPane {
    private Draggin draggin;

    public ScrollPaneWidget(JComponent view) {
        super(view);
    }

    @Override
    public void setViewportView(Component view) {
        Component old = super.getViewport().getView();
        if (old != null) {
            old.removeMouseListener(this.draggin);
            old.removeMouseMotionListener(this.draggin);
        }
        super.setViewportView(view);
        if (view != null) {
            if (this.draggin == null) {
                this.draggin = new Draggin();
            }
            view.addMouseListener(this.draggin);
            view.addMouseMotionListener(this.draggin);
        }
    }

    public class Draggin
    extends MouseAdapter
    implements MouseMotionListener {
        private Point start = new Point();

        @Override
        public void mousePressed(MouseEvent e) {
            this.start.setLocation(e.getPoint());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ((JComponent)e.getSource()).setCursor(null);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ((JComponent)e.getSource()).setCursor(Cursor.getPredefinedCursor(12));
            Point v = ScrollPaneWidget.this.viewport.getViewPosition();
            int dx = e.getPoint().x - this.start.x;
            int dy = e.getPoint().y - this.start.y;
            v.x = Math.min(Math.max(0, v.x - dx), Math.max(0, ScrollPaneWidget.this.viewport.getView().getWidth() - ScrollPaneWidget.this.viewport.getWidth()));
            v.y = Math.min(Math.max(0, v.y - dy), Math.max(0, ScrollPaneWidget.this.viewport.getView().getHeight() - ScrollPaneWidget.this.viewport.getHeight()));
            ScrollPaneWidget.this.viewport.setViewPosition(v);
        }
    }
}

