/*
 * Decompiled with CFR 0.152.
 */
package genj.view;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.util.swing.DialogManager;
import genj.renderer.RenderSelectionHintKey;
import genj.util.Resources;
import genj.util.swing.ImageIcon;
import genj.view.BigBufferedImage;
import genj.view.ScreenshotPanel;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;

public class ScreenshotAction
extends AbstractAncestrisAction {
    private static final ImageIcon IMG = new ImageIcon(ScreenshotAction.class, "images/Camera.png");
    private static final Resources RES = Resources.get(ScreenshotAction.class);
    private JComponent component;

    public ScreenshotAction(JComponent component) {
        this.setImage(IMG);
        this.setTip(RES.getString("screenshot"));
        this.component = component;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ScreenshotPanel panel = new ScreenshotPanel(this.component);
        Object o = DialogManager.create(this.getTip(), panel).setOptionType(2).show();
        panel.savePreferences();
        if (o != DialogManager.OK_OPTION) {
            return;
        }
        final ImageCreator imageCreator = new ImageCreator(panel);
        ProgressHandle ph = ProgressHandleFactory.createHandle((String)RES.getString("progressTask"), (Cancellable)new Cancellable(){

            public boolean cancel() {
                return imageCreator.finish();
            }
        });
        imageCreator.setProgress(ph);
        ph.start();
        new Thread(imageCreator).start();
    }

    public void clearClipboard() {
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new Transferable(){

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[0];
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return false;
                }

                @Override
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                    throw new UnsupportedFlavorException(flavor);
                }
            }, null);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public class ImageCreator
    implements Runnable {
        private int capX = 0;
        private int capY = 0;
        private int capW = 0;
        private int capH = 0;
        private ScreenshotPanel panel = null;
        private ProgressHandle ph = null;

        public ImageCreator(ScreenshotPanel scp) {
            this.panel = scp;
            this.capX = this.panel.getCaptureX();
            this.capY = this.panel.getCaptureY();
            this.capW = this.panel.getCaptureW();
            this.capH = this.panel.getCaptureH();
        }

        public void setProgress(ProgressHandle ph) {
            this.ph = ph;
        }

        @Override
        public void run() {
            ImageTransferable imageSelection = null;
            BigBufferedImage image = null;
            String msg = "";
            try {
                image = BigBufferedImage.create(new File(System.getProperty("java.io.tmpdir")), this.capW, this.capH, 1);
                Graphics2D g = image.createGraphics();
                g.setRenderingHint(RenderSelectionHintKey.KEY, false);
                g.setClip(0, 0, this.capW, this.capH);
                g.translate(-this.capX, -this.capY);
                ScreenshotAction.this.component.paint(g);
                g.dispose();
                if (this.panel.isClipboard()) {
                    ScreenshotAction.this.clearClipboard();
                    imageSelection = new ImageTransferable(image);
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    toolkit.getSystemClipboard().setContents(imageSelection, null);
                    msg = RES.getString("screenshot.copiedToClipboard");
                } else if (this.panel.isFile()) {
                    File outputfile = new File(this.panel.getFile());
                    ImageIO.write((RenderedImage)image, "png", outputfile);
                    msg = RES.getString("screenshot.copiedToFile", outputfile.getAbsolutePath());
                } else {
                    msg = RES.getString("screenshot.nothingToDo");
                    return;
                }
                this.finish();
                DialogManager.create(ScreenshotAction.this.getTip(), msg).show();
            }
            catch (OutOfMemoryError oom) {
                this.finish();
                long maxSize = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
                long calcSize = this.capW * this.capH * 8 / 1024 / 1024;
                msg = RES.getString("screenshot.oom", calcSize, maxSize, String.valueOf(maxSize));
                Logger.getLogger("ancestris.view").log(Level.WARNING, msg, oom);
                DialogManager.createError(ScreenshotAction.this.getTip(), msg).show();
            }
            catch (IOException ex) {
                this.finish();
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (this.panel.isClipboard()) {
                ScreenshotAction.this.clearClipboard();
            }
            if (imageSelection != null) {
                imageSelection.clear();
            }
            image = null;
            imageSelection = null;
        }

        private boolean finish() {
            this.ph.finish();
            return true;
        }
    }

    private static class ImageTransferable
    implements Transferable {
        private Image image;

        private ImageTransferable(Image image) {
            this.image = image;
        }

        public void clear() {
            this.image = null;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!flavor.equals(DataFlavor.imageFlavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(DataFlavor.imageFlavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }
    }
}

