/*
 * Decompiled with CFR 0.152.
 */
package genj.view;

import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.GedcomOptions;
import genj.renderer.RenderSelectionHintKey;
import genj.util.Registry;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ScreenshotPanel
extends JPanel {
    private Registry registry = Registry.get(this.getClass());
    private ImagePanel imagePanel;
    private Rectangle rVisible = null;
    private Rectangle rWhole = null;
    private double factor = 0.0;
    private JLabel areaLabel;
    private JPanel areaPanel;
    private JPanel borderPanel;
    private ButtonGroup buttonGroupArea;
    private ButtonGroup buttonGroupTarget;
    private JRadioButton clipboardButton;
    private JRadioButton fileButton;
    private JButton fileSearchButton;
    private JTextField fileTextField;
    private JLabel msgLabel;
    private JLabel targetLabel;
    private JRadioButton visibleAreaButton;
    private JRadioButton wholeAreaButton;

    public ScreenshotPanel(JComponent component) {
        this.initComponents();
        int width = Math.max(360, this.registry.get("captureWindowWidth", this.getPreferredSize().width));
        int height = Math.max(370, this.registry.get("captureWindowHeight", this.getPreferredSize().height));
        this.setMinimumSize(new Dimension(360, 370));
        this.setPreferredSize(new Dimension(width, height));
        this.visibleAreaButton.setSelected(this.registry.get("captureView", true));
        this.wholeAreaButton.setSelected(!this.visibleAreaButton.isSelected());
        this.clipboardButton.setSelected(this.registry.get("captureTarget", true));
        this.fileButton.setSelected(!this.clipboardButton.isSelected());
        this.borderPanel.setVisible(!this.visibleAreaButton.isSelected());
        this.fileTextField.setEnabled(!this.clipboardButton.isSelected());
        this.fileSearchButton.setEnabled(!this.clipboardButton.isSelected());
        this.msgLabel.setVisible(!this.visibleAreaButton.isSelected());
        this.rVisible = component.getVisibleRect();
        this.rWhole = new Rectangle(new Point(), component.getSize());
        double maxSize = Runtime.getRuntime().maxMemory() / 8L;
        double capX = this.rWhole.width;
        double capY = this.rWhole.height;
        double calcSize = capX * capY * 8.0;
        this.factor = Math.min(1.0, maxSize / calcSize);
        this.imagePanel.setImage(Runtime.getRuntime().maxMemory() / 8L, this.getImageFromComponent(component, this.factor));
        this.fileTextField.setText(this.registry.get("captureFilename", ""));
    }

    private void initComponents() {
        this.buttonGroupArea = new ButtonGroup();
        this.buttonGroupTarget = new ButtonGroup();
        this.areaLabel = new JLabel();
        this.visibleAreaButton = new JRadioButton();
        this.wholeAreaButton = new JRadioButton();
        this.targetLabel = new JLabel();
        this.clipboardButton = new JRadioButton();
        this.fileButton = new JRadioButton();
        this.fileTextField = new JTextField();
        this.fileSearchButton = new JButton();
        this.borderPanel = new JPanel();
        this.imagePanel = new ImagePanel();
        this.areaPanel = this.imagePanel;
        this.msgLabel = new JLabel();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ScreenshotPanel.this.formComponentResized(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.areaLabel, (String)NbBundle.getMessage(ScreenshotPanel.class, (String)"ScreenshotPanel.areaLabel.text"));
        this.buttonGroupArea.add(this.visibleAreaButton);
        Mnemonics.setLocalizedText((AbstractButton)this.visibleAreaButton, (String)NbBundle.getMessage(ScreenshotPanel.class, (String)"ScreenshotPanel.visibleAreaButton.text"));
        this.visibleAreaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenshotPanel.this.visibleAreaButtonActionPerformed(evt);
            }
        });
        this.buttonGroupArea.add(this.wholeAreaButton);
        Mnemonics.setLocalizedText((AbstractButton)this.wholeAreaButton, (String)NbBundle.getMessage(ScreenshotPanel.class, (String)"ScreenshotPanel.wholeAreaButton.text"));
        this.wholeAreaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenshotPanel.this.wholeAreaButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.targetLabel, (String)NbBundle.getMessage(ScreenshotPanel.class, (String)"ScreenshotPanel.targetLabel.text"));
        this.buttonGroupTarget.add(this.clipboardButton);
        Mnemonics.setLocalizedText((AbstractButton)this.clipboardButton, (String)NbBundle.getMessage(ScreenshotPanel.class, (String)"ScreenshotPanel.clipboardButton.text"));
        this.clipboardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenshotPanel.this.clipboardButtonActionPerformed(evt);
            }
        });
        this.buttonGroupTarget.add(this.fileButton);
        Mnemonics.setLocalizedText((AbstractButton)this.fileButton, (String)NbBundle.getMessage(ScreenshotPanel.class, (String)"ScreenshotPanel.fileButton.text"));
        this.fileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenshotPanel.this.fileButtonActionPerformed(evt);
            }
        });
        this.fileTextField.setText(NbBundle.getMessage(ScreenshotPanel.class, (String)"ScreenshotPanel.fileTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.fileSearchButton, (String)NbBundle.getMessage(ScreenshotPanel.class, (String)"ScreenshotPanel.fileSearchButton.text"));
        this.fileSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScreenshotPanel.this.fileSearchButtonActionPerformed(evt);
            }
        });
        this.borderPanel.setBorder(BorderFactory.createEtchedBorder());
        this.borderPanel.setPreferredSize(new Dimension(260, 188));
        this.areaPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                ScreenshotPanel.this.areaPanelMouseDragged(evt);
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                ScreenshotPanel.this.areaPanelMouseMoved(evt);
            }
        });
        this.areaPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ScreenshotPanel.this.areaPanelMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                ScreenshotPanel.this.areaPanelMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ScreenshotPanel.this.areaPanelMouseReleased(evt);
            }
        });
        GroupLayout areaPanelLayout = new GroupLayout(this.areaPanel);
        this.areaPanel.setLayout(areaPanelLayout);
        areaPanelLayout.setHorizontalGroup(areaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        areaPanelLayout.setVerticalGroup(areaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 186, Short.MAX_VALUE));
        GroupLayout borderPanelLayout = new GroupLayout(this.borderPanel);
        this.borderPanel.setLayout(borderPanelLayout);
        borderPanelLayout.setHorizontalGroup(borderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.areaPanel, -1, -1, Short.MAX_VALUE));
        borderPanelLayout.setVerticalGroup(borderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.areaPanel, -1, -1, Short.MAX_VALUE));
        this.msgLabel.setForeground(new Color(255, 0, 0));
        this.msgLabel.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.msgLabel, (String)NbBundle.getMessage(ScreenshotPanel.class, (String)"ScreenshotPanel.msgLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.fileButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileSearchButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.areaLabel).addComponent(this.visibleAreaButton).addComponent(this.wholeAreaButton).addComponent(this.targetLabel).addComponent(this.clipboardButton)).addGap(0, 26, Short.MAX_VALUE))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.msgLabel, -1, -1, Short.MAX_VALUE).addComponent(this.borderPanel, -1, 253, Short.MAX_VALUE)).addGap(23, 23, 23)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.areaLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.visibleAreaButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.wholeAreaButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.borderPanel, -1, 190, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.msgLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.targetLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clipboardButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileButton).addComponent(this.fileTextField, -2, -1, -2).addComponent(this.fileSearchButton)).addContainerGap()));
    }

    private void fileSearchButtonActionPerformed(ActionEvent evt) {
        this.chooseFile(this.fileTextField);
    }

    private void wholeAreaButtonActionPerformed(ActionEvent evt) {
        this.borderPanel.setVisible(this.wholeAreaButton.isSelected());
        this.msgLabel.setVisible(this.wholeAreaButton.isSelected());
    }

    private void visibleAreaButtonActionPerformed(ActionEvent evt) {
        this.borderPanel.setVisible(this.wholeAreaButton.isSelected());
        this.msgLabel.setVisible(this.wholeAreaButton.isSelected());
    }

    private void clipboardButtonActionPerformed(ActionEvent evt) {
        this.fileTextField.setEnabled(this.fileButton.isSelected());
        this.fileSearchButton.setEnabled(this.fileButton.isSelected());
    }

    private void fileButtonActionPerformed(ActionEvent evt) {
        this.fileTextField.setEnabled(this.fileButton.isSelected());
        this.fileSearchButton.setEnabled(this.fileButton.isSelected());
        this.fileTextField.requestFocusInWindow();
    }

    private void areaPanelMouseClicked(MouseEvent evt) {
        if (this.imagePanel != null) {
            this.imagePanel.mouseClicked(evt);
        }
    }

    private void areaPanelMouseMoved(MouseEvent evt) {
        if (this.imagePanel != null) {
            this.imagePanel.mouseMoved(evt);
        }
    }

    private void areaPanelMousePressed(MouseEvent evt) {
        if (this.imagePanel != null) {
            this.imagePanel.mousePressed(evt);
        }
    }

    private void areaPanelMouseDragged(MouseEvent evt) {
        if (this.imagePanel != null) {
            this.imagePanel.mouseDragged(evt);
        }
    }

    private void areaPanelMouseReleased(MouseEvent evt) {
        if (this.imagePanel != null) {
            this.imagePanel.mouseReleased(evt);
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        this.registry.put("captureWindowWidth", evt.getComponent().getWidth());
        this.registry.put("captureWindowHeight", evt.getComponent().getHeight());
    }

    private void chooseFile(JTextField jTF) {
        String path = Registry.get(GedcomOptions.class).get("reportDir", System.getProperty("user.home"));
        File outputfile = new File(path + File.separator + "ancestris_capture.png");
        File file = new FileChooserBuilder(ScreenshotPanel.class.getCanonicalName()).setFilesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(this.getClass(), (String)"TITL_CaptureTargetFile")).setApproveText(NbBundle.getMessage(this.getClass(), (String)"OK_Select")).setDefaultExtension(FileChooserBuilder.getImageFilter().getExtensions()[0]).setFileFilter(FileChooserBuilder.getImageFilter()).setAcceptAllFileFilterUsed(false).setFileHiding(true).setParent(this).setSelectedFile(new File(jTF.getText())).setDefaultWorkingDirectory(outputfile.getParentFile()).showSaveDialog();
        if (file != null) {
            jTF.setText(file.getAbsolutePath());
        }
    }

    public int getCaptureX() {
        if (this.visibleAreaButton.isSelected()) {
            return this.rVisible.x;
        }
        return this.imagePanel.getCaptureX();
    }

    public int getCaptureY() {
        if (this.visibleAreaButton.isSelected()) {
            return this.rVisible.y;
        }
        return this.imagePanel.getCaptureY();
    }

    public int getCaptureW() {
        if (this.visibleAreaButton.isSelected()) {
            return this.rVisible.width;
        }
        return Math.max(this.imagePanel.getCaptureW(), 1);
    }

    public int getCaptureH() {
        if (this.visibleAreaButton.isSelected()) {
            return this.rVisible.height;
        }
        return Math.max(this.imagePanel.getCaptureH(), 1);
    }

    public String getFile() {
        return this.fileTextField.getText();
    }

    public void savePreferences() {
        this.registry.put("captureFilename", this.fileTextField.getText());
        this.registry.put("captureView", this.visibleAreaButton.isSelected());
        this.registry.put("captureTarget", this.clipboardButton.isSelected());
    }

    public boolean isClipboard() {
        return this.clipboardButton.isSelected();
    }

    public boolean isFile() {
        String file = this.getFile();
        File f = new File(file);
        return this.fileButton.isSelected() && file != null && !file.isEmpty() && (!f.exists() || f.exists() && f.isFile());
    }

    private BufferedImage getImageFromComponent(JComponent component, double factor) {
        Rectangle r = new Rectangle(new Point(), component.getSize());
        if (r.width == 0 || r.height == 0) {
            return null;
        }
        try {
            BufferedImage image = new BufferedImage((int)((double)r.width * factor), (int)((double)r.height * factor), 1);
            Graphics2D g = image.createGraphics();
            g.setRenderingHint(RenderSelectionHintKey.KEY, false);
            g.setClip(0, 0, r.width, r.height);
            g.scale(factor, factor);
            g.translate(0, 0);
            component.paint(g);
            g.dispose();
            return image;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private class ImagePanel
    extends JPanel {
        private BufferedImage image = null;
        private double maxXY = 0.0;
        private int DIM_RESIZE = 6;
        private double zoomX = 0.0;
        private double zoomY = 0.0;
        private double resX = 0.0;
        private double resY = 0.0;
        private Rectangle capture = null;
        private Point dragOffset = null;
        private boolean isResize = false;
        private boolean init = true;

        private ImagePanel() {
        }

        public void setImage(double maxXY, BufferedImage image) {
            this.maxXY = maxXY;
            this.image = image;
            this.capture = new Rectangle(0, 0, 1, 1);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.image == null) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            g2d.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            g2d.setRenderingHints(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
            this.init = this.zoomX == 0.0;
            this.zoomX = (double)this.getWidth() / (double)this.image.getWidth();
            this.zoomY = (double)this.getHeight() / (double)this.image.getHeight();
            g2d.scale(this.zoomX, this.zoomY);
            g2d.drawImage((Image)this.image, 0, 0, null);
            if (this.init) {
                this.capture = new Rectangle(0, 0, (int)(50.0 / this.zoomX), (int)(30.0 / this.zoomY));
                this.resX = Math.max((double)(3 * this.DIM_RESIZE) / this.zoomX, 1.0);
                this.resY = Math.max((double)(3 * this.DIM_RESIZE) / this.zoomY, 1.0);
                double sizeOfArea = this.resX * this.resY / ScreenshotPanel.this.factor / ScreenshotPanel.this.factor;
                if (sizeOfArea > this.maxXY) {
                    this.resX = Math.max(1.0 / this.zoomX, 1.0);
                    this.resY = Math.max(1.0 / this.zoomY, 1.0);
                }
            }
            g2d.setColor(new Color(20, 104, 0, 64));
            g.drawRect(this.capture.x, this.capture.y, this.capture.width, this.capture.height);
            g2d.setColor(new Color(0, 255, 0, 64));
            g.fillRect(this.capture.x, this.capture.y, this.capture.width, this.capture.height);
            g2d.setColor(new Color(20, 104, 0, 64));
            g.drawLine(this.capture.x + this.capture.width - (int)((double)(2 * this.DIM_RESIZE) / this.zoomX), this.capture.y + this.capture.height - (int)((double)this.DIM_RESIZE / this.zoomY), this.capture.x + this.capture.width - (int)((double)this.DIM_RESIZE / this.zoomX), this.capture.y + this.capture.height - (int)((double)this.DIM_RESIZE / this.zoomY));
            g.drawLine(this.capture.x + this.capture.width - (int)((double)this.DIM_RESIZE / this.zoomX), this.capture.y + this.capture.height - (int)((double)this.DIM_RESIZE / this.zoomY), this.capture.x + this.capture.width - (int)((double)this.DIM_RESIZE / this.zoomX), this.capture.y + this.capture.height - (int)((double)(2 * this.DIM_RESIZE) / this.zoomY));
        }

        private void mouseClicked(MouseEvent e) {
            if (this.image == null) {
                return;
            }
            Point p = e.getPoint();
            p = new Point((int)((double)p.x / this.zoomX), (int)((double)p.y / this.zoomY));
            int x = Math.max(0, p.x - this.capture.width / 2);
            int y = Math.max(0, p.y - this.capture.height / 2);
            if (this.image.getWidth() - x < this.capture.width) {
                x = this.image.getWidth() - this.capture.width;
            }
            if (this.image.getHeight() - y < this.capture.height) {
                y = this.image.getHeight() - this.capture.height;
            }
            this.capture = new Rectangle(x, y, this.capture.width, this.capture.height);
            this.repaint();
        }

        private void mouseMoved(MouseEvent e) {
            Point p = e.getPoint();
            p = new Point((int)((double)p.x / this.zoomX), (int)((double)p.y / this.zoomY));
            int cursor = 0;
            if (this.capture != null && this.capture.contains(p)) {
                cursor = 13;
            }
            if (this.isResize(p)) {
                cursor = 5;
            }
            this.setCursor(Cursor.getPredefinedCursor(cursor));
        }

        private void mousePressed(MouseEvent e) {
            Point p = e.getPoint();
            p = new Point((int)((double)p.x / this.zoomX), (int)((double)p.y / this.zoomY));
            this.isResize = this.isResize(p);
            this.dragOffset = this.capture.contains(p) ? new Point(this.capture.x - p.x, this.capture.y - p.y) : null;
        }

        private void mouseDragged(MouseEvent e) {
            if (this.image == null) {
                return;
            }
            Point p = e.getPoint();
            p = new Point((int)((double)p.x / this.zoomX), (int)((double)p.y / this.zoomY));
            if (this.isResize) {
                double sizeOfArea;
                int w = p.x - this.capture.x;
                int h = p.y - this.capture.y;
                if ((double)(p.x - this.capture.x) < this.resX) {
                    w = (int)this.resX;
                }
                if ((double)(p.y - this.capture.y) < this.resY) {
                    h = (int)this.resY;
                }
                if (p.x >= this.image.getWidth()) {
                    w = this.image.getWidth() - this.capture.x;
                }
                if (p.y >= this.image.getHeight()) {
                    h = this.image.getHeight() - this.capture.y;
                }
                if ((sizeOfArea = (double)(w * h) / ScreenshotPanel.this.factor / ScreenshotPanel.this.factor) < this.maxXY) {
                    this.capture = new Rectangle(this.capture.x, this.capture.y, w, h);
                    this.repaint();
                    ScreenshotPanel.this.msgLabel.setText(" ");
                } else {
                    ScreenshotPanel.this.msgLabel.setText(NbBundle.getMessage(this.getClass(), (String)"MSG_MaxSizeReached"));
                }
                return;
            }
            if (this.dragOffset == null) {
                return;
            }
            int x = Math.max(0, p.x + this.dragOffset.x);
            int y = Math.max(0, p.y + this.dragOffset.y);
            if (this.image.getWidth() - x < this.capture.width) {
                x = this.image.getWidth() - this.capture.width;
            }
            if (this.image.getHeight() - y < this.capture.height) {
                y = this.image.getHeight() - this.capture.height;
            }
            this.capture = new Rectangle(x, y, this.capture.width, this.capture.height);
            this.repaint();
        }

        private void mouseReleased(MouseEvent evt) {
            this.dragOffset = null;
        }

        private boolean isResize(Point p) {
            double resX = (double)this.DIM_RESIZE / this.zoomX;
            double resY = (double)this.DIM_RESIZE / this.zoomY;
            return (double)p.x > (double)(this.capture.x + this.capture.width) - resX && (double)p.y > (double)(this.capture.y + this.capture.height) - resY && (double)p.x < (double)(this.capture.x + this.capture.width) + resX && (double)p.y < (double)(this.capture.y + this.capture.height) + resY;
        }

        private int getCaptureX() {
            return (int)((double)this.capture.x / ScreenshotPanel.this.factor);
        }

        private int getCaptureY() {
            return (int)((double)this.capture.y / ScreenshotPanel.this.factor);
        }

        private int getCaptureW() {
            return (int)((double)this.capture.width / ScreenshotPanel.this.factor);
        }

        private int getCaptureH() {
            return (int)((double)this.capture.height / ScreenshotPanel.this.factor);
        }
    }
}

