/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.treesharing;

import ancestris.modules.treesharing.TreeSharingTopComponent;
import ancestris.modules.treesharing.communication.AncestrisMember;
import ancestris.modules.treesharing.communication.GedcomFam;
import ancestris.modules.treesharing.communication.GedcomIndi;
import ancestris.modules.treesharing.communication.GedcomNumbers;
import ancestris.modules.treesharing.options.TreeSharingOptionsPanel;
import ancestris.modules.treesharing.panels.AncestrisFriend;
import ancestris.modules.treesharing.panels.FriendGedcomEntity;
import ancestris.modules.treesharing.panels.SharedGedcom;
import ancestris.util.swing.DialogManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchSharedTrees
extends Thread {
    private final TreeSharingTopComponent owner;
    private volatile boolean stopRun;

    public SearchSharedTrees(TreeSharingTopComponent tstc) {
        this.owner = tstc;
    }

    @Override
    public void run() {
        this.stopRun = false;
        this.owner.setRotatingIcon(true);
        while (!this.stopRun) {
            this.owner.updateMembersList();
            this.getAllMatchingEntities(this.owner.getSharedGedcoms(), this.owner.getAncestrisMembers());
        }
    }

    public void stopGracefully() {
        this.stopRun = true;
        this.owner.setRotatingIcon(false);
        this.owner.displaySearchedMember("");
        this.owner.updateSearchStats();
    }

    private void getAllMatchingEntities(List<SharedGedcom> sharedGedcoms, List<AncestrisMember> ancestrisMembers) {
        boolean searchedOnce = false;
        AncestrisFriend friend = null;
        boolean profileExchanged = false;
        int matchType = TreeSharingOptionsPanel.getMatchType();
        List copyOfAncestrisMembers = (List)((ArrayList)ancestrisMembers).clone();
        Set<String> myIndiLastnames = this.owner.getCommHandler().getMySharedIndiLastnames(sharedGedcoms);
        Set<String> myFamLastnames = this.owner.getCommHandler().getMySharedFamLastnames(sharedGedcoms);
        for (AncestrisMember member : copyOfAncestrisMembers) {
            Set<GedcomFam> myGedcomFams;
            Set<String> commonFamLastnames;
            Set<String> memberFamLastnames;
            Set<GedcomIndi> myGedcomIndis;
            Set<String> commonIndiLastnames;
            Set<String> memberIndiLastnames;
            if (!member.isAllowed() || member.getMemberName().equals(this.owner.getPreferredPseudo())) continue;
            searchedOnce = true;
            friend = null;
            profileExchanged = false;
            this.owner.displaySearchedMember(member.getMemberName());
            this.owner.getCommHandler().setCommunicationInProgress(false);
            if (!this.owner.getCommHandler().giveSimpleProfile(member)) continue;
            this.owner.getCommHandler().setCommunicationInProgress(true);
            GedcomNumbers gedcomNumbers = this.owner.getCommHandler().getNbOfEntities(member);
            if (gedcomNumbers == null || gedcomNumbers.nbIndis == 0 && gedcomNumbers.nbFams == 0 || (memberIndiLastnames = this.owner.getCommHandler().getSharedIndiLastnamesFromMember(member)) == null || memberIndiLastnames.isEmpty() || (commonIndiLastnames = this.getCommonItems(myIndiLastnames, new HashSet<String>(memberIndiLastnames))) == null || commonIndiLastnames.isEmpty()) continue;
            Set<GedcomIndi> memberGedcomIndis = this.owner.getCommHandler().getGedcomIndisFromMember(member, commonIndiLastnames);
            if (memberGedcomIndis != null && !memberGedcomIndis.isEmpty() && (myGedcomIndis = this.owner.getCommHandler().getMySharedGedcomIndis(sharedGedcoms, commonIndiLastnames)) != null && !myGedcomIndis.isEmpty() && (friend = this.addCommonIndis(sharedGedcoms, myGedcomIndis, memberGedcomIndis, matchType, member)) != null) {
                friend.setTotals(gedcomNumbers.nbIndis, gedcomNumbers.nbFams);
                if (!profileExchanged) {
                    friend.setProfile(this.owner.getCommHandler().getProfileMember(member), this.owner.getMyProfile());
                    this.owner.getCommHandler().thankMember(member);
                    profileExchanged = true;
                }
                friend = null;
            }
            if ((memberFamLastnames = this.owner.getCommHandler().getSharedFamLastnamesFromMember(member)) == null || memberFamLastnames.isEmpty() || (commonFamLastnames = this.getCommonItems(myFamLastnames, new HashSet<String>(memberFamLastnames))) == null || commonFamLastnames.isEmpty()) continue;
            Set<GedcomFam> memberGedcomFams = this.owner.getCommHandler().getGedcomFamsFromMember(member, commonFamLastnames);
            if (memberGedcomFams != null && !memberGedcomFams.isEmpty() && (myGedcomFams = this.owner.getCommHandler().getMySharedGedcomFams(sharedGedcoms, commonFamLastnames)) != null && !myGedcomFams.isEmpty() && (friend = this.addCommonFams(sharedGedcoms, myGedcomFams, memberGedcomFams, matchType, member)) != null) {
                friend.setTotals(gedcomNumbers.nbIndis, gedcomNumbers.nbFams);
                if (!profileExchanged) {
                    friend.setProfile(this.owner.getCommHandler().getProfileMember(member), this.owner.getMyProfile());
                    this.owner.getCommHandler().thankMember(member);
                    profileExchanged = true;
                }
                friend = null;
            }
            this.owner.getCommHandler().clearMember(member);
        }
        this.owner.getCommHandler().setCommunicationInProgress(false);
        this.stopGracefully();
        if (!searchedOnce) {
            DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"TITL_NoOtherAuthorizedUsers"), (String)NbBundle.getMessage(this.getClass(), (String)"MSG_NoOtherAuthorizedUsers")).setMessageType(1).setOptionType(10).show();
        }
    }

    private Set<String> getCommonItems(Set<String> myIndiLastnames, Set<String> memberIndiLastnames) {
        memberIndiLastnames.retainAll(myIndiLastnames);
        return new HashSet<String>(memberIndiLastnames);
    }

    private AncestrisFriend addCommonIndis(List<SharedGedcom> sharedGedcoms, Set<GedcomIndi> myGedcomIndis, Set<GedcomIndi> memberGedcomIndis, int matchType, AncestrisMember member) {
        AncestrisFriend friend = null;
        for (SharedGedcom sharedGedcom : sharedGedcoms) {
            for (GedcomIndi myGedcomIndi : myGedcomIndis) {
                if (!myGedcomIndi.gedcomName.equals(sharedGedcom.getGedcom().getName())) continue;
                for (GedcomIndi memberGedcomIndi : memberGedcomIndis) {
                    int retMatch = this.isSameIndividual(myGedcomIndi, memberGedcomIndi, matchType);
                    if (retMatch == 0) continue;
                    friend = this.owner.createMatch(sharedGedcom, sharedGedcom.getGedcom().getEntity(myGedcomIndi.entityID), new FriendGedcomEntity(member.getMemberName(), memberGedcomIndi), member, retMatch);
                }
            }
        }
        return friend;
    }

    private AncestrisFriend addCommonFams(List<SharedGedcom> sharedGedcoms, Set<GedcomFam> myGedcomFams, Set<GedcomFam> memberGedcomFams, int matchType, AncestrisMember member) {
        AncestrisFriend friend = null;
        for (SharedGedcom sharedGedcom : sharedGedcoms) {
            for (GedcomFam myGedcomFam : myGedcomFams) {
                if (!myGedcomFam.gedcomName.equals(sharedGedcom.getGedcom().getName())) continue;
                for (GedcomFam memberGedcomFam : memberGedcomFams) {
                    int retMatch = this.isSameFamily(myGedcomFam, memberGedcomFam, matchType);
                    if (retMatch == 0) continue;
                    friend = this.owner.createMatch(sharedGedcom, sharedGedcom.getGedcom().getEntity(myGedcomFam.entityID), new FriendGedcomEntity(member.getMemberName(), memberGedcomFam), member, retMatch);
                }
            }
        }
        return friend;
    }

    private int isSameIndividual(GedcomIndi myIndi, GedcomIndi friendIndi, int matchType) {
        String Asx = myIndi.indiSex;
        String Aln = myIndi.indiLastName.toLowerCase().trim();
        String Afn = myIndi.indiFirstName.toLowerCase().trim();
        String Apl1 = myIndi.indiBirthPlace.toLowerCase().trim();
        String Apl2 = myIndi.indiDeathPlace.toLowerCase().trim();
        int Ayr1 = Integer.valueOf(myIndi.indiBirthDate);
        int Ayr2 = Integer.valueOf(myIndi.indiDeathDate);
        String Bsx = friendIndi.indiSex;
        String Bln = friendIndi.indiLastName.toLowerCase().trim();
        String Bfn = friendIndi.indiFirstName.toLowerCase().trim();
        String Bpl1 = friendIndi.indiBirthPlace.toLowerCase().trim();
        String Bpl2 = friendIndi.indiDeathPlace.toLowerCase().trim();
        int Byr1 = Integer.valueOf(friendIndi.indiBirthDate);
        int Byr2 = Integer.valueOf(friendIndi.indiDeathDate);
        if (!(Asx.equals("0") || Bsx.equals("0") || Asx.equals(Bsx))) {
            return 0;
        }
        if (!Aln.isEmpty() && !Afn.isEmpty() && !Apl1.isEmpty() && Ayr1 != 0 && !Apl2.isEmpty() && Ayr2 != 0 && Asx.equals(Bsx) && Aln.equals(Bln) && Afn.equals(Bfn) && Apl1.equals(Bpl1) && Ayr1 == Byr1 && Apl2.equals(Bpl2) && Ayr2 == Byr2) {
            return 1;
        }
        if (matchType >= 2 && Aln.equals(Bln) && (Apl1.length() > 1 || Apl2.length() > 1 || Bpl1.length() > 1 || Bpl2.length() > 1) && (Ayr1 > 0 || Ayr2 > 0) && (Byr1 > 0 || Byr2 > 0) && (Apl1.equals(Bpl1) && !Bpl1.isEmpty() || Apl1.equals(Bpl2) && !Bpl2.isEmpty() || Apl2.equals(Bpl1) && !Bpl1.isEmpty() || Apl2.equals(Bpl2) && !Bpl2.isEmpty())) {
            if (Ayr1 != 0 && Ayr2 == 0) {
                Ayr2 = Ayr1 + 120;
            }
            if (Byr1 != 0 && Byr2 == 0) {
                Byr2 = Byr1 + 120;
            }
            if (Ayr1 == 0 && Ayr2 != 0) {
                Ayr1 = Ayr2 - 120;
            }
            if (Byr1 == 0 && Byr2 != 0) {
                Byr1 = Byr2 - 120;
            }
            if ((Ayr1 <= Byr1 && Byr1 <= Ayr2 || Byr1 <= Ayr1 && Ayr1 <= Byr2) && Afn.equals(Bfn)) {
                return 2;
            }
        }
        if (matchType >= 3 && Aln.equals(Bln) && Afn.equals(Bfn)) {
            return 3;
        }
        return 0;
    }

    private int isSameFamily(GedcomFam myFamily, GedcomFam friendFam, int matchType) {
        String Ahsx = myFamily.husbSex;
        String Ahln = myFamily.husbLastName.toLowerCase();
        String Ahfn = myFamily.husbFirstName.toLowerCase();
        String Apl1 = myFamily.husbBirthPlace.toLowerCase();
        String Apl2 = myFamily.husbDeathPlace.toLowerCase();
        int Ayr1 = Integer.valueOf(myFamily.husbBirthDate);
        int Ayr2 = Integer.valueOf(myFamily.husbDeathDate);
        String Awsx = myFamily.wifeSex;
        String Awln = myFamily.wifeLastName.toLowerCase();
        String Awfn = myFamily.wifeFirstName.toLowerCase();
        String Apl3 = myFamily.wifeBirthPlace.toLowerCase();
        String Apl4 = myFamily.wifeDeathPlace.toLowerCase();
        int Ayr3 = Integer.valueOf(myFamily.wifeBirthDate);
        int Ayr4 = Integer.valueOf(myFamily.wifeDeathDate);
        String Apl5 = myFamily.famMarrPlace.toLowerCase();
        int Ayr5 = Integer.valueOf(myFamily.famMarrDate);
        String Bhsx = friendFam.husbSex;
        String Bhln = friendFam.husbLastName.toLowerCase();
        String Bhfn = friendFam.husbFirstName.toLowerCase();
        String Bpl1 = friendFam.husbBirthPlace.toLowerCase();
        String Bpl2 = friendFam.husbDeathPlace.toLowerCase();
        int Byr1 = Integer.valueOf(friendFam.husbBirthDate);
        int Byr2 = Integer.valueOf(friendFam.husbDeathDate);
        String Bwsx = friendFam.wifeSex;
        String Bwln = friendFam.wifeLastName.toLowerCase();
        String Bwfn = friendFam.wifeFirstName.toLowerCase();
        String Bpl3 = friendFam.wifeBirthPlace.toLowerCase();
        String Bpl4 = friendFam.wifeDeathPlace.toLowerCase();
        int Byr3 = Integer.valueOf(friendFam.wifeBirthDate);
        int Byr4 = Integer.valueOf(friendFam.wifeDeathDate);
        String Bpl5 = friendFam.famMarrPlace.toLowerCase();
        int Byr5 = Integer.valueOf(friendFam.famMarrDate);
        if (!(Ahsx.equals("0") || Bhsx.equals("0") || Ahsx.equals(Bhsx))) {
            return 0;
        }
        if (!(Awsx.equals("0") || Bwsx.equals("0") || Awsx.equals(Bwsx))) {
            return 0;
        }
        if (!Ahln.isEmpty() && !Ahfn.isEmpty() && !Apl1.isEmpty() && Ayr1 != 0 && !Apl2.isEmpty() && Ayr2 != 0 && !Awln.isEmpty() && !Awfn.isEmpty() && !Apl3.isEmpty() && Ayr3 != 0 && !Apl4.isEmpty() && Ayr4 != 0 && Ahln.equals(Bhln) && Ahfn.equals(Bhfn) && Apl1.equals(Bpl1) && Ayr1 == Byr1 && Apl2.equals(Bpl2) && Ayr2 == Byr2 && Awln.equals(Bwln) && Awfn.equals(Bwfn) && Apl3.equals(Bpl3) && Ayr3 == Byr3 && Apl4.equals(Bpl4) && Ayr4 == Byr4 && Apl5.equals(Bpl5) && Ayr5 == Byr5) {
            return 1;
        }
        if (matchType >= 2) {
            int AyrMin = this.getNonZeroMin(Ayr1, Ayr2, Ayr3, Ayr4, Ayr5);
            int AyrMax = this.getNonZeroMax(Ayr1, Ayr2, Ayr3, Ayr4, Ayr5);
            int ByrMin = this.getNonZeroMin(Byr1, Byr2, Byr3, Byr4, Byr5);
            int ByrMax = this.getNonZeroMax(Byr1, Byr2, Byr3, Byr4, Byr5);
            Set<String> Apls = this.getNonZeroPlaces(Apl1, Apl2, Apl3, Apl4, Apl5);
            Set<String> Bpls = this.getNonZeroPlaces(Bpl1, Bpl2, Bpl3, Bpl4, Bpl5);
            if (Ahln.equals(Bhln) && Awln.equals(Bwln) && Apls.size() > 0 && Bpls.size() > 0 && this.isPlaceCommon(Apls, Bpls) && (AyrMin <= ByrMin && ByrMin <= AyrMax || ByrMin <= AyrMin && AyrMin <= ByrMax)) {
                return 2;
            }
        }
        if (matchType >= 3 && Ahln.equals(Bhln) && Ahfn.equals(Bhfn) && Awln.equals(Bwln) && Awfn.equals(Bwfn)) {
            return 3;
        }
        return 0;
    }

    private int getNonZeroMin(int Ayr1, int Ayr2, int Ayr3, int Ayr4, int Ayr5) {
        int ret = Integer.MAX_VALUE;
        if (Ayr1 != 0) {
            ret = Math.min(ret, Ayr1);
        }
        if (Ayr2 != 0) {
            ret = Math.min(ret, Ayr2);
        }
        if (Ayr3 != 0) {
            ret = Math.min(ret, Ayr3);
        }
        if (Ayr4 != 0) {
            ret = Math.min(ret, Ayr4);
        }
        if (Ayr5 != 0) {
            ret = Math.min(ret, Ayr5);
        }
        return ret;
    }

    private int getNonZeroMax(int Ayr1, int Ayr2, int Ayr3, int Ayr4, int Ayr5) {
        int ret = Integer.MIN_VALUE;
        if (Ayr1 != 0) {
            ret = Math.max(ret, Ayr1);
        }
        if (Ayr2 != 0) {
            ret = Math.max(ret, Ayr2);
        }
        if (Ayr3 != 0) {
            ret = Math.max(ret, Ayr3);
        }
        if (Ayr4 != 0) {
            ret = Math.max(ret, Ayr4);
        }
        if (Ayr5 != 0) {
            ret = Math.max(ret, Ayr5);
        }
        return ret;
    }

    private Set<String> getNonZeroPlaces(String Apl1, String Apl2, String Apl3, String Apl4, String Apl5) {
        HashSet<String> ret = new HashSet<String>();
        if (Apl1.length() > 1) {
            ret.add(Apl1);
        }
        if (Apl2.length() > 1) {
            ret.add(Apl1);
        }
        if (Apl3.length() > 1) {
            ret.add(Apl1);
        }
        if (Apl4.length() > 1) {
            ret.add(Apl1);
        }
        if (Apl5.length() > 1) {
            ret.add(Apl1);
        }
        return ret;
    }

    private boolean isPlaceCommon(Set<String> Apls, Set<String> Bpls) {
        for (String Aplace : Apls) {
            if (!Bpls.contains(Aplace)) continue;
            return true;
        }
        return false;
    }
}

