/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.treesharing;

import ancestris.gedcom.GedcomDirectory;
import ancestris.modules.treesharing.SearchSharedTrees;
import ancestris.modules.treesharing.WelcomePanel;
import ancestris.modules.treesharing.communication.AncestrisMember;
import ancestris.modules.treesharing.communication.Comm;
import ancestris.modules.treesharing.communication.MemberProfile;
import ancestris.modules.treesharing.options.TreeSharingOptionsPanel;
import ancestris.modules.treesharing.options.TreeSharingOptionsPanelController;
import ancestris.modules.treesharing.panels.AncestrisFriend;
import ancestris.modules.treesharing.panels.DisplayStatsAction;
import ancestris.modules.treesharing.panels.EntitiesListPanel;
import ancestris.modules.treesharing.panels.FriendGedcomEntity;
import ancestris.modules.treesharing.panels.GedcomFriendMatch;
import ancestris.modules.treesharing.panels.MatchData;
import ancestris.modules.treesharing.panels.MembersPopup;
import ancestris.modules.treesharing.panels.PrivacyToggle;
import ancestris.modules.treesharing.panels.RearrangeAction;
import ancestris.modules.treesharing.panels.ResetResults;
import ancestris.modules.treesharing.panels.SearchAction;
import ancestris.modules.treesharing.panels.SettingsAction;
import ancestris.modules.treesharing.panels.SharedGedcom;
import ancestris.modules.treesharing.panels.StartSharingAllToggle;
import ancestris.modules.treesharing.panels.StatsData;
import ancestris.modules.treesharing.panels.StatsPanel;
import ancestris.modules.treesharing.panels.StopSharingAllToggle;
import ancestris.modules.treesharing.panels.TimerPanel;
import ancestris.modules.treesharing.panels.TreeSharingPanel;
import ancestris.swing.ToolBar;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringEscapeUtils;
import org.openide.awt.DropDownButtonFactory;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeSharingTopComponent
extends TopComponent {
    private static TreeSharingTopComponent instance;
    private static final String PREFERRED_ID = "TreeSharingTopComponent";
    private static final String ICON_PATH = "ancestris/modules/treesharing/resources/treesharing.png";
    private static final String ICON_PATH_ON = "ancestris/modules/treesharing/resources/treesharingON.png";
    private static final Logger LOG;
    private String titleComponent = "";
    private boolean isComponentCreated = false;
    private JToolBar toolbar = null;
    private TreeSharingPanel desktopPanel = null;
    private final String TOOLBAR_SPACE = "  ";
    private final BorderLayout borderLayout;
    private String defaultBorderLayout = "North";
    private PrivacyToggle privacyToggle;
    private JLabel membersNumber = null;
    private MembersPopup membersList = null;
    private TimerPanel timerPanel;
    private boolean shareAll = false;
    private StartSharingAllToggle startSharingToggle;
    private StopSharingAllToggle stopSharingToggle;
    private SearchAction searchButton = null;
    private JLabel memberInProgress = null;
    private DisplayStatsAction statsButton = null;
    private SettingsAction settings = null;
    private final int LEFT_OFFSET_GEDCOM = 10;
    private final int LEFT_OFFSET_MATCHES = 400;
    private final int LEFT_OFFSET_FRIENDS = 590;
    private final int TOP_OFFSET = 10;
    private final int VERTICAL_SPACE = 10;
    private boolean isBusy = false;
    private String commPseudo = "";
    private Comm commHandler = null;
    private Timer timer;
    private List<AncestrisMember> ancestrisMembers = null;
    private List<SharedGedcom> sharedGedcoms = null;
    private List<AncestrisFriend> ancestrisFriends = null;
    private List<GedcomFriendMatch> gedcomFriendMatches = null;
    private SearchSharedTrees searchThread;
    private final int PING_DELAY = 150;
    private javax.swing.Timer swingTimer;
    private final int REFRESH_DELAY = 50;
    private JLabel rcvdConnections = null;
    private JLabel rcvdUniqueMembers = null;
    private JLabel rcvdUniqueFriends = null;
    private Map<String, StatsData> connectionStats = null;
    private boolean resetStats = false;
    private Set<MatchData> matchedResults = null;

    public static synchronized TreeSharingTopComponent getDefault() {
        if (instance == null) {
            instance = new TreeSharingTopComponent();
        }
        return instance;
    }

    public TreeSharingTopComponent() {
        if (instance == null) {
            instance = this;
        }
        this.titleComponent = NbBundle.getMessage(TreeSharingTopComponent.class, (String)"CTL_TreeSharingTopComponent");
        this.setName(this.titleComponent);
        this.setToolTipText(NbBundle.getMessage(TreeSharingTopComponent.class, (String)"HINT_TreeSharingTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.borderLayout = new BorderLayout();
        this.setLayout(this.borderLayout);
    }

    public void componentOpened() {
        if (!this.isComponentCreated) {
            this.initCommunication();
            this.defaultBorderLayout = NbPreferences.forModule(TreeSharingTopComponent.class).get("ToolbarBorderLayout", "North");
            this.initMainPanel();
            this.initSharedGedcoms();
            this.initConnectionStats();
            this.initResults();
            this.initSwingTimerRefreshValues();
        }
        this.privacyToggle.setPrivacy(this.getPreferredPrivacy());
        this.isComponentCreated = true;
    }

    private void initCommunication() {
        LOG.log(Level.FINE, "Creating communication handler.");
        this.commHandler = new Comm(this, 150);
    }

    private void initMainPanel() {
        LOG.log(Level.FINE, "Initializing main panel.");
        this.toolbar = new ToolBar();
        LOG.log(Level.FINE, "   - Users button.");
        this.membersNumber = new JLabel("");
        LOG.log(Level.FINE, "   - Initatilize Ancestris members list.");
        this.updateMembersList();
        this.membersList = new MembersPopup(this);
        JButton members = DropDownButtonFactory.createDropDownButton((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/treesharing/resources/friend24.png")), (JPopupMenu)this.membersList);
        members.setToolTipText(NbBundle.getMessage(MembersPopup.class, (String)"TIP_MembersList"));
        members.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean ret;
                if (TreeSharingTopComponent.this.commHandler != null) {
                    TreeSharingTopComponent.this.commHandler.clearCommunicationError();
                }
                if (ret = TreeSharingTopComponent.this.updateMembersList()) {
                    TreeSharingTopComponent.this.updateStatsDisplay();
                    if (TreeSharingTopComponent.this.commHandler != null) {
                        TreeSharingTopComponent.this.commHandler.sendPing();
                    }
                }
            }
        });
        this.toolbar.add(members);
        this.toolbar.add(this.membersNumber);
        this.toolbar.add(new JLabel("  "));
        LOG.log(Level.FINE, "   - Other button.");
        this.timerPanel = new TimerPanel(this);
        this.toolbar.add(this.timerPanel);
        this.toolbar.add(new JLabel("  "));
        this.privacyToggle = new PrivacyToggle(this, this.getPreferredPrivacy());
        this.toolbar.add(this.privacyToggle);
        this.toolbar.add(new JLabel("  "));
        this.toolbar.addSeparator();
        this.toolbar.add(new JLabel("  "));
        this.startSharingToggle = new StartSharingAllToggle(this, this.shareAll);
        this.toolbar.add(this.startSharingToggle);
        this.stopSharingToggle = new StopSharingAllToggle(this, !this.shareAll);
        this.toolbar.add(this.stopSharingToggle);
        this.toolbar.add(new JLabel("  "));
        this.toolbar.addSeparator();
        this.toolbar.add(new JLabel("  "));
        this.searchButton = new SearchAction(this);
        this.searchButton.setOff();
        this.toolbar.add((Action)((Object)this.searchButton));
        this.toolbar.add(new JLabel("  "));
        this.memberInProgress = new JLabel("");
        this.toolbar.add(this.memberInProgress);
        this.memberInProgress.setToolTipText(NbBundle.getMessage(MembersPopup.class, (String)"TIP_memberInProgress"));
        this.toolbar.add(new JLabel("  "));
        this.toolbar.add((Action)((Object)new ResetResults(this)));
        this.toolbar.add(new JLabel("  "));
        this.toolbar.addSeparator();
        this.toolbar.add(new JLabel("  "));
        this.statsButton = new DisplayStatsAction(this);
        this.toolbar.add((Action)((Object)this.statsButton));
        this.toolbar.add(new JLabel("  "));
        this.rcvdConnections = new JLabel("");
        this.toolbar.add(this.rcvdConnections);
        this.rcvdConnections.setToolTipText(NbBundle.getMessage(MembersPopup.class, (String)"TIP_rcvdConnections"));
        this.toolbar.add(new JLabel("  "));
        this.rcvdUniqueMembers = new JLabel("");
        this.toolbar.add(this.rcvdUniqueMembers);
        this.rcvdUniqueMembers.setToolTipText(NbBundle.getMessage(MembersPopup.class, (String)"TIP_rcvdUniqueMembers"));
        this.toolbar.add(new JLabel("  "));
        this.rcvdUniqueFriends = new JLabel("");
        this.toolbar.add(this.rcvdUniqueFriends);
        this.rcvdUniqueFriends.setToolTipText(NbBundle.getMessage(MembersPopup.class, (String)"TIP_rcvdUniqueFriends"));
        this.updateStatsDisplay();
        this.toolbar.add((Component)new Box.Filler(null, null, null), "growx, pushx, center");
        this.toolbar.addSeparator();
        this.toolbar.add((Action)((Object)new RearrangeAction(this)));
        this.settings = new SettingsAction();
        this.toolbar.add((Action)((Object)this.settings));
        this.add(this.toolbar, this.defaultBorderLayout);
        this.desktopPanel = new TreeSharingPanel();
        this.add(this.desktopPanel);
    }

    private void initSharedGedcoms() {
        LOG.log(Level.FINE, "Initializing gedcoms panels.");
        this.sharedGedcoms = new LinkedList<SharedGedcom>();
        for (Context context : GedcomDirectory.getDefault().getContexts()) {
            this.sharedGedcoms.add(new SharedGedcom(this, context.getGedcom(), this.privacyToggle.isSelected()));
        }
        this.desktopPanel.setFrames(this.sharedGedcoms, 10, 10, 10, true);
    }

    public void initConnectionStats() {
        LOG.log(Level.FINE, "Initializing connection statistics.");
        if (this.connectionStats == null) {
            this.connectionStats = new HashMap<String, StatsData>();
        } else {
            this.connectionStats.clear();
        }
    }

    public void initResults() {
        LOG.log(Level.FINE, "Initializing matched results.");
        if (this.matchedResults == null) {
            this.matchedResults = new HashSet<MatchData>();
        } else {
            this.matchedResults.clear();
        }
    }

    private void initSwingTimerRefreshValues() {
        LOG.log(Level.FINE, "Creating refreshing toolbar swing timer.");
        this.swingTimer = new javax.swing.Timer(50000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean ret = TreeSharingTopComponent.this.updateMembersList();
                if (!ret && TreeSharingTopComponent.this.isShareAllOn()) {
                    TreeSharingTopComponent.this.stopSharingAll();
                }
                if (ret) {
                    TreeSharingTopComponent.this.checkDisconnection();
                    TreeSharingTopComponent.this.updateStatsDisplay();
                }
            }
        });
        this.swingTimer.setInitialDelay(50000);
        this.swingTimer.start();
    }

    public boolean updateMembersList() {
        boolean ret = this.resetAncestrisMembers();
        int n = this.ancestrisMembers.size() - (this.shareAll ? 1 : 0);
        this.membersNumber.setToolTipText(NbBundle.getMessage(MembersPopup.class, (String)"TIP_MembersNumber", (Object)n));
        if (this.membersList != null) {
            String name;
            String nb;
            this.membersList.updateTable();
            if (n > 0) {
                nb = " " + n + " ";
                name = this.titleComponent + " (" + n + ")";
            } else {
                nb = " ";
                name = this.titleComponent;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreeSharingTopComponent.this.membersNumber.setText(nb);
                    instance.setDisplayName(name);
                }
            });
            this.rememberMembers();
        }
        return ret;
    }

    public void updateStatsDisplay() {
        if (this.connectionStats == null || this.connectionStats.isEmpty()) {
            this.statsButton.setEnabled(false);
            this.rcvdConnections.setText("");
            this.rcvdUniqueMembers.setText("");
            this.rcvdUniqueFriends.setText("");
        } else {
            this.statsButton.setEnabled(true);
            int rcvdConnectionsNb = 0;
            int rcvdUniqueMembersNb = 0;
            int rcvdUniqueFriendsNb = 0;
            for (String member : this.connectionStats.keySet()) {
                StatsData stats = this.connectionStats.get(member);
                rcvdConnectionsNb += stats.connections;
                ++rcvdUniqueMembersNb;
                if (!stats.match) continue;
                ++rcvdUniqueFriendsNb;
            }
            this.rcvdConnections.setText("" + rcvdConnectionsNb);
            this.rcvdUniqueMembers.setText("" + rcvdUniqueMembersNb);
            this.rcvdUniqueFriends.setText("" + rcvdUniqueFriendsNb);
        }
        this.revalidate();
        this.repaint();
    }

    public void rememberMembers() {
        String key = "";
        for (AncestrisMember member : this.ancestrisMembers) {
            key = "memberip-" + member.getxIPAddress();
            NbPreferences.forModule(TreeSharingOptionsPanel.class).put(key, member.isAllowed() ? "1" : "0");
            key = "memberps-" + member.getMemberName();
            NbPreferences.forModule(TreeSharingOptionsPanel.class).put(key, member.isAllowed() ? "1" : "0");
        }
    }

    private boolean resetAncestrisMembers() {
        if (this.ancestrisMembers == null) {
            this.ancestrisMembers = new ArrayList<AncestrisMember>();
        } else {
            this.ancestrisMembers.clear();
        }
        List<AncestrisMember> newList = this.commHandler.getAncestrisMembers();
        String key = "";
        boolean isAllowed = true;
        if (newList != null) {
            for (AncestrisMember tempItem : newList) {
                if (this.ancestrisMembers != null && !this.ancestrisMembers.isEmpty()) {
                    for (AncestrisMember member : this.ancestrisMembers) {
                        if (!tempItem.getMemberName().equals(member.getMemberName())) continue;
                        tempItem.setAllowed(member.isAllowed());
                        tempItem.setUsePrivate(member.getUsePrivate());
                    }
                }
                key = "memberip-" + tempItem.getxIPAddress();
                isAllowed = NbPreferences.forModule(TreeSharingOptionsPanel.class).get(key, "1").equals("1");
                key = "memberps-" + tempItem.getMemberName();
                tempItem.setAllowed(isAllowed &= NbPreferences.forModule(TreeSharingOptionsPanel.class).get(key, "1").equals("1"));
            }
            this.ancestrisMembers.addAll(newList);
        }
        return newList != null;
    }

    private void checkDisconnection() {
        boolean stillConnected = false;
        for (AncestrisMember member : this.ancestrisMembers) {
            if (!member.getMemberName().equals(this.commPseudo)) continue;
            stillConnected = true;
        }
        if (!stillConnected && this.isShareAllOn()) {
            this.stopSharingAll();
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.startSharingAll();
            LOG.log(Level.FINE, "Connection lost. Turning sharing off and back on...   " + this.getRegisteredEndDate());
        }
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.toolbar != null && comp == this.toolbar) {
            int orientation = 0;
            if ("West".equals(constraints) || "East".equals(constraints)) {
                orientation = 1;
            }
            this.defaultBorderLayout = (String)constraints;
            NbPreferences.forModule(TreeSharingTopComponent.class).put("ToolbarBorderLayout", this.defaultBorderLayout);
            this.toolbar.setOrientation(orientation);
        }
        super.addImpl(comp, constraints, index);
    }

    public void componentClosed() {
        this.stopSharingToggle.doClick();
        this.swingTimer.stop();
        this.updateIcon();
        this.rememberMembers();
    }

    public int getPersistenceType() {
        return 0;
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void readProperties(Properties p) {
    }

    public void writeProperties(Properties p) {
    }

    public void resetResults() {
        this.matchedResults.clear();
        for (SharedGedcom sg : this.sharedGedcoms) {
            this.removeMatch(sg);
            sg.resetResults();
        }
    }

    public void rearrangeWindows() {
        if (this.sharedGedcoms != null && !this.sharedGedcoms.isEmpty()) {
            this.desktopPanel.setFrames(this.sharedGedcoms, 10, 10, 10, false);
        }
        if (this.ancestrisFriends != null && !this.ancestrisFriends.isEmpty()) {
            this.desktopPanel.setFrames(this.ancestrisFriends, 590, 10, 10, false);
        }
        if (this.gedcomFriendMatches != null && !this.gedcomFriendMatches.isEmpty()) {
            this.desktopPanel.setFrames(this.gedcomFriendMatches, 400, 10, 10, false);
        }
    }

    public String getPreferredPseudo() {
        return TreeSharingOptionsPanel.getPseudo();
    }

    public String getRegisteredPseudo() {
        return this.getRegisteredPseudo(true);
    }

    public String getRegisteredPseudo(boolean escape) {
        return escape ? StringEscapeUtils.escapeHtml((String)this.commPseudo) : this.commPseudo;
    }

    public String getRegisteredIPAddress() {
        return this.getMember(this.commPseudo).getIPAddress();
    }

    public String getRegisteredPortAddress() {
        return this.getMember(this.commPseudo).getPortAddress();
    }

    public String getRegisteredEndDate() {
        return new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(this.timerPanel.getTimerDate());
    }

    private boolean getPreferredPrivacy() {
        return NbPreferences.forModule(TreeSharingOptionsPanelController.class).getBoolean("RespectPrivacy", true);
    }

    public void dispatchPrivacy(boolean b) {
        if (this.sharedGedcoms == null) {
            return;
        }
        for (SharedGedcom sg : this.sharedGedcoms) {
            sg.setPrivacy(b);
        }
    }

    public void dispatchRecalc() {
        if (this.sharedGedcoms == null) {
            return;
        }
        for (SharedGedcom sg : this.sharedGedcoms) {
            sg.updateStats(true);
        }
    }

    public boolean isShareAllOn() {
        return this.shareAll;
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    public boolean startSharingAll() {
        if (!this.isMyProfileOK()) {
            return false;
        }
        this.commPseudo = this.getPreferredPseudo();
        if (!this.isGedcomLoaded()) {
            return false;
        }
        this.toggleOn();
        if (!this.setTimer()) {
            this.toggleOff();
            this.timerPanel.setFocus();
            return false;
        }
        if (!this.commHandler.registerMe(this.commPseudo)) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            this.toggleOff();
            return false;
        }
        this.shareAll = true;
        this.updateIcon();
        this.updateMembersList();
        return true;
    }

    public boolean stopSharingAll() {
        this.stopSearchEngine();
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.commHandler.unregisterMe(this.commPseudo);
        this.shareAll = false;
        this.updateIcon();
        this.updateMembersList();
        this.toggleOff();
        return true;
    }

    private void toggleOn() {
        Toolkit.getDefaultToolkit().beep();
        this.isBusy = true;
        this.startSharingToggle.setToolTipText(true);
        this.stopSharingToggle.setToolTipText(false);
        this.dispatchShare(true);
        this.searchButton.setOn();
        this.isBusy = false;
    }

    private void toggleOff() {
        Toolkit.getDefaultToolkit().beep();
        Toolkit.getDefaultToolkit().beep();
        this.isBusy = true;
        this.startSharingToggle.setToolTipText(false);
        this.stopSharingToggle.setToolTipText(true);
        this.dispatchShare(false);
        this.searchButton.setOff();
        this.isBusy = false;
    }

    public void updateIcon() {
        boolean atLeastAFlagIsOn = false;
        for (SharedGedcom sg : this.sharedGedcoms) {
            atLeastAFlagIsOn |= sg.isShared();
        }
        final boolean flag = atLeastAFlagIsOn;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                instance.setIcon(ImageUtilities.loadImage((String)(TreeSharingTopComponent.this.isShareAllOn() && flag ? TreeSharingTopComponent.ICON_PATH_ON : TreeSharingTopComponent.ICON_PATH), (boolean)true));
            }
        });
    }

    private boolean isMyProfileOK() {
        this.showWelcomeMessages();
        String error = "";
        error = this.getPreferredPseudo().equals("") ? NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"ERR_NullPseudo") : TreeSharingOptionsPanel.getProfileError();
        if (!error.isEmpty()) {
            DialogManager.create((String)"", (String)"error").setOptionType(10).setMessageType(0).show();
            this.settings.displayOptionsPanel();
            return false;
        }
        return true;
    }

    public MemberProfile getMyProfile() {
        return TreeSharingOptionsPanel.getProfile();
    }

    private boolean isGedcomLoaded() {
        if (this.sharedGedcoms != null && !this.sharedGedcoms.isEmpty()) {
            return true;
        }
        DialogManager.create((String)"", (String)NbBundle.getMessage(TreeSharingTopComponent.class, (String)"MSG_NoGedcomLoaded")).setOptionType(10).setMessageType(0).show();
        return false;
    }

    private void dispatchShare(boolean b) {
        if (this.sharedGedcoms == null) {
            return;
        }
        for (SharedGedcom sg : this.sharedGedcoms) {
            sg.setShared(b);
        }
    }

    public void gedcomOpened(Gedcom gedcom) {
        LOG.log(Level.FINE, "Gedcom opened... (" + gedcom.getName() + ")");
        if (!this.isComponentCreated) {
            LOG.log(Level.FINE, "   - Do nothing. Component not created yet.");
            return;
        }
        LOG.log(Level.FINE, "   - Creating gedcom panel.");
        SharedGedcom newSharedGedcom = new SharedGedcom(this, gedcom, this.privacyToggle.isSelected());
        this.desktopPanel.addFrame(newSharedGedcom, this.findLocation(this.sharedGedcoms.size(), 10, newSharedGedcom.getPreferredSize().height));
        this.sharedGedcoms.add(newSharedGedcom);
        this.updateIcon();
    }

    public void gedcomClosed(Gedcom gedcom) {
        LOG.log(Level.FINE, "Gedcom closed... (" + gedcom.getName() + ")");
        if (!this.isComponentCreated) {
            LOG.log(Level.FINE, "   - Do nothing. Component not created yet.");
            return;
        }
        LOG.log(Level.FINE, "   - Removing gedcom panel.");
        for (SharedGedcom sg : this.sharedGedcoms) {
            if (sg.getGedcom() != gedcom) continue;
            this.removeGedcom(sg);
            this.removeMatch(sg);
            break;
        }
        this.updateIcon();
    }

    private void removeGedcom(SharedGedcom sg) {
        sg.close();
        this.desktopPanel.removeFrame(sg);
        this.desktopPanel.removeLink(sg);
        this.sharedGedcoms.remove(sg);
    }

    private void removeMatch(SharedGedcom sg) {
        if (this.gedcomFriendMatches == null || this.ancestrisFriends == null) {
            return;
        }
        LinkedList<GedcomFriendMatch> removedMatches = new LinkedList<GedcomFriendMatch>();
        for (GedcomFriendMatch match : this.gedcomFriendMatches) {
            if (match.getSharedGedcom() != sg) continue;
            removedMatches.add(match);
        }
        for (GedcomFriendMatch match : removedMatches) {
            AncestrisFriend friend = match.getFriend();
            this.desktopPanel.removeFrame(match);
            this.desktopPanel.removeLink(match);
            this.gedcomFriendMatches.remove(match);
            friend.removeGedcom(sg);
            if (!friend.isEmpty()) continue;
            this.desktopPanel.removeFrame(friend);
            this.desktopPanel.removeLink(friend);
            this.ancestrisFriends.remove(friend);
        }
    }

    private Point findLocation(int size, int offset, int height) {
        return new Point(offset, 10 + size * (height + 10));
    }

    private boolean setTimer() {
        Date limitDate = this.timerPanel.getTimerDate();
        Date currentDate = new Date();
        long delay = limitDate.getTime() - currentDate.getTime();
        if (delay < 0L) {
            delay = TimerPanel.DEFAULT_DELAY;
            this.timerPanel.setTimerDate((int)delay);
            delay *= 3600000L;
        }
        if (delay != 0L) {
            TimerTask task = new TimerTask(){

                public void run() {
                    TreeSharingTopComponent.this.timer.cancel();
                    TreeSharingTopComponent.this.stopSharingToggle.doClick();
                    TreeSharingTopComponent.this.updateIcon();
                }
            };
            this.timer = new Timer();
            this.timer.schedule(task, delay);
        }
        return true;
    }

    public void resetTimer() {
        if (this.timer == null) {
            return;
        }
        this.timer.cancel();
        this.setTimer();
    }

    public void launchSearchEngine() {
        this.searchThread = new SearchSharedTrees(this);
        this.searchThread.start();
    }

    private void stopSearchEngine() {
        if (this.searchThread != null) {
            this.searchThread.stopGracefully();
        }
    }

    public void setRotatingIcon(boolean search) {
        if (search) {
            this.searchButton.setSearching();
        } else {
            this.searchButton.setOn();
        }
    }

    public void displaySearchedMember(String memberName) {
        Font font = this.memberInProgress.getFont();
        this.memberInProgress.setFont(font.deriveFont(2));
        this.memberInProgress.setText(memberName + (memberName.isEmpty() ? "" : "..."));
    }

    public void updateSearchStats() {
        if (this.sharedGedcoms != null) {
            for (SharedGedcom sg : this.sharedGedcoms) {
                sg.updateStats(true);
            }
        }
        if (this.gedcomFriendMatches != null) {
            for (GedcomFriendMatch match : this.gedcomFriendMatches) {
                match.updateStats();
            }
        }
        if (this.ancestrisFriends != null) {
            for (AncestrisFriend f : this.ancestrisFriends) {
                f.updateStats();
            }
        }
    }

    public void setResetStats() {
        this.resetStats = true;
    }

    public void displayStats() {
        this.revalidate();
        this.repaint();
        DialogManager.create((String)NbBundle.getMessage(StatsPanel.class, (String)"TITL_StatsPanel"), (JComponent)new StatsPanel(this.connectionStats, this)).setMessageType(-1).setDialogId(StatsPanel.class).setOptionType(10).show();
        if (this.resetStats) {
            this.initConnectionStats();
            this.updateStatsDisplay();
            this.resetStats = false;
        }
    }

    public void addConnection(String member) {
        StatsData stats;
        if (this.connectionStats == null) {
            this.initConnectionStats();
        }
        if ((stats = this.connectionStats.get(member)) == null) {
            stats = new StatsData();
        }
        ++stats.connections;
        stats.endDate = new Date();
        this.connectionStats.put(member, stats);
        this.updateStatsDisplay();
    }

    public void addUniqueFriend(String member, MemberProfile profile, String ipaddress, boolean resultFound) {
        StatsData stats;
        if (this.connectionStats == null) {
            this.initConnectionStats();
        }
        if ((stats = this.connectionStats.get(member)) == null) {
            stats = new StatsData();
            ++stats.connections;
            stats.endDate = new Date();
        }
        if (resultFound) {
            stats.match = true;
        }
        if (stats.profile == null || stats.profile.photoBytes == null && profile.photoBytes != null) {
            stats.profile = profile;
        }
        stats.profile.ipaddress = ipaddress;
        this.connectionStats.put(member, stats);
        this.updateStatsDisplay();
    }

    public Comm getCommHandler() {
        return this.commHandler;
    }

    public List<SharedGedcom> getSharedGedcoms() {
        return this.sharedGedcoms;
    }

    public List<AncestrisMember> getAncestrisMembers() {
        return this.ancestrisMembers;
    }

    public AncestrisMember getMember(String memberToFind) {
        for (AncestrisMember member : this.ancestrisMembers) {
            if (!member.getMemberName().equals(memberToFind)) continue;
            return member;
        }
        return null;
    }

    public AncestrisFriend createMatch(SharedGedcom sharedGedcom, Entity myEntity, FriendGedcomEntity memberEntity, AncestrisMember member, int matchResult) {
        this.matchedResults.add(new MatchData(myEntity, memberEntity, matchResult));
        AncestrisFriend friend = this.getFriend(memberEntity.friend);
        memberEntity.setFriend(friend);
        GedcomFriendMatch match = this.getGedcomFriendMatch(sharedGedcom, friend);
        sharedGedcom.addEntity(myEntity, memberEntity, matchResult);
        match.addEntity(myEntity, memberEntity, matchResult);
        friend.addEntity(myEntity, memberEntity, matchResult);
        this.desktopPanel.linkFrames(sharedGedcom, match);
        this.desktopPanel.linkFrames(match, friend);
        return friend;
    }

    private GedcomFriendMatch getGedcomFriendMatch(SharedGedcom sharedGedcom, AncestrisFriend friend) {
        GedcomFriendMatch match = null;
        if (this.gedcomFriendMatches == null) {
            this.gedcomFriendMatches = new LinkedList<GedcomFriendMatch>();
        }
        if (!this.gedcomFriendMatches.isEmpty()) {
            for (GedcomFriendMatch gfm : this.gedcomFriendMatches) {
                if (!gfm.getSharedGedcom().getGedcom().getOrigin().getFile().getAbsolutePath().equals(sharedGedcom.getGedcom().getOrigin().getFile().getAbsolutePath()) || !gfm.getFriend().getFriendName().equals(friend.getFriendName())) continue;
                match = gfm;
                break;
            }
        }
        if (match == null) {
            match = new GedcomFriendMatch(this, sharedGedcom, friend);
            this.desktopPanel.addFrame(match, this.findLocation(this.gedcomFriendMatches.size(), 400, match.getPreferredSize().height));
            this.gedcomFriendMatches.add(match);
        }
        return match;
    }

    private AncestrisFriend getFriend(String foundFriend) {
        AncestrisFriend friend = null;
        if (this.ancestrisFriends == null) {
            this.ancestrisFriends = new LinkedList<AncestrisFriend>();
        }
        if (!this.ancestrisFriends.isEmpty()) {
            for (AncestrisFriend f : this.ancestrisFriends) {
                if (!f.getFriendName().equals(foundFriend)) continue;
                friend = f;
                break;
            }
        }
        if (friend == null) {
            friend = new AncestrisFriend(this, foundFriend);
            this.desktopPanel.addFrame(friend, this.findLocation(this.ancestrisFriends.size(), 590, friend.getPreferredSize().height));
            this.ancestrisFriends.add(friend);
        }
        return friend;
    }

    private void showWelcomeMessages() {
        if ("1".equals(NbPreferences.forModule(TreeSharingOptionsPanel.class).get("Welcome", "1"))) {
            DialogManager.create((String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TITL_Welcome"), (JComponent)new WelcomePanel()).setMessageType(-1).setOptionType(10).show();
            NbPreferences.forModule(TreeSharingOptionsPanel.class).put("Welcome", "0");
            this.settings.displayOptionsPanel();
        }
    }

    public void displayResultsPanel(String gedcom, String friend, String typeOfEntity) {
        DialogManager.create((String)NbBundle.getMessage(EntitiesListPanel.class, (String)"TIP_TitleResults"), (JComponent)new EntitiesListPanel(gedcom, friend, this.matchedResults, typeOfEntity)).setMessageType(-1).setDialogId(EntitiesListPanel.class).setOptionType(10).show();
    }

    static {
        LOG = Logger.getLogger("ancestris.treesharing");
    }
}

