/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.treesharing.options;

import ancestris.modules.treesharing.communication.MemberProfile;
import ancestris.modules.treesharing.options.TreeSharingOptionsPanelController;
import ancestris.modules.treesharing.panels.MembersPopup;
import ancestris.modules.treesharing.panels.TechInfoPanel;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.FileChooserBuilder;
import genj.util.EnvironmentChecker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class TreeSharingOptionsPanel
extends JPanel
implements TableModelListener {
    private static final int IMG_SMALL_WIDTH = 16;
    private static final int IMG_SMALL_HEIGHT = 19;
    private static final int IMG_MEDIUM_WIDTH = 51;
    private static final int IMG_MEDIUM_HEIGHT = 62;
    public static final int IMG_LARGE_WIDTH = 155;
    public static final int IMG_LARGE_HEIGHT = 186;
    private final ImageIcon ALLOWED_ICON = new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/allowed.png"));
    private final ImageIcon MEMBER_ICON = new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/friend16.png"));
    private static final int PSEUDO_MAXLENGTH = 15;
    private static final String DEFPROF_LAST = "Chevalier";
    private static final String DEFPROF_FIRST = "Maurice";
    private static final String DEFPROF_EMAIL = "maurice@france.fr";
    private static final String DEFPROF_CITY = "Marnes";
    private static final String DEFPROF_CTRY = "France";
    private final ImageIcon DEFPROF_PHOTO = new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/nophotobig.png"));
    private static String photoPath = "";
    private static File dest = null;
    private static BufferedImage targetImage = null;
    private static boolean loading = false;
    public static final int NO_MATCH = 0;
    public static final int EXACT_MATCH = 1;
    public static final int FLASH_MATCH = 2;
    public static final int LOOSE_MATCH = 3;
    public static final int MAX_MATCH = 3;
    public static final String[] MATCHING_MENU = new String[]{NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"Match1"), NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"Match2"), NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"Match3")};
    private TreeSharingOptionsPanel thisPanel = null;
    private Map<String, Boolean> jlist1 = null;
    private Map<String, Boolean> jlist2 = null;
    private MyTableModel model1 = null;
    private MyTableModel model2 = null;
    private JCheckBox jCheckBox1;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;
    private JTable jTable2;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JTextField jTextField5;
    private JTextField jTextField6;
    public Comparator<String> sortmap = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.toLowerCase().compareTo(o2.toLowerCase());
        }
    };

    TreeSharingOptionsPanel(TreeSharingOptionsPanelController controller) {
        this.initComponents();
        loading = false;
        this.thisPanel = this;
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jTextField5 = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jTextField6 = new JTextField();
        this.jTextField1 = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextField4 = new JTextField();
        this.jPanel1 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextField3 = new JTextField();
        this.jPanel3 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jPanel4 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jScrollPane4 = new JScrollPane();
        this.jTable2 = new JTable();
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jLabel5.text"));
        this.jTextField5.setText(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jTextField5.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jLabel6.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jLabel1.text"));
        this.jTextField6.setText(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jTextField6.text"));
        this.jTextField1.setText(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jTextField1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jLabel7.text"));
        this.jTextField4.setText(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jTextField4.text"));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel8.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jLabel8.text"));
        this.jLabel8.setToolTipText(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jLabel8.toolTipText"));
        this.jLabel8.setBorder(null);
        this.jLabel8.setIconTextGap(0);
        this.jLabel8.setPreferredSize(new Dimension(155, 186));
        this.jLabel8.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                TreeSharingOptionsPanel.this.jLabel8MouseClicked(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.jLabel8.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jLabel8.AccessibleContext.accessibleName"));
        this.jLabel8.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jLabel8.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jLabel2.text"));
        this.jTextField2.setText(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jTextField2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jLabel4.text"));
        this.jTextField3.setText(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jTextField3.text"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel4).addComponent(this.jLabel7).addComponent(this.jLabel5).addComponent(this.jLabel6)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextField5).addComponent(this.jTextField2, GroupLayout.Alignment.LEADING, -1, 212, Short.MAX_VALUE).addComponent(this.jTextField1, GroupLayout.Alignment.LEADING, -1, 212, Short.MAX_VALUE).addComponent(this.jTextField3).addComponent(this.jTextField4).addComponent(this.jTextField6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField1, -2, -1, -2)).addGap(4, 4, 4).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextField3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jTextField4, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextField5, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jTextField6, -2, -1, -2))).addComponent(this.jPanel1, -2, -1, -2)).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jPanel2.TabConstraints.tabTitle"), this.jPanel2);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox1, (String)NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jCheckBox1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jLabel3.text"));
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(MATCHING_MENU));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox1, -1, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jCheckBox1).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jComboBox1, -2, -1, -2)).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jPanel3.TabConstraints.tabTitle"), this.jPanel3);
        this.jLabel9.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jLabel9.text"));
        this.jLabel10.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jLabel10.text"));
        this.jScrollPane3.setViewportView(this.jTable1);
        this.jScrollPane4.setViewportView(this.jTable2);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane3, -2, 0, Short.MAX_VALUE).addComponent(this.jLabel9, -1, 219, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4, -2, 220, -2).addComponent(this.jLabel10, -2, 220, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(14, 14, 14).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4, -1, 251, Short.MAX_VALUE).addComponent(this.jScrollPane3, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jPanel4.TabConstraints.tabTitle"), this.jPanel4);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1).addGap(17, 17, 17)));
    }

    private void jLabel8MouseClicked(MouseEvent evt) {
        loading = true;
        this.chooseAndDisplayImage();
        loading = false;
    }

    void load() {
        this.jTextField1.setText(NbPreferences.forModule(TreeSharingOptionsPanel.class).get("Pseudo", TreeSharingOptionsPanel.getPseudo()).trim());
        this.jTextField2.setText(NbPreferences.forModule(TreeSharingOptionsPanel.class).get("Lastname", DEFPROF_LAST).trim());
        this.jTextField3.setText(NbPreferences.forModule(TreeSharingOptionsPanel.class).get("Firstname", DEFPROF_FIRST).trim());
        this.jTextField4.setText(NbPreferences.forModule(TreeSharingOptionsPanel.class).get("Email", DEFPROF_EMAIL).trim());
        this.jTextField5.setText(NbPreferences.forModule(TreeSharingOptionsPanel.class).get("City", DEFPROF_CITY).trim());
        this.jTextField6.setText(NbPreferences.forModule(TreeSharingOptionsPanel.class).get("Country", DEFPROF_CTRY.trim()));
        photoPath = NbPreferences.forModule(TreeSharingOptionsPanel.class).get("Photo", "");
        this.jLabel8.setText("");
        this.jLabel8.setToolTipText(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TreeSharingOptionsPanel.jLabel8.toolTipText"));
        if (TreeSharingOptionsPanel.loadSavePhoto(new File(photoPath))) {
            this.jLabel8.setIcon(new ImageIcon(targetImage));
        } else {
            this.jLabel8.setIcon(this.DEFPROF_PHOTO);
        }
        this.jCheckBox1.setSelected(NbPreferences.forModule(TreeSharingOptionsPanel.class).getBoolean("RespectPrivacy", true));
        this.jComboBox1.setSelectedIndex(TreeSharingOptionsPanel.getMatchType() - 1);
        this.loadMembersLists();
    }

    void store() {
        String str = this.jTextField1.getText();
        int i = str.indexOf(" ");
        NbPreferences.forModule(TreeSharingOptionsPanel.class).put("Pseudo", i == -1 ? str : str.substring(0, i));
        NbPreferences.forModule(TreeSharingOptionsPanel.class).put("Lastname", this.jTextField2.getText().trim());
        NbPreferences.forModule(TreeSharingOptionsPanel.class).put("Firstname", this.jTextField3.getText().trim());
        NbPreferences.forModule(TreeSharingOptionsPanel.class).put("Email", this.jTextField4.getText().trim());
        NbPreferences.forModule(TreeSharingOptionsPanel.class).put("City", this.jTextField5.getText().trim());
        NbPreferences.forModule(TreeSharingOptionsPanel.class).put("Country", this.jTextField6.getText().trim());
        if (targetImage != null && dest != null) {
            photoPath = dest.getAbsolutePath();
            TreeSharingOptionsPanel.saveImage(dest);
            NbPreferences.forModule(TreeSharingOptionsPanel.class).put("Photo", photoPath);
        }
        NbPreferences.forModule(TreeSharingOptionsPanel.class).putBoolean("RespectPrivacy", this.jCheckBox1.isSelected());
        NbPreferences.forModule(TreeSharingOptionsPanel.class).put("MatchingType", "" + (this.jComboBox1.getSelectedIndex() + 1));
        this.saveMembersLists();
    }

    boolean valid() {
        return true;
    }

    private void chooseAndDisplayImage() {
        File file = new FileChooserBuilder(TreeSharingOptionsPanel.class).setFilesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"FileChooserTitle")).setApproveText(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"FileChooserButton")).setDefaultExtension(FileChooserBuilder.getImageFilter().getExtensions()[0]).setFileFilter((FileFilter)FileChooserBuilder.getImageFilter()).setAcceptAllFileFilterUsed(false).setFileHiding(true).setDefaultPreviewer().showOpenDialog();
        if (file != null) {
            if (TreeSharingOptionsPanel.processImage(file)) {
                this.jLabel8.setIcon(new ImageIcon(targetImage));
            } else {
                this.jLabel8.setIcon(this.DEFPROF_PHOTO);
            }
        }
    }

    private static boolean loadSavePhoto(File f) {
        if (TreeSharingOptionsPanel.processImage(f)) {
            TreeSharingOptionsPanel.saveImage(f);
            return true;
        }
        return false;
    }

    private static boolean processImage(File f) {
        try {
            if (f == null) {
                throw new Exception("FileIsNull");
            }
            targetImage = TreeSharingOptionsPanel.scaleImage(f, 155, 186);
            File dir = new File(System.getProperty("netbeans.user") + File.separator + "config" + File.separator + "Preferences" + NbPreferences.forModule(TreeSharingOptionsPanel.class).absolutePath());
            dir.mkdirs();
            dest = new File(dir, TreeSharingOptionsPanel.removeExtension(f.getName()) + ".jpg");
            return true;
        }
        catch (Exception ex) {
            if (loading) {
                DialogManager.create((String)NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)("TITL_" + ex.getMessage())), (String)NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TITL_PleaseChooseOther")).setMessageType(0).show();
            }
            return false;
        }
    }

    private static void saveImage(File f) {
        try {
            ImageIO.write((RenderedImage)targetImage, "jpeg", f);
        }
        catch (Exception ex) {
            DialogManager.create((String)NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TITL_CannotSaveCopy"), (String)NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TITL_PleaseCheckPath", (Object)photoPath)).setMessageType(0).show();
        }
    }

    private static BufferedImage scaleImage(File f, int IMG_LARGE_WIDTH, int IMG_LARGE_HEIGHT) throws Exception {
        BufferedImage ret = null;
        BufferedImage image = null;
        try {
            image = ImageIO.read(f);
        }
        catch (Exception ex) {
            throw new Exception("FileIsNotAnImage");
        }
        if (image == null) {
            throw new Exception("FileIsNotAnImage");
        }
        int imageWidth = ((Image)image).getWidth(null);
        int imageHeight = ((Image)image).getHeight(null);
        if (imageWidth <= 0 || imageHeight <= 0) {
            image.flush();
            throw new Exception("FileIsNotAnImage");
        }
        int targetWidth = IMG_LARGE_WIDTH;
        int targetHeight = IMG_LARGE_HEIGHT;
        double targetRatio = (double)targetWidth / (double)targetHeight;
        double imageRatio = (double)imageWidth / (double)imageHeight;
        if (targetRatio < imageRatio) {
            targetHeight = (int)((double)targetWidth / imageRatio);
        } else {
            targetWidth = (int)((double)targetHeight * imageRatio);
        }
        try {
            ret = TreeSharingOptionsPanel.resizeImage(image, targetWidth, targetHeight);
        }
        catch (Exception e) {
            throw new Exception("FileCannotBeResized");
        }
        return ret;
    }

    private static BufferedImage resizeImage(Image img, int width, int height) {
        BufferedImage dimg = new BufferedImage(width, height, 1);
        Graphics2D g = dimg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(img, 0, 0, width, height, null);
        g.dispose();
        return dimg;
    }

    public static byte[] getPhotoBytes(File f) {
        try {
            BufferedImage img = ImageIO.read(f);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "jpg", baos);
            baos.flush();
            return baos.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static ImageIcon getPhoto(int size, byte[] photoBytes) {
        Image image = null;
        if (photoBytes == null) {
            return null;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(photoBytes));
            image = size == 1 ? bufferedImage.getScaledInstance(16, 19, 1) : (size == 2 ? bufferedImage.getScaledInstance(51, 62, 1) : (size == 3 ? bufferedImage.getScaledInstance(155, 186, 1) : bufferedImage.getScaledInstance(51, 62, 1)));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return new ImageIcon(image);
    }

    public static String getPseudo() {
        String p = NbPreferences.forModule(TreeSharingOptionsPanel.class).get("Pseudo", TreeSharingOptionsPanel.getDefaultPseudo()).trim();
        NbPreferences.forModule(TreeSharingOptionsPanel.class).put("Pseudo", p);
        return p;
    }

    public static String getDefaultPseudo() {
        String rawName = EnvironmentChecker.getProperty((String)"user.home.ancestris", (String)"", (String)"").trim();
        int i = rawName.indexOf(File.separator);
        rawName = rawName.substring(i + 1);
        i = rawName.indexOf(File.separator);
        if ((i = (rawName = rawName.substring(i + 1)).indexOf(File.separator)) == -1) {
            i = rawName.length();
        }
        if ((rawName = rawName.substring(0, Math.min(15, i)).trim()).isEmpty()) {
            char[] buf = new char[12];
            char[] symbols = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
            Random random = new Random();
            for (int idx = 0; idx < buf.length; ++idx) {
                buf[idx] = symbols[random.nextInt(symbols.length)];
            }
            rawName = "ZZZ" + new String(buf);
        }
        return rawName;
    }

    public static MemberProfile getProfile() {
        MemberProfile profile = new MemberProfile();
        profile.lastname = NbPreferences.forModule(TreeSharingOptionsPanel.class).get("Lastname", DEFPROF_LAST).trim();
        profile.firstname = NbPreferences.forModule(TreeSharingOptionsPanel.class).get("Firstname", DEFPROF_FIRST).trim();
        profile.email = NbPreferences.forModule(TreeSharingOptionsPanel.class).get("Email", DEFPROF_EMAIL).trim();
        profile.city = NbPreferences.forModule(TreeSharingOptionsPanel.class).get("City", DEFPROF_CITY).trim();
        profile.country = NbPreferences.forModule(TreeSharingOptionsPanel.class).get("Country", DEFPROF_CTRY.trim());
        File f = new File(NbPreferences.forModule(TreeSharingOptionsPanel.class).get("Photo", ""));
        if (TreeSharingOptionsPanel.loadSavePhoto(f)) {
            profile.photoBytes = TreeSharingOptionsPanel.getPhotoBytes(f);
        }
        return profile;
    }

    public static String getProfileError() {
        MemberProfile myProfile = TreeSharingOptionsPanel.getProfile();
        if (myProfile.firstname.isEmpty() || myProfile.lastname.isEmpty()) {
            return NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"ERR_NullName");
        }
        if (!TreeSharingOptionsPanel.isValidEmailAddress(myProfile.email)) {
            return NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"ERR_NullEmail");
        }
        if (myProfile.city.isEmpty() || myProfile.country.isEmpty()) {
            return NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"ERR_NullPlace");
        }
        return "";
    }

    public static boolean isValidEmailAddress(String email) {
        String ePattern = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
        Pattern p = Pattern.compile(ePattern);
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public static int getMatchType() {
        int ret = 3;
        String str = NbPreferences.forModule(TreeSharingOptionsPanel.class).get("MatchingType", "");
        try {
            ret = Integer.valueOf(str);
            if (ret < 1 || ret > 3) {
                ret = 3;
            }
        }
        catch (Exception e) {
            ret = 3;
        }
        return ret;
    }

    private static String removeExtension(String name) {
        String ret = name;
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex >= 0) {
            ret = name.substring(0, dotIndex);
        }
        return ret;
    }

    public void loadMembersLists() {
        String[] keys;
        this.jlist1 = new TreeMap<String, Boolean>(this.sortmap);
        this.jlist2 = new TreeMap<String, Boolean>(this.sortmap);
        try {
            keys = NbPreferences.forModule(TreeSharingOptionsPanel.class).keys();
        }
        catch (BackingStoreException ex) {
            return;
        }
        for (String key : keys) {
            if (key.startsWith("memberps-")) {
                String pseudo = key.substring(9);
                if (!TreeSharingOptionsPanel.getPseudo().equals(pseudo)) {
                    this.jlist1.put(pseudo, NbPreferences.forModule(TreeSharingOptionsPanel.class).get(key, "1").equals("1"));
                }
            }
            if (!key.startsWith("memberip-")) continue;
            this.jlist2.put(key.substring(9), NbPreferences.forModule(TreeSharingOptionsPanel.class).get(key, "1").equals("1"));
        }
        this.refreshMembersLists();
    }

    public void refreshMembersLists() {
        this.model1 = new MyTableModel(this.jlist1);
        this.model2 = new MyTableModel(this.jlist2);
        this.jTable1.setModel(this.model1);
        this.jTable2.setModel(this.model2);
        this.setTable(this.jTable1);
        this.setTable(this.jTable2);
    }

    private void saveMembersLists() {
        String[] keys;
        try {
            keys = NbPreferences.forModule(TreeSharingOptionsPanel.class).keys();
        }
        catch (BackingStoreException ex) {
            return;
        }
        for (String key : keys) {
            if (!key.startsWith("memberps-") && !key.startsWith("memberip-")) continue;
            NbPreferences.forModule(TreeSharingOptionsPanel.class).remove(key);
        }
        for (String item : this.jlist1.keySet()) {
            NbPreferences.forModule(TreeSharingOptionsPanel.class).put("memberps-" + item, this.jlist1.get(item) != false ? "1" : "0");
        }
        for (String item : this.jlist2.keySet()) {
            NbPreferences.forModule(TreeSharingOptionsPanel.class).put("memberip-" + item, this.jlist2.get(item) != false ? "1" : "0");
        }
    }

    private void setTable(JTable table) {
        table.getModel().addTableModelListener(this);
        table.setAutoCreateRowSorter(true);
        table.getTableHeader().setToolTipText(NbBundle.getMessage(MembersPopup.class, (String)"TIP_SortHeader"));
        table.getColumnModel().getColumn(0).setPreferredWidth(20);
        DefaultTableCellRenderer rendererCol1 = new DefaultTableCellRenderer();
        rendererCol1.setToolTipText(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"TIP_DisplayMenu"));
        table.getColumnModel().getColumn(1).setCellRenderer(rendererCol1);
        table.setShowHorizontalLines(false);
        table.setShowVerticalLines(false);
        Border headerBorder = UIManager.getBorder("TableHeader.cellBorder");
        JLabel allowedLabel = new JLabel("", this.ALLOWED_ICON, 0);
        allowedLabel.setBorder(headerBorder);
        JLabel nameLabel = new JLabel("", this.MEMBER_ICON, 0);
        nameLabel.setBorder(headerBorder);
        JComponentTableCellRenderer renderer = new JComponentTableCellRenderer();
        table.getColumnModel().getColumn(0).setHeaderRenderer(renderer);
        table.getColumnModel().getColumn(1).setHeaderRenderer(renderer);
        table.getColumnModel().getColumn(0).setHeaderValue(allowedLabel);
        table.getColumnModel().getColumn(1).setHeaderValue(nameLabel);
        table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent me) {
                JTable table = (JTable)me.getSource();
                MyTableModel model = table == TreeSharingOptionsPanel.this.jTable1 ? TreeSharingOptionsPanel.this.model1 : TreeSharingOptionsPanel.this.model2;
                Map list = table == TreeSharingOptionsPanel.this.jTable1 ? TreeSharingOptionsPanel.this.jlist1 : TreeSharingOptionsPanel.this.jlist2;
                Point p = me.getPoint();
                int row = table.convertRowIndexToModel(table.rowAtPoint(p));
                String key = (String)model.getValueAt(row, 1);
                if (model == TreeSharingOptionsPanel.this.model2 && me.isAltDown() && me.isAltGraphDown() && me.getClickCount() == 2) {
                    TechInfoPanel.openIpLocator(key);
                    return;
                }
                if (me.isPopupTrigger()) {
                    PopUpMenu menu = new PopUpMenu(TreeSharingOptionsPanel.this.thisPanel, list, key);
                    menu.show(me.getComponent(), me.getX(), me.getY());
                    return;
                }
            }
        });
    }

    public void tableChanged(TableModelEvent e) {
        MyTableModel model = (MyTableModel)e.getSource();
        int row = e.getFirstRow();
        int column = e.getColumn();
        if (row >= 0 && row < model.getRowCount() && column >= 0 && column < model.getColumnCount() && column == 0) {
            if (model == this.model1) {
                this.jlist1.put((String)model.getValueAt(row, 1), (Boolean)model.getValueAt(row, 0));
            }
            if (model == this.model2) {
                this.jlist2.put((String)model.getValueAt(row, 1), (Boolean)model.getValueAt(row, 0));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PopupActionListener
    implements ActionListener {
        TreeSharingOptionsPanel owner = null;
        Map<String, Boolean> list = null;
        String key = "";

        private PopupActionListener(TreeSharingOptionsPanel owner, Map<String, Boolean> list, String key) {
            this.owner = owner;
            this.list = list;
            this.key = key;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().contains(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"MENU_ShowItem", (Object)this.key))) {
                TechInfoPanel.openIpLocator(this.key);
            }
            if (actionEvent.getActionCommand().contains(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"MENU_EraseItem", (Object)this.key))) {
                this.list.remove(this.key);
                this.owner.refreshMembersLists();
            }
            if (actionEvent.getActionCommand().contains(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"MENU_EraseAllItems"))) {
                this.list.clear();
                this.owner.refreshMembersLists();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PopUpMenu
    extends JPopupMenu {
        JMenuItem showItem;
        JMenuItem eraseItem;
        JMenuItem eraseAllItems;

        public PopUpMenu(TreeSharingOptionsPanel owner, Map<String, Boolean> list, String key) {
            PopupActionListener actionListener = new PopupActionListener(owner, list, key);
            this.eraseItem = new JMenuItem(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"MENU_EraseItem", (Object)key));
            this.eraseItem.addActionListener(actionListener);
            this.add(this.eraseItem);
            this.addSeparator();
            this.eraseAllItems = new JMenuItem(NbBundle.getMessage(TreeSharingOptionsPanel.class, (String)"MENU_EraseAllItems"));
            this.eraseAllItems.addActionListener(actionListener);
            this.add(this.eraseAllItems);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"", ""};
        Object[][] data = new Object[0][2];

        private MyTableModel(Map<String, Boolean> map) {
            this.data = new Object[map.size()][2];
            int i = 0;
            for (String item : map.keySet()) {
                this.data[i][0] = map.get(item);
                this.data[i][1] = item;
                ++i;
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.data.length > 0) {
                return this.data[row][col];
            }
            return null;
        }

        public Class getColumnClass(int c) {
            return c == 0 ? Boolean.class : String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }

    class JComponentTableCellRenderer
    implements TableCellRenderer {
        JComponentTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (JComponent)value;
        }
    }
}

