/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.treesharing.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class DesktopScrollPane
extends JScrollPane {
    private final JDesktopPane desktopPane;
    private final InternalFrameComponentListener componentListener = new InternalFrameComponentListener();

    public DesktopScrollPane(JDesktopPane desktopPane) {
        this.desktopPane = desktopPane;
        desktopPane.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                DesktopScrollPane.this.onComponentAdded(e);
            }

            public void componentRemoved(ContainerEvent e) {
                DesktopScrollPane.this.onComponentRemoved(e);
            }
        });
        this.setViewportView(desktopPane);
        this.setVerticalScrollBarPolicy(20);
        this.setHorizontalScrollBarPolicy(30);
    }

    private void onComponentRemoved(ContainerEvent event) {
        Component removedComponent = event.getChild();
        if (removedComponent instanceof JInternalFrame) {
            removedComponent.removeComponentListener(this.componentListener);
        }
    }

    private void onComponentAdded(ContainerEvent event) {
        Component addedComponent = event.getChild();
        if (addedComponent instanceof JInternalFrame) {
            addedComponent.addComponentListener(this.componentListener);
            this.resizeDesktop();
        }
    }

    public JInternalFrame[] getAllFrames() {
        return this.desktopPane.getAllFrames();
    }

    public void setDesktopSize(Dimension dim) {
        this.desktopPane.setPreferredSize(dim);
        this.desktopPane.revalidate();
    }

    public void resizeDesktop() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int i;
                Rectangle viewPort = DesktopScrollPane.this.getViewport().getViewRect();
                int maxX = viewPort.width + viewPort.x;
                int maxY = viewPort.height + viewPort.y;
                int minX = viewPort.x;
                int minY = viewPort.y;
                JInternalFrame frame = null;
                JInternalFrame[] frames = DesktopScrollPane.this.getAllFrames();
                for (i = 0; i < frames.length; ++i) {
                    frame = frames[i];
                    if (frame.getX() < minX) {
                        minX = frame.getX();
                    }
                    if (frame.getX() + frame.getWidth() > maxX) {
                        maxX = frame.getX() + frame.getWidth();
                    }
                    if (frame.getY() < minY) {
                        minY = frame.getY();
                    }
                    if (frame.getY() + frame.getHeight() <= maxY) continue;
                    maxY = frame.getY() + frame.getHeight();
                }
                if (minX < 0) {
                    minX = 0;
                }
                if (minY < 0) {
                    minY = 0;
                }
                DesktopScrollPane.this.setVisible(false);
                if (minX != 0 || minY != 0) {
                    for (i = 0; i < frames.length; ++i) {
                        frame = frames[i];
                        frame.setLocation(frame.getX() - minX, frame.getY() - minY);
                    }
                    JViewport view = DesktopScrollPane.this.getViewport();
                    view.setViewSize(new Dimension(maxX - minX, maxY - minY));
                    view.setViewPosition(new Point(viewPort.x - minX, viewPort.y - minY));
                    DesktopScrollPane.this.setViewport(view);
                }
                DesktopScrollPane.this.setDesktopSize(new Dimension(maxX - minX, maxY - minY));
                DesktopScrollPane.this.setVisible(true);
                DesktopScrollPane.this.repaint();
                DesktopScrollPane.this.desktopPane.revalidate();
                DesktopScrollPane.this.desktopPane.repaint();
            }
        });
    }

    private class InternalFrameComponentListener
    implements ComponentListener {
        private InternalFrameComponentListener() {
        }

        public void componentResized(ComponentEvent e) {
            DesktopScrollPane.this.resizeDesktop();
        }

        public void componentMoved(ComponentEvent e) {
            DesktopScrollPane.this.resizeDesktop();
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentHidden(ComponentEvent e) {
        }
    }
}

