/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.treesharing.panels;

import ancestris.modules.treesharing.communication.EntityConversion;
import ancestris.modules.treesharing.options.TreeSharingOptionsPanel;
import ancestris.modules.treesharing.panels.AncestrisFriend;
import ancestris.modules.treesharing.panels.EntityBean;
import ancestris.modules.treesharing.panels.MatchData;
import genj.gedcom.Entity;
import genj.gedcom.Indi;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.plaf.basic.BasicComboBoxUI;
import org.apache.commons.lang.StringEscapeUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntitiesListPanel
extends JPanel {
    private final Set<MatchData> list;
    private StringBuffer textToPaste;
    private static final int IMG_MEDIUM_WIDTH = 51;
    private static final int ITEMS_PER_PAGE = 50;
    private final ImageIcon DEFPROF_PHOTO = new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/nophoto.png"));
    private static final ImageIcon nophoto = new ImageIcon(ImageUtilities.loadImage((String)"ancestris/modules/treesharing/resources/nophoto.png"));
    private static final ImageIcon ArrowButton = new ImageIcon(ImageUtilities.loadImage((String)"ancestris/modules/treesharing/resources/dropdownarrow.png"));
    private static final ImageIcon AllMembers = new ImageIcon(ImageUtilities.loadImage((String)"ancestris/modules/treesharing/resources/allMembers.png"));
    private static final String allGedcoms = NbBundle.getMessage(EntitiesListPanel.class, (String)"STR_AllGedcoms");
    private static final String allMembers = NbBundle.getMessage(EntitiesListPanel.class, (String)"STR_AllMembers");
    private SortedSet<String> myGedcoms = new TreeSet<String>();
    private SortedSet<String> memberGedcoms = new TreeSet<String>();
    private TreeMap<String, ImageIcon> members = new TreeMap();
    private String[] arrayMyGedcoms;
    private String[] arrayMemberGedcoms;
    private ImageIcon[] arrayMemberIcons;
    private String[] arrayMemberStrings;
    private TreeMap<String, MatchData> sortedMatches = new TreeMap();
    private int currentPage = 0;
    private boolean busy = false;
    private JButton copyButton;
    private JCheckBox famCheckBox;
    private JLabel famPictoLabel;
    private JButton firstButton;
    private JComboBox gedcomMeComboBox;
    private JComboBox gedcomOtherComboBox;
    private JCheckBox indiCheckBox;
    private JLabel indiPictoLabel;
    private JPanel jPanel1;
    private JButton lastButton;
    private JButton nextButton;
    private JLabel pageLabel;
    private JLabel photoMeLabel;
    private JComboBox photoOtherComboBox;
    private JButton previousButton;
    private JLabel pseudoMeLabel;
    private JLabel pseudoOtherLabel;
    private JScrollPane resultScrollPane;
    private JLabel totalLabel;

    public EntitiesListPanel(String gedcomName, String friend, Set<MatchData> list, String typeOfEntity) {
        this.list = list;
        this.textToPaste = new StringBuffer("");
        this.initComponents();
        this.resultScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.resultScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        this.photoOtherComboBox.setUI(new BasicComboBoxUI(){

            protected JButton createArrowButton() {
                return new JButton(){

                    public int getWidth() {
                        return 20;
                    }

                    public int getX() {
                        return 52;
                    }

                    public Icon getIcon() {
                        return ArrowButton;
                    }
                };
            }
        });
        this.pseudoMeLabel.setText(TreeSharingOptionsPanel.getPseudo());
        ImageIcon myPhoto = TreeSharingOptionsPanel.getProfile().photoBytes == null ? this.DEFPROF_PHOTO : TreeSharingOptionsPanel.getPhoto(2, TreeSharingOptionsPanel.getProfile().photoBytes);
        this.photoMeLabel.setIcon(myPhoto);
        this.busy = true;
        this.indiCheckBox.setSelected(typeOfEntity.equals("INDI"));
        this.famCheckBox.setSelected(typeOfEntity.equals("FAM"));
        this.buildFilteredLists(gedcomName, friend);
        this.updatePanelDisplay();
        this.busy = false;
        this.getInputMap(2).put(KeyStroke.getKeyStroke(38, 128), "doFirst");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(37, 128), "doPrevious");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(39, 128), "doNext");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(40, 128), "doLast");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(155, 128), "doCopy");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(67, 128), "doCopy");
        AbstractAction firstAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (EntitiesListPanel.this.firstButton.isEnabled()) {
                    EntitiesListPanel.this.firstButton.requestFocusInWindow();
                    EntitiesListPanel.this.firstButtonActionPerformed(e);
                }
            }
        };
        AbstractAction previousAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (EntitiesListPanel.this.previousButton.isEnabled()) {
                    EntitiesListPanel.this.previousButton.requestFocusInWindow();
                    EntitiesListPanel.this.previousButtonActionPerformed(e);
                }
            }
        };
        AbstractAction nextAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (EntitiesListPanel.this.nextButton.isEnabled()) {
                    EntitiesListPanel.this.nextButton.requestFocusInWindow();
                    EntitiesListPanel.this.nextButtonActionPerformed(e);
                }
            }
        };
        AbstractAction lastAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (EntitiesListPanel.this.lastButton.isEnabled()) {
                    EntitiesListPanel.this.lastButton.requestFocusInWindow();
                    EntitiesListPanel.this.lastButtonActionPerformed(e);
                }
            }
        };
        AbstractAction copyAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (EntitiesListPanel.this.copyButton.isEnabled()) {
                    EntitiesListPanel.this.copyButton.requestFocusInWindow();
                    EntitiesListPanel.this.copyButtonActionPerformed(e);
                }
            }
        };
        this.getActionMap().put("doFirst", firstAction);
        this.getActionMap().put("doPrevious", previousAction);
        this.getActionMap().put("doNext", nextAction);
        this.getActionMap().put("doLast", lastAction);
        this.getActionMap().put("doCopy", copyAction);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(33, 0), "doPageUp");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(34, 0), "doPageDown");
        AbstractAction pageupAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                EntitiesListPanel.this.resultScrollPane.getVerticalScrollBar().setValue(EntitiesListPanel.this.resultScrollPane.getVerticalScrollBar().getValue() - 60);
            }
        };
        this.getActionMap().put("doPageUp", pageupAction);
        AbstractAction pagedownAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                EntitiesListPanel.this.resultScrollPane.getVerticalScrollBar().setValue(EntitiesListPanel.this.resultScrollPane.getVerticalScrollBar().getValue() + 60);
            }
        };
        this.getActionMap().put("doPageDown", pagedownAction);
    }

    private void initComponents() {
        this.photoMeLabel = new JLabel();
        this.pseudoMeLabel = new JLabel();
        this.indiCheckBox = new JCheckBox();
        this.indiPictoLabel = new JLabel();
        this.gedcomMeComboBox = new JComboBox();
        this.famPictoLabel = new JLabel();
        this.famCheckBox = new JCheckBox();
        this.pseudoOtherLabel = new JLabel();
        this.gedcomOtherComboBox = new JComboBox();
        this.photoOtherComboBox = new JComboBox();
        this.resultScrollPane = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.firstButton = new JButton();
        this.previousButton = new JButton();
        this.nextButton = new JButton();
        this.lastButton = new JButton();
        this.copyButton = new JButton();
        this.pageLabel = new JLabel();
        this.totalLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.photoMeLabel, (String)NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.photoMeLabel.text"));
        this.photoMeLabel.setBorder(BorderFactory.createEtchedBorder());
        this.photoMeLabel.setOpaque(true);
        Mnemonics.setLocalizedText((JLabel)this.pseudoMeLabel, (String)NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.pseudoMeLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.indiCheckBox, (String)NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.indiCheckBox.text"));
        this.indiCheckBox.setToolTipText(NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.indiCheckBox.toolTipText"));
        this.indiCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntitiesListPanel.this.indiCheckBoxActionPerformed(evt);
            }
        });
        this.indiPictoLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/Indi.png")));
        Mnemonics.setLocalizedText((JLabel)this.indiPictoLabel, (String)NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.indiPictoLabel.text"));
        this.indiPictoLabel.setToolTipText(NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.indiPictoLabel.toolTipText"));
        this.gedcomMeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntitiesListPanel.this.gedcomMeComboBoxActionPerformed(evt);
            }
        });
        this.famPictoLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/Fam.png")));
        Mnemonics.setLocalizedText((JLabel)this.famPictoLabel, (String)NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.famPictoLabel.text"));
        this.famPictoLabel.setToolTipText(NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.famPictoLabel.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.famCheckBox, (String)NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.famCheckBox.text"));
        this.famCheckBox.setToolTipText(NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.famCheckBox.toolTipText"));
        this.famCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntitiesListPanel.this.famCheckBoxActionPerformed(evt);
            }
        });
        this.pseudoOtherLabel.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.pseudoOtherLabel, (String)NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.pseudoOtherLabel.text"));
        this.gedcomOtherComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntitiesListPanel.this.gedcomOtherComboBoxActionPerformed(evt);
            }
        });
        this.photoOtherComboBox.setToolTipText(NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.photoOtherComboBox.toolTipText"));
        this.photoOtherComboBox.setBorder(BorderFactory.createEtchedBorder());
        this.photoOtherComboBox.setMinimumSize(new Dimension(51, 62));
        this.photoOtherComboBox.setPreferredSize(new Dimension(51, 62));
        this.photoOtherComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntitiesListPanel.this.photoOtherComboBoxActionPerformed(evt);
            }
        });
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 2));
        this.resultScrollPane.setViewportView(this.jPanel1);
        this.firstButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/first.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.firstButton, (String)NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.firstButton.text"));
        this.firstButton.setToolTipText(NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.firstButton.toolTipText"));
        this.firstButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntitiesListPanel.this.firstButtonActionPerformed(evt);
            }
        });
        this.previousButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/previous.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.previousButton, (String)NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.previousButton.text"));
        this.previousButton.setToolTipText(NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.previousButton.toolTipText"));
        this.previousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntitiesListPanel.this.previousButtonActionPerformed(evt);
            }
        });
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/next.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.nextButton, (String)NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.nextButton.text"));
        this.nextButton.setToolTipText(NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.nextButton.toolTipText"));
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntitiesListPanel.this.nextButtonActionPerformed(evt);
            }
        });
        this.lastButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/last.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.lastButton, (String)NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.lastButton.text"));
        this.lastButton.setToolTipText(NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.lastButton.toolTipText"));
        this.lastButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntitiesListPanel.this.lastButtonActionPerformed(evt);
            }
        });
        this.copyButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/Copy.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.copyButton, (String)NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.copyButton.text"));
        this.copyButton.setToolTipText(NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.copyButton.toolTipText"));
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EntitiesListPanel.this.copyButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.pageLabel, (String)NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.pageLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.totalLabel, (String)NbBundle.getMessage(EntitiesListPanel.class, (String)"EntitiesListPanel.totalLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.photoMeLabel, -2, 51, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pseudoMeLabel, -1, 102, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 73, Short.MAX_VALUE).addComponent(this.indiCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.indiPictoLabel)).addComponent(this.gedcomMeComboBox, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.famPictoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.famCheckBox).addGap(33, 33, 33).addComponent(this.pseudoOtherLabel, -1, 159, Short.MAX_VALUE)).addComponent(this.gedcomOtherComboBox, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.photoOtherComboBox, -2, 74, -2)).addComponent(this.resultScrollPane).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pageLabel).addComponent(this.totalLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.firstButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.previousButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lastButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.photoMeLabel, -2, 62, -2).addComponent(this.photoOtherComboBox, -2, -1, -2).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.famCheckBox).addComponent(this.famPictoLabel).addComponent(this.indiCheckBox).addComponent(this.indiPictoLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.gedcomMeComboBox, -2, -1, -2).addComponent(this.gedcomOtherComboBox, -2, -1, -2))).addGroup(layout.createSequentialGroup().addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pseudoOtherLabel).addComponent(this.pseudoMeLabel)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultScrollPane, -1, 290, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.copyButton).addComponent(this.lastButton).addComponent(this.nextButton).addComponent(this.previousButton).addComponent(this.firstButton)).addGroup(layout.createSequentialGroup().addComponent(this.totalLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pageLabel))).addContainerGap()));
    }

    private void photoOtherComboBoxActionPerformed(ActionEvent evt) {
        if (!this.busy) {
            this.updatePanelDisplay();
        }
    }

    private void gedcomMeComboBoxActionPerformed(ActionEvent evt) {
        if (!this.busy) {
            this.updatePanelDisplay();
        }
    }

    private void gedcomOtherComboBoxActionPerformed(ActionEvent evt) {
        if (!this.busy) {
            this.updatePanelDisplay();
        }
    }

    private void indiCheckBoxActionPerformed(ActionEvent evt) {
        if (!this.busy) {
            this.updatePanelDisplay();
        }
    }

    private void famCheckBoxActionPerformed(ActionEvent evt) {
        if (!this.busy) {
            this.updatePanelDisplay();
        }
    }

    private void firstButtonActionPerformed(ActionEvent evt) {
        this.currentPage = 0;
        this.displayPage();
    }

    private void previousButtonActionPerformed(ActionEvent evt) {
        --this.currentPage;
        if (this.currentPage < 0) {
            this.currentPage = 0;
        }
        this.displayPage();
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        ++this.currentPage;
        if (this.currentPage > this.getMaxPageNb()) {
            this.currentPage = this.getMaxPageNb();
        }
        this.displayPage();
    }

    private void lastButtonActionPerformed(ActionEvent evt) {
        this.currentPage = this.getMaxPageNb();
        this.displayPage();
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        String str = this.textToPaste.toString();
        StringSelection stringSelection = new StringSelection(str);
        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
        clpbrd.setContents(stringSelection, null);
    }

    private void buildFilteredLists(String gedcomName, String friend) {
        this.myGedcoms.clear();
        this.members.clear();
        this.memberGedcoms.clear();
        this.myGedcoms.add(allGedcoms);
        this.members.put(allMembers, AllMembers);
        this.memberGedcoms.add(allGedcoms);
        String iGedcomName = "";
        String iFriend = "";
        String iMemberGedcomName = "";
        for (MatchData line : this.list) {
            iGedcomName = line.myEntity.getGedcom().getName();
            if (!this.myGedcoms.contains(iGedcomName)) {
                this.myGedcoms.add(iGedcomName);
            }
            if (!this.members.containsKey(iFriend = line.friendGedcomEntity.friend)) {
                ImageIcon icon;
                AncestrisFriend af = line.friendGedcomEntity.afriend;
                ImageIcon imageIcon = af != null ? (af.getFriendProfile() != null ? TreeSharingOptionsPanel.getPhoto(2, af.getFriendProfile().photoBytes) : null) : (icon = null);
                if (icon == null) {
                    icon = nophoto;
                }
                this.members.put(iFriend, icon);
            }
            if (this.memberGedcoms.contains(iMemberGedcomName = line.friendGedcomEntity.gedcomName)) continue;
            this.memberGedcoms.add(iMemberGedcomName);
        }
        this.arrayMyGedcoms = this.myGedcoms.toArray(new String[this.myGedcoms.size()]);
        this.arrayMemberStrings = this.members.keySet().toArray(new String[this.members.keySet().size()]);
        this.arrayMemberIcons = this.members.values().toArray(new ImageIcon[this.members.values().size()]);
        this.arrayMemberGedcoms = this.memberGedcoms.toArray(new String[this.memberGedcoms.size()]);
        this.gedcomMeComboBox.setModel(new DefaultComboBoxModel<String>(this.arrayMyGedcoms));
        this.photoOtherComboBox.setModel(new DefaultComboBoxModel<ImageIcon>(this.arrayMemberIcons));
        this.gedcomOtherComboBox.setModel(new DefaultComboBoxModel<String>(this.arrayMemberGedcoms));
        this.gedcomMeComboBox.setSelectedItem(gedcomName);
        this.photoOtherComboBox.setSelectedItem(this.members.get(friend) == null ? AllMembers : this.members.get(friend));
        this.gedcomOtherComboBox.setSelectedItem(allGedcoms);
    }

    private boolean match(String type, String gedcomName, String friend, String memberGedcomName, String iType, String iGedcomName, String iFriend, String iMemberGedcomName) {
        String gn = gedcomName;
        String f = friend;
        String mgn = memberGedcomName;
        if (type == null || type.isEmpty()) {
            type = iType;
        }
        if (gn == null || gn.isEmpty() || gn.equals(allGedcoms)) {
            gn = iGedcomName;
        }
        if (f == null || f.isEmpty() || f.equals(allMembers)) {
            f = iFriend;
        }
        if (mgn == null || mgn.isEmpty() || mgn.equals(allGedcoms)) {
            mgn = iMemberGedcomName;
        }
        return type.equals(iType) && gn.equals(iGedcomName) && f.equals(iFriend) && mgn.equals(iMemberGedcomName);
    }

    private void updatePanelDisplay() {
        this.sortedMatches.clear();
        this.pseudoOtherLabel.setText(this.arrayMemberStrings[this.photoOtherComboBox.getSelectedIndex()]);
        String type = "";
        if (this.indiCheckBox.isSelected() && !this.famCheckBox.isSelected()) {
            type = "INDI";
        }
        if (!this.indiCheckBox.isSelected() && this.famCheckBox.isSelected()) {
            type = "FAM";
        }
        String gedcomName = this.arrayMyGedcoms[this.gedcomMeComboBox.getSelectedIndex()];
        String friend = this.arrayMemberStrings[this.photoOtherComboBox.getSelectedIndex()];
        String memberGedcomName = this.arrayMemberGedcoms[this.gedcomOtherComboBox.getSelectedIndex()];
        String key = "";
        String iType = "";
        String iGedcomName = "";
        String iFriend = "";
        String iMemberGedcomName = "";
        for (MatchData line : this.list) {
            iType = line.myEntity instanceof Indi ? "INDI" : "FAM";
            if (!this.match(type, gedcomName, friend, memberGedcomName, iType, iGedcomName = line.myEntity.getGedcom().getName(), iFriend = line.friendGedcomEntity.friend, iMemberGedcomName = line.friendGedcomEntity.gedcomName)) continue;
            key = line.matchResult + "-" + line.myEntity.getGedcom().getName() + "-" + line.myEntity.getId() + "-" + iFriend + "-" + iGedcomName + "-" + line.friendGedcomEntity.entityID;
            this.sortedMatches.put(key, line);
        }
        this.currentPage = 0;
        this.displayPage();
    }

    private List<String> getPageKeys() {
        ArrayList<String> ret = new ArrayList<String>();
        int item = 0;
        for (String key : this.sortedMatches.keySet()) {
            if (item / 50 == this.currentPage) {
                ret.add(key);
                if (ret.size() == 50) break;
            }
            ++item;
        }
        return ret;
    }

    private void displayPage() {
        this.textToPaste.delete(0, this.textToPaste.length());
        this.jPanel1.removeAll();
        this.jPanel1.repaint();
        this.updateButtons();
        if (this.sortedMatches.isEmpty()) {
            return;
        }
        BoxLayout layout = new BoxLayout(this.jPanel1, 3);
        this.jPanel1.setLayout(layout);
        String group = "";
        String strItem = "";
        String str = "";
        Entity currentEntity = null;
        LinkedList<MatchData> subList = new LinkedList<MatchData>();
        int i = 0;
        for (String key : this.getPageKeys()) {
            MatchData line = this.sortedMatches.get(key);
            this.textToPaste.append(this.convertToText(line));
            strItem = EntityConversion.getStringFromEntity(line.myEntity, false);
            if (!group.equals(strItem)) {
                if (i == 0) {
                    group = strItem;
                    currentEntity = line.myEntity;
                } else {
                    this.addEntityBloc(currentEntity, subList);
                    group = strItem;
                    currentEntity = line.myEntity;
                }
                i = 0;
                subList.clear();
            }
            ++i;
            subList.add(line);
        }
        if (i != 0) {
            this.addEntityBloc(currentEntity, subList);
        }
        this.jPanel1.repaint();
        this.jPanel1.validate();
    }

    private void addEntityBloc(Entity currentEntity, List<MatchData> subList) {
        EntityBean bean = new EntityBean(currentEntity, subList);
        this.jPanel1.add(bean);
    }

    private StringBuffer convertToText(MatchData line) {
        StringBuffer sb = new StringBuffer("");
        sb.append(line.myEntity.getGedcom().getName());
        sb.append("\t");
        sb.append(StringEscapeUtils.unescapeHtml((String)EntityConversion.getStringFromEntity(line.myEntity, false)));
        sb.append("\t");
        sb.append(StringEscapeUtils.unescapeHtml((String)EntityConversion.getStringFromEntity(line.friendGedcomEntity, false)));
        sb.append("\t");
        sb.append(line.friendGedcomEntity.gedcomName);
        sb.append("\t");
        sb.append(line.friendGedcomEntity.friend);
        sb.append("\t");
        sb.append(line.matchResult);
        sb.append("\n");
        return sb;
    }

    private void updateButtons() {
        this.totalLabel.setText(NbBundle.getMessage(EntitiesListPanel.class, (String)"totalMatch", (Object)this.sortedMatches.size(), (Object)50));
        this.pageLabel.setText(NbBundle.getMessage(EntitiesListPanel.class, (String)"currentPage", (Object)(this.currentPage + 1), (Object)(this.getMaxPageNb() + 1)));
        boolean first = this.currentPage == 0;
        boolean listNotEmpty = !this.sortedMatches.isEmpty();
        boolean last = this.currentPage == this.getMaxPageNb();
        this.copyButton.setEnabled(listNotEmpty);
        this.firstButton.setEnabled(!first);
        this.previousButton.setEnabled(!first);
        this.nextButton.setEnabled(!last);
        this.lastButton.setEnabled(!last);
    }

    private int getMaxPageNb() {
        return this.sortedMatches.size() / 50;
    }
}

