/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.treesharing.panels;

import ancestris.modules.treesharing.TreeSharingTopComponent;
import ancestris.modules.treesharing.communication.MemberProfile;
import ancestris.modules.treesharing.options.TreeSharingOptionsPanel;
import ancestris.modules.treesharing.panels.ProfilePanel;
import ancestris.modules.treesharing.panels.StatsData;
import ancestris.util.swing.DialogManager;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsPanel
extends JPanel {
    private static int NBCOLUMNS = 6;
    private final TreeSharingTopComponent owner;
    private final Map<String, StatsData> list;
    private static final SimpleDateFormat formatter = new SimpleDateFormat("d-MMM-yyyy HH:mm");
    private JButton jButton1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JTable jTable2;

    public StatsPanel(final Map<String, StatsData> list, TreeSharingTopComponent tstc) {
        this.owner = tstc;
        this.list = list;
        this.initComponents();
        this.formatTable(this.jTable1);
        this.formatTable(this.jTable2);
        ((JLabel)((Object)this.jTable1.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(0);
        Dimension preferredSize = this.jTable1.getPreferredSize();
        preferredSize.height = list.size() * this.jTable1.getRowHeight();
        this.jTable1.setPreferredSize(preferredSize);
        this.jTable1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                int row = StatsPanel.this.jTable1.rowAtPoint(evt.getPoint());
                int col = StatsPanel.this.jTable1.columnAtPoint(evt.getPoint());
                if (row >= 0 && col == 5) {
                    String pseudo = StatsPanel.this.jTable1.getModel().getValueAt(row, 1).toString();
                    MemberProfile mp = ((StatsData)list.get((Object)((StatsPanel)StatsPanel.this).jTable1.getModel().getValueAt((int)row, (int)1))).profile;
                    if (mp == null) {
                        return;
                    }
                    DialogManager.create((String)NbBundle.getMessage(StatsPanel.class, (String)"TITL_ProfilePanel", (Object)pseudo), (JComponent)new ProfilePanel(mp, StatsPanel.this.owner.getMyProfile())).setMessageType(-1).setResizable(false).setDialogId("profilpanel").setOptionType(10).show();
                }
            }
        });
        this.jTable2.setTableHeader(null);
        Dimension preferredSize2 = this.jTable2.getPreferredSize();
        preferredSize2.height = this.jTable2.getRowHeight();
        this.jTable2.setPreferredSize(preferredSize2);
        this.jTable2.setShowGrid(false);
        this.jTable2.setOpaque(false);
        ((DefaultTableCellRenderer)this.jTable2.getDefaultRenderer(Object.class)).setOpaque(false);
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jScrollPane1 = new JScrollPane();
        this.jTable2 = new JTable();
        this.jButton1 = new JButton();
        this.setPreferredSize(new Dimension(700, 212));
        this.jTable1.setModel(new MyTableModel(this.list));
        this.jTable1.setColumnSelectionAllowed(true);
        this.jTable1.setPreferredSize(new Dimension(720, 100));
        this.jScrollPane2.setViewportView(this.jTable1);
        this.jTable1.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.jTable2.setModel(new MyFooterModel(this.list));
        this.jScrollPane1.setViewportView(this.jTable2);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/reset.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.jButton1.text"));
        this.jButton1.setToolTipText(NbBundle.getMessage(StatsPanel.class, (String)"StatsPanel.jButton1.toolTipText"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                StatsPanel.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 688, Short.MAX_VALUE).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jButton1, -2, 38, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 119, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 48, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addContainerGap()));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.owner.setResetStats();
    }

    private void formatTable(JTable table) {
        table.setAutoCreateRowSorter(true);
        table.getColumnModel().getColumn(0).setPreferredWidth(50);
        table.getColumnModel().getColumn(1).setPreferredWidth(150);
        table.getColumnModel().getColumn(2).setPreferredWidth(40);
        table.getColumnModel().getColumn(3).setPreferredWidth(160);
        table.getColumnModel().getColumn(4).setPreferredWidth(160);
        table.getColumnModel().getColumn(5).setPreferredWidth(50);
        table.setFillsViewportHeight(true);
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        table.getColumnModel().getColumn(0).setCellRenderer(centerRenderer);
        table.getColumnModel().getColumn(1).setCellRenderer(centerRenderer);
        table.getColumnModel().getColumn(3).setCellRenderer(centerRenderer);
        table.getColumnModel().getColumn(4).setCellRenderer(centerRenderer);
        if (table == this.jTable2) {
            table.getColumnModel().getColumn(1).setCellRenderer(centerRenderer);
            table.getColumnModel().getColumn(2).setCellRenderer(centerRenderer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyFooterModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"", "", "", "", "", ""};
        Object[][] data;

        private MyFooterModel(Map<String, StatsData> list) {
            if (list == null || list.isEmpty()) {
                this.data = new Object[1][NBCOLUMNS];
                return;
            }
            this.data = new Object[list.size()][NBCOLUMNS];
            int iConnections = 0;
            int iMember = 0;
            Date minDate = null;
            Date maxDate = null;
            for (String member : list.keySet()) {
                StatsData stats = list.get(member);
                iConnections += stats.connections;
                if (stats.match) {
                    ++iMember;
                }
                if (minDate == null || list.get((Object)member).startDate.compareTo(minDate) < 0) {
                    minDate = list.get((Object)member).startDate;
                }
                if (maxDate != null && list.get((Object)member).endDate.compareTo(maxDate) <= 0) continue;
                maxDate = list.get((Object)member).endDate;
            }
            this.data[0][0] = iConnections;
            this.data[0][1] = list.size();
            this.data[0][2] = iMember;
            this.data[0][3] = formatter.format(minDate);
            this.data[0][4] = formatter.format(maxDate);
            this.data[0][5] = "";
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyTableModel
    extends AbstractTableModel {
        private final ImageIcon NOPROFILE = new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/nophotosmall.png"));
        private String[] columnNames = new String[]{NbBundle.getMessage(StatsData.class, (String)"COL_connections"), NbBundle.getMessage(StatsData.class, (String)"COL_member"), NbBundle.getMessage(StatsData.class, (String)"COL_match"), NbBundle.getMessage(StatsData.class, (String)"COL_startDate"), NbBundle.getMessage(StatsData.class, (String)"COL_endDate"), NbBundle.getMessage(StatsData.class, (String)"COL_profile")};
        private Object[][] data;

        private MyTableModel(Map<String, StatsData> list) {
            if (list == null || list.isEmpty()) {
                this.data = new Object[1][NBCOLUMNS];
                return;
            }
            this.data = new Object[list.size()][NBCOLUMNS];
            int i = 0;
            for (String member : list.keySet()) {
                this.data[i][0] = list.get((Object)member).connections;
                this.data[i][1] = member;
                this.data[i][2] = list.get((Object)member).match;
                this.data[i][3] = formatter.format(list.get((Object)member).startDate);
                this.data[i][4] = formatter.format(list.get((Object)member).endDate);
                MemberProfile mpf = list.get((Object)member).profile;
                this.data[i][5] = mpf != null && mpf.photoBytes != null ? TreeSharingOptionsPanel.getPhoto(1, mpf.photoBytes) : this.NOPROFILE;
                ++i;
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c) != null ? this.getValueAt(0, c).getClass() : String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }
}

