/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.treesharing.panels;

import ancestris.modules.treesharing.TreeSharingTopComponent;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SpinnerDateModel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.time.DateUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TimerPanel
extends JPanel {
    public static int DEFAULT_DELAY = 12;
    private final TreeSharingTopComponent owner;
    private boolean stateBeingChanged = false;
    private JToolTip jToolTip = null;
    private ActionListener hider = null;
    private Popup popup = null;
    private Timer timer = null;
    private JButton jButton1;
    private JSpinner jSpinner1;

    public TimerPanel(TreeSharingTopComponent tstc) {
        this.owner = tstc;
        this.initComponents();
        this.jSpinner1.setEditor(new JSpinner.DateEditor(this.jSpinner1, "d-MMM-yyyy HH:mm"));
        ((JSpinner.DefaultEditor)this.jSpinner1.getEditor()).getTextField().setHorizontalAlignment(0);
        this.initPopup();
        this.setTimerDate(DEFAULT_DELAY);
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jSpinner1 = new JSpinner();
        this.setPreferredSize(new Dimension(186, 30));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/treesharing/resources/timer.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(TimerPanel.class, (String)"TimerPanel.jButton1.text"));
        this.jButton1.setToolTipText(NbBundle.getMessage(TimerPanel.class, (String)"TimerPanel.jButton1.toolTipText"));
        this.jButton1.setPreferredSize(new Dimension(46, 28));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimerPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jSpinner1.setFont(new Font("DejaVu Sans", 0, 11));
        this.jSpinner1.setModel(new SpinnerDateModel(new Date(), null, null, 10));
        this.jSpinner1.setToolTipText(NbBundle.getMessage(TimerPanel.class, (String)"TimerPanel.jSpinner1.toolTipText", (Object)DEFAULT_DELAY));
        this.jSpinner1.setPreferredSize(new Dimension(160, 26));
        this.jSpinner1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                TimerPanel.this.jSpinner1StateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButton1, -2, 34, -2).addGap(2, 2, 2).addComponent(this.jSpinner1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jButton1, -2, -1, -2).addComponent(this.jSpinner1, -2, 28, -2))));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.jSpinner1.setValue(new Date());
    }

    private void jSpinner1StateChanged(ChangeEvent evt) {
        if (!this.stateBeingChanged) {
            this.stateBeingChanged = true;
            Date date = (Date)this.jSpinner1.getValue();
            if (date.before(new Date())) {
                this.jSpinner1.setValue(new Date());
            }
            this.owner.resetTimer();
            this.stateBeingChanged = false;
        }
    }

    public void setTimerEnabled(boolean b) {
        this.jButton1.setEnabled(b);
        this.jSpinner1.setEnabled(b);
    }

    public Date getTimerDate() {
        return (Date)this.jSpinner1.getValue();
    }

    public void setTimerDate(int hours) {
        Date date = DateUtils.addHours((Date)new Date(), (int)hours);
        this.jSpinner1.setValue(date);
    }

    public final void initPopup() {
        this.jToolTip = new JToolTip();
        this.jToolTip.setTipText(NbBundle.getMessage(TimerPanel.class, (String)"TIP_DelayTooShort"));
        this.hider = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TimerPanel.this.popup.hide();
            }
        };
        this.timer = new Timer(3000, this.hider);
    }

    public void setFocus() {
        int x = (int)this.getLocationOnScreen().getX();
        int y = (int)this.getLocationOnScreen().getY();
        this.popup = PopupFactory.getSharedInstance().getPopup(this, this.jToolTip, x + 60, y + 30);
        this.popup.show();
        this.timer.start();
    }
}

