/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.removetag;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.modules.gedcom.removetag.RemoveTagPanel;
import ancestris.modules.gedcom.utilities.GedcomUtilities;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.UnitOfWork;
import java.awt.event.ActionEvent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class RemoveTagAction
extends AbstractAncestrisContextAction {
    public RemoveTagAction() {
        this.setImage("ancestris/modules/gedcom/removetag/RemoveTagIcon.png");
        this.setText(NbBundle.getMessage(RemoveTagAction.class, (String)"CTL_RemoveTagAction"));
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
        RemoveTagPanel removeTagPanel = new RemoveTagPanel();
        Context contextToOpen = this.getContext();
        if (contextToOpen != null) {
            Gedcom gedcom = contextToOpen.getGedcom();
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)removeTagPanel, NbBundle.getMessage(RemoveTagAction.class, (String)"CTL_RemoveTagAction"), 2, 3, null, NotifyDescriptor.OK_OPTION);
            if (DialogDisplayer.getDefault().notify(notifyDescriptor) == NotifyDescriptor.OK_OPTION) {
                final String tag = removeTagPanel.getTag();
                final int selectedentity = removeTagPanel.getSelectedEntityIndex();
                try {
                    gedcom.doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            GedcomUtilities.deleteTags((Gedcom)gedcom, (String)tag, (int)selectedentity);
                        }
                    });
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RemoveTagAction.class, (String)"RemoveTagAction.done", (Object)tag, (Object)removeTagPanel.getSelectedEntityItem()), 1));
            }
        }
    }
}

