/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.commonAncestor.graphics;

import ancestris.modules.commonAncestor.graphics.GraphicsFileOutput;
import ancestris.modules.commonAncestor.graphics.IGraphicsOutput;
import ancestris.modules.commonAncestor.graphics.PdfWriter;
import ancestris.modules.commonAncestor.graphics.PngWriter;
import ancestris.modules.commonAncestor.graphics.ScreenOutput;
import ancestris.modules.commonAncestor.graphics.SvgWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GraphicsOutputFactory {
    public String[] output_types = null;
    private Map<String, IGraphicsOutput> outputs = new LinkedHashMap<String, IGraphicsOutput>();
    public List<IGraphicsOutput> outputList = new ArrayList<IGraphicsOutput>();

    public GraphicsOutputFactory() {
        this.add("pdf", new PdfWriter());
        this.add("png", new PngWriter());
        this.add("svg", new SvgWriter());
        this.add("screen", new ScreenOutput());
    }

    public IGraphicsOutput createOutput(File file, String fileTypeName) {
        IGraphicsOutput output = this.outputs.get(fileTypeName);
        if (output == null) {
            return null;
        }
        if (output instanceof GraphicsFileOutput) {
            GraphicsFileOutput fileOutput = (GraphicsFileOutput)output;
            String extension = fileOutput.getFileExtension();
            if (file == null) {
                return null;
            }
            String suffix = "." + extension;
            if (!file.getPath().endsWith(suffix)) {
                file = new File(file.getPath() + suffix);
            }
            fileOutput.setFile(file);
        }
        return output;
    }

    public void add(String name, IGraphicsOutput output) {
        this.outputs.put(name, output);
        this.outputList.add(output);
        this.output_types = this.outputs.keySet().toArray(new String[0]);
    }

    public Map<String, IGraphicsOutput> getOutputList() {
        return this.outputs;
    }

    public List<String> getFileTypeNames() {
        ArrayList<String> fileOuputNames = new ArrayList<String>();
        for (String fileTypeName : this.outputs.keySet()) {
            if (!(this.outputs.get(fileTypeName) instanceof GraphicsFileOutput)) continue;
            fileOuputNames.add(fileTypeName);
        }
        return fileOuputNames;
    }
}

