/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.commonAncestor.quicksearch.module;

import ancestris.modules.commonAncestor.quicksearch.module.CategoryResult;
import ancestris.modules.commonAncestor.quicksearch.module.CommandEvaluator;
import ancestris.modules.commonAncestor.quicksearch.module.ProviderModel;
import ancestris.modules.commonAncestor.quicksearch.module.QuickSearchPopup;
import ancestris.modules.commonAncestor.quicksearch.module.ResultsModel;
import ancestris.modules.commonAncestor.quicksearch.module.SearchResultRender;
import ancestris.modules.commonAncestor.quicksearch.spi.SearchProvider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public abstract class AbstractQuickSearchComboBar
extends JPanel
implements ActionListener {
    private static final String CATEGORY = "cat";
    public QuickSearchPopup displayer = new QuickSearchPopup(this);
    WeakReference<TopComponent> caller;
    Color origForeground;
    protected final KeyStroke keyStroke;
    private ProviderModel providerModel;
    protected JTextComponent command;

    public AbstractQuickSearchComboBar(KeyStroke ks) {
        this.keyStroke = ks;
        this.initComponents();
        this.setShowHint(true);
        this.command.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent arg0) {
                this.textChanged();
            }

            public void removeUpdate(DocumentEvent arg0) {
                this.textChanged();
            }

            public void changedUpdate(DocumentEvent arg0) {
                this.textChanged();
            }

            private void textChanged() {
                if (AbstractQuickSearchComboBar.this.command.isFocusOwner()) {
                    AbstractQuickSearchComboBar.this.displayer.maybeEvaluate(AbstractQuickSearchComboBar.this.command.getText());
                }
            }
        });
    }

    public AbstractQuickSearchComboBar(String categoryName, String categoryDisplayName, SearchProvider searchProvider, String commandPrefix, KeyStroke ks, int maxResult, int allMaxResult) {
        this.keyStroke = ks;
        this.providerModel = new ProviderModel(categoryName, categoryDisplayName, searchProvider, commandPrefix, maxResult, allMaxResult);
        this.initComponents();
        this.setShowHint(true);
        this.command.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent arg0) {
                this.textChanged();
            }

            public void removeUpdate(DocumentEvent arg0) {
                this.textChanged();
            }

            public void changedUpdate(DocumentEvent arg0) {
                this.textChanged();
            }

            private void textChanged() {
                if (AbstractQuickSearchComboBar.this.command.isFocusOwner()) {
                    AbstractQuickSearchComboBar.this.displayer.maybeEvaluate(AbstractQuickSearchComboBar.this.command.getText());
                }
            }
        });
    }

    public KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    protected abstract JTextComponent createCommandField();

    protected abstract JComponent getInnerComponent();

    private void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setMaximumSize(new Dimension(200, Integer.MAX_VALUE));
        this.setName("Form");
        this.setOpaque(false);
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                AbstractQuickSearchComboBar.this.formFocusLost(evt);
            }
        });
        this.command = this.createCommandField();
        this.command.setToolTipText(NbBundle.getMessage(AbstractQuickSearchComboBar.class, (String)"AbstractQuickSearchComboBar.command.toolTipText", (Object[])new Object[]{"(" + SearchResultRender.getKeyStrokeAsText(this.keyStroke) + ")"}));
        this.command.setName("command");
        this.command.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                AbstractQuickSearchComboBar.this.commandFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                AbstractQuickSearchComboBar.this.commandFocusLost(evt);
            }
        });
        this.command.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                AbstractQuickSearchComboBar.this.commandKeyPressed(evt);
            }
        });
        this.command.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                AbstractQuickSearchComboBar.this.displayer.explicitlyInvoked();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                AbstractQuickSearchComboBar.this.displayer.resizePopup();
            }
        });
    }

    private void formFocusLost(FocusEvent evt) {
        this.displayer.setVisible(false);
    }

    private void commandKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 40) {
            this.displayer.selectNext();
            evt.consume();
        } else if (evt.getKeyCode() == 38) {
            this.displayer.selectPrev();
            evt.consume();
        } else if (evt.getKeyCode() == 10) {
            evt.consume();
            this.invokeSelectedItem();
        } else if (evt.getKeyCode() == 27) {
            this.returnFocus(true);
            this.displayer.clearModel();
        } else if (evt.getKeyCode() == 121 && evt.isShiftDown()) {
            this.maybeShowPopup(null);
        }
    }

    public void invokeSelectedItem() {
        Runnable action;
        JList<ResultsModel.ItemResult> list = this.displayer.getList();
        ResultsModel.ItemResult ir = list.getSelectedValue();
        if (ir != null && (action = ir.getAction()) instanceof CategoryResult) {
            CategoryResult cr = (CategoryResult)action;
            this.evaluateCategory(cr.getCategory(), true);
            return;
        }
        if (list.getModel().getSize() > 0) {
            this.returnFocus(false);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AbstractQuickSearchComboBar.this.displayer.invoke();
                }
            });
        }
    }

    private void returnFocus(boolean force) {
        TopComponent tc;
        this.displayer.setVisible(false);
        if (this.caller != null && (tc = (TopComponent)this.caller.get()) != null) {
            tc.requestActive();
            return;
        }
        if (force) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        }
    }

    private void commandFocusLost(FocusEvent evt) {
        this.displayer.setVisible(false);
        this.setShowHint(true);
    }

    private void commandFocusGained(FocusEvent evt) {
        this.caller = new WeakReference<TopComponent>(TopComponent.getRegistry().getActivated());
        this.setShowHint(false);
        if (CommandEvaluator.isCatTemporary()) {
            CommandEvaluator.setCatTemporary(false);
            CommandEvaluator.setEvalCat(null);
        }
    }

    protected void maybeShowPopup(MouseEvent evt) {
        if (evt != null && !SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        JPopupMenu pm = new JPopupMenu();
        ProviderModel.Category evalCat = null;
        if (!CommandEvaluator.isCatTemporary()) {
            evalCat = CommandEvaluator.getEvalCat();
        }
        JRadioButtonMenuItem allCats = new JRadioButtonMenuItem(NbBundle.getMessage(this.getClass(), (String)"LBL_AllCategories"), evalCat == null);
        allCats.addActionListener(this);
        pm.add(allCats);
        for (ProviderModel.Category cat : this.getProviderModel().getCategories()) {
            if ("Recent".equals(cat.getName())) continue;
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(cat.getDisplayName(), cat == evalCat);
            item.putClientProperty(CATEGORY, cat);
            item.addActionListener(this);
            pm.add(item);
        }
        pm.show(this.getInnerComponent(), 0, this.getInnerComponent().getHeight() - 1);
    }

    public void actionPerformed(ActionEvent e) {
        JRadioButtonMenuItem item = (JRadioButtonMenuItem)e.getSource();
        CommandEvaluator.setEvalCat((ProviderModel.Category)item.getClientProperty(CATEGORY));
        CommandEvaluator.setCatTemporary(false);
        this.setShowHint(!this.command.isFocusOwner());
    }

    public void evaluateCategory(ProviderModel.Category cat, boolean temporary) {
        CommandEvaluator.setEvalCat(cat);
        CommandEvaluator.setCatTemporary(temporary);
        this.displayer.maybeEvaluate(this.command.getText());
    }

    public void setNoResults(boolean areNoResults) {
        if (this.command == null || this.origForeground == null) {
            return;
        }
        if (this.command.getForeground().equals(this.command.getDisabledTextColor())) {
            return;
        }
        this.command.setForeground(areNoResults ? Color.RED : this.origForeground);
    }

    private void setShowHint(boolean showHint) {
        if (this.origForeground == null) {
            this.origForeground = this.command.getForeground();
        }
        if (showHint) {
            this.command.setForeground(this.command.getDisabledTextColor());
            ProviderModel.Category evalCat = CommandEvaluator.getEvalCat();
            if (evalCat != null && !CommandEvaluator.isCatTemporary()) {
                this.command.setText(this.getHintText(evalCat));
            } else {
                this.command.setText(this.getHintText(null));
            }
        } else {
            this.command.setForeground(this.origForeground);
            this.command.setText("");
        }
    }

    private String getHintText(ProviderModel.Category cat) {
        StringBuilder sb = new StringBuilder();
        if (cat != null) {
            sb.append(NbBundle.getMessage(AbstractQuickSearchComboBar.class, (String)"MSG_DiscoverabilityHint2", (Object)cat.getDisplayName()));
        } else {
            sb.append(NbBundle.getMessage(AbstractQuickSearchComboBar.class, (String)"MSG_DiscoverabilityHint"));
        }
        sb.append(" (");
        sb.append(SearchResultRender.getKeyStrokeAsText(this.keyStroke));
        sb.append(")");
        return sb.toString();
    }

    public void requestFocus() {
        super.requestFocus();
        this.command.requestFocus();
    }

    public JTextComponent getCommand() {
        return this.command;
    }

    public int getBottomLineY() {
        return this.getInnerComponent().getY() + this.getInnerComponent().getHeight();
    }

    static Color getComboBorderColor() {
        Color shadow = UIManager.getColor(Utilities.isWindows() ? "Nb.ScrollPane.Border.color" : "TextField.shadow");
        return shadow != null ? shadow : AbstractQuickSearchComboBar.getPopupBorderColor();
    }

    static Color getPopupBorderColor() {
        Color shadow = UIManager.getColor("controlShadow");
        return shadow != null ? shadow : Color.GRAY;
    }

    static Color getTextBackground() {
        Color textB = UIManager.getColor("TextPane.background");
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            textB = UIManager.getColor("NbExplorerView.background");
        }
        return textB != null ? textB : Color.WHITE;
    }

    static Color getResultBackground() {
        return AbstractQuickSearchComboBar.getTextBackground();
    }

    static Color getCategoryTextColor() {
        Color shadow = UIManager.getColor("textInactiveText");
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            shadow = UIManager.getColor("Table.foreground");
        }
        return shadow != null ? shadow : Color.DARK_GRAY;
    }

    protected int computePrefWidth() {
        FontMetrics fm = this.command.getFontMetrics(this.command.getFont());
        ProviderModel pModel = this.getProviderModel();
        int maxWidth = 0;
        for (ProviderModel.Category cat : pModel.getCategories()) {
            if ("Recent".equals(cat.getName())) continue;
            maxWidth = Math.max(maxWidth, fm.stringWidth(this.getHintText(cat)));
        }
        return Math.min(350, maxWidth);
    }

    public ProviderModel getProviderModel() {
        return this.providerModel;
    }
}

