/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.commonAncestor.quicksearch.module;

import ancestris.modules.commonAncestor.quicksearch.module.Accessor;
import ancestris.modules.commonAncestor.quicksearch.module.CategoryResult;
import ancestris.modules.commonAncestor.quicksearch.module.ProviderModel;
import ancestris.modules.commonAncestor.quicksearch.module.ResultsModel;
import ancestris.modules.commonAncestor.quicksearch.spi.SearchProvider;
import ancestris.modules.commonAncestor.quicksearch.spi.SearchRequest;
import ancestris.modules.commonAncestor.quicksearch.spi.SearchResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandEvaluator {
    static final String RECENT = "Recent";
    private static Pattern COMMAND_PATTERN = Pattern.compile("(\\w+)(\\s+)(.+)");
    private static ProviderModel.Category evalCat;
    private static boolean isCatTemporary;
    private static RequestProcessor RP;

    public static Task evaluate(ProviderModel providerModel, String command, ResultsModel model) {
        ArrayList<CategoryResult> l = new ArrayList<CategoryResult>();
        String[] commands = CommandEvaluator.parseCommand(providerModel, command);
        SearchRequest sRequest = Accessor.DEFAULT.createRequest(commands[1], null);
        ArrayList<RequestProcessor.Task> tasks = new ArrayList<RequestProcessor.Task>();
        ArrayList<ProviderModel.Category> provCats = new ArrayList<ProviderModel.Category>();
        boolean allResults = CommandEvaluator.getProviderCategories(providerModel, commands, provCats);
        for (ProviderModel.Category curCat : provCats) {
            CategoryResult catResult = new CategoryResult(curCat, allResults, providerModel.getMaxResult(), providerModel.getAllMaxResult());
            SearchResponse sResponse = Accessor.DEFAULT.createResponse(catResult, sRequest);
            for (SearchProvider provider : curCat.getProviders()) {
                RequestProcessor.Task t = CommandEvaluator.runEvaluation(provider, sRequest, sResponse, curCat);
                if (t == null) continue;
                tasks.add(t);
            }
            l.add(catResult);
        }
        model.setContent(l);
        return new Wait4AllTask(tasks);
    }

    public static ProviderModel.Category getEvalCat() {
        return evalCat;
    }

    public static void setEvalCat(ProviderModel.Category cat) {
        evalCat = cat;
    }

    public static boolean isCatTemporary() {
        return isCatTemporary;
    }

    public static void setCatTemporary(boolean isCatTemporary) {
        CommandEvaluator.isCatTemporary = isCatTemporary;
    }

    private static String[] parseCommand(ProviderModel providerModel, String command) {
        String[] results = new String[2];
        Matcher m = COMMAND_PATTERN.matcher(command);
        if (m.matches()) {
            results[0] = m.group(1);
            if (providerModel.isKnownCommand(results[0])) {
                results[1] = m.group(3);
            } else {
                results[0] = null;
                results[1] = command;
            }
        } else {
            results[1] = command;
        }
        return results;
    }

    private static boolean getProviderCategories(ProviderModel providerModel, String[] commands, List<ProviderModel.Category> result) {
        List<ProviderModel.Category> cats = providerModel.getCategories();
        for (ProviderModel.Category cat : cats) {
            if (!RECENT.equals(cat.getName())) continue;
            result.add(cat);
        }
        if (commands[1] == null || commands[1].trim().equals("")) {
            return false;
        }
        if (commands[0] != null) {
            for (ProviderModel.Category curCat : cats) {
                String commandPrefix = curCat.getCommandPrefix();
                if (commandPrefix == null || !commandPrefix.equalsIgnoreCase(commands[0])) continue;
                result.add(curCat);
                return true;
            }
        }
        if (evalCat != null) {
            result.add(evalCat);
            return true;
        }
        result.clear();
        result.addAll(cats);
        return false;
    }

    private static RequestProcessor.Task runEvaluation(final SearchProvider provider, final SearchRequest request, final SearchResponse response, ProviderModel.Category cat) {
        if (RP == null) {
            RP = new RequestProcessor("QuickSearch Command Evaluator", 10);
        }
        return RP.post(new Runnable(){

            public void run() {
                provider.evaluate(request, response);
            }
        });
    }

    static {
        RP = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Wait4AllTask
    extends Task
    implements Runnable {
        private static final long TIMEOUT = 60000L;
        private List<RequestProcessor.Task> tasks;

        private Wait4AllTask(List<RequestProcessor.Task> tasks) {
            this.tasks = tasks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.notifyRunning();
                for (RequestProcessor.Task task : this.tasks) {
                    try {
                        task.waitFinished(60000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            finally {
                this.notifyFinished();
            }
        }
    }
}

