/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.commonAncestor.quicksearch.module.recent;

import ancestris.modules.commonAncestor.quicksearch.module.ResultsModel;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentSearches {
    private static final int MAX_ITEMS = 5;
    private static final long FIVE_DAYS = 432000000L;
    private LinkedList<ResultsModel.ItemResult> recent = new LinkedList<ResultsModel.ItemResult>(){

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer();
            for (ResultsModel.ItemResult td : this) {
                buf.append(td.getDisplayName() + ":" + td.getDate().getTime() + ",");
            }
            return buf.toString();
        }
    };
    private static RecentSearches instance;
    private static final String RECENT_SEARCHES = "recentSearches";

    private RecentSearches() {
        this.readRecentFromPrefs();
    }

    public static RecentSearches getDefault() {
        if (instance == null) {
            instance = new RecentSearches();
        }
        return instance;
    }

    public void add(ResultsModel.ItemResult result) {
        Date now = new GregorianCalendar().getTime();
        for (ResultsModel.ItemResult ir : this.recent) {
            if (!this.stripHTMLnames(ir.getDisplayName()).equals(this.stripHTMLnames(result.getDisplayName()))) continue;
            ir.setDate(now);
            return;
        }
        if ("SearchSetup".equals(result.getAction().getClass().getSimpleName())) {
            return;
        }
        if (this.recent.size() >= 5) {
            this.recent.removeLast();
        }
        result.setDate(now);
        this.recent.addFirst(result);
        this.prefs().put(RECENT_SEARCHES, this.stripHTMLnames(this.recent.toString()));
    }

    public List<ResultsModel.ItemResult> getSearches() {
        LinkedList<ResultsModel.ItemResult> fiveDayList = new LinkedList<ResultsModel.ItemResult>();
        for (ResultsModel.ItemResult ir : this.recent) {
            if (new GregorianCalendar().getTime().getTime() - ir.getDate().getTime() >= 432000000L) continue;
            fiveDayList.add(ir);
        }
        return fiveDayList;
    }

    private Preferences prefs() {
        return NbPreferences.forModule(RecentSearches.class);
    }

    private void readRecentFromPrefs() {
        Object[] items = this.prefs().get(RECENT_SEARCHES, "").split(",");
        if (items[0].length() != 0) {
            for (int i = 0; i < items.length; ++i) {
                int semicolonPos = items[i].lastIndexOf(":");
                if (semicolonPos < 0) continue;
                try {
                    String name = items[i].substring(0, semicolonPos);
                    long time = Long.parseLong(items[i].substring(semicolonPos + 1));
                    ResultsModel.ItemResult incomplete = new ResultsModel.ItemResult(null, new FakeAction(name), name, new Date(time));
                    this.recent.add(incomplete);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    Logger l = Logger.getLogger(RecentSearches.class.getName());
                    l.log(Level.INFO, "Failed to read recent searches", items);
                }
            }
        }
    }

    private String stripHTMLnames(String s) {
        return s.replaceAll("<.*?>", "").trim();
    }

    public final class FakeAction
    implements Runnable {
        private String name;
        private Runnable action;

        private FakeAction(String name) {
            this.name = name;
        }

        public void run() {
        }

        private String stripHTMLandPackageNames(String s) {
            s = RecentSearches.this.stripHTMLnames(s);
            return s.replaceAll("\\(.*\\)", "").trim();
        }
    }
}

