/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.place.geonames;

import ancestris.api.place.Place;
import ancestris.api.place.SearchPlace;
import ancestris.libs.geonames.GeonamesOptions;
import ancestris.modules.place.geonames.GeonamesPlace;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Gedcom;
import genj.gedcom.PropertyPlace;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import modules.editors.gedcomproperties.utils.PlaceFormatConverterPanel;
import org.geonames.PostalCode;
import org.geonames.PostalCodeSearchCriteria;
import org.geonames.Style;
import org.geonames.Toponym;
import org.geonames.ToponymSearchCriteria;
import org.geonames.ToponymSearchResult;
import org.geonames.WebService;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.TaskListener;

public class GeonamesResearcher
implements SearchPlace {
    private static final Toponym DEFAULT_TOPONYM = GeonamesResearcher.defaultToponym();
    private static final int DEFAULT_LAT = 45;
    private static final int DEFAULT_LON = -4;
    private static final int MAX_ROWS = 100;
    private static final Logger LOG = Logger.getLogger(GeonamesResearcher.class.getName(), null);
    private RequestProcessor.Task theTask;
    private RequestProcessor RP = null;
    private static final String KEYMAP = "geonamesPlaceConversionMap";
    private final Map<String, PostalCode> tmpPostalCode = new HashMap<String, PostalCode>();

    public GeonamesResearcher() {
        if (this.RP == null) {
            this.RP = new RequestProcessor("GeonamesResearcher", 1, true);
        }
    }

    public RequestProcessor.Task getTask() {
        return this.theTask;
    }

    public void searchPlace(String place, String city, String code, List<Place> placesList, int maxResults, TaskListener taskListener) {
        String searchedPlace = this.clean(place);
        if (searchedPlace.isEmpty()) {
            return;
        }
        String searchedCity = (city = this.clean(city)).isEmpty() ? this.getCity(searchedPlace) : city;
        code = this.clean(code);
        String searchedCode = code.isEmpty() ? this.getCode(searchedPlace) : code;
        if (taskListener != null) {
            Runnable runnable = () -> placesList.addAll(this.doSearch(searchedPlace, searchedCity, searchedCode, maxResults));
            this.theTask = this.RP.create(runnable);
            this.theTask.addTaskListener(taskListener);
            this.theTask.schedule(0);
        } else {
            placesList.addAll(this.doSearch(searchedPlace, searchedCity, searchedCode, maxResults));
        }
    }

    private List<Place> doSearch(String searchedPlace, String searchedCity, String searchedCode, int maxResults) {
        ArrayList<Place> mPlacesList = new ArrayList<Place>();
        HashSet<String> tmpListDedup = new HashSet<String>();
        try {
            WebService.setUserName((String)GeonamesOptions.getInstance().getUserName());
            ToponymSearchCriteria searchCriteria = new ToponymSearchCriteria();
            searchCriteria.setStyle(Style.FULL);
            searchCriteria.setLanguage(Locale.getDefault().toString());
            searchCriteria.setMaxRows(maxResults == 0 ? 100 : Math.min(maxResults, 100));
            if (!searchedPlace.isEmpty()) {
                searchCriteria.setQ(searchedPlace);
                this.searchPlace(searchCriteria, searchedPlace, tmpListDedup, mPlacesList, maxResults);
            }
            if (!searchedCode.isEmpty() && (mPlacesList.isEmpty() || maxResults != 1)) {
                searchCriteria.setQ(searchedCode);
                this.searchPlace(searchCriteria, searchedPlace, tmpListDedup, mPlacesList, maxResults);
            }
            if (!searchedCity.isEmpty() && (mPlacesList.isEmpty() || maxResults != 1)) {
                searchCriteria.setNameStartsWith(searchedCity);
                searchCriteria.setQ(null);
                this.searchPlace(searchCriteria, searchedPlace, tmpListDedup, mPlacesList, maxResults);
            }
            if (mPlacesList.isEmpty()) {
                mPlacesList.add(this.defaultPlace());
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error during geonames search.", e);
        }
        return mPlacesList;
    }

    private void searchPlace(ToponymSearchCriteria searchCriteria, String searchedPlace, Set<String> tmpListDedup, List<Place> mPlacesList, int maxResults) throws Exception {
        ToponymSearchResult toponymSearchResult = WebService.search((ToponymSearchCriteria)searchCriteria);
        for (Toponym iTopo : toponymSearchResult.getToponyms()) {
            PostalCode pc;
            GeonamesPlace place = new GeonamesPlace(iTopo, pc = this.lookForPostalCode(iTopo, toponymSearchResult.getTotalResultsCount()));
            String str = ((Object)place).toString();
            if (this.matches(str, searchedPlace) && !tmpListDedup.contains(str)) {
                mPlacesList.add(place);
                tmpListDedup.add(str);
            }
            if (maxResults != 1) continue;
            break;
        }
    }

    private PostalCode lookForPostalCode(Toponym placeName, int maxRows) throws Exception {
        String key = placeName.getName() + ";" + placeName.getCountryCode() + ";" + placeName.getLatitude() + ";" + placeName.getLongitude();
        if (this.tmpPostalCode.containsKey(key)) {
            return this.tmpPostalCode.get(key);
        }
        PostalCodeSearchCriteria pcsc = new PostalCodeSearchCriteria();
        pcsc.setPlaceName(placeName.getName());
        pcsc.setCountryCode(placeName.getCountryCode());
        pcsc.setMaxRows(maxRows == 0 ? 100 : Math.min(maxRows, 100));
        PostalCode reference = new PostalCode();
        reference.setPlaceName(placeName.getName());
        reference.setCountryCode(placeName.getCountryCode());
        reference.setLatitude(placeName.getLatitude());
        reference.setLongitude(placeName.getLongitude());
        List lpc = WebService.postalCodeSearch((PostalCodeSearchCriteria)pcsc);
        for (PostalCode pc : lpc) {
            if (!this.matches(pc, reference)) continue;
            this.tmpPostalCode.put(key, pc);
            return pc;
        }
        return null;
    }

    private boolean matches(PostalCode courant, PostalCode reference) {
        if (!courant.getPlaceName().equals(reference.getPlaceName())) {
            return false;
        }
        if (!courant.getCountryCode().equals(reference.getCountryCode())) {
            return false;
        }
        DecimalFormat df = new DecimalFormat("-###.##");
        df.setRoundingMode(RoundingMode.HALF_UP);
        return df.format(courant.getLatitude()).equals(df.format(reference.getLatitude())) && df.format(courant.getLongitude()).equals(df.format(reference.getLongitude()));
    }

    public Place defaultPlace() {
        return new GeonamesPlace(DEFAULT_TOPONYM, null);
    }

    public Place searchNearestPlace(double latitude, double longitude) {
        WebService.setUserName((String)GeonamesOptions.getInstance().getUserName());
        try {
            List results = WebService.findNearbyPlaceName((double)latitude, (double)longitude);
            if (!results.isEmpty()) {
                int geonameId = ((Toponym)results.get(0)).getGeoNameId();
                Toponym toponym = WebService.get((int)geonameId, null, null);
                return new GeonamesPlace(toponym, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getGeonamesMapString(Gedcom gedcom) {
        return gedcom.getRegistry().get(KEYMAP, "");
    }

    public static String[] getGeonamesMap(Gedcom gedcom) {
        String[] format = null;
        String placeMap = GeonamesResearcher.getGeonamesMapString(gedcom);
        PlaceFormatConverterPanel pfc = new PlaceFormatConverterPanel(GeonamesPlace.getPlaceFormat(), gedcom.getPlaceFormat(), placeMap);
        pfc.setTextTitle(NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_PlaceFormatConversionTitle"));
        pfc.setLeftTitle(NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_PlaceFormatConversionLeftTitle"));
        pfc.setRightTitle(NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_PlaceFormatConversionRightTitle"));
        Object o = DialogManager.create((String)NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_PlaceFormatConversion"), (JComponent)pfc).setMessageType(-1).show();
        if (o == DialogManager.OK_OPTION) {
            String map = pfc.getConversionMapAsString();
            if (!map.replace(",", "").trim().isEmpty()) {
                gedcom.getRegistry().put(KEYMAP, map);
                format = PropertyPlace.getFormat((String)map);
            } else if (placeMap.isEmpty()) {
                DialogManager.create((String)NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_PlaceFormatConversion"), (String)NbBundle.getMessage(GeonamesResearcher.class, (String)"ERR_EmptyConversion")).setMessageType(0).show();
            } else {
                DialogManager.create((String)NbBundle.getMessage(GeonamesResearcher.class, (String)"TITL_PlaceFormatConversion"), (String)NbBundle.getMessage(GeonamesResearcher.class, (String)"ERR_NothingSaved")).setMessageType(0).show();
            }
        }
        return format;
    }

    private String clean(String str) {
        return str.replaceAll(",", " ").replaceAll(" +", " ").trim();
    }

    private String getCity(String text) {
        String[] bits;
        for (String bit : bits = text.split(" ")) {
            String str = bit.replaceAll("[0-9]", "");
            if (str.length() <= 1) continue;
            return str;
        }
        return text;
    }

    private String getCode(String text) {
        String[] bits;
        for (String bit : bits = text.split(" ")) {
            String str = bit.replaceAll("[^0-9]", "");
            if (str.length() <= 1) continue;
            return str;
        }
        return "";
    }

    private boolean matches(String text, String searchedPlace) {
        String[] bits;
        int matches = 0;
        for (String bit : bits = searchedPlace.split(" ")) {
            if (text.toLowerCase().contains(bit.toLowerCase())) {
                ++matches;
            }
            if (matches != 2) continue;
            return true;
        }
        return bits.length == matches && matches > 0;
    }

    private static Toponym defaultToponym() {
        Toponym topo = new Toponym();
        topo.setLatitude(45.0);
        topo.setLongitude(-4.0);
        topo.setPopulation(Long.getLong("0"));
        return topo;
    }
}

