/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.PropertyDate;
import genj.gedcom.TagPath;
import genj.report.Report;

public class ReportDirectoryTool
extends Report {
    public int optionLifeSpan = 70;
    private String textTitle = this.translate("title");
    private String textDate = this.translate("date");
    private String textAge = this.translate("age");
    private String textSelect = this.translate("select");

    public void start(Gedcom gedcom) {
        int yearToCheck;
        String strTemp = this.getValueFromUser("", this.textSelect);
        if (strTemp == null) {
            return;
        }
        try {
            yearToCheck = Integer.parseInt(strTemp);
        }
        catch (NumberFormatException e) {
            this.println("Invalid year");
            return;
        }
        this.println(this.textTitle + " " + yearToCheck);
        this.println();
        Entity[] individuals = gedcom.getEntities("INDI", "");
        for (int loop = 0; loop < individuals.length; ++loop) {
            String strOccu;
            int tempDOBYear = this.getYear(((Indi)individuals[loop]).getBirthDate());
            int tempDODYear = this.getYear(((Indi)individuals[loop]).getDeathDate());
            if (tempDOBYear == -1 && tempDODYear == -1) continue;
            if (tempDOBYear == -1) {
                tempDOBYear = tempDODYear - this.optionLifeSpan;
            }
            if (tempDODYear == -1) {
                tempDODYear = tempDOBYear + this.optionLifeSpan;
            }
            if (yearToCheck < tempDOBYear || yearToCheck > tempDODYear) continue;
            int iAge = yearToCheck - tempDOBYear;
            Boolean flagHasOccu = false;
            if (individuals[loop].getProperty(new TagPath("INDI:OCCU")) == null) {
                strOccu = "";
            } else {
                strOccu = individuals[loop].getProperty(new TagPath("INDI:OCCU")).getDisplayValue();
                flagHasOccu = true;
            }
            if (flagHasOccu.booleanValue() && individuals[loop].getProperty(new TagPath("INDI:OCCU:DATE")) != null) {
                strOccu = strOccu + " " + individuals[loop].getProperty(new TagPath("INDI:OCCU:DATE")).getDisplayValue();
            }
            if (flagHasOccu.booleanValue() && individuals[loop].getProperty(new TagPath("INDI:OCCU:PLAC")) != null) {
                strOccu = strOccu + " " + individuals[loop].getProperty(new TagPath("INDI:OCCU:PLAC")).getDisplayValue();
            }
            if (strOccu.length() > 0) {
                strOccu = "[" + strOccu + "]";
            }
            this.println(individuals[loop] + this.textAge + " " + iAge + " " + strOccu);
        }
    }

    public int getYear(PropertyDate someDate) {
        if (someDate == null || !someDate.isValid() || someDate.isRange()) {
            return -1;
        }
        String strYear = someDate.getDisplayValue().trim();
        strYear = strYear.substring(strYear.length() - 4);
        return Integer.parseInt(strYear);
    }
}

