/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.TagPath;
import genj.gedcom.time.Delta;
import genj.report.Report;
import genj.util.ReferenceSet;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public class ReportGedcomStatistics
extends Report {
    public boolean analyzeIndividuals = true;
    public boolean reportAgeToIndis = true;
    public boolean analyzeFamilies = true;
    public boolean reportIndisToMarriageAge = true;
    public int reportFamsToChildren = 1;
    public String[] reportFamsToChildrens = new String[]{this.translate("choice.all"), this.translate("choice.minmax"), this.translate("choice.none")};
    public boolean reportIndisToChildBirth = true;
    public boolean analyzeLastNames = true;
    public boolean reportAgeToLastNames = true;
    public boolean reportLastNamesToMarriageAge = true;
    public int reportLastNamesToChildren = 2;
    public String[] reportLastNamesToChildrens = new String[]{this.translate("choice.all"), this.translate("choice.minmax"), this.translate("choice.none")};
    public boolean reportLastNamesToChildBirths = true;
    public boolean sortLastNamesByName = true;
    public boolean analyzeOccupations = true;
    public boolean sortOccupationsByName = true;
    public boolean reportIndisToOccupations = true;
    public boolean analyzeBirthPlaces = true;
    public boolean reportIndisToBirthPlaces = true;
    public boolean sortBirthPlacesByName = true;
    public boolean analyzeBaptismPlaces = true;
    public boolean reportIndisToBaptismPlaces = true;
    public boolean sortBaptismPlacesByName = true;
    public boolean analyzeMarriagePlaces = true;
    public boolean reportIndisToMarriagePlaces = true;
    public boolean sortMarriagePlacesByName = true;
    public boolean analyzeEmigrationPlaces = true;
    public boolean reportIndisToEmigrationPlaces = true;
    public boolean sortEmigrationPlacesByName = true;
    public boolean analyzeImmigrationPlaces = true;
    public boolean reportIndisToImmigrationPlaces = true;
    public boolean sortImmigrationPlacesByName = true;
    public boolean analyzeNaturalizationPlaces = true;
    public boolean reportIndisToNaturalizationPlaces = true;
    public boolean sortNaturalizationPlacesByName = true;
    public boolean analyzeDeathPlaces = true;
    public boolean reportIndisToDeathPlaces = true;
    public boolean sortDeathPlacesByName = true;
    private static final int ALL = 1;
    private static final int MALES = 2;
    private static final int FEMALES = 3;
    private static final int UNKNOWN = 4;
    private static final int INDIS = 5;
    private static final int CHILDBIRTH = 6;
    private static final int BIRTH = 7;
    private static final int BAPTISM = 8;
    private static final int MARRIAGE = 9;
    private static final int EMIGRATION = 10;
    private static final int IMMIGRATION = 11;
    private static final int NATURALIZATION = 12;
    private static final int DEATH = 13;

    public void start(Gedcom gedcom) {
        if (!(this.analyzeIndividuals || this.analyzeLastNames || this.analyzeOccupations || this.analyzeFamilies || this.analyzeBirthPlaces || this.analyzeBaptismPlaces || this.analyzeMarriagePlaces || this.analyzeEmigrationPlaces || this.analyzeImmigrationPlaces || this.analyzeNaturalizationPlaces || this.analyzeDeathPlaces)) {
            return;
        }
        Entity[] indis = gedcom.getEntities("INDI", "");
        Entity[] fams = gedcom.getEntities("FAM", "");
        StatisticsIndividuals all = null;
        StatisticsIndividuals males = null;
        StatisticsIndividuals females = null;
        StatisticsIndividuals unknown = null;
        StatisticsLastNames lastNames = null;
        StatisticsOccupations occupations = null;
        StatisticsFamilies families = null;
        StatisticsPlaces births = null;
        StatisticsPlaces baptisms = null;
        StatisticsPlaces marriages = null;
        StatisticsPlaces emigrations = null;
        StatisticsPlaces immigrations = null;
        StatisticsPlaces naturalizations = null;
        StatisticsPlaces deaths = null;
        if (this.analyzeIndividuals) {
            all = new StatisticsIndividuals();
            all.which = 1;
            males = new StatisticsIndividuals();
            males.which = 2;
            females = new StatisticsIndividuals();
            females.which = 3;
            unknown = new StatisticsIndividuals();
            unknown.which = 4;
            this.analyzeIndividuals(indis, all, males, females, unknown);
        }
        if (this.analyzeFamilies) {
            families = new StatisticsFamilies();
            families.number = fams.length;
            this.analyzeFamilies(fams, null, families);
        }
        if (this.analyzeLastNames) {
            lastNames = new StatisticsLastNames();
            this.analyzeLastNames(indis, lastNames);
        }
        if (this.analyzeOccupations) {
            occupations = new StatisticsOccupations();
            this.analyzeOccupations(indis, occupations);
        }
        if (this.analyzeBirthPlaces) {
            births = new StatisticsPlaces();
            births.which = 7;
            this.analyzePlaces(indis, births);
        }
        if (this.analyzeBaptismPlaces) {
            baptisms = new StatisticsPlaces();
            baptisms.which = 8;
            this.analyzePlaces(indis, baptisms);
        }
        if (this.analyzeMarriagePlaces) {
            marriages = new StatisticsPlaces();
            marriages.which = 9;
            this.analyzePlaces(fams, marriages);
        }
        if (this.analyzeEmigrationPlaces) {
            emigrations = new StatisticsPlaces();
            emigrations.which = 10;
            this.analyzePlaces(indis, emigrations);
        }
        if (this.analyzeImmigrationPlaces) {
            immigrations = new StatisticsPlaces();
            immigrations.which = 11;
            this.analyzePlaces(indis, immigrations);
        }
        if (this.analyzeNaturalizationPlaces) {
            naturalizations = new StatisticsPlaces();
            naturalizations.which = 12;
            this.analyzePlaces(indis, naturalizations);
        }
        if (this.analyzeDeathPlaces) {
            deaths = new StatisticsPlaces();
            deaths.which = 13;
            this.analyzePlaces(indis, deaths);
        }
        this.println(this.translate("header", new Object[]{gedcom.getName()}));
        this.println();
        if (this.analyzeIndividuals) {
            int i = this.reportAgeToIndis ? 1 : 3;
            this.reportIndividuals(i, null, 0.0, all, males, females, unknown);
        }
        if (this.analyzeFamilies) {
            this.reportFamilies(families, this.reportFamsToChildren, this.reportIndisToChildBirth, false);
        }
        if (this.analyzeLastNames) {
            this.reportLastNames(lastNames, this.sortLastNamesByName ? gedcom.getCollator() : null, indis.length);
        }
        if (this.analyzeOccupations) {
            this.reportOccupations(occupations, this.sortOccupationsByName ? gedcom.getCollator() : null);
        }
        if (this.analyzeBirthPlaces) {
            this.println(this.translate("birthPlaces") + ": " + new Integer(births.places.getKeys().size()));
            this.reportPlaces(this.reportIndisToBirthPlaces, this.sortBirthPlacesByName ? gedcom.getCollator() : null, births);
        }
        if (this.analyzeBaptismPlaces) {
            this.println(this.translate("baptismPlaces") + ": " + new Integer(baptisms.places.getKeys().size()));
            this.reportPlaces(this.reportIndisToBaptismPlaces, this.sortBaptismPlacesByName ? gedcom.getCollator() : null, baptisms);
        }
        if (this.analyzeMarriagePlaces) {
            this.println(this.translate("marriagePlaces") + ": " + new Integer(marriages.places.getKeys().size()));
            this.reportPlaces(this.reportIndisToMarriagePlaces, this.sortMarriagePlacesByName ? gedcom.getCollator() : null, marriages);
        }
        if (this.analyzeEmigrationPlaces) {
            this.println(this.translate("emigrationPlaces") + ": " + new Integer(emigrations.places.getKeys().size()));
            this.reportPlaces(this.reportIndisToEmigrationPlaces, this.sortEmigrationPlacesByName ? gedcom.getCollator() : null, emigrations);
        }
        if (this.analyzeImmigrationPlaces) {
            this.println(this.translate("immigrationPlaces") + ": " + new Integer(immigrations.places.getKeys().size()));
            this.reportPlaces(this.reportIndisToImmigrationPlaces, this.sortImmigrationPlacesByName ? gedcom.getCollator() : null, immigrations);
        }
        if (this.analyzeNaturalizationPlaces) {
            this.println(this.translate("naturalizationPlaces") + ": " + new Integer(naturalizations.places.getKeys().size()));
            this.reportPlaces(this.reportIndisToNaturalizationPlaces, this.sortNaturalizationPlacesByName ? gedcom.getCollator() : null, naturalizations);
        }
        if (this.analyzeDeathPlaces) {
            this.println(this.translate("deathPlaces") + ": " + new Integer(deaths.places.getKeys().size()));
            this.reportPlaces(this.reportIndisToDeathPlaces, this.sortDeathPlacesByName ? gedcom.getCollator() : null, deaths);
        }
    }

    private double roundNumber(double number, int digits) {
        if (Double.isNaN(number) || Double.isInfinite(number)) {
            return 0.0;
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumFractionDigits(digits);
        nf.setMaximumFractionDigits(digits);
        nf.setGroupingUsed(false);
        return Double.parseDouble(nf.format(number).replace(',', '.'));
    }

    private void analyzePlaces(Entity[] e, StatisticsPlaces places) {
        for (int i = 0; i < e.length; ++i) {
            Property prop = null;
            Property[] props = null;
            switch (places.which) {
                case 7: {
                    props = new Property[]{e[i].getProperty(new TagPath("INDI:BIRT:PLAC"))};
                    break;
                }
                case 8: {
                    ArrayList<Property> baps = new ArrayList<Property>();
                    prop = e[i].getProperty("BAPM");
                    if (prop != null) {
                        prop = e[i].getProperty(new TagPath("INDI:BAPM:PLAC"));
                        baps.add(prop);
                    }
                    if ((prop = e[i].getProperty("BAPL")) != null) {
                        prop = e[i].getProperty(new TagPath("INDI:BAPL:PLAC"));
                        baps.add(prop);
                    }
                    if ((prop = e[i].getProperty("CHR")) != null) {
                        prop = e[i].getProperty(new TagPath("INDI:CHR:PLAC"));
                        baps.add(prop);
                    }
                    if ((prop = e[i].getProperty("CHRA")) != null) {
                        prop = e[i].getProperty(new TagPath("INDI:CHRA:PLAC"));
                        baps.add(prop);
                    }
                    props = baps.toArray(new Property[baps.size()]);
                    break;
                }
                case 10: {
                    prop = e[i].getProperty("EMIG");
                    if (prop == null) break;
                    props = e[i].getProperties(new TagPath("INDI:EMIG:PLAC"));
                    break;
                }
                case 11: {
                    prop = e[i].getProperty("IMMI");
                    if (prop == null) break;
                    props = e[i].getProperties(new TagPath("INDI:IMMI:PLAC"));
                    break;
                }
                case 12: {
                    prop = e[i].getProperty("NATU");
                    if (prop == null) break;
                    props = e[i].getProperties(new TagPath("INDI:NATU:PLAC"));
                    break;
                }
                case 9: {
                    prop = e[i].getProperty("MARR");
                    if (prop == null) break;
                    props = e[i].getProperties(new TagPath("FAM:MARR:PLAC"));
                    break;
                }
                case 13: {
                    props = new Property[1];
                    prop = e[i].getProperty("DEAT");
                    if (prop == null) break;
                    props[0] = e[i].getProperty(new TagPath("INDI:DEAT:PLAC"));
                }
            }
            if (props == null || props.length <= 0) continue;
            for (int j = 0; j < props.length; ++j) {
                String place;
                if (props[j] == null || (place = props[j].getValue()).length() <= 0 || !places.places.add((Object)place, (Object)e[i])) continue;
                ++places.entitiesWithKnownPlaces;
            }
        }
    }

    private void analyzeAge(Indi indi, Delta age, StatisticsIndividuals single, StatisticsIndividuals all, int which) {
        if (age == null) {
            return;
        }
        int a = age.getYears() * 360 + age.getMonths() * 30 + age.getDays();
        switch (which) {
            case 5: 
            case 9: {
                if (all != null) {
                    all.age.add((Object)new Integer(a), (Object)indi);
                    all.sumAge += a;
                    if (a > all.maxAge) {
                        all.maxAge = a;
                    }
                    if (a < all.minAge) {
                        all.minAge = a;
                    }
                }
                single.age.add((Object)new Integer(a), (Object)indi);
                single.sumAge += a;
                if (a > single.maxAge) {
                    single.maxAge = a;
                }
                if (a >= single.minAge) break;
                single.minAge = a;
                break;
            }
            case 6: {
                ++single.childBirthNumber;
                single.sumChildBirthAge += a;
                single.childBirthAge.add((Object)new Integer(a), (Object)indi);
                if (a < single.minChildBirthAge) {
                    single.minChildBirthAge = a;
                }
                if (a <= single.maxChildBirthAge) break;
                single.maxChildBirthAge = a;
            }
        }
    }

    private void analyzeIndividuals(Entity[] e, StatisticsIndividuals all, StatisticsIndividuals males, StatisticsIndividuals females, StatisticsIndividuals unknown) {
        block4: for (int i = 0; i < e.length; ++i) {
            Delta age = null;
            Indi indi = (Indi)e[i];
            ++all.number;
            if (indi.getDeathDate() != null) {
                age = indi.getAge(indi.getDeathDate().getStart());
            }
            switch (indi.getSex()) {
                case 1: {
                    ++males.number;
                    this.analyzeAge(indi, age, males, all, 5);
                    continue block4;
                }
                case 2: {
                    ++females.number;
                    this.analyzeAge(indi, age, females, all, 5);
                    continue block4;
                }
                default: {
                    ++unknown.number;
                    this.analyzeAge(indi, age, unknown, all, 5);
                }
            }
        }
    }

    private void analyzeLastNames(Entity[] e, StatisticsLastNames lastNames) {
        for (int i = 0; i < e.length; ++i) {
            lastNames.lastNamesIndis.add((Object)((Indi)e[i]).getLastName(), (Object)((Indi)e[i]));
        }
        Iterator it = lastNames.lastNamesIndis.getKeys().iterator();
        ArrayList<Fam> familiesToLastName = new ArrayList<Fam>();
        while (it.hasNext()) {
            familiesToLastName.clear();
            String name = (String)it.next();
            for (Indi indi : lastNames.lastNamesIndis.getReferences((Object)name)) {
                if (indi.getNoOfFams() <= 0) continue;
                Fam[] fams = indi.getFamiliesWhereSpouse();
                for (int j = 0; j < fams.length; ++j) {
                    familiesToLastName.add(fams[j]);
                }
            }
            StatisticsFamilies families = new StatisticsFamilies();
            families.number = familiesToLastName.size();
            StatisticsIndividuals all = new StatisticsIndividuals();
            all.which = 1;
            StatisticsIndividuals males = new StatisticsIndividuals();
            males.which = 2;
            StatisticsIndividuals females = new StatisticsIndividuals();
            females.which = 3;
            StatisticsIndividuals unknown = new StatisticsIndividuals();
            unknown.which = 4;
            this.analyzeIndividuals(lastNames.lastNamesIndis.getReferences((Object)name).toArray(new Entity[0]), all, males, females, unknown);
            this.analyzeFamilies(familiesToLastName.toArray(new Entity[0]), name, families);
            lastNames.lastNamesStatistic.add((Object)name, (Object)all);
            lastNames.lastNamesStatistic.add((Object)name, (Object)males);
            lastNames.lastNamesStatistic.add((Object)name, (Object)females);
            lastNames.lastNamesStatistic.add((Object)name, (Object)unknown);
            lastNames.lastNamesStatistic.add((Object)name, (Object)families);
        }
    }

    private void analyzeOccupations(Entity[] e, StatisticsOccupations occupations) {
        for (int i = 0; i < e.length; ++i) {
            ++occupations.numberIndis;
            Property[] props = e[i].getProperties(new TagPath("INDI:OCCU"));
            if (props == null) continue;
            for (int j = 0; j < props.length; ++j) {
                String occu = props[j].getValue();
                if (occu.length() <= 0) continue;
                occupations.occupations.add((Object)occu, (Object)e[i]);
            }
        }
    }

    private void analyzeFamilies(Entity[] e, String lastName, StatisticsFamilies families) {
        for (int i = 0; i < e.length; ++i) {
            Delta age;
            Fam fam = (Fam)e[i];
            Indi husband = fam.getHusband();
            Indi wife = fam.getWife();
            PropertyDate date = fam.getMarriageDate();
            if (date != null) {
                if (husband != null && (lastName == null || husband.getLastName().equals(lastName))) {
                    age = husband.getAge(date.getStart());
                    this.analyzeAge(husband, age, families.husbands, null, 9);
                }
                if (wife != null && (lastName == null || wife.getLastName().equals(lastName))) {
                    age = wife.getAge(date.getStart());
                    this.analyzeAge(wife, age, families.wifes, null, 9);
                }
            }
            Indi[] children = fam.getChildren();
            for (int j = 0; j < children.length; ++j) {
                date = children[j].getBirthDate();
                if (date == null) continue;
                if (husband != null && (lastName == null || husband.getLastName().equals(lastName))) {
                    age = husband.getAge(date.getStart());
                    this.analyzeAge(husband, age, families.husbands, null, 6);
                }
                if (wife == null || lastName != null && !wife.getLastName().equals(lastName)) continue;
                age = wife.getAge(date.getStart());
                this.analyzeAge(wife, age, families.wifes, null, 6);
            }
            families.children.add((Object)new Integer(children.length), (Object)fam);
            if (children.length > 0) {
                ++families.withChildren;
            }
            if (children.length > families.maxChildren) {
                families.maxChildren = children.length;
            }
            if (children.length >= families.minChildren) continue;
            families.minChildren = children.length;
        }
    }

    private int[] calculateAverageAge(double ages, double numAges) {
        int[] age = new int[]{0, 0, 0};
        if (numAges > 0.0 && ages != 2.147483647E9 && ages != -2.147483648E9) {
            age[0] = (int)this.roundNumber(Math.floor(ages / 360.0 / numAges), 0);
            age[1] = (int)this.roundNumber(Math.floor((ages %= 360.0 * numAges) / 30.0 / numAges), 0);
            age[2] = (int)this.roundNumber((ages %= 30.0 * numAges) / numAges, 0);
        }
        return age;
    }

    private void printAges(int printIndis, int indent, StatisticsIndividuals stats, int which) {
        switch (which) {
            case 5: 
            case 9: {
                if (stats.age.getKeys().size() > 0) {
                    if (stats.age.getSize() == 1) {
                        Indi indi = (Indi)stats.age.getReferences((Object)((Integer)stats.age.getKeys().get(0))).iterator().next();
                        int[] age = this.calculateAverageAge(stats.sumAge, 1.0);
                        this.println(this.getIndent(indent) + new Delta(age[2], age[1], age[0]) + " " + this.translate("oneIndi"));
                        if (printIndis >= 3) break;
                        this.println(this.getIndent(indent + 1) + this.translate("entity", new Object[]{indi.getId(), indi.getName()}));
                        break;
                    }
                    this.printMinMaxAge(indent, "minAge", stats.minAge, stats.age.getReferences((Object)new Integer(stats.minAge)));
                    int[] age = this.calculateAverageAge(stats.sumAge, stats.age.getSize());
                    this.println(this.getIndent(indent) + this.translate("avgAge") + " " + new Delta(age[2], age[1], age[0]));
                    this.printMinMaxAge(indent, "maxAge", stats.maxAge, stats.age.getReferences((Object)new Integer(stats.maxAge)));
                    break;
                }
                this.println(this.getIndent(indent) + this.translate("noData"));
                break;
            }
            case 6: {
                if (stats.childBirthAge.getKeys().size() > 0) {
                    if (stats.childBirthAge.getSize() == 1) {
                        Indi indi = (Indi)stats.childBirthAge.getReferences((Object)((Integer)stats.childBirthAge.getKeys().get(0))).iterator().next();
                        int[] age = this.calculateAverageAge(stats.sumChildBirthAge, 1.0);
                        this.println(this.getIndent(indent) + new Delta(age[2], age[1], age[0]) + " " + this.translate("oneIndi"));
                        if (printIndis >= 3) break;
                        this.println(this.getIndent(indent + 1) + this.translate("entity", new Object[]{indi.getId(), indi.getName()}));
                        break;
                    }
                    this.printMinMaxAge(indent, "minAge", stats.minChildBirthAge, stats.childBirthAge.getReferences((Object)new Integer(stats.minChildBirthAge)));
                    int[] age = this.calculateAverageAge(stats.sumChildBirthAge, stats.childBirthNumber);
                    this.println(this.getIndent(indent) + this.translate("avgAge") + " " + new Delta(age[2], age[1], age[0]));
                    this.printMinMaxAge(indent, "maxAge", stats.maxChildBirthAge, stats.childBirthAge.getReferences((Object)new Integer(stats.maxChildBirthAge)));
                    break;
                }
                this.println(this.getIndent(indent) + this.translate("noData"));
            }
        }
    }

    private void printMinMaxAge(int indent, String prefix, int age, Collection c) {
        int[] avg = this.calculateAverageAge(age, 1.0);
        this.println(this.getIndent(indent) + this.translate(prefix) + " " + new Delta(avg[2], avg[1], avg[0]));
        for (Indi indi : c) {
            this.println(this.getIndent(indent + 1) + this.translate("entity", new Object[]{indi.getId(), indi.getName()}));
        }
    }

    private void reportIndividuals(int printIndis, String lastName, double numberAllIndis, StatisticsIndividuals all, StatisticsIndividuals males, StatisticsIndividuals females, StatisticsIndividuals unknown) {
        int indent;
        if (lastName == null) {
            this.println(this.translate("people"));
            this.println(this.getIndent(2) + this.translate("number", new Object[]{all.number}));
            indent = 3;
        } else {
            this.println(this.getIndent(2) + "\"" + lastName + "\": " + all.number + " (" + this.roundNumber((double)all.number / numberAllIndis * 100.0, this.OPTIONS.getPositions()) + "%)");
            this.println(this.getIndent(3) + this.translate("ages"));
            this.println(this.getIndent(4) + this.translate("all"));
            indent = 5;
        }
        if (lastName == null || all.number > 0) {
            this.printAges(printIndis, indent, all, 5);
        }
        if (lastName == null || males.number > 0) {
            this.println(this.getIndent(indent - 1) + this.translate("males", new Object[]{"" + males.number, "" + this.roundNumber((double)males.number / (double)all.number * 100.0, this.OPTIONS.getPositions())}));
            this.printAges(printIndis, indent, males, 5);
        }
        if (lastName == null || females.number > 0) {
            this.println(this.getIndent(indent - 1) + this.translate("females", new Object[]{"" + females.number, "" + this.roundNumber((double)females.number / (double)all.number * 100.0, this.OPTIONS.getPositions())}));
            this.printAges(printIndis, indent, females, 5);
        }
        if (lastName == null || unknown.number > 0) {
            this.println(this.getIndent(indent - 1) + this.translate("unknown", new Object[]{"" + unknown.number, "" + this.roundNumber((double)unknown.number / (double)all.number * 100.0, this.OPTIONS.getPositions())}));
            this.printAges(printIndis, indent, unknown, 5);
        }
        if (lastName == null) {
            this.println();
        }
    }

    private void printChildren(StatisticsFamilies families, int childs, int indent) {
        for (Fam fam : families.children.getReferences((Object)new Integer(childs))) {
            this.println(this.getIndent(indent + 2) + this.translate("entity", new Object[]{fam.getId(), fam.toString()}));
        }
    }

    private void reportFamilies(StatisticsFamilies families, int reportFamsToChildren, boolean reportIndisToChildBirths, boolean lastName) {
        int i = -1;
        int j = -1;
        int indent = -1;
        i = this.reportIndisToMarriageAge ? 1 : 3;
        j = this.reportIndisToChildBirth ? 1 : 3;
        if (!lastName) {
            this.println(this.translate("families") + ": " + families.number);
            indent = 2;
        } else {
            indent = 3;
        }
        if (families.number > 0) {
            this.println(this.getIndent(indent) + this.translate("ageAtMarriage"));
            this.println(this.getIndent(indent + 1) + this.translate("husbands"));
            this.printAges(i, indent + 2, families.husbands, 9);
            this.println(this.getIndent(indent + 1) + this.translate("wifes"));
            this.printAges(i, indent + 2, families.wifes, 9);
            this.println(this.getIndent(indent) + this.translate("withChildren", new Object[]{"" + families.withChildren, "" + this.roundNumber((double)families.withChildren / (double)families.number * 100.0, this.OPTIONS.getPositions())}));
            switch (reportFamsToChildren) {
                case 0: {
                    this.println(this.getIndent(indent + 1) + this.translate("avgChildren", new Object[]{"" + this.roundNumber((double)families.withChildren / (double)families.number, this.OPTIONS.getPositions())}));
                    Iterator f = families.children.getKeys().iterator();
                    while (f.hasNext()) {
                        int children = (Integer)f.next();
                        this.println(this.getIndent(indent + 1) + this.translate("children") + ": " + children);
                        this.printChildren(families, children, indent);
                    }
                    break;
                }
                case 1: {
                    this.println(this.getIndent(indent + 1) + this.translate("avgChildren", new Object[]{"" + this.roundNumber((double)families.withChildren / (double)families.number, this.OPTIONS.getPositions())}));
                    this.println(this.getIndent(indent + 1) + this.translate("minChildren", new Object[]{families.minChildren}));
                    this.printChildren(families, families.minChildren, indent);
                    this.println(this.getIndent(indent + 1) + this.translate("maxChildren", new Object[]{families.maxChildren}));
                    this.printChildren(families, families.maxChildren, indent);
                    break;
                }
                case 2: {
                    this.println(this.getIndent(indent + 1) + this.translate("minChildren", new Object[]{families.minChildren}));
                    this.println(this.getIndent(indent + 1) + this.translate("avgChildren", new Object[]{"" + this.roundNumber((double)families.withChildren / (double)families.number, this.OPTIONS.getPositions())}));
                    this.println(this.getIndent(indent + 1) + this.translate("maxChildren", new Object[]{families.maxChildren}));
                }
            }
            this.println(this.getIndent(indent) + this.translate("agesAtChildBirths"));
            this.println(this.getIndent(indent + 1) + this.translate("husbands"));
            this.printAges(j, indent + 2, families.husbands, 6);
            this.println(this.getIndent(indent + 1) + this.translate("wifes"));
            this.printAges(j, indent + 2, families.wifes, 6);
        }
        if (!lastName) {
            this.println();
        }
    }

    private void reportPlaces(boolean reportIndisToPlaces, Comparator sort, StatisticsPlaces places) {
        for (String place : places.places.getKeys(sort)) {
            int number = places.places.getSize((Object)place);
            this.println(this.getIndent(2) + place + ": " + number + " (" + this.roundNumber((double)number / (double)places.entitiesWithKnownPlaces * 100.0, this.OPTIONS.getPositions()) + "%)");
            if (!reportIndisToPlaces) continue;
            Iterator entities = places.places.getReferences((Object)place).iterator();
            while (entities.hasNext()) {
                if (places.which == 9) {
                    Fam fam = (Fam)entities.next();
                    this.println(this.getIndent(3) + this.translate("entity", new Object[]{fam.getId(), fam.toString()}));
                    continue;
                }
                Indi indi = (Indi)entities.next();
                this.println(this.getIndent(3) + this.translate("entity", new Object[]{indi.getId(), indi.getName()}));
            }
        }
        this.println();
    }

    private void reportLastNames(StatisticsLastNames lastNames, Comparator sort, int numberAllIndis) {
        this.println(this.translate("lastNames", new Object[]{"" + lastNames.lastNamesIndis.getKeys().size(), "" + numberAllIndis}));
        for (String name : lastNames.lastNamesIndis.getKeys(sort)) {
            StatisticsIndividuals all = null;
            StatisticsIndividuals males = null;
            StatisticsIndividuals females = null;
            StatisticsIndividuals unknown = null;
            StatisticsFamilies families = null;
            for (Object stat : lastNames.lastNamesStatistic.getReferences((Object)name)) {
                if (stat instanceof StatisticsIndividuals) {
                    switch (((StatisticsIndividuals)stat).which) {
                        case 1: {
                            all = (StatisticsIndividuals)stat;
                            break;
                        }
                        case 2: {
                            males = (StatisticsIndividuals)stat;
                            break;
                        }
                        case 3: {
                            females = (StatisticsIndividuals)stat;
                            break;
                        }
                        case 4: {
                            unknown = (StatisticsIndividuals)stat;
                        }
                    }
                    continue;
                }
                families = (StatisticsFamilies)stat;
            }
            int i = this.reportAgeToLastNames ? 1 : 3;
            this.reportIndividuals(i, name, numberAllIndis, all, males, females, unknown);
            this.reportFamilies(families, this.reportFamsToChildren, this.reportIndisToChildBirth, true);
        }
    }

    private void reportOccupations(StatisticsOccupations occupations, Comparator sort) {
        this.println(this.translate("occupations"));
        this.println(this.getIndent(2) + this.translate("number", new Object[]{occupations.occupations.getKeys().size()}));
        for (String occupation : occupations.occupations.getKeys(sort)) {
            this.println(this.getIndent(3) + this.translate("occupation", new Object[]{occupation, "" + occupations.occupations.getSize((Object)occupation), "" + this.roundNumber((double)occupations.occupations.getSize((Object)occupation) / (double)occupations.occupations.getSize() * 100.0, this.OPTIONS.getPositions())}));
            if (!this.reportIndisToOccupations) continue;
            for (Indi indi : occupations.occupations.getReferences((Object)occupation)) {
                this.println(this.getIndent(4) + this.translate("entity", new Object[]{indi.getId(), indi.getName()}));
            }
        }
        this.println();
    }

    private static class StatisticsPlaces {
        int which = -1;
        int entitiesWithKnownPlaces = 0;
        ReferenceSet places = new ReferenceSet();

        private StatisticsPlaces() {
        }
    }

    private static class StatisticsFamilies {
        StatisticsIndividuals husbands = new StatisticsIndividuals();
        StatisticsIndividuals wifes = new StatisticsIndividuals();
        int number = 0;
        int withChildren = 0;
        ReferenceSet children = new ReferenceSet();
        int minChildren = 999;
        int maxChildren = 0;
        int sumChildren = 0;

        private StatisticsFamilies() {
        }
    }

    private static class StatisticsOccupations {
        int numberIndis = 0;
        ReferenceSet occupations = new ReferenceSet();

        private StatisticsOccupations() {
        }
    }

    private static class StatisticsLastNames {
        ReferenceSet lastNamesIndis = new ReferenceSet();
        ReferenceSet lastNamesStatistic = new ReferenceSet();

        private StatisticsLastNames() {
        }
    }

    private static class StatisticsIndividuals {
        int which = -1;
        int number = 0;
        ReferenceSet age = new ReferenceSet();
        ReferenceSet childBirthAge = new ReferenceSet();
        int minChildBirthAge = Integer.MAX_VALUE;
        int maxChildBirthAge = Integer.MIN_VALUE;
        int childBirthNumber = 0;
        int sumChildBirthAge = 0;
        int minAge = Integer.MAX_VALUE;
        int maxAge = Integer.MIN_VALUE;
        int sumAge = 0;

        private StatisticsIndividuals() {
        }
    }
}

