/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.TagPath;
import genj.gedcom.time.PointInTime;
import genj.report.Report;

public class ReportMissingInformation
extends Report {
    public boolean checkBirthDate = true;
    public boolean checkBirthPlace = true;
    public boolean checkBirthSource = true;
    public boolean checkBaptismDate = true;
    public boolean checkBaptismPlace = true;
    public boolean checkBaptismSource = true;
    public boolean checkDeathDate = true;
    public boolean checkDeathPlace = true;
    public boolean checkDeathSource = true;
    public boolean checkSex = true;
    public boolean checkGiven = true;
    public boolean checkSurname = true;
    private final String textTitle = this.translate("title");
    private final String textSubject = this.translate("subject");
    private final String textBirth = this.translate("birth");
    private final String textBaptism = this.translate("baptism");
    private final String textDeath = this.translate("death");
    private final String textDate = this.translate("date");
    private final String textPlace = this.translate("place");
    private final String textSex = this.translate("sex");
    private final String textGiven = this.translate("given");
    private final String textSurname = this.translate("surname");
    private final String textKey = this.translate("key");
    private final String textSource = this.translate("source");
    private final int colName = 60;
    private final int colData = 6;
    private final int numDataCols = 12;

    public void start(Indi indi) {
        this.displayHeader(indi.getName());
        this.checkIndi(indi);
    }

    public void checkIndi(Indi indi) {
        Boolean flagOk2;
        Boolean flagOk1;
        Property tempP;
        PropertyPlace tempPlace;
        PropertyDate tempDate;
        StringBuilder strDataRow = new StringBuilder();
        String strNameID = String.format("%-10s", indi.getId()) + " " + indi.getName();
        strDataRow.append(ReportMissingInformation.align((String)strNameID, (int)60, (int)3));
        if (this.checkBirthDate) {
            tempDate = indi.getBirthDate();
            this.addSymbol(strDataRow, tempDate != null && tempDate.isValid());
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.checkBirthPlace) {
            tempPlace = (PropertyPlace)indi.getProperty(new TagPath("INDI:BIRT:PLAC"));
            this.addSymbol(strDataRow, tempPlace != null);
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.checkBirthSource) {
            tempP = indi.getProperty(new TagPath("INDI:BIRT:SOUR"));
            this.addSymbol(strDataRow, tempP != null);
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.checkBaptismDate) {
            flagOk1 = true;
            flagOk2 = true;
            tempDate = (PropertyDate)indi.getProperty(new TagPath("INDI:BAPM:DATE"));
            if (tempDate == null || !tempDate.isValid()) {
                flagOk1 = false;
            }
            if ((tempDate = (PropertyDate)indi.getProperty(new TagPath("INDI:CHR:DATE"))) == null || !tempDate.isValid()) {
                flagOk2 = false;
            }
            this.addSymbol(strDataRow, flagOk1 != false || flagOk2 != false);
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.checkBaptismPlace) {
            flagOk1 = true;
            flagOk2 = true;
            tempPlace = (PropertyPlace)indi.getProperty(new TagPath("INDI:BAPM:PLAC"));
            if (tempPlace == null || "".equals(tempPlace.getValue())) {
                flagOk1 = false;
            }
            if ((tempPlace = (PropertyPlace)indi.getProperty(new TagPath("INDI:CHR:PLAC"))) == null || tempPlace.getValue().length() == 0) {
                flagOk2 = false;
            }
            this.addSymbol(strDataRow, flagOk1 != false || flagOk2 != false);
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.checkBaptismSource) {
            flagOk1 = true;
            flagOk2 = true;
            tempP = indi.getProperty(new TagPath("INDI:BAPM:SOUR"));
            if (tempP == null) {
                flagOk1 = false;
            }
            if ((tempP = indi.getProperty(new TagPath("INDI:CHR:SOUR"))) == null) {
                flagOk2 = false;
            }
            this.addSymbol(strDataRow, flagOk1 != false || flagOk2 != false);
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.checkDeathDate) {
            tempDate = indi.getDeathDate();
            this.addSymbol(strDataRow, indi.getDeathDate() != null && tempDate.isValid());
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.checkDeathPlace) {
            tempPlace = (PropertyPlace)indi.getProperty(new TagPath("INDI:DEAT:PLAC"));
            this.addSymbol(strDataRow, tempPlace != null);
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.checkDeathSource) {
            tempP = indi.getProperty(new TagPath("INDI:DEAT:SOUR"));
            this.addSymbol(strDataRow, tempP != null);
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.checkSex) {
            this.addSymbol(strDataRow, indi.getSex() == 1 || indi.getSex() == 2);
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.checkGiven) {
            this.addSymbol(strDataRow, !"".equals(indi.getFirstName()));
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        if (this.checkSurname) {
            this.addSymbol(strDataRow, !"".equals(indi.getLastName()));
        } else {
            strDataRow.append(ReportMissingInformation.align((String)"-", (int)6, (int)1));
        }
        this.println(strDataRow);
    }

    public void start(Gedcom gedcom) {
        this.displayHeader(gedcom.getName());
        Entity[] individuals = gedcom.getEntities("INDI", "");
        for (int loop = 0; loop < individuals.length; ++loop) {
            Indi person = (Indi)individuals[loop];
            this.checkIndi(person);
        }
    }

    public void displayHeader(String strSubject) {
        this.println(ReportMissingInformation.align((String)this.textTitle, (int)132, (int)1));
        this.println();
        this.println(this.textSubject + ": " + strSubject);
        this.println(this.textDate + ": " + PointInTime.getNow().toString());
        this.println(this.textKey);
        this.println();
        String strUnderLine = "-";
        for (int loop = 1; loop < 131; ++loop) {
            strUnderLine = strUnderLine + "-";
        }
        String strColHeader1 = ReportMissingInformation.align((String)" ", (int)60, (int)1) + ReportMissingInformation.align((String)this.textBirth, (int)6, (int)1) + ReportMissingInformation.align((String)this.textBirth, (int)6, (int)1) + ReportMissingInformation.align((String)this.textBirth, (int)6, (int)1) + ReportMissingInformation.align((String)this.textBaptism, (int)6, (int)1) + ReportMissingInformation.align((String)this.textBaptism, (int)6, (int)1) + ReportMissingInformation.align((String)this.textBaptism, (int)6, (int)1) + ReportMissingInformation.align((String)this.textDeath, (int)6, (int)1) + ReportMissingInformation.align((String)this.textDeath, (int)6, (int)1) + ReportMissingInformation.align((String)this.textDeath, (int)6, (int)1);
        String strColHeader2 = ReportMissingInformation.align((String)" ", (int)60, (int)1) + ReportMissingInformation.align((String)this.textDate, (int)6, (int)1) + ReportMissingInformation.align((String)this.textPlace, (int)6, (int)1) + ReportMissingInformation.align((String)this.textSource, (int)6, (int)1) + ReportMissingInformation.align((String)this.textDate, (int)6, (int)1) + ReportMissingInformation.align((String)this.textPlace, (int)6, (int)1) + ReportMissingInformation.align((String)this.textSource, (int)6, (int)1) + ReportMissingInformation.align((String)this.textDate, (int)6, (int)1) + ReportMissingInformation.align((String)this.textPlace, (int)6, (int)1) + ReportMissingInformation.align((String)this.textSource, (int)6, (int)1) + ReportMissingInformation.align((String)this.textSex, (int)6, (int)1) + ReportMissingInformation.align((String)this.textGiven, (int)6, (int)1) + ReportMissingInformation.align((String)this.textSurname, (int)6, (int)1);
        this.println(strColHeader1);
        this.println(strColHeader2);
        this.println(strUnderLine);
    }

    private void addSymbol(StringBuilder sb, boolean test) {
        if (test) {
            sb.append(ReportMissingInformation.align((String)"ok", (int)6, (int)1));
        } else {
            sb.append(ReportMissingInformation.align((String)"X", (int)6, (int)1));
        }
    }
}

