/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.tools;

import ancestris.core.actions.AbstractAncestrisAction;
import genj.report.Report;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;

public class Log {
    private Report report;
    public boolean writeFile = false;
    private File logFile;
    private PrintWriter outFile;

    public Log(Report report, String title, String msg, boolean writeFile) {
        this.report = report;
        this.writeFile = writeFile;
        if (writeFile) {
            File file = report.getFileFromUser(msg, AbstractAncestrisAction.TXT_OK, true);
            if (file == null) {
                report.println((Object)"##### Cancelled by user #####");
                this.writeFile = false;
            } else {
                try {
                    this.outFile = new PrintWriter(new FileWriter(file));
                    this.outFile.println(report.getName());
                    this.outFile.println("Log file for " + title);
                }
                catch (IOException ioe) {
                    report.println((Object)"IO Exception!");
                    ioe.printStackTrace();
                }
                this.logFile = file;
            }
        }
    }

    public void write(String text, boolean onScreen) {
        if (onScreen) {
            this.report.println((Object)text);
        }
        if (this.writeFile) {
            this.outFile.println(text);
        }
    }

    public void write(String text) {
        this.write(text, true);
    }

    public void write(int level, int indent, String str, int length, String text) {
        String line = "";
        for (int i = 1; i <= length; ++i) {
            line = line + str;
        }
        String indentSpaces = "";
        for (int i = 1; i <= indent; ++i) {
            indentSpaces = indentSpaces + " ";
        }
        if (level == 0) {
            this.write(indentSpaces + text);
        }
        if (level == 1) {
            this.write(" ");
            this.write(line);
            this.write(indentSpaces + text);
            this.write(line);
        }
        if (level == 2) {
            this.write(line);
            this.write(indentSpaces + text);
            this.write(" ");
        }
        if (level == 9) {
            this.write(" ");
            this.write(line);
            this.write(indentSpaces + "##### " + text + " #####");
            this.write(line);
            this.write(" ");
        }
    }

    public void timeStamp() {
        this.write(Calendar.getInstance().getTime().toString(), true);
    }

    public void timeStamp(int indent, String str) {
        this.write(0, indent, "", 0, str + Calendar.getInstance().getTime().toString());
    }

    public String getLogName() {
        return this.logFile.toString();
    }

    public void close() {
        if (this.writeFile) {
            this.outFile.flush();
            this.outFile.close();
        }
    }
}

